/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.language.TranslationKey;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.libs.net.kyori.adventure.text.Component;
import com.loohp.imageframe.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.imageframe.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.imageframe.libs.net.kyori.adventure.text.event.ClickEvent;
import com.loohp.imageframe.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.imageframe.migration.ExternalPluginMigration;
import com.loohp.imageframe.migration.PluginMigrationRegistry;
import com.loohp.imageframe.objectholders.BlockPosition;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.imageframe.objectholders.IFPlayerPreference;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessControl;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapCreationTask;
import com.loohp.imageframe.objectholders.ImageMapCreationTaskManager;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapLoaders;
import com.loohp.imageframe.objectholders.ItemFrameSelectionManager;
import com.loohp.imageframe.objectholders.MapMarkerEditManager;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMap;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMapCreateInfo;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.PreferenceState;
import com.loohp.imageframe.objectholders.URLImageMap;
import com.loohp.imageframe.objectholders.URLImageMapCreateInfo;
import com.loohp.imageframe.storage.ImageFrameStorage;
import com.loohp.imageframe.storage.ImageFrameStorageLoader;
import com.loohp.imageframe.storage.ImageFrameStorageLoaders;
import com.loohp.imageframe.storage.StorageMigrator;
import com.loohp.imageframe.updater.Updater;
import com.loohp.imageframe.upload.ImageUploadManager;
import com.loohp.imageframe.upload.PendingUpload;
import com.loohp.imageframe.utils.ChatColorUtils;
import com.loohp.imageframe.utils.CommandSenderUtils;
import com.loohp.imageframe.utils.ComponentUtils;
import com.loohp.imageframe.utils.HTTPRequestUtils;
import com.loohp.imageframe.utils.ImageMapUtils;
import com.loohp.imageframe.utils.KeyUtils;
import com.loohp.imageframe.utils.MCVersion;
import com.loohp.imageframe.utils.MapUtils;
import com.loohp.imageframe.utils.MathUtils;
import com.loohp.imageframe.utils.PlayerUtils;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class Commands
implements CommandExecutor,
TabCompleter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            CommandSenderUtils.sendMessage(sender, ChatColor.DARK_AQUA + "ImageFrame written by LOOHP!");
            CommandSenderUtils.sendMessage(sender, ChatColor.GOLD + "You are running ImageFrame version: " + ImageFrame.plugin.getDescription().getVersion());
            CommandSenderUtils.sendMessage(sender, ChatColor.YELLOW + "Translations are crowdsourced from the community! Visit https://crowdin.com/project/imageframe");
            if (!ImageFrame.imageFrameClientEnabled) return true;
            if (!(sender instanceof Player)) return true;
            Player player = (Player)sender;
            if (ImageFrame.customClientNetworkManager.hasPlayer(player)) {
                CommandSenderUtils.sendMessage(sender, ChatColor.GREEN + "Your ImageFrame Client is supported on the server!");
                return true;
            }
            ImageFrame.customClientNetworkManager.sendAcknowledgement(player);
            CommandSenderUtils.sendMessage(sender, ChatColor.RED + "This server supports ImageFrame Client but you are not using it.");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("imageframe.reload")) {
                ImageFrame.plugin.reloadConfig();
                ImageFrame.languageManager.reloadLanguages();
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.reloaded", new Object[0]).color(NamedTextColor.GREEN));
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("resync")) {
            if (sender.hasPermission("imageframe.resync")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.resync", new Object[0]).color(NamedTextColor.GREEN));
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> ImageFrame.imageMapManager.syncMaps(true));
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("update")) {
            if (sender.hasPermission("imageframe.update")) {
                CommandSenderUtils.sendMessage(sender, ChatColor.DARK_AQUA + "[ImageFrame] ImageFrame written by LOOHP!");
                CommandSenderUtils.sendMessage(sender, ChatColor.GOLD + "[ImageFrame] You are running ImageFrame version: " + ImageFrame.plugin.getDescription().getVersion());
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    Updater.UpdaterResponse version = Updater.checkUpdate();
                    if (version.getResult().equals("latest")) {
                        if (version.isDevBuildLatest()) {
                            CommandSenderUtils.sendMessage(sender, ChatColor.GREEN + "[ImageFrame] You are running the latest version!");
                        } else {
                            Updater.sendUpdateMessage(sender, version.getResult(), version.getSpigotPluginId(), true);
                        }
                    } else {
                        Updater.sendUpdateMessage(sender, version.getResult(), version.getSpigotPluginId());
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (!sender.hasPermission("imageframe.create")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length != 4 && args.length != 5 && args.length != 6 && args.length != 7) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                int takenMaps;
                DitheringType ditheringType;
                int height;
                int width;
                ItemFrameSelectionManager.SelectedItemFrameResult selection;
                boolean combined;
                boolean isAdmin;
                boolean isConsole;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[1]);
                String name = pair.getSecond();
                boolean bl = isConsole = !(sender instanceof Player);
                if (pair.getFirst() == null && isConsole) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Player player = isConsole ? null : (Player)sender;
                UUID owner = pair.getFirst();
                boolean bl2 = isAdmin = isConsole || !owner.equals(player.getUniqueId());
                if (isAdmin && !sender.hasPermission("imageframe.create.others")) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (ImageFrame.combinedByDefault) {
                    combined = !(args.length == 6 && args[5].equalsIgnoreCase("separated") || args.length == 7 && args[6].equalsIgnoreCase("separated"));
                } else {
                    boolean bl3 = combined = args.length == 6 && args[5].equalsIgnoreCase("combined") || args.length == 7 && args[6].equalsIgnoreCase("combined");
                }
                if (args[3].equalsIgnoreCase("selection")) {
                    if (isConsole) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                    selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)player);
                    if (selection == null) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.no_selection", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                } else {
                    if (args.length != 5 && args.length != 6 && args.length != 7) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                    selection = null;
                }
                if (selection == null) {
                    width = Integer.parseInt(args[3]);
                    height = Integer.parseInt(args[4]);
                    ditheringType = DitheringType.fromName(args.length > 5 && !args[5].equalsIgnoreCase(ImageFrame.combinedByDefault ? "separated" : "combined") ? args[5].toLowerCase() : null);
                } else {
                    width = selection.getWidth();
                    height = selection.getHeight();
                    ditheringType = DitheringType.fromName(args.length > 4 ? args[4].toLowerCase() : null);
                }
                if (width * height > ImageFrame.mapMaxSize) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.oversize", ImageFrame.mapMaxSize).color(NamedTextColor.RED));
                    return true;
                }
                int limit = isAdmin ? -1 : ImageFrame.getPlayerCreationLimit(player);
                Set<ImageMap> existingMaps = ImageFrame.imageMapManager.getFromCreator(owner);
                if (limit >= 0 && existingMaps.size() >= limit) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.player_creation_limit_reached", limit).color(NamedTextColor.RED));
                    return true;
                }
                if (existingMaps.stream().anyMatch(each -> each.getName().equalsIgnoreCase(name))) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.duplicate_map_name", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (!ImageFrame.isURLAllowed(args[2])) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_restricted", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (ImageFrame.requireEmptyMaps && !isConsole) {
                    takenMaps = MapUtils.removeEmptyMaps(player, width * height, true);
                    if (takenMaps < 0) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_enough_maps", width * height).color(NamedTextColor.RED));
                        return true;
                    }
                } else {
                    takenMaps = 0;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    block15: {
                        ImageMapCreationTask<ImageMap> creationTask = null;
                        String url = "Pending...";
                        try {
                            url = args[2];
                            if (ImageFrame.imageUploadManager.isOperational() && url.equalsIgnoreCase("upload")) {
                                UUID user = isConsole ? ImageMap.CONSOLE_CREATOR : player.getUniqueId();
                                PendingUpload pendingUpload = ImageFrame.imageUploadManager.newPendingUpload(user);
                                String uploadUrl = pendingUpload.getUrl(ImageFrame.uploadServiceDisplayURL, user);
                                Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.upload_link", ((TextComponent)Component.text(uploadUrl).color(NamedTextColor.YELLOW)).clickEvent(ClickEvent.openUrl(uploadUrl))).color(NamedTextColor.GREEN)), 2L);
                                url = pendingUpload.getFileBlocking().toURI().toURL().toString();
                            }
                            if (HTTPRequestUtils.getContentSize(url) > ImageFrame.maxImageFileSize) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_over_max_file_size", ImageFrame.maxImageFileSize).color(NamedTextColor.RED));
                                throw new IOException("Image over max file size");
                            }
                            String imageType = HTTPRequestUtils.getContentType(url);
                            if (imageType == null) {
                                imageType = URLConnection.guessContentTypeFromName(url);
                            }
                            imageType = imageType == null ? "" : imageType.trim();
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_processing", new Object[0]).color(NamedTextColor.YELLOW));
                            String finalUrl = url;
                            String finalImageType = imageType;
                            creationTask = ImageFrame.imageMapCreationTaskManager.enqueue(owner, name, () -> {
                                ImageMapLoader<URLImageMap, URLImageMapCreateInfo> loader = ImageMapLoaders.getLoader(URLImageMap.class, URLImageMapCreateInfo.class, finalImageType, sender);
                                return loader.create(new URLImageMapCreateInfo(ImageFrame.imageMapManager, name, finalUrl, width, height, ditheringType, owner)).get();
                            });
                            ImageMap imageMap = (ImageMap)creationTask.get();
                            ImageFrame.imageMapManager.addMap(imageMap);
                            if (!isConsole) {
                                if (combined) {
                                    ImageFrame.combinedMapItemHandler.giveCombinedMap(imageMap, player);
                                } else if (selection == null) {
                                    imageMap.giveMaps(player, ImageFrame.mapItemFormat);
                                } else {
                                    AtomicBoolean flag = new AtomicBoolean(false);
                                    imageMap.fillItemFrames(selection.getItemFrames(), selection.getRotation(), (frame, item) -> {
                                        ItemStack originalItem = frame.getItem();
                                        if (originalItem != null && !originalItem.getType().equals((Object)Material.AIR)) {
                                            return false;
                                        }
                                        return PlayerUtils.isInteractionAllowed(player, (Entity)frame);
                                    }, (frame, item) -> {
                                        PlayerUtils.giveItem(player, item);
                                        if (!flag.getAndSet(true)) {
                                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.item_frame_occupied", new Object[0]).color(NamedTextColor.RED));
                                        }
                                    }, ImageFrame.mapItemFormat);
                                }
                            }
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_created", new Object[0]).color(NamedTextColor.GREEN));
                            creationTask.complete(ComponentUtils.translatable("imageframe.messages.image_map_created", new Object[0]).color(NamedTextColor.GREEN));
                        }
                        catch (ImageUploadManager.LinkTimeoutException e) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.upload_expired", new Object[0]).color(NamedTextColor.RED));
                            if (takenMaps > 0 && !isConsole) {
                                PlayerUtils.giveItem(player, new ItemStack(Material.MAP, takenMaps));
                            }
                        }
                        catch (ImageMapCreationTaskManager.EnqueueRejectedException e) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_already_queued", new Object[0]).color(NamedTextColor.RED));
                            if (takenMaps > 0 && !isConsole) {
                                PlayerUtils.giveItem(player, new ItemStack(Material.MAP, takenMaps));
                            }
                        }
                        catch (Exception e) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                            if (creationTask != null) {
                                creationTask.complete(ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                            }
                            new IOException("Unable to download image. Make sure you are using a direct link to the image, they usually ends with a file extension like \".png\". Dispatcher: " + sender.getName() + " URL: " + url, e).printStackTrace();
                            if (takenMaps <= 0 || isConsole) break block15;
                            PlayerUtils.giveItem(player, new ItemStack(Material.MAP, takenMaps));
                        }
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("overlay")) {
            if (!sender.hasPermission("imageframe.overlay")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length != 3 && args.length != 4 && args.length != 5) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (!(sender instanceof Player)) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                DitheringType ditheringType;
                int height;
                int width;
                List<MapView> mapViews;
                boolean isAdmin;
                Player player = (Player)sender;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[1]);
                String name = pair.getSecond();
                if (pair.getFirst() == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                UUID owner = pair.getFirst();
                boolean bl = isAdmin = !owner.equals(player.getUniqueId());
                if (isAdmin && !sender.hasPermission("imageframe.create.others")) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if ((args.length == 4 || args.length == 5) && args[3].equalsIgnoreCase("selection")) {
                    ItemFrameSelectionManager.SelectedItemFrameResult selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)player);
                    if (selection == null) {
                        CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.selection.no_selection", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                    mapViews = selection.getMapViews();
                    width = selection.getWidth();
                    height = selection.getHeight();
                    ditheringType = DitheringType.fromName(args.length == 5 ? args[4].toLowerCase() : null);
                } else {
                    if (args.length != 3 && args.length != 4) {
                        CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                    mapViews = Collections.singletonList(MapUtils.getPlayerMapView(player));
                    width = 1;
                    height = 1;
                    ditheringType = DitheringType.fromName(args.length == 4 ? args[3].toLowerCase() : null);
                }
                if (mapViews.contains(null)) {
                    CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.selection.invalid", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (mapViews.stream().anyMatch(each -> ImageFrame.imageMapManager.getFromMapView((MapView)each) != null) || mapViews.stream().distinct().count() < (long)mapViews.size()) {
                    CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.invalid_overlay_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (width * height > ImageFrame.mapMaxSize) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.oversize", ImageFrame.mapMaxSize).color(NamedTextColor.RED));
                    return true;
                }
                int limit = isAdmin ? -1 : ImageFrame.getPlayerCreationLimit(player);
                Set<ImageMap> existingMaps = ImageFrame.imageMapManager.getFromCreator(owner);
                if (limit >= 0 && existingMaps.size() >= limit) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.player_creation_limit_reached", limit).color(NamedTextColor.RED));
                    return true;
                }
                if (existingMaps.stream().anyMatch(each -> each.getName().equalsIgnoreCase(name))) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.duplicate_map_name", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    ImageMapCreationTask<ImageMap> creationTask = null;
                    try {
                        String url = args[2];
                        if (ImageFrame.imageUploadManager.isOperational() && url.equalsIgnoreCase("upload")) {
                            UUID user = player.getUniqueId();
                            PendingUpload pendingUpload = ImageFrame.imageUploadManager.newPendingUpload(user);
                            String uploadUrl = pendingUpload.getUrl(ImageFrame.uploadServiceDisplayURL, user);
                            Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.upload_link", ((TextComponent)Component.text(uploadUrl).color(NamedTextColor.YELLOW)).clickEvent(ClickEvent.openUrl(uploadUrl))).color(NamedTextColor.GREEN)), 2L);
                            url = pendingUpload.getFileBlocking().toURI().toURL().toString();
                        }
                        if (!ImageFrame.isURLAllowed(url)) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_restricted", new Object[0]).color(NamedTextColor.RED));
                            return;
                        }
                        if (HTTPRequestUtils.getContentSize(url) > ImageFrame.maxImageFileSize) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_over_max_file_size", ImageFrame.maxImageFileSize).color(NamedTextColor.RED));
                            throw new IOException("Image over max file size");
                        }
                        String finalUrl = url;
                        creationTask = ImageFrame.imageMapCreationTaskManager.enqueue(owner, name, () -> {
                            ImageMapLoader<MinecraftURLOverlayImageMap, MinecraftURLOverlayImageMapCreateInfo> loader = ImageMapLoaders.getLoader(MinecraftURLOverlayImageMap.class, MinecraftURLOverlayImageMapCreateInfo.class, null, sender);
                            return loader.create(new MinecraftURLOverlayImageMapCreateInfo(ImageFrame.imageMapManager, name, finalUrl, mapViews, width, height, ditheringType, player.getUniqueId())).get();
                        });
                        ImageMap imageMap = (ImageMap)creationTask.get();
                        ImageFrame.imageMapManager.addMap(imageMap);
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_created", new Object[0]).color(NamedTextColor.GREEN));
                        creationTask.complete(ComponentUtils.translatable("imageframe.messages.image_map_created", new Object[0]).color(NamedTextColor.GREEN));
                    }
                    catch (ImageUploadManager.LinkTimeoutException e) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.upload_expired", new Object[0]).color(NamedTextColor.RED));
                    }
                    catch (ImageMapCreationTaskManager.EnqueueRejectedException e) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_already_queued", new Object[0]).color(NamedTextColor.RED));
                    }
                    catch (Exception e) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                        if (creationTask != null) {
                            creationTask.complete(ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                        }
                        e.printStackTrace();
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("clone")) {
            if (!sender.hasPermission("imageframe.clone")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length != 3 && args.length != 4) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                int takenMaps;
                ImageMap imageMap;
                ItemFrameSelectionManager.SelectedItemFrameResult selection;
                boolean combined;
                boolean isAdmin;
                boolean isConsole;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[2]);
                String name = pair.getSecond();
                boolean bl = isConsole = !(sender instanceof Player);
                if (pair.getFirst() == null && isConsole) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Player player = isConsole ? null : (Player)sender;
                UUID owner = pair.getFirst();
                boolean bl4 = isAdmin = isConsole || !owner.equals(player.getUniqueId());
                if (isAdmin && !sender.hasPermission("imageframe.create.others")) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (ImageFrame.combinedByDefault) {
                    combined = args.length <= 3 || !args[3].equalsIgnoreCase("separated");
                } else {
                    boolean bl5 = combined = args.length > 3 && args[3].equalsIgnoreCase("combined");
                }
                if (args.length > 3 && args[3].equalsIgnoreCase("selection")) {
                    selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)player);
                    if (selection == null) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.no_selection", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                } else {
                    selection = null;
                }
                if ((imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1])) == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.EDIT_CLONE)) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (selection != null && (imageMap.getWidth() != selection.getWidth() || imageMap.getHeight() != selection.getHeight())) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.incorrect_size", imageMap.getWidth(), imageMap.getHeight()).color(NamedTextColor.RED));
                    return true;
                }
                int limit = isAdmin ? -1 : ImageFrame.getPlayerCreationLimit(player);
                Set<ImageMap> existingMaps = ImageFrame.imageMapManager.getFromCreator(owner);
                if (limit >= 0 && existingMaps.size() >= limit) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.player_creation_limit_reached", limit).color(NamedTextColor.RED));
                    return true;
                }
                if (existingMaps.stream().anyMatch(each -> each.getName().equalsIgnoreCase(name))) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.duplicate_map_name", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (ImageFrame.requireEmptyMaps && !isConsole) {
                    takenMaps = MapUtils.removeEmptyMaps(player, imageMap.getWidth() * imageMap.getHeight(), true);
                    if (takenMaps < 0) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_enough_maps", imageMap.getWidth() * imageMap.getHeight()).color(NamedTextColor.RED));
                        return true;
                    }
                } else {
                    takenMaps = 0;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    block9: {
                        ImageMapCreationTask<ImageMap> creationTask = null;
                        try {
                            creationTask = ImageFrame.imageMapCreationTaskManager.enqueue(owner, name, () -> imageMap.deepClone(name, owner));
                            ImageMap newImageMap = (ImageMap)creationTask.get();
                            ImageFrame.imageMapManager.addMap(newImageMap);
                            if (!isConsole) {
                                if (combined) {
                                    ImageFrame.combinedMapItemHandler.giveCombinedMap(newImageMap, player);
                                } else if (selection == null) {
                                    newImageMap.giveMaps(player, ImageFrame.mapItemFormat);
                                } else {
                                    AtomicBoolean flag = new AtomicBoolean(false);
                                    newImageMap.fillItemFrames(selection.getItemFrames(), selection.getRotation(), (frame, item) -> {
                                        ItemStack originalItem = frame.getItem();
                                        if (originalItem != null && !originalItem.getType().equals((Object)Material.AIR)) {
                                            return false;
                                        }
                                        return PlayerUtils.isInteractionAllowed(player, (Entity)frame);
                                    }, (frame, item) -> {
                                        PlayerUtils.giveItem(player, item);
                                        if (!flag.getAndSet(true)) {
                                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.item_frame_occupied", new Object[0]).color(NamedTextColor.RED));
                                        }
                                    }, ImageFrame.mapItemFormat);
                                }
                            }
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_created", new Object[0]).color(NamedTextColor.GREEN));
                            creationTask.complete(ComponentUtils.translatable("imageframe.messages.image_map_created", new Object[0]).color(NamedTextColor.GREEN));
                        }
                        catch (ImageMapCreationTaskManager.EnqueueRejectedException e) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_already_queued", new Object[0]).color(NamedTextColor.RED));
                        }
                        catch (Exception e) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                            if (creationTask != null) {
                                creationTask.complete(ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                            }
                            e.printStackTrace();
                            if (takenMaps <= 0 || isConsole) break block9;
                            PlayerUtils.giveItem((Player)sender, new ItemStack(Material.MAP, takenMaps));
                        }
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("playback")) {
            if (!sender.hasPermission("imageframe.playback")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length <= 2) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                boolean isConsole;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[1]);
                boolean bl = isConsole = !(sender instanceof Player);
                if (pair.getFirst() == null && isConsole) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.ADJUST_PLAYBACK)) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        if (args[2].equalsIgnoreCase("pause")) {
                            if (imageMap.requiresAnimationService()) {
                                boolean targetState = args.length > 3 ? Boolean.parseBoolean(args[3]) : !imageMap.isAnimationPaused();
                                imageMap.setAnimationPause(targetState);
                            }
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_toggle_paused", new Object[0]).color(NamedTextColor.GREEN));
                        } else if (args[2].equalsIgnoreCase("jumpto") && args.length > 3) {
                            try {
                                double seconds = Double.parseDouble(args[3]);
                                if (imageMap.requiresAnimationService()) {
                                    imageMap.setAnimationPlaybackTime(seconds);
                                }
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_playback_jump_to", seconds).color(NamedTextColor.GREEN));
                            }
                            catch (NumberFormatException e) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                            }
                        } else {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("select")) {
            if (!sender.hasPermission("imageframe.select")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length == 1) {
                if (!(sender instanceof Player)) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Player player = (Player)sender;
                if (ImageFrame.itemFrameSelectionManager.isInSelection((CommandSender)player)) {
                    ImageFrame.itemFrameSelectionManager.setInSelection((CommandSender)player, false);
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.clear", new Object[0]).color(NamedTextColor.YELLOW));
                    return true;
                }
                ImageFrame.itemFrameSelectionManager.setInSelection((CommandSender)player, true);
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.begin", new Object[0]).color(NamedTextColor.GREEN));
                return true;
            }
            if (args.length != 8 && args.length != 9) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                float yaw;
                World world = Bukkit.getWorld((String)args[1]);
                if (world == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                int x1 = Integer.parseInt(args[2]);
                int y1 = Integer.parseInt(args[3]);
                int z1 = Integer.parseInt(args[4]);
                int x2 = Integer.parseInt(args[5]);
                int y2 = Integer.parseInt(args[6]);
                int z2 = Integer.parseInt(args[7]);
                BlockPosition pos1 = new BlockPosition(world, x1, y1, z1);
                BlockPosition pos2 = new BlockPosition(world, x2, y2, z2);
                if (args.length == 9) {
                    yaw = Float.parseFloat(args[8]);
                } else {
                    float f = yaw = sender instanceof Player ? ((Player)sender).getLocation().getYaw() : 0.0f;
                }
                if (ImageFrame.itemFrameSelectionManager.isInSelection(sender)) {
                    ImageFrame.itemFrameSelectionManager.setInSelection(sender, false);
                }
                ImageFrame.itemFrameSelectionManager.applyDirectItemFrameSelection(sender, yaw, pos1, pos2);
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("marker")) {
            if (!sender.hasPermission("imageframe.marker")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (!(sender instanceof Player)) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            Player player = (Player)sender;
            if (args.length <= 1) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args[1].equalsIgnoreCase("add")) {
                if (args.length <= 5) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName((CommandSender)player, args[2]);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.MARKER)) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (ImageFrame.mapMarkerEditManager.isActiveEditing(player)) {
                    ImageFrame.mapMarkerEditManager.leaveActiveEditing(player);
                }
                try {
                    String name = args[3];
                    if (imageMap.getMapMarker(name) != null) {
                        CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.markers.duplicate_name", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                    byte direction = Byte.parseByte(args[4]);
                    MapCursor.Type type = MapCursor.Type.valueOf((String)args[5].toUpperCase());
                    String caption = args.length > 6 ? ChatColorUtils.translateAlternateColorCodes('&', String.join((CharSequence)" ", Arrays.copyOfRange(args, 6, args.length))) : null;
                    MapCursor mapCursor = new MapCursor(0, 0, direction, type, true, caption);
                    ImageFrame.mapMarkerEditManager.setActiveEditing(player, name, mapCursor, imageMap);
                    if (!MapUtils.isRenderOnFrame(type)) {
                        CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.markers.not_render_on_frame_warning", new Object[0]).color(NamedTextColor.YELLOW));
                    }
                    CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.markers.add_begin", imageMap.getName()).color(NamedTextColor.GREEN));
                    return true;
                }
                catch (IllegalArgumentException e) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
            }
            if (args[1].equalsIgnoreCase("remove")) {
                if (args.length <= 3) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                ImageMap imageMap = ImageFrame.imageMapManager.getFromCreator(player.getUniqueId(), args[2]);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    for (Map<String, MapCursor> map : imageMap.getMapMarkers()) {
                        if (map.remove(args[3]) == null) continue;
                        try {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.markers.remove", new Object[0]).color(NamedTextColor.YELLOW));
                            Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(imageMap));
                            imageMap.send(imageMap.getViewers());
                            imageMap.save();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.markers.not_a_marker", new Object[0]).color(NamedTextColor.RED));
                });
                return true;
            }
            if (args[1].equalsIgnoreCase("clear")) {
                if (args.length <= 2) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                ImageMap imageMap = ImageFrame.imageMapManager.getFromCreator(player.getUniqueId(), args[2]);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        imageMap.getMapMarkers().forEach(each -> each.clear());
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.markers.clear", new Object[0]).color(NamedTextColor.YELLOW));
                        Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(imageMap));
                        imageMap.send(imageMap.getViewers());
                        imageMap.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
            if (args[1].equalsIgnoreCase("cancel")) {
                MapMarkerEditManager.MapMarkerEditData editData = ImageFrame.mapMarkerEditManager.leaveActiveEditing(player);
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.markers.cancel", new Object[0]).color(NamedTextColor.YELLOW));
                if (editData == null) return true;
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> editData.getImageMap().send(editData.getImageMap().getViewers()));
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("refresh")) {
            if (sender.hasPermission("imageframe.refresh")) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    block27: {
                        ImageMap imageMap = null;
                        String url = null;
                        DitheringType ditheringType = null;
                        if (args.length > 1) {
                            imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                            if (imageMap == null) {
                                ditheringType = DitheringType.fromNameOrNull(args[1].toLowerCase());
                                if (ditheringType == null) {
                                    url = args[1];
                                }
                            } else if (args.length > 2 && (ditheringType = DitheringType.fromNameOrNull(args[2].toLowerCase())) == null) {
                                url = args[2];
                            }
                        }
                        if (imageMap == null) {
                            if (!(sender instanceof Player)) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                                return;
                            }
                            MapView mapView = MapUtils.getPlayerMapView((Player)sender);
                            if (mapView == null) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                                return;
                            }
                            imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
                        }
                        if (imageMap == null) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                        } else if (ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.EDIT)) {
                            try {
                                if (imageMap instanceof URLImageMap) {
                                    URLImageMap urlImageMap = (URLImageMap)imageMap;
                                    String imageType = HTTPRequestUtils.getContentType(url);
                                    if (imageType == null) {
                                        imageType = URLConnection.guessContentTypeFromName(url);
                                    }
                                    imageType = imageType == null ? "" : imageType.trim();
                                    if (!ImageFrame.isURLAllowed(url)) {
                                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_restricted", new Object[0]).color(NamedTextColor.RED));
                                        return;
                                    }
                                    if (imageType.equals("image/gif") == urlImageMap.requiresAnimationService()) {
                                        String oldUrl = urlImageMap.getUrl();
                                        if (url != null) {
                                            urlImageMap.setUrl(url);
                                        }
                                        if (ImageFrame.imageUploadManager.isOperational() && urlImageMap.getUrl().equalsIgnoreCase("upload")) {
                                            UUID user = !(sender instanceof Player) ? ImageMap.CONSOLE_CREATOR : ((Player)sender).getUniqueId();
                                            PendingUpload pendingUpload = ImageFrame.imageUploadManager.newPendingUpload(user);
                                            String uploadUrl = pendingUpload.getUrl(ImageFrame.uploadServiceDisplayURL, user);
                                            Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.upload_link", ((TextComponent)Component.text(uploadUrl).color(NamedTextColor.YELLOW)).clickEvent(ClickEvent.openUrl(uploadUrl))).color(NamedTextColor.GREEN)), 2L);
                                            String newUrl = pendingUpload.getFileBlocking().toURI().toURL().toString();
                                            if (HTTPRequestUtils.getContentSize(newUrl) > ImageFrame.maxImageFileSize) {
                                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_over_max_file_size", ImageFrame.maxImageFileSize).color(NamedTextColor.RED));
                                                throw new IOException("Image over max file size");
                                            }
                                            urlImageMap.setUrl(newUrl);
                                        }
                                        if (ditheringType != null) {
                                            urlImageMap.setDitheringType(ditheringType);
                                        }
                                        try {
                                            imageMap.update();
                                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_refreshed", new Object[0]).color(NamedTextColor.GREEN));
                                        }
                                        catch (Throwable e) {
                                            urlImageMap.setUrl(oldUrl);
                                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                                            e.printStackTrace();
                                        }
                                    } else {
                                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_change_image_type", new Object[0]).color(NamedTextColor.RED));
                                    }
                                    break block27;
                                }
                                if (ditheringType != null) {
                                    imageMap.setDitheringType(ditheringType);
                                }
                                imageMap.update();
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_refreshed", new Object[0]).color(NamedTextColor.GREEN));
                            }
                            catch (ImageUploadManager.LinkTimeoutException e) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.upload_expired", new Object[0]).color(NamedTextColor.RED));
                            }
                            catch (Exception e) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unable_to_load_map", new Object[0]).color(NamedTextColor.RED));
                                e.printStackTrace();
                            }
                        } else {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                        }
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("rename")) {
            if (!sender.hasPermission("imageframe.rename")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length <= 2) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
            if (imageMap == null) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.EDIT)) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            String newName = args[2];
            if (ImageFrame.imageMapManager.getFromCreator(imageMap.getCreator(), newName) == null) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        imageMap.rename(newName);
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_renamed", new Object[0]).color(NamedTextColor.GREEN));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.duplicate_map_name", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("info")) {
            MapView mapView;
            ImageMap imageMap;
            if (!sender.hasPermission("imageframe.info")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length > 1) {
                imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                mapView = imageMap.getMapViews().get(0);
            } else {
                mapView = sender instanceof Player ? MapUtils.getPlayerMapView((Player)sender) : null;
            }
            if (mapView == null) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
            if (imageMap == null) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            Component access = ((TextComponent)((TextComponent)Component.empty().append(Component.text("[").color(NamedTextColor.AQUA))).append(imageMap.getAccessControl().getPermissions().entrySet().stream().sorted(Map.Entry.comparingByValue()).map(each -> {
                String offlinePlayerName;
                UUID uuid = (UUID)each.getKey();
                TextComponent playerName = uuid.equals(ImageMapAccessControl.EVERYONE) ? Component.text("*") : Component.text((offlinePlayerName = Bukkit.getOfflinePlayer((UUID)uuid).getName()) == null ? uuid.toString() : offlinePlayerName);
                TranslatableComponent permission = ComponentUtils.translatable(TranslationKey.ACCESS_TYPE((ImageMapAccessPermissionType)each.getValue()), new Object[0]).fallback(((ImageMapAccessPermissionType)each.getValue()).name());
                return playerName.append(Component.text(" - ")).append(permission).color(NamedTextColor.YELLOW);
            }).collect(Component.toComponent(Component.text(", ").color(NamedTextColor.AQUA))))).append(Component.text("]").color(NamedTextColor.AQUA));
            Component markers = ((TextComponent)((TextComponent)Component.empty().append(Component.text("[").color(NamedTextColor.AQUA))).append(imageMap.getMapMarkers().stream().flatMap(each -> each.keySet().stream()).map(each -> (TextComponent)Component.text(each).color(NamedTextColor.YELLOW)).collect(Component.toComponent(Component.text(", ").color(NamedTextColor.AQUA))))).append(Component.text("]").color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.1", Component.text(imageMap.getImageIndex()).color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.2", Component.text(imageMap.getName()).color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.3", Component.text(imageMap.getWidth()).color(NamedTextColor.YELLOW), Component.text(imageMap.getHeight()).color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.4", Component.text(imageMap.getDitheringType().getName()).color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.5", Component.text(imageMap.getCreatorName()).color(NamedTextColor.YELLOW), Component.text(imageMap.getCreator().toString()).color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.6", access.color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.7", Component.text(ImageFrame.dateFormat.format(new Date(imageMap.getCreationTime()))).color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.8", markers.color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.url_image_map_info.9", Component.text(imageMap instanceof URLImageMap ? ((URLImageMap)imageMap).getUrl() : "-").color(NamedTextColor.YELLOW)).color(NamedTextColor.AQUA));
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (sender.hasPermission("imageframe.list")) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    OfflinePlayer player = null;
                    if (args.length > 1) {
                        player = Bukkit.getOfflinePlayer((String)args[1]);
                    } else if (sender instanceof Player) {
                        player = (Player)sender;
                    }
                    if (player == null) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                    } else if (!player.equals((Object)sender) && !sender.hasPermission("imageframe.list.others")) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    } else {
                        Component prefix = ComponentUtils.translatable("imageframe.messages.map_lookup", player.getName() == null ? "" : player.getName(), player.getUniqueId()).color(NamedTextColor.AQUA);
                        Component suffix = ImageFrame.imageMapManager.getFromCreator(player.getUniqueId(), Comparator.comparing(each -> each.getCreationTime())).stream().map(each -> {
                            String qualifiedName = each.getCreatorName() + ":" + each.getName();
                            return (TextComponent)((TextComponent)Component.text(each.getName()).color(NamedTextColor.YELLOW)).clickEvent(ClickEvent.runCommand("/imageframe info " + qualifiedName));
                        }).collect(Component.toComponent(Component.text(", ").color(NamedTextColor.AQUA)));
                        Component message = prefix.append(Component.text(" [").color(NamedTextColor.AQUA)).append(suffix).append(Component.text("]").color(NamedTextColor.AQUA));
                        CommandSenderUtils.sendMessage(sender, message);
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("delete")) {
            if (!sender.hasPermission("imageframe.delete")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length > 1) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                        if (imageMap == null) {
                            if (!(sender instanceof Player)) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                                return;
                            }
                            MapView mapView = MapUtils.getPlayerMapView((Player)sender);
                            if (mapView == null) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                                return;
                            }
                            imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
                        }
                        if (imageMap == null) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                        } else if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.ALL)) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                        } else {
                            ImageFrame.imageMapManager.deleteMap(imageMap.getImageIndex());
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_deleted", new Object[0]).color(NamedTextColor.YELLOW));
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                                    PlayerInventory inventory = player.getInventory();
                                    for (int i = 0; i < inventory.getSize(); ++i) {
                                        ItemStack currentItem = inventory.getItem(i);
                                        MapView currentMapView = MapUtils.getItemMapView(currentItem);
                                        if (currentMapView == null || !ImageFrame.imageMapManager.isMapDeleted(currentMapView) || ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) continue;
                                        inventory.setItem(i, new ItemStack(Material.MAP, currentItem.getAmount()));
                                    }
                                }, (Entity)player);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("purge")) {
            if (!sender.hasPermission("imageframe.purge")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length > 1) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    Set<UUID> uuids;
                    if (args[1].equalsIgnoreCase("*")) {
                        if (sender.hasPermission("imageframe.purge.all")) {
                            uuids = ImageFrame.imageMapManager.getCreators();
                        } else {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                            uuids = Collections.emptySet();
                        }
                    } else {
                        UUID uuid;
                        try {
                            uuid = UUID.fromString(args[1]);
                        }
                        catch (IllegalArgumentException e) {
                            uuid = Bukkit.getOfflinePlayer((String)args[1]).getUniqueId();
                        }
                        uuids = Collections.singleton(uuid);
                    }
                    for (UUID uuid : uuids) {
                        ArrayList<String> names = new ArrayList<String>();
                        for (ImageMap imageMap : ImageFrame.imageMapManager.getFromCreator(uuid)) {
                            if (!ImageFrame.imageMapManager.deleteMap(imageMap.getImageIndex())) continue;
                            names.add(imageMap.getName());
                        }
                        String playerName = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                        Component mapNames = names.stream().map(n -> (TextComponent)Component.text(n).color(NamedTextColor.RED)).collect(Component.toComponent(Component.text(", ").color(NamedTextColor.YELLOW)));
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_player_purge", names.size(), playerName == null ? "???" : playerName, uuid, mapNames).color(NamedTextColor.YELLOW));
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("setaccess")) {
            if (!sender.hasPermission("imageframe.setaccess")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length > 3) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                        if (imageMap == null) {
                            if (!(sender instanceof Player)) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                                return;
                            }
                            MapView mapView = MapUtils.getPlayerMapView((Player)sender);
                            if (mapView == null) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                                return;
                            }
                            imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
                        }
                        if (imageMap == null) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                        } else if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.ALL)) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                        } else {
                            String targetPlayer = args[2];
                            boolean isEveryone = targetPlayer.equals("*");
                            UUID uuid = isEveryone ? ImageMapAccessControl.EVERYONE : Bukkit.getOfflinePlayer((String)targetPlayer).getUniqueId();
                            String permissionTypeStr = args[3].toUpperCase();
                            try {
                                ImageMapAccessControl accessControl = imageMap.getAccessControl();
                                ImageMapAccessPermissionType permissionType = permissionTypeStr.equals("NONE") ? null : ImageMapAccessPermissionType.valueOf(permissionTypeStr);
                                accessControl.setPermission(uuid, permissionType);
                                ImageMapAccessPermissionType newPermission = accessControl.getPermission(uuid);
                                String newPermissionName = newPermission == null ? "NONE" : newPermission.name();
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.access_permission.updated", targetPlayer, uuid, ComponentUtils.translatable(TranslationKey.ACCESS_TYPE(newPermission), new Object[0]).fallback(newPermissionName)).color(NamedTextColor.GREEN));
                            }
                            catch (IllegalArgumentException e) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                            }
                            catch (Exception e) {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.unknown_error", new Object[0]).color(NamedTextColor.RED));
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("get")) {
            Player senderPlayer;
            if (!sender.hasPermission("imageframe.get")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            Player player = senderPlayer = sender instanceof Player ? (Player)sender : null;
            if (args.length <= 1) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                Player player2;
                ItemFrameSelectionManager.SelectedItemFrameResult selection;
                boolean combined;
                if (ImageFrame.combinedByDefault) {
                    combined = args.length <= 2 || !args[2].equalsIgnoreCase("separated");
                } else {
                    boolean bl = combined = args.length > 2 && args[2].equalsIgnoreCase("combined");
                }
                if (args.length > 2 && args[2].equalsIgnoreCase("selection") && senderPlayer != null) {
                    selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)senderPlayer);
                    if (selection == null) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.no_selection", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                } else {
                    selection = null;
                }
                if (selection == null && sender.hasPermission("imageframe.get.others")) {
                    int pos;
                    int n = pos = combined ? 3 : 2;
                    if (args.length > pos) {
                        player2 = Bukkit.getPlayer((String)args[pos]);
                        if (player2 == null) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.player_not_found", new Object[0]).color(NamedTextColor.RED));
                            return true;
                        }
                    } else {
                        if (!(sender instanceof Player)) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                            return true;
                        }
                        player2 = (Player)sender;
                    }
                } else {
                    if (!(sender instanceof Player)) {
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                        return true;
                    }
                    player2 = (Player)sender;
                }
                ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.GET)) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                if (selection != null && (imageMap.getWidth() != selection.getWidth() || imageMap.getHeight() != selection.getHeight())) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.incorrect_size", imageMap.getWidth(), imageMap.getHeight()).color(NamedTextColor.RED));
                    return true;
                }
                if (ImageFrame.requireEmptyMaps && senderPlayer != null && MapUtils.removeEmptyMaps(senderPlayer, imageMap.getMapViews().size(), true) < 0) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_enough_maps", imageMap.getMapViews().size()).color(NamedTextColor.RED));
                    return true;
                }
                if (combined) {
                    ImageFrame.combinedMapItemHandler.giveCombinedMap(imageMap, player2);
                } else if (selection == null) {
                    imageMap.giveMaps(player2, ImageFrame.mapItemFormat);
                } else {
                    AtomicBoolean flag = new AtomicBoolean(false);
                    imageMap.fillItemFrames(selection.getItemFrames(), selection.getRotation(), (frame, item) -> {
                        ItemStack originalItem = frame.getItem();
                        if (originalItem != null && !originalItem.getType().equals((Object)Material.AIR)) {
                            return false;
                        }
                        return PlayerUtils.isInteractionAllowed(player2, (Entity)frame);
                    }, (frame, item) -> {
                        PlayerUtils.giveItem(player2, item);
                        if (!flag.getAndSet(true)) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.item_frame_occupied", new Object[0]).color(NamedTextColor.RED));
                        }
                    }, ImageFrame.mapItemFormat);
                }
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_created", new Object[0]).color(NamedTextColor.GREEN));
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("admindelete")) {
            if (!sender.hasPermission("imageframe.admindelete")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length <= 1) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                int imageId = Integer.parseInt(args[1]);
                ImageMap imageMap = ImageFrame.imageMapManager.getFromImageId(imageId);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    ImageFrame.imageMapManager.deleteMap(imageMap.getImageIndex());
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.image_map_deleted", new Object[0]).color(NamedTextColor.YELLOW));
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                            PlayerInventory inventory = player.getInventory();
                            for (int i = 0; i < inventory.getSize(); ++i) {
                                ItemStack currentItem = inventory.getItem(i);
                                MapView currentMapView = MapUtils.getItemMapView(currentItem);
                                if (currentMapView == null || !ImageFrame.imageMapManager.isMapDeleted(currentMapView) || ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) continue;
                                inventory.setItem(i, new ItemStack(Material.MAP, currentItem.getAmount()));
                            }
                        }, (Entity)player);
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("adminsetcreator")) {
            if (!sender.hasPermission("imageframe.adminsetcreator")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length <= 2) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            try {
                int imageId = Integer.parseInt(args[1]);
                ImageMap imageMap = ImageFrame.imageMapManager.getFromImageId(imageId);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.not_an_image_map", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[2]);
                        imageMap.changeCreator(player.getUniqueId());
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.set_creator", imageMap.getImageIndex(), imageMap.getCreatorName(), imageMap.getCreator()).color(NamedTextColor.GREEN));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("adminmigrate")) {
            if (!sender.hasPermission("imageframe.adminmigrate")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length > 1) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    ExternalPluginMigration migration = PluginMigrationRegistry.getMigration(args[1]);
                    if (migration != null) {
                        if (migration.requirePlayer()) {
                            if (sender instanceof Player) {
                                CommandSenderUtils.sendMessage(sender, ChatColor.YELLOW + "Migration has begun, see console for progress, completion and errors");
                                migration.migrate(((Player)sender).getUniqueId());
                            } else {
                                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                            }
                        } else {
                            CommandSenderUtils.sendMessage(sender, ChatColor.YELLOW + "Migration has begun, see console for progress, completion and errors");
                            migration.migrate();
                        }
                    } else {
                        CommandSenderUtils.sendMessage(sender, args[1] + " is not a supported plugin for migration");
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("preference")) {
            if (!sender.hasPermission("imageframe.preference")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length <= 2) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            IFPlayerPreference<?> preference = IFPlayerPreference.valueOf(args[1].toUpperCase());
            if (preference == null) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            IFPlayerPreference.StringDeserializerResult<?> result = preference.getStringDeserializer().apply(args[2]);
            if (result.isAccepted()) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    UUID player;
                    if (args.length > 3) {
                        if (!sender.hasPermission("imageframe.preference.others")) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                            return;
                        }
                        player = Bukkit.getOfflinePlayer((String)args[3]).getUniqueId();
                    } else {
                        if (!(sender instanceof Player)) {
                            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                            return;
                        }
                        player = ((Player)sender).getUniqueId();
                    }
                    Object value = result.getValue();
                    IFPlayer ifPlayer = ImageFrame.ifPlayerManager.getIFPlayer(player);
                    ifPlayer.setPreference(preference, (PreferenceState)value);
                    try {
                        ifPlayer.save();
                        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.preferences.update_message", ComponentUtils.translatable(TranslationKey.PREFERENCES_TYPE(preference), new Object[0]).fallback(preference.name()).color(NamedTextColor.WHITE), ComponentUtils.translatable(TranslationKey.PREFERENCES_VALUE(value), new Object[0]).fallback(value.name()).color(value.getDisplayColor())).color(NamedTextColor.YELLOW));
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (args[0].equalsIgnoreCase("giveinvisibleframe")) {
            Player target;
            if (args.length <= 1) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (!sender.hasPermission("imageframe.giveinvisibleframe")) {
                CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
                return true;
            }
            if (args.length > 3) {
                target = Bukkit.getPlayer((String)args[3]);
                if (target == null) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.player_not_found", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
            } else {
                if (!(sender instanceof Player)) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_console", new Object[0]).color(NamedTextColor.RED));
                    return true;
                }
                target = (Player)sender;
            }
            String type = args[1];
            int amount = 1;
            try {
                amount = args.length > 2 ? Integer.parseInt(args[2]) : 1;
            }
            catch (NumberFormatException player) {
                // empty catch block
            }
            amount = Math.max(1, amount);
            ItemStack itemStack = type.equalsIgnoreCase("glowing") && ImageFrame.version.isNewerOrEqualTo(MCVersion.V1_17) ? new ItemStack(Material.valueOf((String)"GLOW_ITEM_FRAME")) : new ItemStack(Material.ITEM_FRAME);
            ItemStack modified = ImageFrame.invisibleFrameManager.withInvisibleItemFrameData(itemStack);
            PrimitiveIterator.OfInt itr = MathUtils.splitToChunksOf(amount, 64);
            while (true) {
                if (!itr.hasNext()) {
                    CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.given_invisible_frame", amount, target.getName()).color(NamedTextColor.GREEN));
                    return true;
                }
                ItemStack finalStack = modified.clone();
                finalStack.setAmount(itr.nextInt());
                PlayerUtils.giveItem(target, finalStack);
            }
        }
        if (!args[0].equalsIgnoreCase("storagemigrate")) {
            CommandSenderUtils.sendMessage(sender, ChatColorUtils.translateAlternateColorCodes('&', Bukkit.spigot().getConfig().getString("messages.unknown-command")));
            return true;
        }
        if (args.length <= 1) {
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.invalid_usage", new Object[0]).color(NamedTextColor.RED));
            return true;
        }
        if (sender.hasPermission("imageframe.storagemigrate")) {
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.storage_migration", new Object[0]).color(NamedTextColor.GREEN));
            Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                try {
                    ImageFrameStorageLoader<?> loader = ImageFrameStorageLoaders.getLoader(KeyUtils.imageFrameKey(args[1]));
                    boolean forced = args.length > 2 && args[2].equalsIgnoreCase("forced");
                    HashMap<String, String> options = new HashMap<String, String>();
                    int argIndex = 3;
                    for (String optionKey : loader.getRequiredOptions()) {
                        if (args.length <= argIndex) {
                            throw new IllegalArgumentException("Missing required option: " + optionKey);
                        }
                        options.put(optionKey, args[argIndex]);
                        ++argIndex;
                    }
                    for (String optionKey : loader.getOptionalOptions()) {
                        if (args.length > argIndex) {
                            options.put(optionKey, args[argIndex]);
                        }
                        ++argIndex;
                    }
                    try (ImageFrameStorage targetStorage = ImageFrameStorageLoaders.create(KeyUtils.imageFrameKey(args[1]), ImageFrame.plugin.getDataFolder(), options);
                         StorageMigrator storageMigrator = new StorageMigrator(ImageFrame.imageMapManager, ImageFrame.ifPlayerManager, targetStorage);){
                        if (!storageMigrator.isTargetEmpty() && !forced) {
                            throw new IllegalStateException("Target storage is not empty, if you wish to migrate anyway, please set the forced flag to true.");
                        }
                        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "[ImageFrame] Beginning to migrate image map data to " + loader.getIdentifier().asString());
                        storageMigrator.migrateImageMaps();
                        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "[ImageFrame] Beginning to migrate deleted maps data to " + loader.getIdentifier().asString());
                        storageMigrator.migrateDeletedMaps();
                        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "[ImageFrame] Beginning to migrate ImageFrame player data to " + loader.getIdentifier().asString());
                        storageMigrator.migrateIFPlayers();
                        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] Successfully migrated data to " + loader.getIdentifier().asString() + ", please stop the server and switch to that storage type in the config.");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
            return true;
        }
        CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.no_permission", new Object[0]).color(NamedTextColor.RED));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        LinkedList<String> tab = new LinkedList<String>();
        switch (args.length) {
            case 0: {
                if (sender.hasPermission("imageframe.reload")) {
                    tab.add("reload");
                }
                if (sender.hasPermission("imageframe.resync")) {
                    tab.add("resync");
                }
                if (sender.hasPermission("imageframe.create")) {
                    tab.add("create");
                }
                if (sender.hasPermission("imageframe.overlay")) {
                    tab.add("overlay");
                }
                if (sender.hasPermission("imageframe.clone")) {
                    tab.add("clone");
                }
                if (sender.hasPermission("imageframe.playback")) {
                    tab.add("playback");
                }
                if (sender.hasPermission("imageframe.select")) {
                    tab.add("select");
                }
                if (sender.hasPermission("imageframe.refresh")) {
                    tab.add("refresh");
                }
                if (sender.hasPermission("imageframe.rename")) {
                    tab.add("rename");
                }
                if (sender.hasPermission("imageframe.info")) {
                    tab.add("info");
                }
                if (sender.hasPermission("imageframe.list")) {
                    tab.add("list");
                }
                if (sender.hasPermission("imageframe.delete")) {
                    tab.add("delete");
                }
                if (sender.hasPermission("imageframe.purge")) {
                    tab.add("purge");
                }
                if (sender.hasPermission("imageframe.get")) {
                    tab.add("get");
                }
                if (sender.hasPermission("imageframe.update")) {
                    tab.add("update");
                }
                if (sender.hasPermission("imageframe.marker")) {
                    tab.add("marker");
                }
                if (sender.hasPermission("imageframe.setaccess")) {
                    tab.add("setaccess");
                }
                if (sender.hasPermission("imageframe.admindelete")) {
                    tab.add("admindelete");
                }
                if (sender.hasPermission("imageframe.adminsetcreator")) {
                    tab.add("adminsetcreator");
                }
                if (sender.hasPermission("imageframe.adminmigrate")) {
                    tab.add("adminmigrate");
                }
                if (sender.hasPermission("imageframe.preference")) {
                    tab.add("preference");
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe")) {
                    tab.add("giveinvisibleframe");
                }
                if (sender.hasPermission("imageframe.storagemigrate")) {
                    tab.add("storagemigrate");
                }
                return tab;
            }
            case 1: {
                if (sender.hasPermission("imageframe.reload") && "reload".startsWith(args[0].toLowerCase())) {
                    tab.add("reload");
                }
                if (sender.hasPermission("imageframe.resync") && "resync".startsWith(args[0].toLowerCase())) {
                    tab.add("resync");
                }
                if (sender.hasPermission("imageframe.create") && "create".startsWith(args[0].toLowerCase())) {
                    tab.add("create");
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".startsWith(args[0].toLowerCase())) {
                    tab.add("overlay");
                }
                if (sender.hasPermission("imageframe.clone") && "clone".startsWith(args[0].toLowerCase())) {
                    tab.add("clone");
                }
                if (sender.hasPermission("imageframe.playback") && "playback".startsWith(args[0].toLowerCase())) {
                    tab.add("playback");
                }
                if (sender.hasPermission("imageframe.select") && "select".startsWith(args[0].toLowerCase())) {
                    tab.add("select");
                }
                if (sender.hasPermission("imageframe.refresh") && "refresh".startsWith(args[0].toLowerCase())) {
                    tab.add("refresh");
                }
                if (sender.hasPermission("imageframe.rename") && "rename".startsWith(args[0].toLowerCase())) {
                    tab.add("rename");
                }
                if (sender.hasPermission("imageframe.info") && "info".startsWith(args[0].toLowerCase())) {
                    tab.add("info");
                }
                if (sender.hasPermission("imageframe.list") && "list".startsWith(args[0].toLowerCase())) {
                    tab.add("list");
                }
                if (sender.hasPermission("imageframe.delete") && "delete".startsWith(args[0].toLowerCase())) {
                    tab.add("delete");
                }
                if (sender.hasPermission("imageframe.purge") && "purge".startsWith(args[0].toLowerCase())) {
                    tab.add("purge");
                }
                if (sender.hasPermission("imageframe.get") && "get".startsWith(args[0].toLowerCase())) {
                    tab.add("get");
                }
                if (sender.hasPermission("imageframe.update") && "update".startsWith(args[0].toLowerCase())) {
                    tab.add("update");
                }
                if (sender.hasPermission("imageframe.marker") && "marker".startsWith(args[0].toLowerCase())) {
                    tab.add("marker");
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".startsWith(args[0].toLowerCase())) {
                    tab.add("setaccess");
                }
                if (sender.hasPermission("imageframe.admindelete") && "admindelete".startsWith(args[0].toLowerCase())) {
                    tab.add("admindelete");
                }
                if (sender.hasPermission("imageframe.adminsetcreator") && "adminsetcreator".startsWith(args[0].toLowerCase())) {
                    tab.add("adminsetcreator");
                }
                if (sender.hasPermission("imageframe.adminmigrate") && "adminmigrate".startsWith(args[0].toLowerCase())) {
                    tab.add("adminmigrate");
                }
                if (sender.hasPermission("imageframe.preference") && "preference".startsWith(args[0].toLowerCase())) {
                    tab.add("preference");
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".startsWith(args[0].toLowerCase())) {
                    tab.add("giveinvisibleframe");
                }
                if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".startsWith(args[0].toLowerCase())) {
                    tab.add("storagemigrate");
                }
                return tab;
            }
            case 2: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    tab.add("<name>");
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0])) {
                    tab.add("<name>");
                }
                if (sender.hasPermission("imageframe.clone") && "clone".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.playback") && "playback".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1], ImageMapAccessPermissionType.ADJUST_PLAYBACK, imageMap -> imageMap.requiresAnimationService()));
                }
                if (sender.hasPermission("imageframe.refresh") && "refresh".equalsIgnoreCase(args[0])) {
                    tab.add("[url]");
                    if (ImageFrame.imageUploadManager.isOperational() && "upload".startsWith(args[1].toLowerCase())) {
                        tab.add("upload");
                    }
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[1].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.select") && "list".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.list.others") && "list".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.rename") && "rename".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.info") && "info".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.delete") && "delete".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.purge") && "purge".equalsIgnoreCase(args[0])) {
                    tab.add("<player>");
                }
                if (sender.hasPermission("imageframe.get") && "get".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0])) {
                    if ("add".startsWith(args[1].toLowerCase())) {
                        tab.add("add");
                    }
                    if ("remove".startsWith(args[1].toLowerCase())) {
                        tab.add("remove");
                    }
                    if ("clear".startsWith(args[1].toLowerCase())) {
                        tab.add("clear");
                    }
                    if (sender instanceof Player && ImageFrame.mapMarkerEditManager.isActiveEditing((Player)sender) && "cancel".startsWith(args[1].toLowerCase())) {
                        tab.add("cancel");
                    }
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.admindelete") && "admindelete".equalsIgnoreCase(args[0])) {
                    tab.add("<image-id>");
                }
                if (sender.hasPermission("imageframe.adminsetcreator") && "adminsetcreator".equalsIgnoreCase(args[0])) {
                    tab.add("<image-id>");
                }
                if (sender.hasPermission("imageframe.adminmigrate") && "adminmigrate".equalsIgnoreCase(args[0])) {
                    for (String string : PluginMigrationRegistry.getPluginNames()) {
                        if (!string.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.preference") && "preference".equalsIgnoreCase(args[0])) {
                    for (IFPlayerPreference iFPlayerPreference : IFPlayerPreference.values()) {
                        if (!iFPlayerPreference.name().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(iFPlayerPreference.name().toLowerCase());
                    }
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".equalsIgnoreCase(args[0])) {
                    if ("regular".startsWith(args[1].toLowerCase())) {
                        tab.add("regular");
                    }
                    if (ImageFrame.version.isNewerOrEqualTo(MCVersion.V1_17) && "glowing".startsWith(args[1].toLowerCase())) {
                        tab.add("glowing");
                    }
                }
                if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".equalsIgnoreCase(args[0])) {
                    for (ImageFrameStorageLoader imageFrameStorageLoader : ImageFrameStorageLoaders.getRegisteredLoaders()) {
                        if (ImageFrame.imageFrameStorage.getLoader().getIdentifier().equals(imageFrameStorageLoader.getIdentifier()) || !imageFrameStorageLoader.getIdentifier().asString().startsWith(args[1].toLowerCase())) continue;
                        tab.add(imageFrameStorageLoader.getIdentifier().asString());
                    }
                }
                return tab;
            }
            case 3: {
                IFPlayerPreference<?> preference;
                Object imageMap2;
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    tab.add("<url>");
                    if (ImageFrame.imageUploadManager.isOperational() && "upload".startsWith(args[2].toLowerCase())) {
                        tab.add("upload");
                    }
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0])) {
                    tab.add("<url>");
                    if (ImageFrame.imageUploadManager.isOperational() && "upload".startsWith(args[2].toLowerCase())) {
                        tab.add("upload");
                    }
                }
                if (sender.hasPermission("imageframe.clone") && "clone".equalsIgnoreCase(args[0])) {
                    tab.add("<new-name>");
                }
                if (sender.hasPermission("imageframe.playback") && "playback".equalsIgnoreCase(args[0])) {
                    if ("pause".startsWith(args[2].toUpperCase())) {
                        tab.add("pause");
                    }
                    if ("jumpto".startsWith(args[2].toLowerCase())) {
                        tab.add("jumpto");
                    }
                }
                if (sender.hasPermission("imageframe.refresh") && "refresh".equalsIgnoreCase(args[0]) && (imageMap2 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1])) != null) {
                    tab.add("[url]");
                    if (ImageFrame.imageUploadManager.isOperational() && "upload".startsWith(args[2].toLowerCase())) {
                        tab.add("upload");
                    }
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[2].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.get") && "get".equalsIgnoreCase(args[0])) {
                    if (sender instanceof Player && "selection".startsWith(args[2].toLowerCase())) {
                        tab.add("selection");
                    }
                    if (ImageFrame.combinedByDefault) {
                        if ("separated".startsWith(args[2].toLowerCase())) {
                            tab.add("separated");
                        }
                    } else if ("combined".startsWith(args[2].toLowerCase())) {
                        tab.add("combined");
                    }
                    if (sender.hasPermission("imageframe.get.others")) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                            tab.add(player.getName());
                        }
                    }
                }
                if (sender.hasPermission("imageframe.rename") && "rename".equalsIgnoreCase(args[0])) {
                    tab.add("<new-name>");
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0])) {
                    if ("add".equalsIgnoreCase(args[1])) {
                        tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[2]));
                    }
                    if ("remove".equalsIgnoreCase(args[1])) {
                        tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[2]));
                    }
                    if ("clear".equalsIgnoreCase(args[1])) {
                        tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[2]));
                    }
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".equalsIgnoreCase(args[0])) {
                    ImageMap imageMap3 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                    UUID uUID = imageMap3 == null ? null : imageMap3.getCreator();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (player.getUniqueId().equals(uUID) || !player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                    if ("*".startsWith(args[2].toLowerCase())) {
                        tab.add("*");
                    }
                }
                if (sender.hasPermission("imageframe.adminsetcreator") && "adminsetcreator".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.preference") && "preference".equalsIgnoreCase(args[0]) && (preference = IFPlayerPreference.valueOf(args[1].toUpperCase())) != null) {
                    tab.addAll(preference.getSuggestedValues().keySet());
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".equalsIgnoreCase(args[0])) {
                    tab.add("<amount>");
                }
                if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".equalsIgnoreCase(args[0])) {
                    if ("normal".startsWith(args[2].toLowerCase())) {
                        tab.add("normal");
                    }
                    if ("forced".startsWith(args[2].toLowerCase())) {
                        tab.add("forced");
                    }
                }
                return tab;
            }
            case 4: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    if (args[3].matches("(?i)[0-9]*")) {
                        tab.add("<width>");
                    }
                    if ("selection".startsWith(args[3].toLowerCase())) {
                        tab.add("selection");
                    }
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0])) {
                    if ("selection".startsWith(args[3].toLowerCase())) {
                        tab.add("selection");
                    }
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[3].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.clone") && "clone".equalsIgnoreCase(args[0])) {
                    if ("selection".startsWith(args[3].toLowerCase())) {
                        tab.add("selection");
                    }
                    if (ImageFrame.combinedByDefault) {
                        if ("separated".startsWith(args[3].toLowerCase())) {
                            tab.add("separated");
                        }
                    } else if ("combined".startsWith(args[3].toLowerCase())) {
                        tab.add("combined");
                    }
                }
                if (sender.hasPermission("imageframe.playback") && "playback".equalsIgnoreCase(args[0])) {
                    if ("pause".equalsIgnoreCase(args[2])) {
                        if ("true".startsWith(args[3].toLowerCase())) {
                            tab.add("true");
                        }
                        if ("false".startsWith(args[3].toLowerCase())) {
                            tab.add("false");
                        }
                    }
                    if ("jumpto".equalsIgnoreCase(args[2])) {
                        tab.add("0.0");
                    }
                }
                if (sender.hasPermission("imageframe.get") && "get".equalsIgnoreCase(args[0]) && args[2].equalsIgnoreCase(ImageFrame.combinedByDefault ? "separated" : "combined") && sender.hasPermission("imageframe.get.others")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0])) {
                    Object imageMap3;
                    if ("add".equalsIgnoreCase(args[1])) {
                        tab.add("<marker-name>");
                    }
                    if ("remove".equalsIgnoreCase(args[1]) && sender instanceof Player && (imageMap3 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[2])) != null) {
                        for (Map<String, MapCursor> map : ((ImageMap)imageMap3).getMapMarkers()) {
                            for (String name : map.keySet()) {
                                if (!name.toLowerCase().startsWith(args[3].toLowerCase())) continue;
                                tab.add(name);
                            }
                        }
                    }
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".equalsIgnoreCase(args[0])) {
                    for (String string : ImageMapAccessPermissionType.values().keySet()) {
                        if (!string.toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(string);
                    }
                    if ("NONE".toLowerCase().startsWith(args[3].toLowerCase())) {
                        tab.add("NONE");
                    }
                }
                if (sender.hasPermission("imageframe.preference.others") && "preference".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".equalsIgnoreCase(args[0])) {
                    try {
                        ImageFrameStorageLoader<?> loader = ImageFrameStorageLoaders.getLoader(KeyUtils.imageFrameKey(args[1]));
                        Stream.concat(Arrays.stream(loader.getRequiredOptions()).map(k -> "<" + k + ">"), Arrays.stream(loader.getOptionalOptions()).map(k -> "[" + k + "]")).findFirst().ifPresent(optionKey -> tab.add((String)optionKey));
                    }
                    catch (Throwable loader) {
                        // empty catch block
                    }
                }
                return tab;
            }
            case 5: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    if (!args[3].equalsIgnoreCase("selection")) {
                        tab.add("<height>");
                    } else {
                        for (String string : DitheringType.values().keySet()) {
                            if (!string.startsWith(args[4].toLowerCase())) continue;
                            tab.add(string);
                        }
                    }
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0]) && args[3].equalsIgnoreCase("selection")) {
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[4].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0]) && "add".equalsIgnoreCase(args[1])) {
                    for (int i = 0; i < 16; ++i) {
                        if (!String.valueOf(i).startsWith(args[4])) continue;
                        tab.add(String.valueOf(i));
                    }
                }
                if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".equalsIgnoreCase(args[0])) {
                    try {
                        ImageFrameStorageLoader<?> loader = ImageFrameStorageLoaders.getLoader(KeyUtils.imageFrameKey(args[1]));
                        Stream.concat(Arrays.stream(loader.getRequiredOptions()).map(k -> "<" + k + ">"), Arrays.stream(loader.getOptionalOptions()).map(k -> "[" + k + "]")).skip(1L).findFirst().ifPresent(optionKey -> tab.add((String)optionKey));
                    }
                    catch (Throwable loader) {
                        // empty catch block
                    }
                }
                return tab;
            }
            case 6: {
                Object loader;
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0]) && !args[3].equalsIgnoreCase("selection")) {
                    if (ImageFrame.combinedByDefault) {
                        if ("separated".startsWith(args[5].toLowerCase())) {
                            tab.add("separated");
                        }
                    } else if ("combined".startsWith(args[5].toLowerCase())) {
                        tab.add("combined");
                    }
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[5].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0]) && "add".equalsIgnoreCase(args[1])) {
                    void var8_59;
                    loader = MapCursor.Type.values();
                    int n = ((MapCursor.Type[])loader).length;
                    boolean bl = false;
                    while (var8_59 < n) {
                        Object type = loader[var8_59];
                        if (type.name().toLowerCase().startsWith(args[5].toLowerCase())) {
                            tab.add(type.name().toLowerCase());
                        }
                        ++var8_59;
                    }
                }
                if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".equalsIgnoreCase(args[0])) {
                    try {
                        loader = ImageFrameStorageLoaders.getLoader(KeyUtils.imageFrameKey(args[1]));
                        Stream.concat(Arrays.stream(loader.getRequiredOptions()).map(k -> "<" + k + ">"), Arrays.stream(loader.getOptionalOptions()).map(k -> "[" + k + "]")).skip(2L).findFirst().ifPresent(optionKey -> tab.add((String)optionKey));
                    }
                    catch (Throwable loader2) {
                        // empty catch block
                    }
                }
                return tab;
            }
            case 7: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0]) && !args[3].equalsIgnoreCase("selection") && !args[5].equalsIgnoreCase(ImageFrame.combinedByDefault ? "separated" : "combined")) {
                    if (ImageFrame.combinedByDefault) {
                        if ("separated".startsWith(args[6].toLowerCase())) {
                            tab.add("separated");
                        }
                    } else if ("combined".startsWith(args[6].toLowerCase())) {
                        tab.add("combined");
                    }
                }
                if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".equalsIgnoreCase(args[0])) {
                    try {
                        ImageFrameStorageLoader<?> loader = ImageFrameStorageLoaders.getLoader(KeyUtils.imageFrameKey(args[1]));
                        Stream.concat(Arrays.stream(loader.getRequiredOptions()).map(k -> "<" + k + ">"), Arrays.stream(loader.getOptionalOptions()).map(k -> "[" + k + "]")).skip(3L).findFirst().ifPresent(optionKey -> tab.add((String)optionKey));
                    }
                    catch (Throwable loader) {
                        // empty catch block
                    }
                }
                return tab;
            }
        }
        if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0]) && "add".equalsIgnoreCase(args[1])) {
            tab.add("[caption]...");
        }
        if (sender.hasPermission("imageframe.storagemigrate") && "storagemigrate".equalsIgnoreCase(args[0])) {
            try {
                ImageFrameStorageLoader<?> loader = ImageFrameStorageLoaders.getLoader(KeyUtils.imageFrameKey(args[1]));
                Stream.concat(Arrays.stream(loader.getRequiredOptions()).map(k -> "<" + k + ">"), Arrays.stream(loader.getOptionalOptions()).map(k -> "[" + k + "]")).skip(args.length - 4).findFirst().ifPresent(optionKey -> tab.add((String)optionKey));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return tab;
    }
}

