/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.libs.com.loohp.platformscheduler;

import com.loohp.imageframe.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public abstract class ScheduledRunnable
implements Runnable {
    private ScheduledTask task;

    public synchronized boolean isCancelled() {
        this.checkScheduled();
        return this.task.isCancelled();
    }

    public synchronized void cancel() {
        this.checkScheduled();
        this.task.cancel();
    }

    public synchronized ScheduledTask runTask(Plugin plugin, Entity entity) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTask(plugin, (Runnable)this, entity));
    }

    public synchronized ScheduledTask runTaskLater(Plugin plugin, long delay, Entity entity) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskLater(plugin, (Runnable)this, delay, entity));
    }

    public synchronized ScheduledTask runTaskTimer(Plugin plugin, long delay, long period, Entity entity) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskTimer(plugin, (Runnable)this, delay, period, entity));
    }

    public synchronized ScheduledTask runTask(Plugin plugin, Location location) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTask(plugin, (Runnable)this, location));
    }

    public synchronized ScheduledTask runTaskLater(Plugin plugin, long delay, Location location) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskLater(plugin, (Runnable)this, delay, location));
    }

    public synchronized ScheduledTask runTaskTimer(Plugin plugin, long delay, long period, Location location) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskTimer(plugin, (Runnable)this, delay, period, location));
    }

    public synchronized ScheduledTask runTask(Plugin plugin, Chunk chunk) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTask(plugin, (Runnable)this, chunk));
    }

    public synchronized ScheduledTask runTaskLater(Plugin plugin, long delay, Chunk chunk) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskLater(plugin, (Runnable)this, delay, chunk));
    }

    public synchronized ScheduledTask runTaskTimer(Plugin plugin, long delay, long period, Chunk chunk) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskTimer(plugin, (Runnable)this, delay, period, chunk));
    }

    public synchronized ScheduledTask runTask(Plugin plugin, World world, int chunkX, int chunkZ) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTask(plugin, this, world, chunkX, chunkZ));
    }

    public synchronized ScheduledTask runTaskLater(Plugin plugin, long delay, World world, int chunkX, int chunkZ) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskLater(plugin, this, delay, world, chunkX, chunkZ));
    }

    public synchronized ScheduledTask runTaskTimer(Plugin plugin, long delay, long period, World world, int chunkX, int chunkZ) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskTimer(plugin, this, delay, period, world, chunkX, chunkZ));
    }

    public synchronized ScheduledTask runTask(Plugin plugin) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTask(plugin, this));
    }

    public synchronized ScheduledTask runTaskLater(Plugin plugin, long delay) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskLater(plugin, this, delay));
    }

    public synchronized ScheduledTask runTaskTimer(Plugin plugin, long delay, long period) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskTimer(plugin, this, delay, period));
    }

    public synchronized ScheduledTask runTaskAsynchronously(Plugin plugin) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskAsynchronously(plugin, this));
    }

    public synchronized ScheduledTask runTaskLaterAsynchronously(Plugin plugin, long delay) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskLaterAsynchronously(plugin, this, delay));
    }

    public synchronized ScheduledTask runTaskTimerAsynchronously(Plugin plugin, long delay, long period) {
        this.checkNotYetScheduled();
        return this.setupTask(Scheduler.runTaskTimerAsynchronously(plugin, this, delay, period));
    }

    private void checkScheduled() {
        if (this.task == null) {
            throw new IllegalStateException("Not scheduled yet");
        }
    }

    private void checkNotYetScheduled() {
        if (this.task != null) {
            throw new IllegalStateException("Already scheduled as " + this.task);
        }
    }

    private ScheduledTask setupTask(ScheduledTask task) {
        this.task = task;
        return task;
    }
}

