/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.utils.dithering.FloydSteinbergDithering;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.map.MapPalette;

public class DitheringType {
    private static final Map<String, DitheringType> REGISTERED_TYPES = new LinkedHashMap<String, DitheringType>();
    public static final DitheringType NEAREST_COLOR = DitheringType.register(new DitheringType("nearest-color", image -> MapPalette.imageToBytes((Image)image)));
    public static final DitheringType FLOYD_STEINBERG = DitheringType.register(new DitheringType("floyd-steinberg", image -> FloydSteinbergDithering.floydSteinbergDithering(image)));
    private final String name;
    private final Function<BufferedImage, byte[]> applyDithering;

    public static DitheringType register(DitheringType ditheringType) {
        REGISTERED_TYPES.put(ditheringType.getName(), ditheringType);
        return ditheringType;
    }

    public static Map<String, DitheringType> values() {
        return Collections.unmodifiableMap(REGISTERED_TYPES);
    }

    public static DitheringType fromName(String name) {
        return REGISTERED_TYPES.getOrDefault(name, NEAREST_COLOR);
    }

    public static DitheringType fromNameOrNull(String name) {
        return REGISTERED_TYPES.get(name);
    }

    public DitheringType(String name, Function<BufferedImage, byte[]> applyDithering) {
        this.name = name;
        this.applyDithering = applyDithering;
    }

    public String getName() {
        return this.name;
    }

    public byte[] applyDithering(BufferedImage image) {
        return this.applyDithering.apply(image);
    }
}

