/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.storage;

import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.storage.ImageFrameStorageLoader;
import com.loohp.imageframe.storage.JdbcImageFrameStorage;
import java.io.File;
import java.util.Map;

public class JdbcImageFrameStorageLoader
implements ImageFrameStorageLoader<JdbcImageFrameStorage> {
    private static final Key IDENTIFIER = Key.key("imageframe", "jdbc");
    private static final String[] REQUIRED_OPTIONS = new String[]{"JdbcUrl", "Username", "Password"};
    private static final String[] OPTIONAL_OPTIONS = new String[]{"ActivePollInterval"};

    @Override
    public Key getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public String[] getRequiredOptions() {
        return REQUIRED_OPTIONS;
    }

    @Override
    public String[] getOptionalOptions() {
        return OPTIONAL_OPTIONS;
    }

    @Override
    public JdbcImageFrameStorage create(File dataFolder, Map<String, String> options) {
        String jdbcUrl = options.get("JdbcUrl");
        String username = options.get("Username");
        String password = options.get("Password");
        int activePollInterval = 100;
        try {
            activePollInterval = Integer.parseInt(options.get("ActivePollInterval")) * 20;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (jdbcUrl == null || username == null || password == null) {
            throw new IllegalArgumentException("Missing database details");
        }
        return new JdbcImageFrameStorage(new File(dataFolder, "data"), jdbcUrl, username, password, activePollInterval);
    }
}

