/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.language;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.debug.Debug;
import com.loohp.imageframe.libs.net.kyori.adventure.text.Component;
import com.loohp.imageframe.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.imageframe.libs.net.kyori.adventure.text.TranslationArgument;
import com.loohp.imageframe.utils.HTTPRequestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LanguageManager {
    public static final String LANGUAGE_META_URL = "https://api.loohpjames.com/spigot/plugins/imageframe/language";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
    private final File languageFolder = new File(ImageFrame.plugin.getDataFolder(), "language");
    private final Map<String, Map<String, String>> translations;

    public LanguageManager() {
        this.languageFolder.mkdirs();
        this.translations = new ConcurrentHashMap<String, Map<String, String>>();
        this.reloadLanguages();
    }

    public void reloadLanguages() {
        this.downloadTranslations();
        this.translations.clear();
        this.loadTranslations();
    }

    public Set<String> getLoadedLanguages() {
        return Collections.unmodifiableSet(this.translations.keySet());
    }

    public void downloadTranslations() {
        try {
            JsonObject json;
            JsonObject languageHashes;
            File languageHashFile = new File(ImageFrame.plugin.getDataFolder(), "language_hashes.json");
            if (languageHashFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(languageHashFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    languageHashes = GSON.fromJson((Reader)reader, JsonObject.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    languageHashes = new JsonObject();
                }
            } else {
                languageHashes = new JsonObject();
            }
            try {
                Debug.debug("Downloading language meta...");
                json = HTTPRequestUtils.getJsonResponse(LANGUAGE_META_URL);
            }
            catch (Exception e) {
                throw new IOException("Unable to fetch language meta from \"api.loohpjames.com\". This could be an internet issue or \"api.loohpjames.com\" is down. If the plugin functions correctly after this, this error can be ignored.", e);
            }
            for (JsonElement element : json.get("languages").getAsJsonArray()) {
                String existingHash;
                JsonObject languageObj = element.getAsJsonObject();
                String language = languageObj.get("language").getAsString();
                String url = languageObj.get("url").getAsString();
                String hash = languageObj.get("hash").getAsString();
                String string = existingHash = languageHashes.has(language) ? languageHashes.get(language).getAsString() : null;
                if (!hash.equalsIgnoreCase(existingHash)) {
                    Debug.debug("Downloading language " + language + "...");
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(HTTPRequestUtils.getInputStream(url), StandardCharsets.UTF_8));
                         PrintWriter writer = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(new File(this.languageFolder, language + ".json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                        reader.lines().forEachOrdered(l -> writer.println((String)l));
                        writer.flush();
                    }
                    catch (IOException e) {
                        new IOException("Unable to download language " + language + " from " + url, e).printStackTrace();
                    }
                }
                languageHashes.addProperty(language, hash);
            }
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(languageHashFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                writer.println(GSON.toJson(languageHashes));
                writer.flush();
            }
            catch (IOException e) {
                new IOException("Unable to save language hashes to " + languageHashFile.getAbsolutePath(), e).printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void loadTranslations() {
        for (File file : this.languageFolder.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(".json")) continue;
            String language = name.substring(0, name.indexOf("."));
            ConcurrentHashMap<String, String> translations = new ConcurrentHashMap<String, String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                JsonObject jsonObject = GSON.fromJson((Reader)reader, JsonObject.class);
                for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                    translations.put(entry.getKey(), entry.getValue().getAsString());
                }
            }
            catch (Exception e) {
                new IOException("Unable to load language file " + file.getAbsolutePath(), e).printStackTrace();
            }
            this.translations.put(language, translations);
        }
    }

    public String getTranslation(String key, String language) {
        String translation = (String)this.translations.getOrDefault(language.toLowerCase(), Collections.emptyMap()).get(key);
        if (translation != null) {
            return translation;
        }
        if (ImageFrame.language.equalsIgnoreCase(language)) {
            return null;
        }
        return this.getTranslation(key, ImageFrame.language);
    }

    public List<String> getListTranslation(String key, String language) {
        return this.getListTranslation(key, language, 127);
    }

    public List<String> getListTranslation(String key, String language, int maxSize) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < maxSize; ++i) {
            String translated = this.getTranslation(key + "." + i, language);
            if (translated == null) {
                return result;
            }
            result.add(translated);
        }
        return result;
    }

    public Component resolve(Component component, String language) {
        if (component instanceof TranslatableComponent) {
            component = this.convertSingleTranslatable((TranslatableComponent)component, language);
        }
        ArrayList<Component> children = new ArrayList<Component>(component.children());
        children.replaceAll(child -> this.resolve((Component)child, language));
        return component.children(children);
    }

    private Component convertSingleTranslatable(TranslatableComponent component, String language) {
        String tail;
        String translation = this.getTranslation(component.key(), language);
        if (translation == null) {
            return component;
        }
        List<TranslationArgument> arguments = component.arguments();
        Matcher matcher = FORMAT_PATTERN.matcher(translation);
        int lastEnd = 0;
        int nextUnindexed = 0;
        ArrayList<Component> parts = new ArrayList<Component>();
        while (matcher.find()) {
            String indexGroup;
            int argIndex;
            String literal;
            if (matcher.start() > lastEnd && !(literal = translation.substring(lastEnd, matcher.start())).isEmpty()) {
                parts.add(Component.text(literal));
            }
            if ((argIndex = (indexGroup = matcher.group(1)) != null ? Integer.parseInt(indexGroup) - 1 : nextUnindexed++) >= 0 && argIndex < arguments.size()) {
                parts.add(arguments.get(argIndex).asComponent());
            } else {
                parts.add(Component.text(matcher.group()));
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < translation.length() && !(tail = translation.substring(lastEnd)).isEmpty()) {
            parts.add(Component.text(tail));
        }
        Component result = Component.empty().style(component.style());
        for (Component part : parts) {
            result = result.append(part);
        }
        for (Component child : component.children()) {
            result = result.append(child);
        }
        return result;
    }
}

