/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.migration;

import com.loohp.imageframe.migration.DrMapMigration;
import com.loohp.imageframe.migration.ExternalPluginMigration;
import com.loohp.imageframe.migration.ImageMapMigration;
import com.loohp.imageframe.migration.ImageOnMapMigration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PluginMigrationRegistry {
    private static final Map<String, ExternalPluginMigration> REGISTERED_MIGRATIONS = new ConcurrentHashMap<String, ExternalPluginMigration>();
    public static final DrMapMigration DR_MAP_MIGRATION = PluginMigrationRegistry.register(new DrMapMigration());
    public static final ImageOnMapMigration IMAGE_ON_MAP_MIGRATION = PluginMigrationRegistry.register(new ImageOnMapMigration());
    public static final ImageMapMigration IMAGE_MAP_MIGRATION = PluginMigrationRegistry.register(new ImageMapMigration());

    public static Set<String> getPluginNames() {
        return REGISTERED_MIGRATIONS.keySet();
    }

    public static ExternalPluginMigration getMigration(String plugin) {
        ExternalPluginMigration migration = REGISTERED_MIGRATIONS.get(plugin);
        if (migration != null) {
            return migration;
        }
        return REGISTERED_MIGRATIONS.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(plugin)).findFirst().map(e -> (ExternalPluginMigration)e.getValue()).orElse(null);
    }

    public static <T extends ExternalPluginMigration> T register(T migration) {
        REGISTERED_MIGRATIONS.put(migration.externalPluginName(), migration);
        return migration;
    }
}

