/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.common.base.Strings;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.libs.net.kyori.adventure.text.Component;
import com.loohp.imageframe.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.imageframe.objectholders.ComponentTemplate;
import com.loohp.imageframe.objectholders.ImageMapCreationTaskManager;
import com.loohp.imageframe.utils.CommandSenderUtils;
import com.loohp.imageframe.utils.ThrowingSupplier;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ImageMapCreationTask<T>
extends CompletableFuture<T>
implements Runnable {
    private final ImageMapCreationTaskManager manager;
    private final UUID creationTaskId;
    private final UUID creator;
    private final ThrowingSupplier<T> creationTask;
    private final ScheduledTask monitorTask;
    private final ComponentTemplate queuingMessageTemplate;
    private final ComponentTemplate processingMessageTemplate;
    private final AtomicBoolean queuing;
    private final AtomicInteger tick;
    private final AtomicInteger processingStart;
    private final Future<?> submission;

    public ImageMapCreationTask(ImageMapCreationTaskManager manager, UUID creator, ThrowingSupplier<T> creationTask, ExecutorService executor, String imageMapName) {
        this.manager = manager;
        this.creationTaskId = UUID.randomUUID();
        this.creator = creator;
        this.creationTask = creationTask;
        this.manager.getTaskInQueue().add(this);
        this.queuingMessageTemplate = ComponentTemplate.template("imageframe.messages.image_map_queued_action_bar", imageMapName);
        this.processingMessageTemplate = ComponentTemplate.template("imageframe.messages.image_map_processing_action_bar", imageMapName);
        this.monitorTask = Scheduler.runTaskTimerAsynchronously((Plugin)ImageFrame.plugin, new MonitorTask(), 0L, 10L);
        this.tick = new AtomicInteger(0);
        this.processingStart = new AtomicInteger(-1);
        this.queuing = new AtomicBoolean(true);
        this.submission = executor.submit(this);
    }

    public ImageMapCreationTaskManager getManager() {
        return this.manager;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public UUID getCreationTaskId() {
        return this.creationTaskId;
    }

    public boolean isQueuing() {
        return this.queuing.get();
    }

    public int getPositionInQueue() {
        return this.manager.getPositionInQueue(this);
    }

    @Override
    public void run() {
        this.manager.getTaskInQueue().remove(this);
        this.queuing.set(false);
        try {
            this.complete(this.creationTask.get());
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    public boolean isCompleted() {
        return this.monitorTask.isCancelled();
    }

    public void complete(Component message) {
        if (!this.isCompleted()) {
            this.monitorTask.cancel();
            this.manager.getCreatorsInQueue().remove(this.creator);
            Player player = Bukkit.getPlayer((UUID)this.creator);
            if (player != null) {
                CommandSenderUtils.sendMessage((CommandSender)player, ChatMessageType.ACTION_BAR, message);
            }
        }
    }

    private class MonitorTask
    implements Runnable {
        private MonitorTask() {
        }

        @Override
        public void run() {
            ImageMapCreationTask.this.processingStart.updateAndGet(currentProcessingStart -> {
                int currentTick = ImageMapCreationTask.this.tick.get();
                if (currentProcessingStart < 0) {
                    if (!ImageMapCreationTask.this.queuing.get()) {
                        return currentTick;
                    }
                } else if (currentTick - currentProcessingStart > ImageFrame.maxProcessingTime * 20) {
                    ImageMapCreationTask.this.submission.cancel(true);
                }
                return currentProcessingStart;
            });
            Player player = Bukkit.getPlayer((UUID)ImageMapCreationTask.this.creator);
            if (player != null) {
                TranslatableComponent message;
                if (ImageMapCreationTask.this.queuing.get()) {
                    int position = ImageMapCreationTask.this.getPositionInQueue() + 1;
                    message = ImageMapCreationTask.this.queuingMessageTemplate.build(position);
                } else {
                    int dots = ImageMapCreationTask.this.tick.getAndIncrement() % 4;
                    message = ImageMapCreationTask.this.processingMessageTemplate.build(Strings.repeat((String)".", (int)dots));
                }
                if (!message.key().isEmpty()) {
                    CommandSenderUtils.sendMessage((CommandSender)player, ChatMessageType.ACTION_BAR, message);
                }
            }
        }
    }
}

