/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.imageframe.objectholders.IFPlayerManager;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapLoaders;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.LazyDataSource;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.storage.FileImageFrameStorageLoader;
import com.loohp.imageframe.storage.ImageFrameStorage;
import com.loohp.imageframe.storage.ImageFrameStorageLoaders;
import com.loohp.imageframe.utils.FileUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;

public class FileImageFrameStorage
implements ImageFrameStorage {
    private final File imageMapFolder;
    private final File playerDataFolder;
    private final AtomicInteger mapIndexCounter;
    private final UUID instanceId;

    public FileImageFrameStorage(File imageMapFolder, File playerDataFolder) {
        block15: {
            this.imageMapFolder = imageMapFolder;
            this.playerDataFolder = playerDataFolder;
            this.mapIndexCounter = new AtomicInteger(0);
            this.imageMapFolder.mkdirs();
            File localDataFile = new File(imageMapFolder, "data.json");
            if (localDataFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(localDataFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    JsonObject json = ImageMapManager.GSON.fromJson((Reader)reader, JsonObject.class);
                    this.instanceId = UUID.fromString(json.get("instanceId").getAsString());
                    break block15;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Unable to read " + localDataFile.getAbsolutePath(), e);
                }
            }
            JsonObject json = new JsonObject();
            this.instanceId = UUID.randomUUID();
            json.addProperty("instanceId", this.instanceId.toString());
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(localDataFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                pw.println(ImageMapManager.GSON.toJson(json));
                pw.flush();
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to save " + localDataFile.getAbsolutePath(), e);
            }
        }
    }

    public File getImageMapFolder() {
        return this.imageMapFolder;
    }

    public File getPlayerDataFolder() {
        return this.playerDataFolder;
    }

    @Override
    public UUID getInstanceId() {
        return this.instanceId;
    }

    public FileImageFrameStorageLoader getLoader() {
        return ImageFrameStorageLoaders.FILE;
    }

    @Override
    public LazyDataSource getSource(int imageIndex, String fileName) {
        return new FileLazyDataSource(this, imageIndex, fileName);
    }

    @Override
    public Set<Integer> getAllImageIndexes() {
        this.imageMapFolder.mkdirs();
        File[] files = this.imageMapFolder.listFiles();
        Arrays.sort(files, FileUtils.BY_NUMBER_THEN_STRING);
        HashSet<Integer> result = new HashSet<Integer>();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            try {
                int imageIndex = Integer.parseInt(file.getName());
                result.add(imageIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public boolean hasImageMapData(int imageIndex) {
        File folder = new File(this.imageMapFolder, String.valueOf(imageIndex));
        if (!folder.exists()) {
            return false;
        }
        return new File(folder, "data.json").exists();
    }

    @Override
    public JsonObject loadImageMapData(int imageIndex) throws IOException {
        File folder = new File(this.imageMapFolder, String.valueOf(imageIndex));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(new File(folder, "data.json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonObject jsonObject = ImageMapManager.GSON.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
    }

    @Override
    public void prepareImageIndex(ImageMap map, IntConsumer imageIndexSetter) {
        int originalImageIndex = map.getImageIndex();
        if (originalImageIndex < 0) {
            imageIndexSetter.accept(this.mapIndexCounter.getAndIncrement());
        } else {
            this.mapIndexCounter.updateAndGet(i -> Math.max(originalImageIndex + 1, i));
        }
    }

    @Override
    public void deleteMap(int imageIndex) {
        this.imageMapFolder.mkdirs();
        File folder = new File(this.imageMapFolder, String.valueOf(imageIndex));
        if (folder.exists() && folder.isDirectory()) {
            FileUtils.removeFolderRecursively(folder);
        }
    }

    @Override
    public List<MutablePair<String, Future<? extends ImageMap>>> loadMaps(ImageMapManager manager, Set<Integer> deletedMapIds, IFPlayerManager ifPlayerManager) {
        this.imageMapFolder.mkdirs();
        File[] files = this.imageMapFolder.listFiles();
        Arrays.sort(files, FileUtils.BY_NUMBER_THEN_STRING);
        LinkedList<MutablePair<String, Future<? extends ImageMap>>> futures = new LinkedList<MutablePair<String, Future<? extends ImageMap>>>();
        for (File file : files) {
            JsonObject json;
            if (file.isDirectory()) {
                try {
                    int imageIndex = Integer.parseInt(file.getName());
                    json = this.loadImageMapData(imageIndex);
                    futures.add(new MutablePair<String, Future<? extends ImageMap>>(file.getAbsolutePath(), ImageMapLoaders.load(manager, json)));
                }
                catch (Throwable e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMap data in " + file.getAbsolutePath());
                    e.printStackTrace();
                }
                continue;
            }
            if (file.getName().equalsIgnoreCase("deletedMaps.bin")) {
                deletedMapIds.addAll(this.loadDeletedMaps());
                continue;
            }
            if (!file.getName().equalsIgnoreCase("deletedMaps.json")) continue;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                json = ImageMapManager.GSON.fromJson((Reader)reader, JsonObject.class);
                JsonArray deletedMapIdsArray = json.get("mapids").getAsJsonArray();
                for (JsonElement element : deletedMapIdsArray) {
                    deletedMapIds.add(element.getAsInt());
                }
            }
            catch (IOException e) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMapManager data in " + file.getAbsolutePath());
                e.printStackTrace();
            }
            this.saveDeletedMaps(deletedMapIds);
            try {
                Files.move(file.toPath(), new File(this.imageMapFolder, "deletedMaps.json.bak").toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return futures;
    }

    @Override
    public void saveImageMapData(int imageIndex, JsonObject json) throws IOException {
        File folder = new File(this.imageMapFolder, String.valueOf(imageIndex));
        folder.mkdirs();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(new File(folder, "data.json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            pw.println(ImageMapManager.GSON.toJson(json));
            pw.flush();
        }
    }

    @Override
    public Set<Integer> loadDeletedMaps() {
        File file = new File(this.imageMapFolder, "deletedMaps.bin");
        HashSet<Integer> deletedMapIds = new HashSet<Integer>();
        try (DataInputStream dataInputStream = new DataInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            try {
                deletedMapIds.add(dataInputStream.readInt());
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMapManager data in " + file.getAbsolutePath());
            e.printStackTrace();
        }
        return deletedMapIds;
    }

    @Override
    public void saveDeletedMaps(Set<Integer> deletedMapIds) {
        File file = new File(this.imageMapFolder, "deletedMaps.bin");
        try (DataOutputStream dataOutputStream = new DataOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            for (int deletedMapId : deletedMapIds) {
                dataOutputStream.writeInt(deletedMapId);
            }
            dataOutputStream.flush();
        }
        catch (IOException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to save ImageMapManager data in " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    @Override
    public JsonObject loadPlayerData(IFPlayerManager manager, UUID uuid) {
        this.playerDataFolder.mkdirs();
        File file = new File(this.playerDataFolder, uuid + ".json");
        if (file.exists()) {
            JsonObject jsonObject;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            try {
                JsonObject json = ImageMapManager.GSON.fromJson((Reader)reader, JsonObject.class);
                IFPlayer.load(manager, json);
                jsonObject = json;
            }
            catch (Throwable json) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        json.addSuppressed(throwable);
                    }
                    throw json;
                }
                catch (Exception e) {
                    new RuntimeException("Unable to load ImageFrame player data from " + file.getAbsolutePath(), e).printStackTrace();
                    try {
                        Files.copy(file.toPath(), new File(file.getParentFile(), file.getName() + ".bak").toPath(), new CopyOption[0]);
                    }
                    catch (IOException ex) {
                        new RuntimeException("Unable to backup ImageFrame player data from " + file.getAbsolutePath(), ex).printStackTrace();
                    }
                }
            }
            reader.close();
            return jsonObject;
        }
        return null;
    }

    @Override
    public void savePlayerData(UUID uuid, JsonObject json) throws IOException {
        this.playerDataFolder.mkdirs();
        File file = new File(this.playerDataFolder, uuid + ".json");
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            pw.println(ImageMapManager.GSON.toJson(json));
            pw.flush();
        }
    }

    @Override
    public Set<UUID> getAllSavedPlayerData() {
        File[] files;
        HashSet<UUID> players = new HashSet<UUID>();
        this.playerDataFolder.mkdirs();
        for (File file : files = this.playerDataFolder.listFiles()) {
            if (!file.isFile()) continue;
            try {
                String fileName = file.getName();
                players.add(UUID.fromString(fileName.substring(0, fileName.indexOf("."))));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return players;
    }

    @Override
    public void close() {
    }

    public static class FileLazyDataSource
    implements LazyDataSource {
        private final FileImageFrameStorage storage;
        private final int imageIndex;
        private final String fileName;

        public FileLazyDataSource(FileImageFrameStorage storage, int imageIndex, String fileName) {
            this.storage = storage;
            this.imageIndex = imageIndex;
            this.fileName = fileName;
        }

        @Override
        public <T> T load(LazyDataSource.Reader<T> reader) throws IOException {
            File folder = new File(this.storage.imageMapFolder, String.valueOf(this.imageIndex));
            File file = new File(folder, this.fileName);
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                T t = reader.read(inputStream);
                return t;
            }
        }

        @Override
        public void save(LazyDataSource.Writer writer) throws IOException {
            File folder = new File(this.storage.imageMapFolder, String.valueOf(this.imageIndex));
            folder.mkdirs();
            File file = new File(folder, this.fileName);
            File tempFile = new File(folder, this.fileName + ".tmp");
            try (OutputStream outputStream = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
                writer.write(outputStream);
            }
            Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public FileLazyDataSource withFileName(String fileName) {
            return new FileLazyDataSource(this.storage, this.imageIndex, fileName);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileLazyDataSource that = (FileLazyDataSource)o;
            return this.imageIndex == that.imageIndex && Objects.equals(this.storage.imageMapFolder, that.storage.imageMapFolder) && Objects.equals(this.fileName, that.fileName);
        }

        public int hashCode() {
            return Objects.hash(this.storage.imageMapFolder, this.imageIndex, this.fileName);
        }
    }
}

