/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.storage;

import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.imageframe.objectholders.IFPlayerManager;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.storage.ImageFrameStorage;
import java.util.UUID;

public class StorageMigrator
implements AutoCloseable {
    private final ImageMapManager imageMapManager;
    private final IFPlayerManager ifPlayerManager;
    private final ImageFrameStorage targetStorage;

    public StorageMigrator(ImageMapManager imageMapManager, IFPlayerManager ifPlayerManager, ImageFrameStorage targetStorage) {
        this.imageMapManager = imageMapManager;
        this.ifPlayerManager = ifPlayerManager;
        this.targetStorage = targetStorage;
    }

    public boolean isTargetEmpty() {
        return this.targetStorage.getAllImageIndexes().isEmpty() && this.targetStorage.loadDeletedMaps().isEmpty() && this.targetStorage.getAllSavedPlayerData().isEmpty();
    }

    public void migrateImageMaps() throws Exception {
        for (ImageMap imageMap : this.imageMapManager.getMaps()) {
            imageMap.save(this.targetStorage, true);
        }
    }

    public void migrateDeletedMaps() {
        this.targetStorage.saveDeletedMaps(this.imageMapManager.getDeletedMapIds());
    }

    public void migrateIFPlayers() throws Exception {
        for (UUID uuid : this.ifPlayerManager.getStorage().getAllSavedPlayerData()) {
            IFPlayer player = IFPlayer.load(this.ifPlayerManager, this.ifPlayerManager.getStorage().loadPlayerData(this.ifPlayerManager, uuid));
            player.save(this.targetStorage);
        }
    }

    @Override
    public void close() {
        this.targetStorage.close();
    }
}

