/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.loohp.imageframe.utils.SizeLimitedByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;

public class HTTPRequestUtils {
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();

    public static JsonObject getJsonResponse(String link) throws IOException {
        URL url = new URL(link);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.addRequestProperty("Pragma", "no-cache");
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            JsonObject jsonObject = GSON.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
    }

    public static InputStream getInputStream(String link) throws IOException {
        URLConnection connection = new URL(link).openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.addRequestProperty("Pragma", "no-cache");
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        return connection.getInputStream();
    }

    public static byte[] download(String link, long sizeLimit) throws IOException {
        try (InputStream is = HTTPRequestUtils.getInputStream(link);){
            int n;
            SizeLimitedByteArrayOutputStream baos = new SizeLimitedByteArrayOutputStream(sizeLimit);
            byte[] byteChunk = new byte[4096];
            while ((n = is.read(byteChunk)) > 0) {
                ((ByteArrayOutputStream)baos).write(byteChunk, 0, n);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static long getContentSize(String link) {
        try {
            URLConnection connection = new URL(link).openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            connection.addRequestProperty("Pragma", "no-cache");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            return connection.getContentLengthLong();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public static String getContentType(String link) {
        try {
            URLConnection connection = new URL(link).openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            connection.addRequestProperty("Pragma", "no-cache");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            return connection.getContentType();
        }
        catch (IOException e) {
            return "";
        }
    }
}

