/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class WrappedIterable<I, O>
implements Iterable<O> {
    private final Iterable<I> backingIterable;
    private final Function<I, O> converter;

    public WrappedIterable(Iterable<I> backingCollection, Function<I, O> converter) {
        this.backingIterable = backingCollection;
        this.converter = converter;
    }

    @Override
    public Iterator<O> iterator() {
        return new Iterator<O>(){
            private final Iterator<I> itr;
            {
                this.itr = WrappedIterable.this.backingIterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public O next() {
                Object obj = this.itr.next();
                return obj == null ? null : (Object)WrappedIterable.this.converter.apply(obj);
            }
        };
    }

    public Stream<O> stream() {
        Spliterator spliterator = this.backingIterable.spliterator();
        return StreamSupport.stream(() -> spliterator, spliterator.characteristics(), false).map(each -> each == null ? null : this.converter.apply(each));
    }

    public Iterable<I> getHandle() {
        return this.backingIterable;
    }

    public Function<I, O> getConverter() {
        return this.converter;
    }

    public boolean isEmpty() {
        return !this.backingIterable.iterator().hasNext();
    }
}

