/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.entityholders;

import com.loohp.interactionvisualizer.entityholders.VisualizerEntity;
import com.loohp.interactionvisualizer.nms.NMSWrapper;
import com.loohp.interactionvisualizer.utils.ComponentFont;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Item
extends VisualizerEntity {
    private ItemStack item = new ItemStack(Material.STONE);
    private boolean hasGravity = false;
    private boolean isGlowing = false;
    private int pickupDelay = 0;
    private Component customName = null;
    private boolean customNameVisible = false;
    private Vector velocity = new Vector(0.0, 0.0, 0.0);

    public Item(Location location) {
        super(location);
    }

    @Override
    public int cacheCode() {
        int prime = 17;
        int result = super.cacheCode();
        result = prime * result + (this.hasGravity ? 5351 : 8923);
        result = prime * result + this.pickupDelay;
        result = prime * result + (this.hasGravity ? 6719 : 2753);
        result = prime * result + (this.item == null ? 0 : this.item.hashCode());
        result = prime * result + (this.customName == null ? 0 : this.customName.hashCode());
        result = prime * result + (this.customNameVisible ? 6199 : 8647);
        result = prime * result + (this.velocity == null ? 0 : this.velocity.hashCode());
        return result;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName == null ? null : ComponentFont.parseFont((Component)LegacyComponentSerializer.legacySection().deserialize(customName));
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public void setGlowing(boolean bool) {
        this.isGlowing = bool;
    }

    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public void setCustomNameVisible(boolean bool) {
        this.customNameVisible = bool;
    }

    public void setItemStack(ItemStack item, boolean force) {
        if (this.lock && !force) {
            return;
        }
        if (item.getType().equals((Object)Material.AIR)) {
            this.item = new ItemStack(Material.STONE);
            return;
        }
        this.item = item.clone();
    }

    public ItemStack getItemStack() {
        return this.item.clone();
    }

    public void setItemStack(ItemStack item) {
        if (this.lock) {
            return;
        }
        if (item.getType().equals((Object)Material.AIR)) {
            this.item = new ItemStack(Material.STONE);
            return;
        }
        this.item = item.clone();
    }

    public void setGravity(boolean bool) {
        this.hasGravity = bool;
    }

    public boolean hasGravity() {
        return this.hasGravity;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector vector) {
        this.velocity = vector.clone();
    }

    public int getPickupDelay() {
        return this.pickupDelay;
    }

    public void setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    @Override
    public List<?> getDataWatchers() {
        return NMSWrapper.getInstance().getWatchableCollection(this);
    }

    @Override
    public double getHeight() {
        return 0.25;
    }
}

