/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.entityholders;

import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.DynamicVisualizerEntity;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class SurroundingPlaneArmorStand
extends ArmorStand
implements DynamicVisualizerEntity {
    public static final double RIGHT_ANGLE = 1.5707963267948966;
    public static final double _45_ANGLE = 0.7853981633974483;
    private double radius;
    private DynamicVisualizerEntity.PathType path;

    private static Vector getViewingVector(Location location, Location from, Vector direction, double radius, DynamicVisualizerEntity.PathType path) {
        Vector vector;
        Location leveled = from.clone();
        leveled.setY(location.getY());
        if (location.distanceSquared(leveled) < radius * radius) {
            Vector v = direction.clone().setY(0);
            if (v.getX() == 0.0 && v.getZ() == 0.0) {
                v.setX(0.001);
            }
            v.normalize().multiply(radius + 2.0);
            Location altLocation = leveled.clone().add(v);
            return SurroundingPlaneArmorStand.getViewingVector(location, altLocation, direction, radius, path);
        }
        switch (path) {
            case SQUARE: {
                Vector axis = location.clone().add(1.0, 0.0, 0.0).toVector().subtract(location.toVector()).normalize();
                vector = leveled.toVector().subtract(location.toVector()).normalize();
                double rawAngle = Math.abs(axis.angle(vector));
                double angle = rawAngle % 0.7853981633974483;
                if (rawAngle % 1.5707963267948966 > 0.7853981633974483) {
                    angle = 0.7853981633974483 - angle;
                }
                double length = radius / Math.cos(angle);
                vector.multiply(length);
                break;
            }
            case CIRCLE: {
                vector = leveled.toVector().subtract(location.toVector()).normalize().multiply(radius);
                break;
            }
            default: {
                Vector facing = leveled.toVector().subtract(location.toVector()).normalize();
                Location origin = location.clone().setDirection(facing);
                float yaw = SurroundingPlaneArmorStand.getCardinalDirection(origin);
                origin.setYaw(yaw);
                vector = origin.getDirection().normalize().multiply(radius);
            }
        }
        return vector;
    }

    public static float getCardinalDirection(Location location) {
        double rotation = (location.getYaw() - 90.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (0.0 <= rotation && rotation < 45.0) {
            return 90.0f;
        }
        if (45.0 <= rotation && rotation < 135.0) {
            return 180.0f;
        }
        if (135.0 <= rotation && rotation < 225.0) {
            return -90.0f;
        }
        if (225.0 <= rotation && rotation < 315.0) {
            return 0.0f;
        }
        if (315.0 <= rotation && rotation < 360.0) {
            return 90.0f;
        }
        return 0.0f;
    }

    public SurroundingPlaneArmorStand(Location location, double radius, DynamicVisualizerEntity.PathType path) {
        super(location);
        this.radius = radius;
        this.path = path;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public DynamicVisualizerEntity.PathType getPathType() {
        return this.path;
    }

    @Override
    public void setPathType(DynamicVisualizerEntity.PathType path) {
        this.path = path;
    }

    @Override
    public Location getViewingLocation(Location from, Vector direction) {
        if (!from.getWorld().equals((Object)this.location.getWorld())) {
            throw new IllegalArgumentException("Cannot view SurroundingArmorStand in " + this.location.getWorld().getName() + " from " + from.getWorld().getName());
        }
        Vector vector = SurroundingPlaneArmorStand.getViewingVector(this.location, from, direction, this.radius, this.path);
        return this.location.clone().add(vector);
    }
}

