/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.entityholders;

import com.loohp.interactionvisualizer.entityholders.IVisualizerEntity;
import com.loohp.interactionvisualizer.nms.NMSWrapper;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;

public abstract class VisualizerEntity
implements IVisualizerEntity {
    private final transient Future<Integer> entityIdFuture = NMSWrapper.getInstance().getNextEntityId();
    protected final UUID uuid;
    protected Location location;
    protected boolean lock;
    protected boolean isSilent;
    protected final EntityType type;
    private int id = Integer.MIN_VALUE;

    public VisualizerEntity(Location location) {
        this.uuid = UUID.randomUUID();
        this.location = location.clone();
        this.lock = false;
        this.isSilent = false;
        this.type = NMSWrapper.getInstance().getEntityType(this);
    }

    @Override
    public final int getEntityId() {
        if (this.id != Integer.MIN_VALUE) {
            return this.id;
        }
        try {
            this.id = this.entityIdFuture.get();
            return this.id;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public EntityType getType() {
        return this.type;
    }

    public int cacheCode() {
        int prime = 17;
        int result = 1;
        result = prime * result + this.id;
        result = prime * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = prime * result + (this.location == null ? 0 : this.location.hashCode());
        result = prime * result + (this.lock ? 1531 : 4021);
        result = prime * result + (this.isSilent ? 3301 : 4507);
        return result;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        if (this.lock) {
            return;
        }
        this.teleport(this.location.getWorld(), this.location.getX(), this.location.getY(), this.location.getZ(), yaw, pitch);
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    public void teleport(Location location) {
        this.location = location.clone();
    }

    @Override
    public void teleport(World world, double x, double y, double z) {
        this.location = new Location(world, x, y, z, this.location.getYaw(), this.location.getPitch());
    }

    @Override
    public void teleport(World world, double x, double y, double z, float yaw, float pitch) {
        this.location = new Location(world, x, y, z, yaw, pitch);
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public void setLocation(Location location) {
        this.location = location.clone();
    }

    @Override
    public boolean isSilent() {
        return this.isSilent;
    }

    @Override
    public void setSilent(boolean bool) {
        this.isSilent = bool;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public boolean isLocked() {
        return this.lock;
    }

    @Override
    public void setLocked(boolean bool) {
        this.lock = bool;
    }

    @Override
    public abstract double getHeight();

    @Override
    public abstract List<?> getDataWatchers();
}

