/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class ChunkPosition {
    private final UUID world;
    private final int x;
    private final int z;

    public ChunkPosition(World world, int chunkX, int chunkZ) {
        this.world = world.getUID();
        this.x = chunkX;
        this.z = chunkZ;
    }

    public ChunkPosition(Location location) {
        this(location.getWorld(), (int)Math.floor((double)location.getBlockX() / 16.0), (int)Math.floor((double)location.getBlockZ() / 16.0));
    }

    public World getWorld() {
        return Bukkit.getWorld((UUID)this.world);
    }

    public UUID getWorldUID() {
        return this.world;
    }

    public int getChunkX() {
        return this.x;
    }

    public int getChunkZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChunkPosition)) {
            return false;
        }
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        int prime = 17;
        int result = 0;
        result = prime * result + this.world.hashCode();
        result = prime * result + this.x;
        result = prime * result + this.z;
        return result;
    }

    public boolean isLoaded() {
        World world = this.getWorld();
        if (world == null) {
            return false;
        }
        return world.isChunkLoaded(this.x, this.z);
    }

    public Chunk getChunk() {
        return this.getWorld().getChunkAt(this.x, this.z);
    }
}

