/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SynchronizedFilteredCollection<E>
implements Collection<E> {
    private final Collection<E> backingCollection;
    private final Predicate<E> predicate;
    private final ReentrantReadWriteLock lock;

    public static <E> SynchronizedFilteredCollection<E> filter(Collection<E> backingCollection, Predicate<E> predicate) {
        return new SynchronizedFilteredCollection<E>(backingCollection, predicate);
    }

    public static <E> SynchronizedFilteredCollection<E> from(Collection<E> backingCollection) {
        return new SynchronizedFilteredCollection<Object>(backingCollection, e -> true);
    }

    private SynchronizedFilteredCollection(Collection<E> backingCollection, Predicate<E> predicate) {
        this.backingCollection = backingCollection;
        this.predicate = predicate;
        this.lock = this.acquireLock();
    }

    private ReentrantReadWriteLock acquireLock() {
        if (this.backingCollection instanceof SynchronizedFilteredCollection) {
            return ((SynchronizedFilteredCollection)this.backingCollection).acquireLock();
        }
        return new ReentrantReadWriteLock();
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public int size() {
        try {
            this.lock.readLock().lock();
            int n = (int)this.backingCollection.stream().filter(this.predicate).count();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.lock.readLock().lock();
            boolean bl = this.backingCollection.stream().noneMatch(this.predicate);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.backingCollection.stream().filter(this.predicate).anyMatch(each -> Objects.equals(each, o));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        Iterator itr;
        try {
            this.lock.readLock().lock();
            itr = this.backingCollection.stream().filter(this.predicate).collect(Collectors.toList()).iterator();
        }
        finally {
            this.lock.readLock().unlock();
        }
        return new Iterator<E>(){
            private E currentElement = null;

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public E next() {
                this.currentElement = itr.next();
                return this.currentElement;
            }

            @Override
            public void remove() {
                if (this.currentElement == null) {
                    throw new IllegalStateException("Call itr.next() first");
                }
                SynchronizedFilteredCollection.this.backingCollection.remove(this.currentElement);
            }
        };
    }

    @Override
    public Object[] toArray() {
        try {
            this.lock.readLock().lock();
            Object[] objectArray = this.backingCollection.stream().filter(this.predicate).toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        try {
            this.lock.readLock().lock();
            A[] AArray = this.backingCollection.stream().filter(this.predicate).toArray((int size) -> a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size));
            return AArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean add(E e) {
        if (this.predicate.test(e)) {
            try {
                this.lock.writeLock().lock();
                boolean bl = this.backingCollection.add(e);
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        try {
            this.lock.writeLock().lock();
            boolean bl = this.backingCollection.remove(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Collection list;
        try {
            this.lock.readLock().lock();
            list = this.backingCollection.stream().filter(this.predicate).collect(Collectors.toList());
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (Object o : c) {
            if (list.contains(o)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean flag = false;
        try {
            this.lock.writeLock().lock();
            for (E e : c) {
                if (!this.add(e)) continue;
                flag = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return flag;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        try {
            this.lock.writeLock().lock();
            boolean bl = this.backingCollection.removeAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Predicate<? super E> test = this.predicate.and(filter);
        try {
            this.lock.writeLock().lock();
            boolean bl = this.backingCollection.removeIf(test);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        boolean flag = false;
        try {
            this.lock.writeLock().lock();
            Iterator<E> itr = this.backingCollection.iterator();
            while (itr.hasNext()) {
                E e = itr.next();
                if (!this.predicate.test(e) || c.contains(e)) continue;
                itr.remove();
                flag = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return flag;
    }

    @Override
    public void clear() {
        try {
            this.lock.writeLock().lock();
            this.backingCollection.removeIf(this.predicate);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        try {
            this.lock.readLock().lock();
            Spliterator spliterator = this.backingCollection.stream().filter(this.predicate).collect(Collectors.toList()).spliterator();
            return spliterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<E> stream() {
        try {
            this.lock.readLock().lock();
            Stream stream = this.backingCollection.stream().filter(this.predicate).collect(Collectors.toList()).stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<E> parallelStream() {
        try {
            this.lock.readLock().lock();
            Stream stream = this.backingCollection.parallelStream().filter(this.predicate).collect(Collectors.toList()).parallelStream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

