/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.nms;

import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.entityholders.ItemFrame;
import com.loohp.interactionvisualizer.entityholders.VisualizerEntity;
import com.loohp.interactionvisualizer.nms.NMSWrapper;
import com.loohp.interactionvisualizer.objectholders.BlockPosition;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.objectholders.ChunkPosition;
import com.loohp.interactionvisualizer.objectholders.NMSTileEntitySet;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.objectholders.ValuePairs;
import com.loohp.interactionvisualizer.objectholders.WrappedIterable;
import com.loohp.interactionvisualizer.utils.UnsafeAccessor;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.v1_16_R2.Block;
import net.minecraft.server.v1_16_R2.Chunk;
import net.minecraft.server.v1_16_R2.DataWatcher;
import net.minecraft.server.v1_16_R2.DataWatcherObject;
import net.minecraft.server.v1_16_R2.EntityArmorStand;
import net.minecraft.server.v1_16_R2.EntityItem;
import net.minecraft.server.v1_16_R2.EntityItemFrame;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.EntityTypes;
import net.minecraft.server.v1_16_R2.EnumItemSlot;
import net.minecraft.server.v1_16_R2.IBlockAccess;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.IRegistry;
import net.minecraft.server.v1_16_R2.MathHelper;
import net.minecraft.server.v1_16_R2.MobEffectList;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutAnimation;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_16_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R2.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R2.TileEntity;
import net.minecraft.server.v1_16_R2.Vec3D;
import net.minecraft.server.v1_16_R2.Vector3f;
import net.minecraft.server.v1_16_R2.VoxelShape;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftItem;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class V1_16_2
extends NMSWrapper {
    private final Field[] entityMetadataPacketFields;
    private final Field entityCountField;
    private final Field dataWatcherByteField;
    private final Field dataWatcherCustomNameField;
    private final Field dataWatcherCustomNameVisibleField;
    private final Field dataWatcherSilentField;
    private final Field dataWatcherNoGravityField;
    private final Field dataWatcherItemItemField;
    private final Field dataWatcherItemFrameItemField;
    private final Field dataWatcherItemFrameRotationField;
    private final Field[] spawnEntityLivingPacketFields;
    private final Field[] entityTeleportPacketFields;

    public V1_16_2() {
        try {
            this.entityMetadataPacketFields = PacketPlayOutEntityMetadata.class.getDeclaredFields();
            this.entityCountField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("entityCount");
            this.dataWatcherByteField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("S");
            this.dataWatcherCustomNameField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("aq");
            this.dataWatcherCustomNameVisibleField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("ar");
            this.dataWatcherSilentField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("as");
            this.dataWatcherNoGravityField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("at");
            this.dataWatcherItemItemField = EntityItem.class.getDeclaredField("ITEM");
            this.dataWatcherItemFrameItemField = EntityItemFrame.class.getDeclaredField("ITEM");
            this.dataWatcherItemFrameRotationField = EntityItemFrame.class.getDeclaredField("g");
            this.spawnEntityLivingPacketFields = PacketPlayOutSpawnEntityLiving.class.getDeclaredFields();
            this.entityTeleportPacketFields = PacketPlayOutEntityTeleport.class.getDeclaredFields();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public Particle getItemCrackParticle() {
        return Particle.ITEM_CRACK;
    }

    public Enchantment getPowerEnchantment() {
        return Enchantment.ARROW_DAMAGE;
    }

    public int getItemAge(org.bukkit.entity.Item item) {
        return ((EntityItem)((CraftItem)item).getHandle()).age;
    }

    public int getItemDamage(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            return ((Damageable)itemMeta).getDamage();
        }
        return 0;
    }

    public Component getItemHoverName(ItemStack itemStack) {
        net.minecraft.server.v1_16_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)nmsItemStack.getName()));
    }

    public PacketPlayOutEntityEquipment[] createEntityEquipmentPacket(int entityId, List<ValuePairs<EquipmentSlot, ItemStack>> equipments) {
        ArrayList<Pair> nmsEquipments = new ArrayList<Pair>();
        for (ValuePairs<EquipmentSlot, ItemStack> pair : equipments) {
            EnumItemSlot nmsSlot;
            switch ((EquipmentSlot)pair.getFirst()) {
                case CHEST: {
                    nmsSlot = EnumItemSlot.CHEST;
                    break;
                }
                case FEET: {
                    nmsSlot = EnumItemSlot.FEET;
                    break;
                }
                case HEAD: {
                    nmsSlot = EnumItemSlot.HEAD;
                    break;
                }
                case LEGS: {
                    nmsSlot = EnumItemSlot.LEGS;
                    break;
                }
                case OFF_HAND: {
                    nmsSlot = EnumItemSlot.OFFHAND;
                    break;
                }
                default: {
                    nmsSlot = EnumItemSlot.MAINHAND;
                }
            }
            net.minecraft.server.v1_16_R2.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)((ItemStack)pair.getSecond()));
            nmsEquipments.add(new Pair((Object)nmsSlot, (Object)nmsItem));
        }
        return new PacketPlayOutEntityEquipment[]{new PacketPlayOutEntityEquipment(entityId, nmsEquipments)};
    }

    public PacketPlayOutEntityDestroy[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketPlayOutEntityDestroy[]{new PacketPlayOutEntityDestroy(entityIds)};
    }

    public PacketPlayOutEntityMetadata createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
            this.entityMetadataPacketFields[0].setAccessible(true);
            this.entityMetadataPacketFields[0].setInt(packet, entityId);
            this.entityMetadataPacketFields[1].setAccessible(true);
            this.entityMetadataPacketFields[1].set(packet, dataWatchers);
            return packet;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public List<BoundingBox> getBoundingBoxes(BlockPosition pos) {
        net.minecraft.server.v1_16_R2.BlockPosition blockpos = new net.minecraft.server.v1_16_R2.BlockPosition(pos.getX(), pos.getY(), pos.getZ());
        WorldServer world = ((CraftWorld)pos.getWorld()).getHandle();
        VoxelShape shape = world.getType(blockpos).getShape((IBlockAccess)world, blockpos);
        return shape.d().stream().map(each -> new BoundingBox(each.minX + (double)pos.getX(), each.minY + (double)pos.getY(), each.minZ + (double)pos.getZ(), each.maxX + (double)pos.getX(), each.maxY + (double)pos.getY(), each.maxZ + (double)pos.getZ())).collect(Collectors.toList());
    }

    public NMSTileEntitySet<?, ?> getTileEntities(ChunkPosition chunk, boolean load) {
        if (!chunk.isLoaded() && !load) {
            return null;
        }
        World world = chunk.getWorld();
        Chunk nmsChunk = ((CraftWorld)world).getHandle().getChunkIfLoaded(chunk.getChunkX(), chunk.getChunkZ());
        return new NMSTileEntitySet(nmsChunk.getTileEntities(), entry -> {
            net.minecraft.server.v1_16_R2.BlockPosition pos = (net.minecraft.server.v1_16_R2.BlockPosition)entry.getKey();
            Material type = CraftMagicNumbers.getMaterial((Block)((TileEntity)entry.getValue()).getBlock().getBlock());
            TileEntity.TileEntityType tileEntityType = com.loohp.interactionvisualizer.objectholders.TileEntity.getTileEntityType((Material)type);
            if (tileEntityType != null) {
                return new com.loohp.interactionvisualizer.objectholders.TileEntity(world, pos.getX(), pos.getY(), pos.getZ(), tileEntityType);
            }
            return null;
        });
    }

    public int getItemDespawnRate(org.bukkit.entity.Item item) {
        int despawnRate;
        try {
            Object spigotWorldConfig = net.minecraft.server.v1_16_R2.World.class.getField("spigotConfig").get(((CraftWorld)item.getWorld()).getHandle());
            despawnRate = spigotWorldConfig.getClass().getField("itemDespawnRate").getInt(spigotWorldConfig);
            try {
                despawnRate = (Integer)EntityItem.class.getMethod("getDespawnRate", new Class[0]).invoke((Object)((CraftItem)item).getHandle(), new Object[0]);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            despawnRate = 6000;
        }
        return despawnRate;
    }

    public String getBannerCustomName(org.bukkit.block.Block block) {
        WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
        TileEntity tileEntity = worldServer.getTileEntity(new net.minecraft.server.v1_16_R2.BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (tileEntity == null) {
            return "";
        }
        return tileEntity.b().getString("CustomName");
    }

    public WrappedIterable<?, Entity> getEntities(World world) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        return new WrappedIterable((Iterable)worldServer.entitiesById.values(), net.minecraft.server.v1_16_R2.Entity::getBukkitEntity);
    }

    public Future<Integer> getNextEntityId() {
        try {
            this.entityCountField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)this.entityCountField.get(null);
            return CompletableFuture.completedFuture(counter.incrementAndGet());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public ChatColor getRarityColor(ItemStack itemStack) {
        net.minecraft.server.v1_16_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        String str = nmsItemStack.v().e.toString();
        return ChatColor.getByChar((char)str.charAt(str.length() - 1));
    }

    public String getTranslationKey(ItemStack itemStack) {
        net.minecraft.server.v1_16_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        return nmsItemStack.getItem().getName();
    }

    public String getEnchantmentTranslationKey(Enchantment enchantment) {
        NamespacedKey namespacedKey = enchantment.getKey();
        return "enchantment." + namespacedKey.getNamespace() + "." + namespacedKey.getKey();
    }

    public String getEffectTranslationKey(PotionEffectType type) {
        int id = type.getId();
        MobEffectList effectList = MobEffectList.fromId((int)id);
        if (effectList != null) {
            return effectList.c();
        }
        return "";
    }

    public EntityType getEntityType(VisualizerEntity entity) {
        if (entity instanceof ArmorStand) {
            return EntityType.ARMOR_STAND;
        }
        if (entity instanceof Item) {
            return EntityType.DROPPED_ITEM;
        }
        if (entity instanceof ItemFrame) {
            return EntityType.ITEM_FRAME;
        }
        throw new RuntimeException("Unknown VisualizerEntity class " + entity.getClass().getName());
    }

    public List<DataWatcher.Item<?>> getWatchableCollection(ArmorStand stand) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 0;
            bitmask = !stand.isVisible() ? (byte)(bitmask | 0x20) : bitmask;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            Component customName = stand.getCustomName();
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), customName == null ? Optional.empty() : Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(customName))))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)stand.isCustomNameVisible()));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherSilentField.get(null), (Object)stand.isSilent()));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherNoGravityField.get(null), (Object)(!stand.hasGravity() ? 1 : 0)));
            byte standbitmask = 0;
            standbitmask = stand.isSmall() ? (byte)(standbitmask | 1) : standbitmask;
            standbitmask = stand.hasArms() ? (byte)(standbitmask | 4) : standbitmask;
            standbitmask = !stand.hasBasePlate() ? (byte)(standbitmask | 8) : standbitmask;
            standbitmask = stand.isMarker() ? (byte)(standbitmask | 0x10) : standbitmask;
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.b, (Object)standbitmask));
            Vector3f headrotation = new Vector3f((float)Math.toDegrees(stand.getHeadPose().getX()), (float)Math.toDegrees(stand.getHeadPose().getY()), (float)Math.toDegrees(stand.getHeadPose().getZ()));
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.c, (Object)headrotation));
            Vector3f rightarmrotation = new Vector3f((float)Math.toDegrees(stand.getRightArmPose().getX()), (float)Math.toDegrees(stand.getRightArmPose().getY()), (float)Math.toDegrees(stand.getRightArmPose().getZ()));
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.f, (Object)rightarmrotation));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.Item<?>> getWatchableCollection(Item item) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            this.dataWatcherItemItemField.setAccessible(true);
            byte bitmask = 0;
            bitmask = item.isGlowing() ? (byte)(bitmask | 0x40) : bitmask;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            Component customName = item.getCustomName();
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), customName == null ? Optional.empty() : Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(customName))))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)item.isCustomNameVisible()));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherNoGravityField.get(null), (Object)(!item.hasGravity() ? 1 : 0)));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherItemItemField.get(null), (Object)CraftItemStack.asNMSCopy((ItemStack)item.getItemStack())));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.Item<?>> getWatchableCollection(ItemFrame frame) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherItemFrameItemField.setAccessible(true);
            this.dataWatcherItemFrameRotationField.setAccessible(true);
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherSilentField.get(null), (Object)frame.isSilent()));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherItemFrameItemField.get(null), (Object)CraftItemStack.asNMSCopy((ItemStack)frame.getItem())));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherItemFrameRotationField.get(null), (Object)frame.getFrameRotation()));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.Item<?>> createCustomNameWatchableCollection(Component name) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            boolean visible = name != null;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name == null ? Optional.empty() : Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(name))))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.Item<?>> resetCustomNameWatchableCollection(Entity entity) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            net.minecraft.server.v1_16_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.getDataWatcher();
            Optional name = (Optional)watcher.get((DataWatcherObject)this.dataWatcherCustomNameField.get(null));
            boolean visible = (Boolean)watcher.get((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendHandMovement(Collection<Player> players, Player entity) {
        EntityPlayer entityPlayer = ((CraftPlayer)entity).getHandle();
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((net.minecraft.server.v1_16_R2.Entity)entityPlayer, 0);
        for (Player player : players) {
            this.sendPacket(player, packet);
        }
    }

    public void teleportEntity(Player player, int entityId, Location location) {
        try {
            PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport();
            this.entityTeleportPacketFields[0].setAccessible(true);
            this.entityTeleportPacketFields[1].setAccessible(true);
            this.entityTeleportPacketFields[2].setAccessible(true);
            this.entityTeleportPacketFields[3].setAccessible(true);
            this.entityTeleportPacketFields[4].setAccessible(true);
            this.entityTeleportPacketFields[5].setAccessible(true);
            this.entityTeleportPacketFields[6].setAccessible(true);
            this.entityTeleportPacketFields[0].setInt(packet, entityId);
            this.entityTeleportPacketFields[1].setDouble(packet, location.getX());
            this.entityTeleportPacketFields[2].setDouble(packet, location.getY());
            this.entityTeleportPacketFields[3].setDouble(packet, location.getZ());
            this.entityTeleportPacketFields[4].setByte(packet, (byte)(location.getYaw() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[5].setByte(packet, (byte)(location.getPitch() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[6].setBoolean(packet, false);
            this.sendPacket(player, packet);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void spawnArmorStand(Collection<Player> players, ArmorStand entity) {
        try {
            EntityTypes type = EntityTypes.ARMOR_STAND;
            PacketPlayOutSpawnEntityLiving packet1 = (PacketPlayOutSpawnEntityLiving)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutSpawnEntityLiving.class);
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entity.getEntityId());
            this.spawnEntityLivingPacketFields[1].set(packet1, entity.getUniqueId());
            this.spawnEntityLivingPacketFields[2].setInt(packet1, IRegistry.ENTITY_TYPE.a((Object)type));
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, entity.getLocation().getX());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, entity.getLocation().getY());
            this.spawnEntityLivingPacketFields[5].setDouble(packet1, entity.getLocation().getZ());
            this.spawnEntityLivingPacketFields[6].setInt(packet1, (int)(MathHelper.a((double)entity.getVelocity().getX(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[7].setInt(packet1, (int)(MathHelper.a((double)entity.getVelocity().getY(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[8].setInt(packet1, (int)(MathHelper.a((double)entity.getVelocity().getZ(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)(entity.getLocation().getPitch() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[11].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            List watcher = entity.getDataWatchers();
            PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
            ArrayList<ValuePairs<EquipmentSlot, ItemStack>> equipments = new ArrayList<ValuePairs<EquipmentSlot, ItemStack>>();
            equipments.add(new ValuePairs((Object)EquipmentSlot.HAND, (Object)entity.getItemInMainHand()));
            equipments.add(new ValuePairs((Object)EquipmentSlot.HEAD, (Object)entity.getHelmet()));
            PacketPlayOutEntityEquipment[] packet3 = this.createEntityEquipmentPacket(entity.getEntityId(), equipments);
            for (Player player : players) {
                this.sendPacket(player, packet1);
                this.sendPacket(player, packet2);
                for (PacketPlayOutEntityEquipment packet : packet3) {
                    this.sendPacket(player, packet);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateArmorStand(Collection<Player> players, ArmorStand entity) {
        try {
            PacketPlayOutEntityTeleport packet1 = new PacketPlayOutEntityTeleport();
            this.entityTeleportPacketFields[0].setAccessible(true);
            this.entityTeleportPacketFields[1].setAccessible(true);
            this.entityTeleportPacketFields[2].setAccessible(true);
            this.entityTeleportPacketFields[3].setAccessible(true);
            this.entityTeleportPacketFields[4].setAccessible(true);
            this.entityTeleportPacketFields[5].setAccessible(true);
            this.entityTeleportPacketFields[6].setAccessible(true);
            this.entityTeleportPacketFields[0].setInt(packet1, entity.getEntityId());
            this.entityTeleportPacketFields[1].setDouble(packet1, entity.getLocation().getX());
            this.entityTeleportPacketFields[2].setDouble(packet1, entity.getLocation().getY());
            this.entityTeleportPacketFields[3].setDouble(packet1, entity.getLocation().getZ());
            this.entityTeleportPacketFields[4].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[5].setByte(packet1, (byte)(entity.getLocation().getPitch() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[6].setBoolean(packet1, false);
            List watcher = entity.getDataWatchers();
            PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
            ArrayList<ValuePairs<EquipmentSlot, ItemStack>> equipments = new ArrayList<ValuePairs<EquipmentSlot, ItemStack>>();
            equipments.add(new ValuePairs((Object)EquipmentSlot.HAND, (Object)entity.getItemInMainHand()));
            equipments.add(new ValuePairs((Object)EquipmentSlot.HEAD, (Object)entity.getHelmet()));
            PacketPlayOutEntityEquipment[] packet3 = this.createEntityEquipmentPacket(entity.getEntityId(), equipments);
            for (Player player : players) {
                this.sendPacket(player, packet1);
                this.sendPacket(player, packet2);
                for (PacketPlayOutEntityEquipment packet : packet3) {
                    this.sendPacket(player, packet);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateArmorStandOnlyMeta(Collection<Player> players, ArmorStand entity) {
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet);
        }
    }

    public void removeArmorStand(Collection<Player> players, ArmorStand entity) {
        PacketPlayOutEntityDestroy[] packets = this.createEntityDestroyPacket(entity.getEntityId());
        for (Player player : players) {
            for (PacketPlayOutEntityDestroy packet : packets) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void spawnItem(Collection<Player> players, Item entity) {
        if (entity.getItemStack().getType().equals((Object)Material.AIR)) {
            return;
        }
        EntityTypes type = EntityTypes.ITEM;
        Vec3D velocity = new Vec3D(entity.getVelocity().getX(), entity.getVelocity().getY(), entity.getVelocity().getZ());
        PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entity.getEntityId(), entity.getUniqueId(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getPitch(), entity.getLocation().getYaw(), type, 0, velocity);
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet1);
            this.sendPacket(player, packet2);
        }
    }

    public void updateItem(Collection<Player> players, Item entity) {
        try {
            List watcher = entity.getDataWatchers();
            PacketPlayOutEntityMetadata packet1 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
            PacketPlayOutEntityTeleport packet2 = new PacketPlayOutEntityTeleport();
            this.entityTeleportPacketFields[0].setAccessible(true);
            this.entityTeleportPacketFields[1].setAccessible(true);
            this.entityTeleportPacketFields[2].setAccessible(true);
            this.entityTeleportPacketFields[3].setAccessible(true);
            this.entityTeleportPacketFields[4].setAccessible(true);
            this.entityTeleportPacketFields[5].setAccessible(true);
            this.entityTeleportPacketFields[6].setAccessible(true);
            this.entityTeleportPacketFields[0].setInt(packet2, entity.getEntityId());
            this.entityTeleportPacketFields[1].setDouble(packet2, entity.getLocation().getX());
            this.entityTeleportPacketFields[2].setDouble(packet2, entity.getLocation().getY());
            this.entityTeleportPacketFields[3].setDouble(packet2, entity.getLocation().getZ());
            this.entityTeleportPacketFields[4].setByte(packet2, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[5].setByte(packet2, (byte)(entity.getLocation().getPitch() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[6].setBoolean(packet2, false);
            Vec3D velocity = new Vec3D(entity.getVelocity().getX(), entity.getVelocity().getY(), entity.getVelocity().getZ());
            PacketPlayOutEntityVelocity packet3 = new PacketPlayOutEntityVelocity(entity.getEntityId(), velocity);
            for (Player player : players) {
                this.sendPacket(player, packet1);
                this.sendPacket(player, packet2);
                this.sendPacket(player, packet3);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeItem(Collection<Player> players, Item entity) {
        PacketPlayOutEntityDestroy[] packets = this.createEntityDestroyPacket(entity.getEntityId());
        for (Player player : players) {
            for (PacketPlayOutEntityDestroy packet : packets) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void spawnItemFrame(Collection<Player> players, ItemFrame entity) {
        EntityTypes type = EntityTypes.ITEM_FRAME;
        Vec3D velocity = Vec3D.ORIGIN;
        PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entity.getEntityId(), entity.getUniqueId(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getPitch(), entity.getLocation().getYaw(), type, V1_16_2.getItemFrameData((ItemFrame)entity), velocity);
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet1);
            this.sendPacket(player, packet2);
        }
    }

    public void updateItemFrame(Collection<Player> players, ItemFrame entity) {
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet);
        }
    }

    public void removeItemFrame(Collection<Player> players, ItemFrame entity) {
        PacketPlayOutEntityDestroy[] packets = this.createEntityDestroyPacket(entity.getEntityId());
        for (Player player : players) {
            for (PacketPlayOutEntityDestroy packet : packets) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }
}

