/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.nms;

import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.entityholders.ItemFrame;
import com.loohp.interactionvisualizer.entityholders.VisualizerEntity;
import com.loohp.interactionvisualizer.nms.NMSWrapper;
import com.loohp.interactionvisualizer.objectholders.BlockPosition;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.objectholders.ChunkPosition;
import com.loohp.interactionvisualizer.objectholders.NMSTileEntitySet;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.objectholders.ValuePairs;
import com.loohp.interactionvisualizer.objectholders.WrappedIterable;
import com.loohp.interactionvisualizer.utils.ReflectionUtils;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vector3f;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class V1_21_7
extends NMSWrapper {
    private final Field entityCountField;
    private final Field dataWatcherByteField;
    private final Field dataWatcherCustomNameField;
    private final Field dataWatcherCustomNameVisibleField;
    private final Field dataWatcherSilentField;
    private final Field dataWatcherNoGravityField;
    private final Field dataWatcherItemItemField;
    private Field spigotWorldConfigField;
    private Field spigotItemDespawnRateField;
    private Field paperItemDespawnRateField;
    private Method worldServerEntityLookup;

    public V1_21_7() {
        try {
            this.entityCountField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, AtomicInteger.class, (String[])new String[]{"ENTITY_COUNTER", "c"});
            this.dataWatcherByteField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, (String[])new String[]{"DATA_SHARED_FLAGS_ID", "az"});
            this.dataWatcherCustomNameField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, (String[])new String[]{"DATA_CUSTOM_NAME", "bl"});
            this.dataWatcherCustomNameVisibleField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, (String[])new String[]{"DATA_CUSTOM_NAME_VISIBLE", "bm"});
            this.dataWatcherSilentField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, (String[])new String[]{"DATA_SILENT", "bn"});
            this.dataWatcherNoGravityField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, (String[])new String[]{"DATA_NO_GRAVITY", "bo"});
            this.dataWatcherItemItemField = ReflectionUtils.findDeclaredField(EntityItem.class, DataWatcherObject.class, (String[])new String[]{"DATA_ITEM", "c"});
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            this.spigotWorldConfigField = net.minecraft.world.level.World.class.getField("spigotConfig");
            this.spigotItemDespawnRateField = this.spigotWorldConfigField.getType().getField("itemDespawnRate");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        try {
            this.paperItemDespawnRateField = EntityItem.class.getDeclaredField("despawnRate");
            this.worldServerEntityLookup = WorldServer.class.getMethod("moonrise$getEntityLookup", new Class[0]);
        }
        catch (NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public Enchantment getPowerEnchantment() {
        return Enchantment.POWER;
    }

    public Particle getItemCrackParticle() {
        return Particle.ITEM;
    }

    public int getItemAge(org.bukkit.entity.Item item) {
        return ((CraftItem)item).getHandle().k;
    }

    public int getItemDamage(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            return ((Damageable)itemMeta).getDamage();
        }
        return 0;
    }

    public Component getItemHoverName(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)nmsItemStack.B()));
    }

    public PacketPlayOutEntityEquipment[] createEntityEquipmentPacket(int entityId, List<ValuePairs<EquipmentSlot, ItemStack>> equipments) {
        ArrayList<Pair> nmsEquipments = new ArrayList<Pair>();
        for (ValuePairs<EquipmentSlot, ItemStack> pair : equipments) {
            EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS((EquipmentSlot)((EquipmentSlot)pair.getFirst()));
            net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)((ItemStack)pair.getSecond()));
            nmsEquipments.add(new Pair((Object)nmsSlot, (Object)nmsItem));
        }
        return new PacketPlayOutEntityEquipment[]{new PacketPlayOutEntityEquipment(entityId, nmsEquipments)};
    }

    public PacketPlayOutEntityDestroy[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketPlayOutEntityDestroy[]{new PacketPlayOutEntityDestroy(entityIds)};
    }

    public PacketPlayOutEntityMetadata createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        return new PacketPlayOutEntityMetadata(entityId, dataWatchers);
    }

    public List<BoundingBox> getBoundingBoxes(BlockPosition pos) {
        net.minecraft.core.BlockPosition blockpos = new net.minecraft.core.BlockPosition(pos.getX(), pos.getY(), pos.getZ());
        WorldServer world = ((CraftWorld)pos.getWorld()).getHandle();
        VoxelShape shape = world.a_(blockpos).h((IBlockAccess)world, blockpos);
        return shape.e().stream().map(each -> new BoundingBox(each.a + (double)pos.getX(), each.b + (double)pos.getY(), each.c + (double)pos.getZ(), each.d + (double)pos.getX(), each.e + (double)pos.getY(), each.f + (double)pos.getZ())).collect(Collectors.toList());
    }

    public NMSTileEntitySet<?, ?> getTileEntities(ChunkPosition chunk, boolean load) {
        if (!chunk.isLoaded() && !load) {
            return null;
        }
        World world = chunk.getWorld();
        Chunk nmsChunk = ((CraftWorld)world).getHandle().getChunkIfLoaded(chunk.getChunkX(), chunk.getChunkZ());
        return new NMSTileEntitySet(nmsChunk.k, entry -> {
            net.minecraft.core.BlockPosition pos = (net.minecraft.core.BlockPosition)entry.getKey();
            Material type = CraftMagicNumbers.getMaterial((Block)((TileEntity)entry.getValue()).m().b());
            TileEntity.TileEntityType tileEntityType = com.loohp.interactionvisualizer.objectholders.TileEntity.getTileEntityType((Material)type);
            if (tileEntityType != null) {
                return new com.loohp.interactionvisualizer.objectholders.TileEntity(world, pos.u(), pos.v(), pos.w(), tileEntityType);
            }
            return null;
        });
    }

    public int getItemDespawnRate(org.bukkit.entity.Item item) {
        try {
            if (this.paperItemDespawnRateField != null) {
                this.paperItemDespawnRateField.setAccessible(true);
                return this.paperItemDespawnRateField.getInt(((CraftItem)item).getHandle());
            }
            if (this.spigotWorldConfigField != null && this.spigotItemDespawnRateField != null) {
                Object spigotWorldConfig = this.spigotWorldConfigField.get(((CraftWorld)item.getWorld()).getHandle());
                return this.spigotItemDespawnRateField.getInt(spigotWorldConfig);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 6000;
    }

    public String getBannerCustomName(org.bukkit.block.Block block) {
        WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
        TileEntity tileEntity = worldServer.c_(new net.minecraft.core.BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (tileEntity == null) {
            return "";
        }
        return tileEntity.a((HolderLookup.a)worldServer.K_()).i("CustomName").orElse("");
    }

    public WrappedIterable<?, Entity> getEntities(World world) {
        try {
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            LevelEntityGetter levelEntityGetter = this.worldServerEntityLookup == null ? worldServer.P.e() : (LevelEntityGetter)this.worldServerEntityLookup.invoke((Object)worldServer, new Object[0]);
            return new WrappedIterable(levelEntityGetter.a(), net.minecraft.world.entity.Entity::getBukkitEntity);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<Integer> getNextEntityId() {
        try {
            this.entityCountField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)this.entityCountField.get(null);
            return CompletableFuture.completedFuture(counter.incrementAndGet());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public ChatColor getRarityColor(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        String str = nmsItemStack.D().a().toString();
        return ChatColor.getByChar((char)str.charAt(str.length() - 1));
    }

    public String getTranslationKey(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        return nmsItemStack.h().j();
    }

    public String getEnchantmentTranslationKey(Enchantment enchantment) {
        NamespacedKey namespacedKey = enchantment.getKey();
        return "enchantment." + namespacedKey.getNamespace() + "." + namespacedKey.getKey();
    }

    public String getEffectTranslationKey(PotionEffectType type) {
        NamespacedKey namespacedKey = type.getKey();
        return "effect." + namespacedKey.getNamespace() + "." + namespacedKey.getKey();
    }

    public EntityType getEntityType(VisualizerEntity entity) {
        if (entity instanceof ArmorStand) {
            return EntityType.ARMOR_STAND;
        }
        if (entity instanceof Item) {
            return EntityType.ITEM;
        }
        if (entity instanceof ItemFrame) {
            return EntityType.ITEM_FRAME;
        }
        throw new RuntimeException("Unknown VisualizerEntity class " + entity.getClass().getName());
    }

    public List<DataWatcher.c<?>> getWatchableCollection(ArmorStand stand) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 0;
            bitmask = !stand.isVisible() ? (byte)(bitmask | 0x20) : bitmask;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherByteField.get(null)), (Object)bitmask));
            Component customName = stand.getCustomName();
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), customName == null ? Optional.empty() : Optional.ofNullable(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(customName))))));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)stand.isCustomNameVisible()));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherSilentField.get(null)), (Object)stand.isSilent()));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherNoGravityField.get(null)), (Object)(!stand.hasGravity() ? 1 : 0)));
            byte standbitmask = 0;
            standbitmask = stand.isSmall() ? (byte)(standbitmask | 1) : standbitmask;
            standbitmask = stand.hasArms() ? (byte)(standbitmask | 4) : standbitmask;
            standbitmask = !stand.hasBasePlate() ? (byte)(standbitmask | 8) : standbitmask;
            standbitmask = stand.isMarker() ? (byte)(standbitmask | 0x10) : standbitmask;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)EntityArmorStand.bS, (Object)standbitmask));
            Vector3f headrotation = new Vector3f((float)Math.toDegrees(stand.getHeadPose().getX()), (float)Math.toDegrees(stand.getHeadPose().getY()), (float)Math.toDegrees(stand.getHeadPose().getZ()));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)EntityArmorStand.bT, (Object)headrotation));
            Vector3f rightarmrotation = new Vector3f((float)Math.toDegrees(stand.getRightArmPose().getX()), (float)Math.toDegrees(stand.getRightArmPose().getY()), (float)Math.toDegrees(stand.getRightArmPose().getZ()));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)EntityArmorStand.bW, (Object)rightarmrotation));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.c<?>> getWatchableCollection(Item item) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            this.dataWatcherItemItemField.setAccessible(true);
            byte bitmask = 0;
            bitmask = item.isGlowing() ? (byte)(bitmask | 0x40) : bitmask;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherByteField.get(null)), (Object)bitmask));
            Component customName = item.getCustomName();
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), customName == null ? Optional.empty() : Optional.ofNullable(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(customName))))));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)item.isCustomNameVisible()));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherNoGravityField.get(null)), (Object)(!item.hasGravity() ? 1 : 0)));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherItemItemField.get(null)), (Object)CraftItemStack.asNMSCopy((ItemStack)item.getItemStack())));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.c<?>> getWatchableCollection(ItemFrame frame) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherSilentField.setAccessible(true);
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherSilentField.get(null)), (Object)frame.isSilent()));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)EntityItemFrame.d, (Object)CraftItemStack.asNMSCopy((ItemStack)frame.getItem())));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)EntityItemFrame.e, (Object)frame.getFrameRotation()));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.c<?>> createCustomNameWatchableCollection(Component name) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            boolean visible = name != null;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name == null ? Optional.empty() : Optional.ofNullable(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(name))))));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.c<?>> resetCustomNameWatchableCollection(Entity entity) {
        try {
            ArrayList dataWatcher = new ArrayList();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.au();
            Optional name = (Optional)watcher.a((DataWatcherObject)this.dataWatcherCustomNameField.get(null));
            boolean visible = (Boolean)watcher.a((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), (Object)name));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendHandMovement(Collection<Player> players, Player entity) {
        EntityPlayer entityPlayer = ((CraftPlayer)entity).getHandle();
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((net.minecraft.world.entity.Entity)entityPlayer, 0);
        for (Player player : players) {
            this.sendPacket(player, packet);
        }
    }

    public void teleportEntity(Player player, int entityId, Location location) {
        ClientboundEntityPositionSyncPacket packet = new ClientboundEntityPositionSyncPacket(entityId, new PositionMoveRotation(new Vec3D(location.getX(), location.getY(), location.getZ()), Vec3D.c, location.getYaw(), location.getPitch()), false);
        this.sendPacket(player, packet);
    }

    public void spawnArmorStand(Collection<Player> players, ArmorStand entity) {
        EntityTypes type = EntityTypes.g;
        Vec3D velocity = new Vec3D(entity.getVelocity().getX(), entity.getVelocity().getY(), entity.getVelocity().getZ());
        PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entity.getEntityId(), entity.getUniqueId(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getPitch(), entity.getLocation().getYaw(), type, 0, velocity, (double)entity.getLocation().getYaw());
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        ArrayList<ValuePairs<EquipmentSlot, ItemStack>> equipments = new ArrayList<ValuePairs<EquipmentSlot, ItemStack>>();
        equipments.add(new ValuePairs((Object)EquipmentSlot.HAND, (Object)entity.getItemInMainHand()));
        equipments.add(new ValuePairs((Object)EquipmentSlot.HEAD, (Object)entity.getHelmet()));
        PacketPlayOutEntityEquipment[] packet3 = this.createEntityEquipmentPacket(entity.getEntityId(), equipments);
        for (Player player : players) {
            this.sendPacket(player, packet1);
            this.sendPacket(player, packet2);
            for (PacketPlayOutEntityEquipment packet : packet3) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void updateArmorStand(Collection<Player> players, ArmorStand entity) {
        ClientboundEntityPositionSyncPacket packet1 = new ClientboundEntityPositionSyncPacket(entity.getEntityId(), new PositionMoveRotation(new Vec3D(entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ()), Vec3D.c, entity.getLocation().getYaw(), entity.getLocation().getPitch()), false);
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        ArrayList<ValuePairs<EquipmentSlot, ItemStack>> equipments = new ArrayList<ValuePairs<EquipmentSlot, ItemStack>>();
        equipments.add(new ValuePairs((Object)EquipmentSlot.HAND, (Object)entity.getItemInMainHand()));
        equipments.add(new ValuePairs((Object)EquipmentSlot.HEAD, (Object)entity.getHelmet()));
        PacketPlayOutEntityEquipment[] packet3 = this.createEntityEquipmentPacket(entity.getEntityId(), equipments);
        for (Player player : players) {
            this.sendPacket(player, packet1);
            this.sendPacket(player, packet2);
            for (PacketPlayOutEntityEquipment packet : packet3) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void updateArmorStandOnlyMeta(Collection<Player> players, ArmorStand entity) {
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet);
        }
    }

    public void removeArmorStand(Collection<Player> players, ArmorStand entity) {
        PacketPlayOutEntityDestroy[] packets = this.createEntityDestroyPacket(entity.getEntityId());
        for (Player player : players) {
            for (PacketPlayOutEntityDestroy packet : packets) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void spawnItem(Collection<Player> players, Item entity) {
        if (entity.getItemStack().getType().equals((Object)Material.AIR)) {
            return;
        }
        EntityTypes type = EntityTypes.as;
        Vec3D velocity = new Vec3D(entity.getVelocity().getX(), entity.getVelocity().getY(), entity.getVelocity().getZ());
        PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entity.getEntityId(), entity.getUniqueId(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getPitch(), entity.getLocation().getYaw(), type, 0, velocity, (double)entity.getLocation().getYaw());
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet1);
            this.sendPacket(player, packet2);
        }
    }

    public void updateItem(Collection<Player> players, Item entity) {
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet1 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        ClientboundEntityPositionSyncPacket packet2 = new ClientboundEntityPositionSyncPacket(entity.getEntityId(), new PositionMoveRotation(new Vec3D(entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ()), Vec3D.c, entity.getLocation().getYaw(), entity.getLocation().getPitch()), false);
        Vec3D velocity = new Vec3D(entity.getVelocity().getX(), entity.getVelocity().getY(), entity.getVelocity().getZ());
        PacketPlayOutEntityVelocity packet3 = new PacketPlayOutEntityVelocity(entity.getEntityId(), velocity);
        for (Player player : players) {
            this.sendPacket(player, packet1);
            this.sendPacket(player, packet2);
            this.sendPacket(player, packet3);
        }
    }

    public void removeItem(Collection<Player> players, Item entity) {
        PacketPlayOutEntityDestroy[] packets = this.createEntityDestroyPacket(entity.getEntityId());
        for (Player player : players) {
            for (PacketPlayOutEntityDestroy packet : packets) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void spawnItemFrame(Collection<Player> players, ItemFrame entity) {
        EntityTypes type = EntityTypes.au;
        Vec3D velocity = Vec3D.c;
        PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entity.getEntityId(), entity.getUniqueId(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getPitch(), entity.getLocation().getYaw(), type, V1_21_7.getItemFrameData((ItemFrame)entity), velocity, (double)entity.getLocation().getYaw());
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet2 = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet1);
            this.sendPacket(player, packet2);
        }
    }

    public void updateItemFrame(Collection<Player> players, ItemFrame entity) {
        List watcher = entity.getDataWatchers();
        PacketPlayOutEntityMetadata packet = this.createEntityMetadataPacket(entity.getEntityId(), watcher);
        for (Player player : players) {
            this.sendPacket(player, packet);
        }
    }

    public void removeItemFrame(Collection<Player> players, ItemFrame entity) {
        PacketPlayOutEntityDestroy[] packets = this.createEntityDestroyPacket(entity.getEntityId());
        for (Player player : players) {
            for (PacketPlayOutEntityDestroy packet : packets) {
                this.sendPacket(player, packet);
            }
        }
    }

    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().g.b((Packet)packet);
    }
}

