/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechat.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.interactivechat.nms.NMSWrapper;
import com.loohp.interactivechat.objectholders.CommandSuggestion;
import com.loohp.interactivechat.objectholders.CustomTabCompletionAction;
import com.loohp.interactivechat.objectholders.IICPlayer;
import com.loohp.interactivechat.objectholders.InternalOfflinePlayerInfo;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.v1_13_R1.Advancement;
import net.minecraft.server.v1_13_R1.AdvancementDisplay;
import net.minecraft.server.v1_13_R1.AdvancementFrameType;
import net.minecraft.server.v1_13_R1.AdvancementProgress;
import net.minecraft.server.v1_13_R1.AdvancementRewards;
import net.minecraft.server.v1_13_R1.BossBattleServer;
import net.minecraft.server.v1_13_R1.ChatComponentText;
import net.minecraft.server.v1_13_R1.Criterion;
import net.minecraft.server.v1_13_R1.CriterionInstance;
import net.minecraft.server.v1_13_R1.CriterionTriggerImpossible;
import net.minecraft.server.v1_13_R1.EntityHuman;
import net.minecraft.server.v1_13_R1.EntityInsentient;
import net.minecraft.server.v1_13_R1.EntityPlayer;
import net.minecraft.server.v1_13_R1.EnumItemSlot;
import net.minecraft.server.v1_13_R1.IChatBaseComponent;
import net.minecraft.server.v1_13_R1.ItemSkullPlayer;
import net.minecraft.server.v1_13_R1.MapIcon;
import net.minecraft.server.v1_13_R1.MinecraftKey;
import net.minecraft.server.v1_13_R1.MinecraftServer;
import net.minecraft.server.v1_13_R1.MojangsonParser;
import net.minecraft.server.v1_13_R1.NBTBase;
import net.minecraft.server.v1_13_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_13_R1.NBTTagCompound;
import net.minecraft.server.v1_13_R1.NBTTagList;
import net.minecraft.server.v1_13_R1.NonNullList;
import net.minecraft.server.v1_13_R1.Packet;
import net.minecraft.server.v1_13_R1.PacketPlayInSettings;
import net.minecraft.server.v1_13_R1.PacketPlayOutAdvancements;
import net.minecraft.server.v1_13_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_13_R1.PacketPlayOutMap;
import net.minecraft.server.v1_13_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_13_R1.PacketPlayOutTabComplete;
import net.minecraft.server.v1_13_R1.PacketPlayOutTitle;
import net.minecraft.server.v1_13_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_13_R1.PlayerConnection;
import net.minecraft.server.v1_13_R1.PlayerInteractManager;
import net.minecraft.server.v1_13_R1.World;
import net.minecraft.server.v1_13_R1.WorldServer;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.io.NamedTag;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_13_R1.CraftServer;
import org.bukkit.craftbukkit.v1_13_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_13_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_13_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_13_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_13_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class V1_13
extends NMSWrapper {
    private final Field[] tabCompletePacketFields;
    private final Method craftMapViewIsContextualMethod;
    private final Method playerConnectionHandleCommandMethod;
    private final Field craftSkullMetaProfileField;
    private final Field entityPlayerCanChatColorField;
    private final Field craftBossbarHandleField;

    public V1_13() {
        try {
            this.tabCompletePacketFields = PacketPlayOutTabComplete.class.getDeclaredFields();
            this.craftMapViewIsContextualMethod = CraftMapView.class.getDeclaredMethod("isContextual", new Class[0]);
            this.playerConnectionHandleCommandMethod = PlayerConnection.class.getDeclaredMethod("handleCommand", String.class);
            this.craftSkullMetaProfileField = Class.forName("org.bukkit.craftbukkit.v1_13_R1.inventory.CraftMetaSkull").getDeclaredField("profile");
            this.entityPlayerCanChatColorField = EntityPlayer.class.getDeclaredField("cu");
            this.craftBossbarHandleField = CraftBossBar.class.getDeclaredField("handle");
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getColorSettingsFromClientInformationPacket(PacketContainer packet) {
        PacketPlayInSettings nmsPacket = (PacketPlayInSettings)packet.getHandle();
        return nmsPacket.e();
    }

    public CommandSuggestion<Suggestions> readCommandSuggestionPacket(PacketContainer packet) {
        try {
            this.tabCompletePacketFields[0].setAccessible(true);
            this.tabCompletePacketFields[1].setAccessible(true);
            PacketPlayOutTabComplete nmsPacket = (PacketPlayOutTabComplete)packet.getHandle();
            int id = this.tabCompletePacketFields[0].getInt(nmsPacket);
            Suggestions suggestions = (Suggestions)this.tabCompletePacketFields[1].get(nmsPacket);
            return CommandSuggestion.of((int)id, (Object)suggestions);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public PacketContainer createCommandSuggestionPacket(int id, Object suggestions) {
        return V1_13.p((Object)new PacketPlayOutTabComplete(id, (Suggestions)suggestions));
    }

    public boolean isCustomTabCompletionSupported() {
        return false;
    }

    public PacketContainer createCustomTabCompletionPacket(CustomTabCompletionAction action, List<String> tab) {
        throw new UnsupportedOperationException();
    }

    public ItemStack toBukkitCopy(Object handle) {
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R1.ItemStack)((net.minecraft.server.v1_13_R1.ItemStack)handle));
    }

    public net.minecraft.server.v1_13_R1.ItemStack toNMSCopy(ItemStack itemstack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemstack);
    }

    public Component getItemStackDisplayName(ItemStack itemStack) {
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)nmsItemStack.getName()));
    }

    public void setItemStackDisplayName(ItemStack itemStack, Component component) {
        IChatBaseComponent nmsComponent = IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(component)));
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        nmsItemStack.a(nmsComponent);
        ItemStack modifiedStack = this.toBukkitCopy(nmsItemStack);
        ItemMeta meta = modifiedStack.getItemMeta();
        if (meta != null) {
            itemStack.setItemMeta(meta);
        }
    }

    public List<Component> getItemStackLore(ItemStack itemStack) {
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        NBTTagCompound nbttagcompound = nmsItemStack.b("display");
        if (nbttagcompound.d("Lore") == 9) {
            ArrayList<Component> lore = new ArrayList<Component>();
            NBTTagList nbtLore = nbttagcompound.getList("Lore", 8);
            for (int i = 0; i < nbtLore.size(); ++i) {
                String json = nbtLore.getString(i);
                lore.add(GsonComponentSerializer.gson().deserialize((Object)json));
            }
            return lore;
        }
        return Collections.emptyList();
    }

    public String getItemStackTranslationKey(ItemStack itemStack) {
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        return nmsItemStack.getItem().h(nmsItemStack);
    }

    public ChatColor getRarityColor(ItemStack itemStack) {
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        String str = nmsItemStack.u().e.toString();
        return ChatColor.getByChar((char)str.charAt(str.length() - 1));
    }

    public Component getSkullOwner(ItemStack itemStack) {
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        ItemSkullPlayer skull = (ItemSkullPlayer)nmsItemStack.getItem();
        IChatBaseComponent owner = skull.i(nmsItemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)owner));
    }

    public boolean isWearable(ItemStack itemStack) {
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        EnumItemSlot slot = EntityInsentient.e((net.minecraft.server.v1_13_R1.ItemStack)nmsItemStack);
        return slot != EnumItemSlot.MAINHAND && slot != EnumItemSlot.OFFHAND;
    }

    public boolean hasBlockEntityTag(ItemStack itemStack) {
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        return nmsItemStack.b("BlockEntityTag") != null;
    }

    public MapView getMapView(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof MapMeta) {
            return Bukkit.getMap((short)((short)((MapMeta)meta).getMapId()));
        }
        return null;
    }

    public int getMapId(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof MapMeta) {
            return ((MapMeta)meta).getMapId();
        }
        return -1;
    }

    public boolean isContextual(MapView mapView) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            this.craftMapViewIsContextualMethod.setAccessible(true);
            return (Boolean)this.craftMapViewIsContextualMethod.invoke((Object)craftMapView, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getColors(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        RenderData renderData = craftMapView.render((CraftPlayer)player);
        return renderData.buffer;
    }

    public List<MapCursor> getCursors(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        RenderData renderData = craftMapView.render((CraftPlayer)player);
        return renderData.cursors;
    }

    public List<MapIcon> toNMSMapIconList(List<MapCursor> mapCursors) {
        return mapCursors.stream().map(c -> {
            MapIcon.Type decorationTypeHolder = MapIcon.Type.a((byte)c.getType().getValue());
            IChatBaseComponent iChat = CraftChatMessage.fromStringOrNull((String)c.getCaption());
            return new MapIcon(decorationTypeHolder, c.getX(), c.getY(), c.getDirection(), iChat);
        }).collect(Collectors.toList());
    }

    public ItemStack getItemFromNBTJson(String json) {
        try {
            NBTTagCompound nbtTagCompound = MojangsonParser.parse((String)json);
            net.minecraft.server.v1_13_R1.ItemStack itemStack = net.minecraft.server.v1_13_R1.ItemStack.a((NBTTagCompound)nbtTagCompound);
            return this.toBukkitCopy(itemStack);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNMSItemStackJson(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        NBTTagCompound nbt = nmsItemStack.save(nbtTagCompound);
        return nbt.toString();
    }

    public Map<Key, DataComponentValue> getNMSItemStackDataComponents(ItemStack itemStack) {
        throw new UnsupportedOperationException();
    }

    public ItemStack getItemStackFromDataComponents(ItemStack itemStack, Map<Key, DataComponentValue> dataComponents) {
        throw new UnsupportedOperationException();
    }

    public Key getNMSItemStackNamespacedKey(ItemStack itemStack) {
        NamespacedKey key = itemStack.getType().getKey();
        return Key.key((String)key.getNamespace(), (String)key.getKey());
    }

    public String getNMSItemStackTag(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        net.minecraft.server.v1_13_R1.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        NBTTagCompound nbt = nmsItemStack.save(nbtTagCompound);
        NBTBase tag = nbt.get("tag");
        return tag == null ? null : tag.toString();
    }

    public NamedTag fromSNBT(String snbt) throws IOException {
        try {
            NBTTagCompound nbt = MojangsonParser.parse((String)snbt);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            NBTCompressedStreamTools.a((NBTTagCompound)nbt, (DataOutput)new DataOutputStream(out));
            return (NamedTag)new NBTDeserializer(false).fromBytes(out.toByteArray());
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void modernChatSigningDetectRateSpam(Player player, String message) {
        throw new UnsupportedOperationException();
    }

    public int modernChatSigningGetChatMessageType(Object chatMessageTypeB) {
        throw new UnsupportedOperationException();
    }

    public Object modernChatSigningGetPlayerChatMessage(String message) {
        throw new UnsupportedOperationException();
    }

    public Object modernChatSigningGetPlayerChatMessage(String message, Component component) {
        throw new UnsupportedOperationException();
    }

    public Optional<Object> modernChatSigningGetUnsignedContent(Object playerChatMessage) {
        throw new UnsupportedOperationException();
    }

    public String modernChatSigningGetSignedContent(Object playerChatMessage) {
        throw new UnsupportedOperationException();
    }

    public boolean modernChatSigningHasWithResult() {
        throw new UnsupportedOperationException();
    }

    public Object modernChatSigningWithResult(Object playerChatMessage, Object result) {
        throw new UnsupportedOperationException();
    }

    public Object modernChatSigningWithUnsignedContent(Object playerChatMessage, Object unsignedContent) {
        throw new UnsupportedOperationException();
    }

    public boolean modernChatSigningIsArgumentSignatureClass(Object instance) {
        throw new UnsupportedOperationException();
    }

    public List<?> modernChatSigningGetArgumentSignatureEntries(Object argumentSignatures) {
        throw new UnsupportedOperationException();
    }

    public String modernChatSigningGetSignedMessageBodyAContent(Object signedMessageBodyA) {
        throw new UnsupportedOperationException();
    }

    public boolean modernChatSigningIsChatMessageIllegal(String s) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> modernChatSigningGetChatDecorator(Player player, Component message) {
        throw new UnsupportedOperationException();
    }

    public void chatAsPlayerAsync(Player player, String message, Object unsignedContentOrResult) {
        ((CraftPlayer)player).getHandle().playerConnection.chat(message, true);
    }

    public void dispatchCommandAsPlayer(Player player, String command) {
        try {
            this.playerConnectionHandleCommandMethod.setAccessible(true);
            PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
            this.playerConnectionHandleCommandMethod.invoke((Object)connection, command.trim());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPing(Player player) {
        return ((CraftPlayer)player).getHandle().ping;
    }

    public boolean canChatColor(Player player) {
        try {
            this.entityPlayerCanChatColorField.setAccessible(true);
            EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
            return this.entityPlayerCanChatColorField.getBoolean(entityPlayer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSkinValue(Player player) {
        Collection textures = ((CraftPlayer)player).getProfile().getProperties().get((Object)"textures");
        if (textures == null || textures.isEmpty()) {
            return null;
        }
        return ((Property)textures.iterator().next()).getValue();
    }

    public String getSkinValue(ItemMeta skull) {
        try {
            if (skull instanceof SkullMeta && ((SkullMeta)skull).hasOwner()) {
                this.craftSkullMetaProfileField.setAccessible(true);
                GameProfile profile = (GameProfile)this.craftSkullMetaProfileField.get(skull);
                Collection textures = profile.getProperties().get((Object)"textures");
                if (textures == null || textures.isEmpty()) {
                    return null;
                }
                return ((Property)textures.iterator().next()).getValue();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public void sendToast(IICPlayer sender, Player pinged, String message, ItemStack icon) {
        MinecraftKey minecraftKey = new MinecraftKey("interactivechat", "mentioned/" + sender.getUniqueId());
        AdvancementRewards advancementRewards = new AdvancementRewards(0, new MinecraftKey[0], new MinecraftKey[0], null);
        IChatBaseComponent componentTitle = CraftChatMessage.fromStringOrNull((String)message);
        ChatComponentText componentSubtitle = new ChatComponentText("");
        AdvancementDisplay advancementDisplay = new AdvancementDisplay(this.toNMSCopy(icon), componentTitle, (IChatBaseComponent)componentSubtitle, null, AdvancementFrameType.GOAL, true, false, true);
        HashMap<String, Criterion> advancementCriteria = new HashMap<String, Criterion>();
        Criterion criterion = new Criterion((CriterionInstance)new CriterionTriggerImpossible.a());
        advancementCriteria.put("for_free", criterion);
        String[][] advancementRequirements = new String[][]{{"for_free"}};
        Advancement advancement = new Advancement(minecraftKey, null, advancementDisplay, advancementRewards, advancementCriteria, advancementRequirements);
        HashMap<MinecraftKey, AdvancementProgress> advancementProgresses = new HashMap<MinecraftKey, AdvancementProgress>();
        AdvancementProgress advancementProgress = new AdvancementProgress();
        advancementProgress.a(advancementCriteria, advancementRequirements);
        advancementProgress.getCriterionProgress("for_free").b();
        advancementProgresses.put(minecraftKey, advancementProgress);
        List<Advancement> advancements = Collections.singletonList(advancement);
        PlayerConnection connection = ((CraftPlayer)pinged).getHandle().playerConnection;
        PacketPlayOutAdvancements packet1 = new PacketPlayOutAdvancements(false, advancements, Collections.emptySet(), advancementProgresses);
        connection.sendPacket((Packet)packet1);
        Set<MinecraftKey> removeAdvancements = Collections.singleton(minecraftKey);
        PacketPlayOutAdvancements packet2 = new PacketPlayOutAdvancements(false, Collections.emptyList(), removeAdvancements, Collections.emptyMap());
        connection.sendPacket((Packet)packet2);
    }

    public void setBossbarTitle(Object bukkitBossbar, Component component) {
        try {
            this.craftBossbarHandleField.setAccessible(true);
            CraftBossBar craftBossBar = (CraftBossBar)bukkitBossbar;
            BossBattleServer bossBattleServer = (BossBattleServer)this.craftBossbarHandleField.get(craftBossBar);
            bossBattleServer.a(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(component))));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendTitle(Player player, Component title, Component subtitle, Component actionbar, int fadeIn, int stay, int fadeOut) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
        PacketPlayOutTitle packet1 = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.RESET, null);
        connection.sendPacket((Packet)packet1);
        if (!PlainTextComponentSerializer.plainText().serialize(title).isEmpty()) {
            PacketPlayOutTitle packet2 = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.TITLE, IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(title))));
            connection.sendPacket((Packet)packet2);
        }
        if (!PlainTextComponentSerializer.plainText().serialize(subtitle).isEmpty()) {
            PacketPlayOutTitle packet3 = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.SUBTITLE, IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(subtitle))));
            connection.sendPacket((Packet)packet3);
        }
        if (!PlainTextComponentSerializer.plainText().serialize(actionbar).isEmpty()) {
            PacketPlayOutTitle packet4 = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.ACTIONBAR, IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(actionbar))));
            connection.sendPacket((Packet)packet4);
        }
        PacketPlayOutTitle packet5 = new PacketPlayOutTitle(fadeIn, stay, fadeOut);
        connection.sendPacket((Packet)packet5);
    }

    public void sendFakePlayerInventory(Player player, Inventory inventory, boolean armor, boolean offhand) {
        ItemStack item;
        int i;
        ItemStack items = new ItemStack[46];
        Arrays.fill((Object[])items, ITEM_STACK_AIR);
        int u = 36;
        for (i = 0; i < 9; ++i) {
            item = inventory.getItem(i);
            items[u] = item == null ? ITEM_STACK_AIR : item.clone();
            ++u;
        }
        for (i = 9; i < 36; ++i) {
            item = inventory.getItem(i);
            items[i] = item == null ? ITEM_STACK_AIR : item.clone();
        }
        if (armor) {
            u = 8;
            for (i = 36; i < 40; ++i) {
                item = inventory.getItem(i);
                items[u] = item == null ? ITEM_STACK_AIR : item.clone();
                --u;
            }
        }
        if (offhand) {
            ItemStack item2 = inventory.getItem(40);
            items[45] = item2 == null ? ITEM_STACK_AIR : item2.clone();
        }
        NonNullList itemList = NonNullList.a();
        for (ItemStack itemStack : items) {
            itemList.add((Object)this.toNMSCopy(itemStack));
        }
        PacketPlayOutWindowItems packet1 = new PacketPlayOutWindowItems(0, itemList);
        PacketPlayOutSetSlot packet2 = new PacketPlayOutSetSlot(-1, -1, this.toNMSCopy(ITEM_STACK_AIR));
        PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
        connection.sendPacket((Packet)packet1);
        connection.sendPacket((Packet)packet2);
    }

    public void sendFakeMainHandSlot(Player player, ItemStack item) {
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(player.getEntityId(), EnumItemSlot.MAINHAND, this.toNMSCopy(item));
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    public void sendFakeMapUpdate(Player player, int mapId, List<MapCursor> mapCursors, byte[] colors) {
        List<MapIcon> mapIcons = this.toNMSMapIconList(mapCursors);
        PacketPlayOutMap packet = new PacketPlayOutMap(mapId, 0, false, mapIcons, colors, 0, 0, 128, 128);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    public InternalOfflinePlayerInfo loadOfflinePlayer(UUID uuid, Inventory inventory, Inventory enderchest) {
        int slot;
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer worldServer = server.getWorldServer(0);
        if (worldServer == null) {
            return null;
        }
        OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uuid);
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        PlayerInteractManager interactManager = new PlayerInteractManager((World)worldServer);
        EntityPlayer player = new EntityPlayer(server, worldServer, profile, interactManager);
        player.getAdvancementData().a();
        NBTTagCompound loadedData = player.server.getPlayerList().playerFileData.load((EntityHuman)player);
        if (loadedData == null) {
            return null;
        }
        player.f(loadedData);
        player.a(loadedData);
        CraftPlayer p = player.getBukkitEntity();
        PlayerInventory playerInventory = p.getInventory();
        int selectedSlot = playerInventory.getHeldItemSlot();
        boolean rightHanded = p.getMainHand().equals((Object)MainHand.RIGHT);
        int xpLevel = p.getLevel();
        for (slot = 0; slot < Math.min(playerInventory.getSize(), inventory.getSize()); ++slot) {
            inventory.setItem(slot, playerInventory.getItem(slot));
        }
        for (slot = 0; slot < Math.min(p.getEnderChest().getSize(), enderchest.getSize()); ++slot) {
            enderchest.setItem(slot, p.getEnderChest().getItem(slot));
        }
        return new InternalOfflinePlayerInfo(selectedSlot, rightHanded, xpLevel, inventory, enderchest);
    }

    public Object deserializeChatComponent(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    public String serializeChatComponent(Object handle) {
        return CraftChatMessage.toJSON((IChatBaseComponent)((IChatBaseComponent)handle));
    }
}

