/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechat.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.interactivechat.nms.NMSWrapper;
import com.loohp.interactivechat.objectholders.CommandSuggestion;
import com.loohp.interactivechat.objectholders.CustomTabCompletionAction;
import com.loohp.interactivechat.objectholders.IICPlayer;
import com.loohp.interactivechat.objectholders.InternalOfflinePlayerInfo;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemSkullPlayer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.io.NamedTag;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_19_R3.map.RenderData;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class V1_19_4
extends NMSWrapper {
    private final Method craftMapViewIsContextualMethod;
    private final Method playerConnectionDetectRateSpamMethod;
    private final Method playerConnectionIsChatMessageIllegalMethod;
    private final Method playerConnectionHandleCommandMethod;
    private final Field craftSkullMetaProfileField;
    private Method paperChatDecoratorDecorateMethod;
    private Method paperPlayerChatMessageWithResultMethod;

    public V1_19_4() {
        try {
            this.craftMapViewIsContextualMethod = CraftMapView.class.getDeclaredMethod("isContextual", new Class[0]);
            this.playerConnectionDetectRateSpamMethod = PlayerConnection.class.getDeclaredMethod("detectRateSpam", String.class);
            this.playerConnectionIsChatMessageIllegalMethod = PlayerConnection.class.getDeclaredMethod("c", String.class);
            this.playerConnectionHandleCommandMethod = PlayerConnection.class.getDeclaredMethod("handleCommand", String.class);
            this.craftSkullMetaProfileField = Class.forName("org.bukkit.craftbukkit.v1_19_R3.inventory.CraftMetaSkull").getDeclaredField("profile");
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            this.paperChatDecoratorDecorateMethod = Arrays.stream(ChatDecorator.class.getMethods()).filter(m -> m.getParameterCount() == 3).findFirst().orElse(null);
            this.paperPlayerChatMessageWithResultMethod = PlayerChatMessage.class.getMethod("withResult", Class.forName("net.minecraft.network.chat.ChatDecorator$Result"));
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public boolean getColorSettingsFromClientInformationPacket(PacketContainer packet) {
        PacketPlayInSettings nmsPacket = (PacketPlayInSettings)packet.getHandle();
        return nmsPacket.e();
    }

    public CommandSuggestion<Suggestions> readCommandSuggestionPacket(PacketContainer packet) {
        PacketPlayOutTabComplete nmsPacket = (PacketPlayOutTabComplete)packet.getHandle();
        return CommandSuggestion.of((int)nmsPacket.a(), (Object)nmsPacket.c());
    }

    public PacketContainer createCommandSuggestionPacket(int id, Object suggestions) {
        return V1_19_4.p((Object)new PacketPlayOutTabComplete(id, (Suggestions)suggestions));
    }

    public boolean isCustomTabCompletionSupported() {
        try {
            ClientboundCustomChatCompletionsPacket.class.getName();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public PacketContainer createCustomTabCompletionPacket(CustomTabCompletionAction action, List<String> tab) {
        ClientboundCustomChatCompletionsPacket.Action nmsAction = null;
        switch (action) {
            case ADD: {
                nmsAction = ClientboundCustomChatCompletionsPacket.Action.a;
                break;
            }
            case REMOVE: {
                nmsAction = ClientboundCustomChatCompletionsPacket.Action.b;
            }
        }
        return V1_19_4.p((Object)new ClientboundCustomChatCompletionsPacket(nmsAction, tab));
    }

    public ItemStack toBukkitCopy(Object handle) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)handle));
    }

    public net.minecraft.world.item.ItemStack toNMSCopy(ItemStack itemstack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemstack);
    }

    public Component getItemStackDisplayName(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)nmsItemStack.x()));
    }

    public void setItemStackDisplayName(ItemStack itemStack, Component component) {
        IChatBaseComponent nmsComponent = CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(component)));
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        nmsItemStack.a(nmsComponent);
        ItemStack modifiedStack = this.toBukkitCopy(nmsItemStack);
        ItemMeta meta = modifiedStack.getItemMeta();
        if (meta != null) {
            itemStack.setItemMeta(meta);
        }
    }

    public List<Component> getItemStackLore(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        NBTTagCompound nbttagcompound = nmsItemStack.b("display");
        if (nbttagcompound.d("Lore") == 9) {
            ArrayList<Component> lore = new ArrayList<Component>();
            NBTTagList nbtLore = nbttagcompound.c("Lore", 8);
            for (int i = 0; i < nbtLore.size(); ++i) {
                String json = nbtLore.j(i);
                lore.add(GsonComponentSerializer.gson().deserialize((Object)json));
            }
            return lore;
        }
        return Collections.emptyList();
    }

    public String getItemStackTranslationKey(ItemStack itemStack) {
        return itemStack.getTranslationKey();
    }

    public ChatColor getRarityColor(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        String str = nmsItemStack.B().e.toString();
        return ChatColor.getByChar((char)str.charAt(str.length() - 1));
    }

    public Component getSkullOwner(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        ItemSkullPlayer skull = (ItemSkullPlayer)nmsItemStack.d();
        IChatBaseComponent owner = skull.m(nmsItemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)owner));
    }

    public boolean isWearable(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        EnumItemSlot slot = EntityInsentient.h((net.minecraft.world.item.ItemStack)nmsItemStack);
        return slot != EnumItemSlot.a && slot != EnumItemSlot.b;
    }

    public boolean hasBlockEntityTag(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        return nmsItemStack.b("BlockEntityTag") != null;
    }

    public MapView getMapView(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof MapMeta) {
            return Bukkit.getMap((int)((MapMeta)meta).getMapId());
        }
        return null;
    }

    public int getMapId(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof MapMeta) {
            return ((MapMeta)meta).getMapId();
        }
        return -1;
    }

    public boolean isContextual(MapView mapView) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            this.craftMapViewIsContextualMethod.setAccessible(true);
            return (Boolean)this.craftMapViewIsContextualMethod.invoke((Object)craftMapView, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getColors(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        RenderData renderData = craftMapView.render((CraftPlayer)player);
        return renderData.buffer;
    }

    public List<MapCursor> getCursors(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        RenderData renderData = craftMapView.render((CraftPlayer)player);
        return renderData.cursors;
    }

    public List<MapIcon> toNMSMapIconList(List<MapCursor> mapCursors) {
        return mapCursors.stream().map(c -> {
            MapIcon.Type decorationTypeHolder = MapIcon.Type.a((byte)c.getType().getValue());
            IChatBaseComponent iChat = CraftChatMessage.fromStringOrNull((String)c.getCaption());
            return new MapIcon(decorationTypeHolder, c.getX(), c.getY(), c.getDirection(), iChat);
        }).collect(Collectors.toList());
    }

    public ItemStack getItemFromNBTJson(String json) {
        try {
            NBTTagCompound nbtTagCompound = MojangsonParser.a((String)json);
            net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.a((NBTTagCompound)nbtTagCompound);
            return this.toBukkitCopy(itemStack);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNMSItemStackJson(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        NBTTagCompound nbt = nmsItemStack.b(nbtTagCompound);
        return nbt.toString();
    }

    public Map<Key, DataComponentValue> getNMSItemStackDataComponents(ItemStack itemStack) {
        throw new UnsupportedOperationException();
    }

    public ItemStack getItemStackFromDataComponents(ItemStack itemStack, Map<Key, DataComponentValue> dataComponents) {
        throw new UnsupportedOperationException();
    }

    public Key getNMSItemStackNamespacedKey(ItemStack itemStack) {
        NamespacedKey key = itemStack.getType().getKey();
        return Key.key((String)key.getNamespace(), (String)key.getKey());
    }

    public String getNMSItemStackTag(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        NBTTagCompound nbt = nmsItemStack.b(nbtTagCompound);
        NBTTagCompound tag = nbt.p("tag");
        return tag == null ? null : tag.toString();
    }

    public NamedTag fromSNBT(String snbt) throws IOException {
        try {
            NBTTagCompound nbt = MojangsonParser.a((String)snbt);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            NBTCompressedStreamTools.a((NBTTagCompound)nbt, (DataOutput)new DataOutputStream(out));
            return (NamedTag)new NBTDeserializer(false).fromBytes(out.toByteArray());
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void modernChatSigningDetectRateSpam(Player player, String message) {
        try {
            this.playerConnectionDetectRateSpamMethod.setAccessible(true);
            PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
            this.playerConnectionDetectRateSpamMethod.invoke((Object)connection, message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int modernChatSigningGetChatMessageType(Object chatMessageTypeB) {
        ChatMessageType.b type = (ChatMessageType.b)chatMessageTypeB;
        return type.a();
    }

    public PlayerChatMessage modernChatSigningGetPlayerChatMessage(String message) {
        return PlayerChatMessage.a((String)message);
    }

    public PlayerChatMessage modernChatSigningGetPlayerChatMessage(String message, Component component) {
        return PlayerChatMessage.a((String)message).a(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(component))));
    }

    public Optional<IChatBaseComponent> modernChatSigningGetUnsignedContent(Object playerChatMessage) {
        PlayerChatMessage message = (PlayerChatMessage)playerChatMessage;
        return Optional.ofNullable(message.m());
    }

    public String modernChatSigningGetSignedContent(Object playerChatMessage) {
        PlayerChatMessage message = (PlayerChatMessage)playerChatMessage;
        return message.l().a();
    }

    public boolean modernChatSigningHasWithResult() {
        return this.paperPlayerChatMessageWithResultMethod != null;
    }

    public PlayerChatMessage modernChatSigningWithResult(Object playerChatMessage, Object result) {
        try {
            return (PlayerChatMessage)this.paperPlayerChatMessageWithResultMethod.invoke(playerChatMessage, result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public PlayerChatMessage modernChatSigningWithUnsignedContent(Object playerChatMessage, Object unsignedContent) {
        PlayerChatMessage message = (PlayerChatMessage)playerChatMessage;
        IChatBaseComponent content = (IChatBaseComponent)unsignedContent;
        return message.a(content);
    }

    public boolean modernChatSigningIsArgumentSignatureClass(Object instance) {
        return instance instanceof ArgumentSignatures;
    }

    public List<ArgumentSignatures.a> modernChatSigningGetArgumentSignatureEntries(Object argumentSignatures) {
        ArgumentSignatures signatures = (ArgumentSignatures)argumentSignatures;
        return signatures.a();
    }

    public String modernChatSigningGetSignedMessageBodyAContent(Object signedMessageBodyA) {
        SignedMessageBody.a body = (SignedMessageBody.a)signedMessageBodyA;
        return body.a();
    }

    public boolean modernChatSigningIsChatMessageIllegal(String s) {
        try {
            this.playerConnectionIsChatMessageIllegalMethod.setAccessible(true);
            return (Boolean)this.playerConnectionIsChatMessageIllegalMethod.invoke(null, s);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<?> modernChatSigningGetChatDecorator(Player player, Component message) {
        try {
            ChatDecorator chatDecorator = ((CraftServer)Bukkit.getServer()).getServer().bg();
            EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
            if (this.paperChatDecoratorDecorateMethod == null) {
                return chatDecorator.decorate(entityPlayer, CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(message))));
            }
            return (CompletableFuture)this.paperChatDecoratorDecorateMethod.invoke((Object)chatDecorator, entityPlayer, null, CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(message))));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void chatAsPlayerAsync(Player player, String message, Object unsignedContentOrResult) {
        PlayerChatMessage playerChatMessage = this.modernChatSigningGetPlayerChatMessage(message);
        if (unsignedContentOrResult != null) {
            playerChatMessage = unsignedContentOrResult instanceof IChatBaseComponent ? this.modernChatSigningWithUnsignedContent(playerChatMessage, unsignedContentOrResult) : this.modernChatSigningWithResult(playerChatMessage, unsignedContentOrResult);
        }
        ((CraftPlayer)player).getHandle().b.chat(message, playerChatMessage, true);
    }

    public void dispatchCommandAsPlayer(Player player, String command) {
        try {
            this.playerConnectionHandleCommandMethod.setAccessible(true);
            PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
            this.playerConnectionHandleCommandMethod.invoke((Object)connection, command.trim());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPing(Player player) {
        return player.getPing();
    }

    public boolean canChatColor(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        return entityPlayer.z();
    }

    public String getSkinValue(Player player) {
        Collection textures = ((CraftPlayer)player).getProfile().getProperties().get((Object)"textures");
        if (textures == null || textures.isEmpty()) {
            return null;
        }
        return ((Property)textures.iterator().next()).getValue();
    }

    public String getSkinValue(ItemMeta skull) {
        try {
            if (skull instanceof SkullMeta && ((SkullMeta)skull).hasOwner()) {
                this.craftSkullMetaProfileField.setAccessible(true);
                GameProfile profile = (GameProfile)this.craftSkullMetaProfileField.get(skull);
                Collection textures = profile.getProperties().get((Object)"textures");
                if (textures == null || textures.isEmpty()) {
                    return null;
                }
                return ((Property)textures.iterator().next()).getValue();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public void sendToast(IICPlayer sender, Player pinged, String message, ItemStack icon) {
        MinecraftKey minecraftKey = new MinecraftKey("interactivechat", "mentioned/" + sender.getUniqueId());
        AdvancementRewards advancementRewards = new AdvancementRewards(0, new MinecraftKey[0], new MinecraftKey[0], null);
        IChatBaseComponent componentTitle = CraftChatMessage.fromStringOrNull((String)message);
        IChatBaseComponent componentSubtitle = IChatBaseComponent.a((String)"");
        AdvancementDisplay advancementDisplay = new AdvancementDisplay(this.toNMSCopy(icon), componentTitle, componentSubtitle, null, AdvancementFrameType.c, true, false, true);
        HashMap<String, Criterion> advancementCriteria = new HashMap<String, Criterion>();
        Criterion criterion = new Criterion((CriterionInstance)new CriterionTriggerImpossible.a());
        advancementCriteria.put("for_free", criterion);
        String[][] advancementRequirements = new String[][]{{"for_free"}};
        Advancement advancement = new Advancement(minecraftKey, null, advancementDisplay, advancementRewards, advancementCriteria, advancementRequirements);
        HashMap<MinecraftKey, AdvancementProgress> advancementProgresses = new HashMap<MinecraftKey, AdvancementProgress>();
        AdvancementProgress advancementProgress = new AdvancementProgress();
        advancementProgress.a(advancementCriteria, advancementRequirements);
        advancementProgress.c("for_free").b();
        advancementProgresses.put(minecraftKey, advancementProgress);
        List<Advancement> advancements = Collections.singletonList(advancement);
        PlayerConnection connection = ((CraftPlayer)pinged).getHandle().b;
        PacketPlayOutAdvancements packet1 = new PacketPlayOutAdvancements(false, advancements, Collections.emptySet(), advancementProgresses);
        connection.a((Packet)packet1);
        Set<MinecraftKey> removeAdvancements = Collections.singleton(minecraftKey);
        PacketPlayOutAdvancements packet2 = new PacketPlayOutAdvancements(false, Collections.emptyList(), removeAdvancements, Collections.emptyMap());
        connection.a((Packet)packet2);
    }

    public void setBossbarTitle(Object bukkitBossbar, Component component) {
        CraftBossBar craftBossBar = (CraftBossBar)bukkitBossbar;
        craftBossBar.getHandle().a(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(component))));
    }

    public void sendTitle(Player player, Component title, Component subtitle, Component actionbar, int fadeIn, int stay, int fadeOut) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
        ClientboundClearTitlesPacket packet1 = new ClientboundClearTitlesPacket(true);
        connection.a((Packet)packet1);
        if (!PlainTextComponentSerializer.plainText().serialize(title).isEmpty()) {
            ClientboundSetTitleTextPacket packet2 = new ClientboundSetTitleTextPacket(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(title))));
            connection.a((Packet)packet2);
        }
        if (!PlainTextComponentSerializer.plainText().serialize(subtitle).isEmpty()) {
            ClientboundSetSubtitleTextPacket packet3 = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(subtitle))));
            connection.a((Packet)packet3);
        }
        if (!PlainTextComponentSerializer.plainText().serialize(actionbar).isEmpty()) {
            ClientboundSetActionBarTextPacket packet4 = new ClientboundSetActionBarTextPacket(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(actionbar))));
            connection.a((Packet)packet4);
        }
        ClientboundSetTitlesAnimationPacket packet5 = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        connection.a((Packet)packet5);
    }

    public void sendFakePlayerInventory(Player player, Inventory inventory, boolean armor, boolean offhand) {
        ItemStack item;
        int i;
        ItemStack items = new ItemStack[46];
        Arrays.fill((Object[])items, ITEM_STACK_AIR);
        int u = 36;
        for (i = 0; i < 9; ++i) {
            item = inventory.getItem(i);
            items[u] = item == null ? ITEM_STACK_AIR : item.clone();
            ++u;
        }
        for (i = 9; i < 36; ++i) {
            item = inventory.getItem(i);
            items[i] = item == null ? ITEM_STACK_AIR : item.clone();
        }
        if (armor) {
            u = 8;
            for (i = 36; i < 40; ++i) {
                item = inventory.getItem(i);
                items[u] = item == null ? ITEM_STACK_AIR : item.clone();
                --u;
            }
        }
        if (offhand) {
            ItemStack item2 = inventory.getItem(40);
            items[45] = item2 == null ? ITEM_STACK_AIR : item2.clone();
        }
        NonNullList itemList = NonNullList.a();
        for (ItemStack itemStack : items) {
            itemList.add((Object)this.toNMSCopy(itemStack));
        }
        PacketPlayOutWindowItems packet1 = new PacketPlayOutWindowItems(0, 0, itemList, this.toNMSCopy(ITEM_STACK_AIR));
        PacketPlayOutSetSlot packet2 = new PacketPlayOutSetSlot(-1, -1, 0, this.toNMSCopy(ITEM_STACK_AIR));
        PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
        connection.a((Packet)packet1);
        connection.a((Packet)packet2);
    }

    public void sendFakeMainHandSlot(Player player, ItemStack item) {
        List<Pair> nmsEquipments = Collections.singletonList(new Pair((Object)EnumItemSlot.a, (Object)this.toNMSCopy(item)));
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(player.getEntityId(), nmsEquipments);
        ((CraftPlayer)player).getHandle().b.a((Packet)packet);
    }

    public void sendFakeMapUpdate(Player player, int mapId, List<MapCursor> mapCursors, byte[] colors) {
        List<MapIcon> mapIcons = this.toNMSMapIconList(mapCursors);
        WorldMap.b b2 = new WorldMap.b(0, 0, 128, 128, colors);
        PacketPlayOutMap packet = new PacketPlayOutMap(mapId, 0, false, mapIcons, b2);
        ((CraftPlayer)player).getHandle().b.a((Packet)packet);
    }

    public InternalOfflinePlayerInfo loadOfflinePlayer(UUID uuid, Inventory inventory, Inventory enderchest) {
        int slot;
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer worldServer = server.a(World.i);
        if (worldServer == null) {
            return null;
        }
        OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uuid);
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        EntityPlayer player = new EntityPlayer((MinecraftServer)server, worldServer, profile);
        player.M().a();
        NBTTagCompound loadedData = player.c.ac().s.b((EntityHuman)player);
        if (loadedData == null) {
            return null;
        }
        player.g(loadedData);
        player.a(loadedData);
        player.c(loadedData);
        CraftPlayer p = player.getBukkitEntity();
        PlayerInventory playerInventory = p.getInventory();
        int selectedSlot = playerInventory.getHeldItemSlot();
        boolean rightHanded = p.getMainHand().equals((Object)MainHand.RIGHT);
        int xpLevel = p.getLevel();
        for (slot = 0; slot < Math.min(playerInventory.getSize(), inventory.getSize()); ++slot) {
            inventory.setItem(slot, playerInventory.getItem(slot));
        }
        for (slot = 0; slot < Math.min(p.getEnderChest().getSize(), enderchest.getSize()); ++slot) {
            enderchest.setItem(slot, p.getEnderChest().getItem(slot));
        }
        return new InternalOfflinePlayerInfo(selectedSlot, rightHanded, xpLevel, inventory, enderchest);
    }

    public Object deserializeChatComponent(String json) {
        return CraftChatMessage.fromJSON((String)json);
    }

    public String serializeChatComponent(Object handle) {
        return CraftChatMessage.toJSON((IChatBaseComponent)((IChatBaseComponent)handle));
    }
}

