/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechat.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.google.gson.JsonElement;
import com.loohp.interactivechat.nms.NMSWrapper;
import com.loohp.interactivechat.objectholders.CommandSuggestion;
import com.loohp.interactivechat.objectholders.CustomTabCompletionAction;
import com.loohp.interactivechat.objectholders.IICPlayer;
import com.loohp.interactivechat.objectholders.InternalOfflinePlayerInfo;
import com.loohp.interactivechat.utils.NativeJsonConverter;
import com.loohp.interactivechat.utils.ReflectionUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonDataComponentValue;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.item.ItemSkullPlayer;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.ValueInput;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.io.NamedTag;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R5.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R5.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class V1_21_7
extends NMSWrapper {
    private final Method craftMapViewIsContextualMethod;
    private final Method playerConnectionDetectRateSpamMethod;
    private final Method playerConnectionIsChatMessageIllegalMethod;
    private final Method playerConnectionHandleCommandMethod;
    private final Field craftSkullMetaProfileField;
    private final Field renderDataCursorsField;
    private final Method nmsEntityPlayerLoadMethod;
    private final Field nmsEntityPlayerServerField;
    private Method paperChatDecoratorDecorateMethod;

    public V1_21_7() {
        try {
            this.craftMapViewIsContextualMethod = CraftMapView.class.getDeclaredMethod("isContextual", new Class[0]);
            this.playerConnectionDetectRateSpamMethod = PlayerConnection.class.getDeclaredMethod("detectRateSpam", String.class);
            this.playerConnectionIsChatMessageIllegalMethod = ReflectionUtils.findDeclaredMethod(PlayerConnection.class, (Class[])new Class[]{String.class}, (String[])new String[]{"isChatMessageIllegal", "d"});
            this.playerConnectionHandleCommandMethod = PlayerConnection.class.getDeclaredMethod("handleCommand", String.class);
            this.craftSkullMetaProfileField = Class.forName("org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMetaSkull").getDeclaredField("profile");
            this.renderDataCursorsField = RenderData.class.getField("cursors");
            this.nmsEntityPlayerLoadMethod = EntityPlayer.class.getDeclaredMethod("a", ValueInput.class);
            this.nmsEntityPlayerServerField = ReflectionUtils.findDeclaredField(EntityPlayer.class, MinecraftServer.class, (String[])new String[]{"server", "cW"});
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.paperChatDecoratorDecorateMethod = Arrays.stream(ChatDecorator.class.getMethods()).filter(m -> m.getParameterCount() == 3).findFirst().orElse(null);
    }

    private NBTBase toNBT(net.minecraft.world.item.ItemStack itemStack) {
        IRegistryCustom registryAccess = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().K_();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        return (NBTBase)net.minecraft.world.item.ItemStack.b.encode((Object)itemStack, (DynamicOps)registryAccess.a((DynamicOps)DynamicOpsNBT.a), (Object)nbtTagCompound).getOrThrow();
    }

    private Optional<net.minecraft.world.item.ItemStack> fromNBT(NBTBase nbtbase) {
        IRegistryCustom registryAccess = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().K_();
        return net.minecraft.world.item.ItemStack.b.parse((DynamicOps)registryAccess.a((DynamicOps)DynamicOpsNBT.a), (Object)nbtbase).resultOrPartial();
    }

    public boolean getColorSettingsFromClientInformationPacket(PacketContainer packet) {
        ServerboundClientInformationPacket nmsPacket = (ServerboundClientInformationPacket)packet.getHandle();
        return nmsPacket.b().e();
    }

    public CommandSuggestion<Suggestions> readCommandSuggestionPacket(PacketContainer packet) {
        PacketPlayOutTabComplete nmsPacket = (PacketPlayOutTabComplete)packet.getHandle();
        return CommandSuggestion.of((int)nmsPacket.e(), (Object)nmsPacket.b());
    }

    public PacketContainer createCommandSuggestionPacket(int id, Object suggestions) {
        return V1_21_7.p((Object)new PacketPlayOutTabComplete(id, (Suggestions)suggestions));
    }

    public boolean isCustomTabCompletionSupported() {
        try {
            ClientboundCustomChatCompletionsPacket.class.getName();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public PacketContainer createCustomTabCompletionPacket(CustomTabCompletionAction action, List<String> tab) {
        ClientboundCustomChatCompletionsPacket.Action nmsAction = null;
        switch (action) {
            case ADD: {
                nmsAction = ClientboundCustomChatCompletionsPacket.Action.a;
                break;
            }
            case REMOVE: {
                nmsAction = ClientboundCustomChatCompletionsPacket.Action.b;
            }
        }
        return V1_21_7.p((Object)new ClientboundCustomChatCompletionsPacket(nmsAction, tab));
    }

    public ItemStack toBukkitCopy(Object handle) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)handle));
    }

    public net.minecraft.world.item.ItemStack toNMSCopy(ItemStack itemstack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemstack);
    }

    public Component getItemStackDisplayName(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)nmsItemStack.y()));
    }

    public void setItemStackDisplayName(ItemStack itemStack, Component component) {
        IChatBaseComponent nmsComponent = CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(component)));
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        DataComponentPatch dataComponentPatch = DataComponentPatch.a().a(DataComponents.g, (Object)nmsComponent).a();
        nmsItemStack.a(dataComponentPatch);
        ItemStack modifiedStack = this.toBukkitCopy(nmsItemStack);
        ItemMeta meta = modifiedStack.getItemMeta();
        if (meta != null) {
            itemStack.setItemMeta(meta);
        }
    }

    public List<Component> getItemStackLore(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        ItemLore lore = (ItemLore)nmsItemStack.a(DataComponents.j);
        if (lore == null) {
            return Collections.emptyList();
        }
        return lore.b().stream().map(e -> GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)e))).collect(Collectors.toList());
    }

    public String getItemStackTranslationKey(ItemStack itemStack) {
        return itemStack.getTranslationKey();
    }

    public ChatColor getRarityColor(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        String str = nmsItemStack.D().a().toString();
        return ChatColor.getByChar((char)str.charAt(str.length() - 1));
    }

    public Component getSkullOwner(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        ItemSkullPlayer skull = (ItemSkullPlayer)nmsItemStack.h();
        IChatBaseComponent owner = skull.a(nmsItemStack);
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)owner));
    }

    public boolean isWearable(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        Equippable equippable = (Equippable)nmsItemStack.a(DataComponents.D);
        if (equippable == null) {
            return false;
        }
        if (!equippable.f().map(a2 -> a2.a().anyMatch(s -> ((EntityTypes)s.a()).equals(EntityTypes.bS))).orElse(true).booleanValue()) {
            return false;
        }
        EnumItemSlot slot = equippable.b();
        return slot != EnumItemSlot.a && slot != EnumItemSlot.b;
    }

    public boolean hasBlockEntityTag(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        return nmsItemStack.a(DataComponents.Y) != null;
    }

    public MapView getMapView(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof MapMeta) {
            return Bukkit.getMap((int)((MapMeta)meta).getMapId());
        }
        return null;
    }

    public int getMapId(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof MapMeta) {
            return ((MapMeta)meta).getMapId();
        }
        return -1;
    }

    public boolean isContextual(MapView mapView) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            this.craftMapViewIsContextualMethod.setAccessible(true);
            return (Boolean)this.craftMapViewIsContextualMethod.invoke((Object)craftMapView, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getColors(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        RenderData renderData = craftMapView.render((CraftPlayer)player);
        return renderData.buffer;
    }

    public List<MapCursor> getCursors(MapView mapView, Player player) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            RenderData renderData = craftMapView.render((CraftPlayer)player);
            return (List)this.renderDataCursorsField.get(renderData);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public List<MapIcon> toNMSMapIconList(List<MapCursor> mapCursors) {
        return mapCursors.stream().map(c2 -> {
            Holder decorationTypeHolder = CraftMapCursor.CraftType.bukkitToMinecraftHolder((MapCursor.Type)c2.getType());
            IChatBaseComponent iChat = CraftChatMessage.fromStringOrNull((String)c2.getCaption());
            return new MapIcon(decorationTypeHolder, c2.getX(), c2.getY(), c2.getDirection(), Optional.ofNullable(iChat));
        }).collect(Collectors.toList());
    }

    public ItemStack getItemFromNBTJson(String json) {
        try {
            IRegistryCustom registryAccess = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().K_();
            NBTTagCompound nbtTagCompound = MojangsonParser.a((String)json);
            net.minecraft.world.item.ItemStack itemStack = this.fromNBT((NBTBase)nbtTagCompound).orElseThrow(() -> new RuntimeException());
            return this.toBukkitCopy(itemStack);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNMSItemStackJson(ItemStack itemStack) {
        if (itemStack.getType().isAir()) {
            return "{id: \"minecraft:air\", count: 1}";
        }
        return this.toNBT(this.toNMSCopy(itemStack)).toString();
    }

    public Map<Key, DataComponentValue> getNMSItemStackDataComponents(ItemStack itemStack) {
        if (itemStack.getType().isAir()) {
            return Collections.emptyMap();
        }
        IRegistryCustom registryAccess = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().K_();
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        DataComponentPatch dataComponentPatch = nmsItemStack.d();
        HashMap<Key, DataComponentValue> convertedComponents = new HashMap<Key, DataComponentValue>();
        for (Map.Entry entry : dataComponentPatch.b()) {
            DataComponentType type = (DataComponentType)entry.getKey();
            Optional optValue = (Optional)entry.getValue();
            MinecraftKey minecraftKey = BuiltInRegistries.am.b((Object)type);
            Key key = Key.key((String)minecraftKey.b(), (String)minecraftKey.a());
            if (optValue.isPresent()) {
                Codec codec = type.b();
                if (codec == null) continue;
                Object nativeJsonElement = codec.encodeStart((DynamicOps)registryAccess.a((DynamicOps)JsonOps.INSTANCE), optValue.get()).getOrThrow();
                JsonElement jsonElement = NativeJsonConverter.fromNative((Object)nativeJsonElement);
                GsonDataComponentValue value = GsonDataComponentValue.gsonDataComponentValue((JsonElement)jsonElement);
                convertedComponents.put(key, (DataComponentValue)value);
                continue;
            }
            convertedComponents.put(key, (DataComponentValue)DataComponentValue.removed());
        }
        return convertedComponents;
    }

    public ItemStack getItemStackFromDataComponents(ItemStack itemStack, Map<Key, DataComponentValue> dataComponents) {
        if (dataComponents.isEmpty()) {
            return itemStack;
        }
        try {
            IRegistryCustom registryAccess = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().K_();
            net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
            DataComponentPatch.a builder = DataComponentPatch.a();
            for (Map.Entry<Key, DataComponentValue> entry : dataComponents.entrySet()) {
                Key key = entry.getKey();
                DataComponentValue value = entry.getValue();
                MinecraftKey minecraftKey = MinecraftKey.a((String)key.namespace(), (String)key.value());
                Optional optType = BuiltInRegistries.am.b(minecraftKey);
                if (!optType.isPresent()) continue;
                DataComponentType type = (DataComponentType)optType.get();
                if (value instanceof DataComponentValue.Removed) {
                    builder.a(type);
                    continue;
                }
                if (!(value instanceof GsonDataComponentValue)) continue;
                JsonElement jsonElement = ((GsonDataComponentValue)value).element();
                Object nativeJsonElement = NativeJsonConverter.toNative((JsonElement)jsonElement);
                Object result = ((Pair)type.b().decode((DynamicOps)registryAccess.a((DynamicOps)JsonOps.INSTANCE), nativeJsonElement).getOrThrow()).getFirst();
                builder.a(type, result);
            }
            nmsItemStack.a(builder.a());
            return this.toBukkitCopy(nmsItemStack);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Key getNMSItemStackNamespacedKey(ItemStack itemStack) {
        if (itemStack.getType().isAir()) {
            return Key.key((String)"minecraft", (String)"air");
        }
        NamespacedKey key = itemStack.getType().getKey();
        return Key.key((String)key.getNamespace(), (String)key.getKey());
    }

    public String getNMSItemStackTag(ItemStack itemStack) {
        if (itemStack.getType().isAir()) {
            return null;
        }
        IRegistryCustom registryAccess = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().K_();
        net.minecraft.world.item.ItemStack nmsItemStack = this.toNMSCopy(itemStack);
        NBTBase nbt = this.toNBT(nmsItemStack);
        if (nbt instanceof NBTTagCompound) {
            NBTTagList tag = ((NBTTagCompound)nbt).p("tag");
            return tag == null ? null : tag.toString();
        }
        return null;
    }

    public NamedTag fromSNBT(String snbt) throws IOException {
        try {
            NBTTagCompound nbt = MojangsonParser.a((String)snbt);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            NBTCompressedStreamTools.c((NBTBase)nbt, (DataOutput)new DataOutputStream(out));
            return (NamedTag)new NBTDeserializer(false).fromBytes(out.toByteArray());
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void modernChatSigningDetectRateSpam(Player player, String message) {
        try {
            this.playerConnectionDetectRateSpamMethod.setAccessible(true);
            PlayerConnection connection = ((CraftPlayer)player).getHandle().g;
            this.playerConnectionDetectRateSpamMethod.invoke((Object)connection, message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int modernChatSigningGetChatMessageType(Object chatMessageTypeB) {
        return 0;
    }

    public PlayerChatMessage modernChatSigningGetPlayerChatMessage(String message) {
        return PlayerChatMessage.a((String)message);
    }

    public PlayerChatMessage modernChatSigningGetPlayerChatMessage(String message, Component component) {
        return PlayerChatMessage.a((String)message).a(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(component))));
    }

    public Optional<IChatBaseComponent> modernChatSigningGetUnsignedContent(Object playerChatMessage) {
        PlayerChatMessage message = (PlayerChatMessage)playerChatMessage;
        return Optional.ofNullable(message.n());
    }

    public String modernChatSigningGetSignedContent(Object playerChatMessage) {
        PlayerChatMessage message = (PlayerChatMessage)playerChatMessage;
        return message.m().a();
    }

    public boolean modernChatSigningHasWithResult() {
        return false;
    }

    public Object modernChatSigningWithResult(Object playerChatMessage, Object result) {
        return null;
    }

    public PlayerChatMessage modernChatSigningWithUnsignedContent(Object playerChatMessage, Object unsignedContent) {
        PlayerChatMessage message = (PlayerChatMessage)playerChatMessage;
        IChatBaseComponent content = (IChatBaseComponent)unsignedContent;
        return message.a(content);
    }

    public boolean modernChatSigningIsArgumentSignatureClass(Object instance) {
        return instance instanceof ArgumentSignatures;
    }

    public List<ArgumentSignatures.a> modernChatSigningGetArgumentSignatureEntries(Object argumentSignatures) {
        ArgumentSignatures signatures = (ArgumentSignatures)argumentSignatures;
        return signatures.a();
    }

    public String modernChatSigningGetSignedMessageBodyAContent(Object signedMessageBodyA) {
        SignedMessageBody.a body = (SignedMessageBody.a)signedMessageBodyA;
        return body.a();
    }

    public boolean modernChatSigningIsChatMessageIllegal(String s) {
        try {
            this.playerConnectionIsChatMessageIllegalMethod.setAccessible(true);
            return (Boolean)this.playerConnectionIsChatMessageIllegalMethod.invoke(null, s);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<IChatBaseComponent> modernChatSigningGetChatDecorator(Player player, Component message) {
        try {
            ChatDecorator chatDecorator = ((CraftServer)Bukkit.getServer()).getServer().bk();
            EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
            if (this.paperChatDecoratorDecorateMethod == null) {
                return CompletableFuture.completedFuture(chatDecorator.decorate(entityPlayer, CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(message)))));
            }
            return (CompletableFuture)this.paperChatDecoratorDecorateMethod.invoke((Object)chatDecorator, entityPlayer, null, CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(message))));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void chatAsPlayerAsync(Player player, String message, Object unsignedContentOrResult) {
        PlayerChatMessage playerChatMessage = this.modernChatSigningGetPlayerChatMessage(message);
        if (unsignedContentOrResult != null) {
            playerChatMessage = this.modernChatSigningWithUnsignedContent(playerChatMessage, unsignedContentOrResult);
        }
        ((CraftPlayer)player).getHandle().g.chat(message, playerChatMessage, true);
    }

    public void dispatchCommandAsPlayer(Player player, String command) {
        try {
            this.playerConnectionHandleCommandMethod.setAccessible(true);
            PlayerConnection connection = ((CraftPlayer)player).getHandle().g;
            this.playerConnectionHandleCommandMethod.invoke((Object)connection, command.trim());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPing(Player player) {
        return player.getPing();
    }

    public boolean canChatColor(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        return entityPlayer.D();
    }

    public String getSkinValue(Player player) {
        Collection textures = ((CraftPlayer)player).getProfile().getProperties().get((Object)"textures");
        if (textures == null || textures.isEmpty()) {
            return null;
        }
        return ((Property)textures.iterator().next()).value();
    }

    public String getSkinValue(ItemMeta skull) {
        try {
            if (skull instanceof SkullMeta && ((SkullMeta)skull).hasOwner()) {
                this.craftSkullMetaProfileField.setAccessible(true);
                GameProfile profile = (GameProfile)this.craftSkullMetaProfileField.get(skull);
                Collection textures = profile.getProperties().get((Object)"textures");
                if (textures == null || textures.isEmpty()) {
                    return null;
                }
                return ((Property)textures.iterator().next()).value();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public void sendToast(IICPlayer sender, Player pinged, String message, ItemStack icon) {
        MinecraftKey minecraftKey = MinecraftKey.a((String)"interactivechat", (String)("mentioned/" + sender.getUniqueId()));
        AdvancementRewards advancementRewards = new AdvancementRewards(0, Collections.emptyList(), Collections.emptyList(), Optional.empty());
        IChatBaseComponent componentTitle = CraftChatMessage.fromStringOrNull((String)message);
        IChatBaseComponent componentSubtitle = IChatBaseComponent.a((String)"");
        AdvancementDisplay advancementDisplay = new AdvancementDisplay(this.toNMSCopy(icon), componentTitle, componentSubtitle, Optional.empty(), AdvancementFrameType.c, true, false, true);
        HashMap<String, Criterion> advancementCriteria = new HashMap<String, Criterion>();
        Criterion criterion = new Criterion((CriterionTrigger)new CriterionTriggerImpossible(), (CriterionInstance)new CriterionTriggerImpossible.a());
        advancementCriteria.put("for_free", criterion);
        List<List<String>> fixedRequirements = Collections.singletonList(Collections.singletonList("for_free"));
        AdvancementRequirements advancementRequirements = new AdvancementRequirements(fixedRequirements);
        Advancement advancement = new Advancement(Optional.empty(), Optional.of(advancementDisplay), advancementRewards, advancementCriteria, advancementRequirements, false);
        HashMap<MinecraftKey, AdvancementProgress> advancementProgresses = new HashMap<MinecraftKey, AdvancementProgress>();
        AdvancementProgress advancementProgress = new AdvancementProgress();
        advancementProgress.a(advancementRequirements);
        advancementProgress.c("for_free").b();
        advancementProgresses.put(minecraftKey, advancementProgress);
        List<AdvancementHolder> advancements = Collections.singletonList(new AdvancementHolder(minecraftKey, advancement));
        PlayerConnection connection = ((CraftPlayer)pinged).getHandle().g;
        PacketPlayOutAdvancements packet1 = new PacketPlayOutAdvancements(false, advancements, Collections.emptySet(), advancementProgresses, true);
        connection.b((Packet)packet1);
        Set<MinecraftKey> removeAdvancements = Collections.singleton(minecraftKey);
        PacketPlayOutAdvancements packet2 = new PacketPlayOutAdvancements(false, Collections.emptyList(), removeAdvancements, Collections.emptyMap(), true);
        connection.b((Packet)packet2);
    }

    public void setBossbarTitle(Object bukkitBossbar, Component component) {
        CraftBossBar craftBossBar = (CraftBossBar)bukkitBossbar;
        craftBossBar.getHandle().a(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(component))));
    }

    public void sendTitle(Player player, Component title, Component subtitle, Component actionbar, int fadeIn, int stay, int fadeOut) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().g;
        ClientboundClearTitlesPacket packet1 = new ClientboundClearTitlesPacket(true);
        connection.b((Packet)packet1);
        if (!PlainTextComponentSerializer.plainText().serialize(title).isEmpty()) {
            ClientboundSetTitleTextPacket packet2 = new ClientboundSetTitleTextPacket(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(title))));
            connection.b((Packet)packet2);
        }
        if (!PlainTextComponentSerializer.plainText().serialize(subtitle).isEmpty()) {
            ClientboundSetSubtitleTextPacket packet3 = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(subtitle))));
            connection.b((Packet)packet3);
        }
        if (!PlainTextComponentSerializer.plainText().serialize(actionbar).isEmpty()) {
            ClientboundSetActionBarTextPacket packet4 = new ClientboundSetActionBarTextPacket(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(actionbar))));
            connection.b((Packet)packet4);
        }
        ClientboundSetTitlesAnimationPacket packet5 = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        connection.b((Packet)packet5);
    }

    public void sendFakePlayerInventory(Player player, Inventory inventory, boolean armor, boolean offhand) {
        ItemStack item;
        int i;
        ItemStack items = new ItemStack[46];
        Arrays.fill((Object[])items, ITEM_STACK_AIR);
        int u = 36;
        for (i = 0; i < 9; ++i) {
            item = inventory.getItem(i);
            items[u] = item == null ? ITEM_STACK_AIR : item.clone();
            ++u;
        }
        for (i = 9; i < 36; ++i) {
            item = inventory.getItem(i);
            items[i] = item == null ? ITEM_STACK_AIR : item.clone();
        }
        if (armor) {
            u = 8;
            for (i = 36; i < 40; ++i) {
                item = inventory.getItem(i);
                items[u] = item == null ? ITEM_STACK_AIR : item.clone();
                --u;
            }
        }
        if (offhand) {
            ItemStack item2 = inventory.getItem(40);
            items[45] = item2 == null ? ITEM_STACK_AIR : item2.clone();
        }
        NonNullList itemList = NonNullList.a();
        for (ItemStack itemStack : items) {
            itemList.add((Object)this.toNMSCopy(itemStack));
        }
        PacketPlayOutWindowItems packet1 = new PacketPlayOutWindowItems(0, 0, (List)itemList, this.toNMSCopy(ITEM_STACK_AIR));
        PacketPlayOutSetSlot packet2 = new PacketPlayOutSetSlot(-1, -1, 0, this.toNMSCopy(ITEM_STACK_AIR));
        PlayerConnection connection = ((CraftPlayer)player).getHandle().g;
        connection.b((Packet)packet1);
        connection.b((Packet)packet2);
    }

    public void sendFakeMainHandSlot(Player player, ItemStack item) {
        List<Pair> nmsEquipments = Collections.singletonList(new Pair((Object)EnumItemSlot.a, (Object)this.toNMSCopy(item)));
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(player.getEntityId(), nmsEquipments);
        ((CraftPlayer)player).getHandle().g.b((Packet)packet);
    }

    public void sendFakeMapUpdate(Player player, int mapId, List<MapCursor> mapCursors, byte[] colors) {
        List<MapIcon> mapIcons = this.toNMSMapIconList(mapCursors);
        WorldMap.c c2 = new WorldMap.c(0, 0, 128, 128, colors);
        PacketPlayOutMap packet = new PacketPlayOutMap(new MapId(mapId), 0, false, Optional.of(mapIcons), Optional.of(c2));
        ((CraftPlayer)player).getHandle().g.b((Packet)packet);
    }

    public InternalOfflinePlayerInfo loadOfflinePlayer(UUID uuid, Inventory inventory, Inventory enderchest) {
        try {
            int slot;
            this.nmsEntityPlayerLoadMethod.setAccessible(true);
            this.nmsEntityPlayerServerField.setAccessible(true);
            DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
            WorldServer worldServer = server.a(World.i);
            if (worldServer == null) {
                return null;
            }
            OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uuid);
            GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
            ClientInformation dummyInfo = new ClientInformation("en_us", 1, EnumChatVisibility.c, false, 0, EntityPlayer.bQ, true, false, ParticleStatus.c);
            EntityPlayer player = new EntityPlayer((MinecraftServer)server, worldServer, profile, dummyInfo);
            player.S().a();
            MinecraftServer minecraftServer = (MinecraftServer)this.nmsEntityPlayerServerField.get(player);
            ValueInput loadedData = minecraftServer.ag().t.a((EntityHuman)player, ProblemReporter.a).orElse(null);
            if (loadedData == null) {
                return null;
            }
            player.c(loadedData);
            this.nmsEntityPlayerLoadMethod.invoke((Object)player, loadedData);
            player.b(loadedData);
            CraftPlayer p = player.getBukkitEntity();
            PlayerInventory playerInventory = p.getInventory();
            int selectedSlot = playerInventory.getHeldItemSlot();
            boolean rightHanded = p.getMainHand().equals((Object)MainHand.RIGHT);
            int xpLevel = p.getLevel();
            for (slot = 0; slot < Math.min(playerInventory.getSize(), inventory.getSize()); ++slot) {
                inventory.setItem(slot, playerInventory.getItem(slot));
            }
            for (slot = 0; slot < Math.min(p.getEnderChest().getSize(), enderchest.getSize()); ++slot) {
                enderchest.setItem(slot, p.getEnderChest().getItem(slot));
            }
            return new InternalOfflinePlayerInfo(selectedSlot, rightHanded, xpLevel, inventory, enderchest);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Object deserializeChatComponent(String json) {
        return CraftChatMessage.fromJSON((String)json);
    }

    public String serializeChatComponent(Object handle) {
        return CraftChatMessage.toJSON((IChatBaseComponent)((IChatBaseComponent)handle));
    }
}

