/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;

public class AttributeBase {
    private final String descriptionId;
    private final boolean syncable;
    private final AttributeSentiment sentiment;
    private final boolean hidden;

    public AttributeBase(String descriptionId, boolean syncable, AttributeSentiment sentiment, boolean hidden) {
        this.syncable = syncable;
        this.descriptionId = descriptionId;
        this.sentiment = sentiment;
        this.hidden = hidden;
    }

    public AttributeBase(String descriptionId, boolean syncable, AttributeSentiment sentiment) {
        this(descriptionId, syncable, AttributeSentiment.POSITIVE, false);
    }

    public AttributeBase(String descriptionId, boolean syncable) {
        this(descriptionId, syncable, AttributeSentiment.POSITIVE);
    }

    public AttributeBase(String descriptionId) {
        this(descriptionId, true);
    }

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public boolean isClientSyncable() {
        return this.syncable;
    }

    public AttributeSentiment getSentiment() {
        return this.sentiment;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public TextColor getStyle(boolean isAmountPositive) {
        return this.sentiment.getStyle(isAmountPositive);
    }

    public static enum AttributeSentiment {
        POSITIVE,
        NEUTRAL,
        NEGATIVE;

        private static final AttributeSentiment[] VALUES;

        public static AttributeSentiment fromNMS(Enum<?> nmsSentiment) {
            return VALUES[nmsSentiment.ordinal()];
        }

        public TextColor getStyle(boolean isAmountPositive) {
            switch (this.ordinal()) {
                case 0: {
                    return isAmountPositive ? NamedTextColor.BLUE : NamedTextColor.RED;
                }
                case 1: {
                    return NamedTextColor.GRAY;
                }
                case 2: {
                    return isAmountPositive ? NamedTextColor.RED : NamedTextColor.BLUE;
                }
            }
            throw new IllegalArgumentException();
        }

        static {
            VALUES = AttributeSentiment.values();
        }
    }
}

