/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.inventory.EquipmentSlot;

public enum EquipmentSlotGroup {
    ANY("any", EquipmentSlot.values()),
    MAINHAND("mainhand", EquipmentSlot.HAND),
    OFFHAND("offhand", EquipmentSlot.OFF_HAND),
    ANY_HAND("hand", EquipmentSlot.HAND, EquipmentSlot.OFF_HAND),
    FEET("feet", EquipmentSlot.FEET),
    LEGS("legs", EquipmentSlot.LEGS),
    CHEST("chest", EquipmentSlot.CHEST),
    HEAD("head", EquipmentSlot.HEAD),
    ARMOR("armor", EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD),
    BODY("body", new EquipmentSlot[0]),
    SADDLE("saddle", new EquipmentSlot[0]);

    private final String name;
    private final List<EquipmentSlot> slots;

    private EquipmentSlotGroup(String name, List<EquipmentSlot> slots) {
        this.name = name;
        this.slots = Collections.unmodifiableList(slots);
    }

    private EquipmentSlotGroup(String name, EquipmentSlot slot) {
        this(name, Collections.singletonList(slot));
    }

    private EquipmentSlotGroup(String name, EquipmentSlot ... slots) {
        this(name, Arrays.asList(slots));
    }

    public static EquipmentSlotGroup forEquipmentSlot(EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return MAINHAND;
            }
            case OFF_HAND: {
                return OFFHAND;
            }
            case FEET: {
                return FEET;
            }
            case LEGS: {
                return LEGS;
            }
            case CHEST: {
                return CHEST;
            }
            case HEAD: {
                return HEAD;
            }
        }
        return null;
    }

    public static EquipmentSlotGroup fromName(String name) {
        for (EquipmentSlotGroup slotGroup : EquipmentSlotGroup.values()) {
            if (!slotGroup.name.equals(name)) continue;
            return slotGroup;
        }
        return null;
    }

    public String asString() {
        return this.name;
    }

    public boolean matches(EquipmentSlot slot) {
        return this.slots.contains(slot);
    }

    public List<EquipmentSlot> getEquipmentSlots() {
        return this.slots;
    }
}

