/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechatdiscordsrvaddon.grahpics.BaseImageUtils;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;

public interface TintColorProvider {
    public static final TintColorProvider EMPTY_INSTANCE = new TintColorProvider(){

        @Override
        public BufferedImage applyTint(BufferedImage image, int tintIndex) {
            return image;
        }

        @Override
        public int getTintColor(int tintIndex) {
            return -1;
        }

        @Override
        public boolean hasTintColor(int tintIndex) {
            return false;
        }
    };

    default public BufferedImage applyTint(BufferedImage image, int tintIndex) {
        if (this.hasTintColor(tintIndex)) {
            int color = this.getTintColor(tintIndex);
            BufferedImage tintImage = BaseImageUtils.changeColorTo(BaseImageUtils.copyImage(image), color);
            return BaseImageUtils.multiply(image, tintImage);
        }
        return image;
    }

    public int getTintColor(int var1);

    public boolean hasTintColor(int var1);

    public static class SpawnEggTintData
    implements TintColorProvider {
        private final int base;
        private final int overlay;

        public SpawnEggTintData(int base, int overlay) {
            this.base = base;
            this.overlay = overlay;
        }

        public int getBase() {
            return this.base;
        }

        public int getOverlay() {
            return this.overlay;
        }

        @Override
        public int getTintColor(int tintIndex) {
            return tintIndex == 0 ? this.base : this.overlay;
        }

        @Override
        public boolean hasTintColor(int tintIndex) {
            return true;
        }
    }

    public static class DyeTintProvider
    implements TintColorProvider {
        private final IntUnaryOperator colorSupplier;

        public DyeTintProvider(IntUnaryOperator colorSupplier) {
            this.colorSupplier = colorSupplier;
        }

        @Override
        public int getTintColor(int tintIndex) {
            if (tintIndex >= 0) {
                return this.colorSupplier.applyAsInt(tintIndex);
            }
            return -1;
        }

        @Override
        public boolean hasTintColor(int tintIndex) {
            return tintIndex >= 0;
        }
    }

    public static class TintIndexData
    implements TintColorProvider {
        private final List<IntSupplier> data;

        public TintIndexData(List<IntSupplier> data) {
            this.data = Collections.unmodifiableList(data);
        }

        public TintIndexData(IntSupplier ... data) {
            this(Arrays.asList(data));
        }

        @Override
        public int getTintColor(int tintIndex) {
            IntSupplier colorSupplier;
            if (tintIndex >= 0 && tintIndex < this.data.size() && (colorSupplier = this.data.get(tintIndex)) != null) {
                return colorSupplier.getAsInt();
            }
            return -1;
        }

        @Override
        public boolean hasTintColor(int tintIndex) {
            return tintIndex >= 0 && tintIndex < this.data.size() && this.data.get(tintIndex) != null;
        }
    }
}

