/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import java.util.Collections;
import java.util.List;

public class CustomModelData {
    private final List<Float> floats;
    private final List<Boolean> flags;
    private final List<String> strings;
    private final List<Integer> colors;

    public static boolean isEmpty(CustomModelData data) {
        return data == null || data.isEmpty();
    }

    public CustomModelData(List<Float> floats, List<Boolean> flags, List<String> strings, List<Integer> colors) {
        this.floats = floats;
        this.flags = flags;
        this.strings = strings;
        this.colors = colors;
    }

    public CustomModelData(Number legacyIndex) {
        this(Collections.singletonList(Float.valueOf(legacyIndex.floatValue())), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private static <T> T getValue(List<T> var0, int var1) {
        return var1 >= 0 && var1 < var0.size() ? (T)var0.get(var1) : null;
    }

    public Float getFloat(int index) {
        return CustomModelData.getValue(this.floats, index);
    }

    public Boolean getFlag(int index) {
        return CustomModelData.getValue(this.flags, index);
    }

    public String getString(int index) {
        return CustomModelData.getValue(this.strings, index);
    }

    public Integer getColor(int index) {
        return CustomModelData.getValue(this.colors, index);
    }

    public List<Float> getFloats() {
        return this.floats;
    }

    public List<Boolean> getFlags() {
        return this.flags;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public List<Integer> getColors() {
        return this.colors;
    }

    public boolean hasLegacyIndex() {
        return !this.floats.isEmpty() && this.floats.get(0) != null;
    }

    public float getLegacyIndex() {
        return this.floats.get(0).floatValue();
    }

    public boolean isEmpty() {
        return this.floats.isEmpty() && this.flags.isEmpty() && this.strings.isEmpty() && this.colors.isEmpty();
    }
}

