/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.grahpics;

import com.loohp.blockmodelrenderer.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class BaseImageUtils {
    public static BufferedImage copyImage(BufferedImage source) {
        BufferedImage b = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.dispose();
        return b;
    }

    public static BufferedImage multiply(BufferedImage image, BufferedImage imageOnTop) {
        return BaseImageUtils.multiply(image, imageOnTop, false);
    }

    public static BufferedImage multiply(BufferedImage image, BufferedImage imageOnTop, boolean ignoreTransparent) {
        for (int y = 0; y < image.getHeight() && y < imageOnTop.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth() && x < imageOnTop.getWidth(); ++x) {
                int value = image.getRGB(x, y);
                int multiplyValue = imageOnTop.getRGB(x, y);
                if (ignoreTransparent && ColorUtils.getAlpha((int)multiplyValue) <= 0) continue;
                int red = (int)Math.round((double)ColorUtils.getRed((int)value) / 255.0 * (double)ColorUtils.getRed((int)multiplyValue));
                int green = (int)Math.round((double)ColorUtils.getGreen((int)value) / 255.0 * (double)ColorUtils.getGreen((int)multiplyValue));
                int blue = (int)Math.round((double)ColorUtils.getBlue((int)value) / 255.0 * (double)ColorUtils.getBlue((int)multiplyValue));
                int color = ColorUtils.getIntFromColor((int)red, (int)green, (int)blue, (int)ColorUtils.getAlpha((int)value));
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    public static BufferedImage changeColorTo(BufferedImage image, Color color) {
        return BaseImageUtils.changeColorTo(image, color.getRGB());
    }

    public static BufferedImage changeColorTo(BufferedImage image, int color) {
        color &= 0xFFFFFF;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int colorValue = image.getRGB(x, y);
                int newColor = color | colorValue & 0xFF000000;
                image.setRGB(x, y, newColor);
            }
        }
        return image;
    }
}

