/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import net.md_5.bungee.api.ChatColor;

public enum AdvancementType {
    TASK(ChatColor.GREEN, "chat.type.advancement.task"),
    CHALLENGE(ChatColor.DARK_PURPLE, "chat.type.advancement.challenge"),
    GOAL(ChatColor.GREEN, "chat.type.advancement.goal"),
    LEGACY(ChatColor.GREEN, "chat.type.achievement", true);

    private static final AdvancementType[] VALUES;
    private final ChatColor color;
    private final String translationKey;
    private final boolean isLegacy;

    public static AdvancementType fromName(String name) {
        for (AdvancementType type : VALUES) {
            if (!type.toString().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    private AdvancementType(ChatColor color, String translationKey, boolean isLegacy) {
        this.color = color;
        this.translationKey = translationKey;
        this.isLegacy = isLegacy;
    }

    private AdvancementType(ChatColor color, String translationKey) {
        this(color, translationKey, false);
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    static {
        VALUES = AdvancementType.values();
    }
}

