/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import com.loohp.interactivechat.libs.net.kyori.adventure.key.Key;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import java.util.Optional;

public class PaintingVariant {
    private final Key key;
    private final int offsetX;
    private final int offsetY;
    private final int blockWidth;
    private final int blockHeight;
    private final Optional<Component> title;
    private final Optional<Component> author;

    private static Optional<Component> getLegacyPaintingTitle(Key key) {
        return Optional.of(Component.translatable((String)("painting." + key.namespace() + "." + key.value() + ".title")).color((TextColor)NamedTextColor.YELLOW));
    }

    private static Optional<Component> getLegacyPaintingAuthor(Key key) {
        return Optional.of(Component.translatable((String)("painting." + key.namespace() + "." + key.value() + ".author")).color((TextColor)NamedTextColor.GRAY));
    }

    public PaintingVariant(Key key, int offsetX, int offsetY, int blockWidth, int blockHeight, Optional<Component> title, Optional<Component> author) {
        this.key = key;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blockWidth = blockWidth;
        this.blockHeight = blockHeight;
        this.title = title;
        this.author = author;
    }

    public PaintingVariant(Key key, int blockWidth, int blockHeight, Optional<Component> title, Optional<Component> author) {
        this(key, 0, 0, blockWidth, blockHeight, title, author);
    }

    public PaintingVariant(Key key, int offsetX, int offsetY, int blockWidth, int blockHeight) {
        this(key, offsetX, offsetY, blockWidth, blockHeight, PaintingVariant.getLegacyPaintingTitle(key), PaintingVariant.getLegacyPaintingAuthor(key));
    }

    public PaintingVariant(Key key, int blockWidth, int blockHeight) {
        this(key, blockWidth, blockHeight, PaintingVariant.getLegacyPaintingTitle(key), PaintingVariant.getLegacyPaintingAuthor(key));
    }

    public Key getKey() {
        return this.key;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getPixelWidth() {
        return this.blockWidth * 16;
    }

    public int getPixelHeight() {
        return this.blockHeight * 16;
    }

    public int getBlockWidth() {
        return this.blockWidth;
    }

    public int getBlockHeight() {
        return this.blockHeight;
    }

    public Optional<Component> getTitle() {
        return this.title;
    }

    public Optional<Component> getAuthor() {
        return this.author;
    }
}

