/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.objectholders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum MoonPhase {
    FULL_MOON(0, "full_moon"),
    WANING_GIBBOUS(1, "waning_gibbous"),
    THIRD_QUARTER(2, "third_quarter"),
    WANING_CRESCENT(3, "waning_crescent"),
    NEW_MOON(4, "new_moon"),
    WAXING_CRESCENT(5, "waxing_crescent"),
    FIRST_QUARTER(6, "first_quarter"),
    WAXING_GIBBOUS(7, "waxing_gibbous");

    public static final List<MoonPhase> MOON_PHASES;
    public static final int TOTAL_TIME_IN_DAY = 24000;
    private final int index;
    private final String name;

    public static MoonPhase fromIndex(int index) {
        return MOON_PHASES.get(index % MOON_PHASES.size());
    }

    private MoonPhase(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public int startTick() {
        return this.index * 24000;
    }

    static {
        MOON_PHASES = Collections.unmodifiableList(Arrays.asList(MoonPhase.values()));
    }
}

