/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game;

import com.loohp.lotterysix.config.Config;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGameIndex;
import com.loohp.lotterysix.game.lottery.GameNumber;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.lottery.LazyCompletedLotterySixGameList;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.BetResultConsumer;
import com.loohp.lotterysix.game.objects.BossBarInfo;
import com.loohp.lotterysix.game.objects.CarryOverMode;
import com.loohp.lotterysix.game.objects.LotterySixAction;
import com.loohp.lotterysix.game.objects.MessageConsumer;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PrizeCalculationMode;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.game.objects.WinningNumbers;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersType;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.game.player.LotteryPlayerManager;
import com.loohp.lotterysix.gui.GUIInfo;
import com.loohp.lotterysix.gui.GUIType;
import com.loohp.lotterysix.libs.com.cronutils.model.Cron;
import com.loohp.lotterysix.libs.com.google.gson.Gson;
import com.loohp.lotterysix.libs.com.google.gson.GsonBuilder;
import com.loohp.lotterysix.libs.com.google.gson.JsonArray;
import com.loohp.lotterysix.libs.com.google.gson.JsonElement;
import com.loohp.lotterysix.utils.ChatColorUtils;
import com.loohp.lotterysix.utils.CronUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.Year;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class LotterySix
implements AutoCloseable {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final TimerTask lotteryTask;
    private volatile TimerTask announcementTask;
    private final File dataFolder;
    private final String configId;
    public String messageReloaded;
    public String messageNoPermission;
    public String messageNoConsole;
    public String messageInvalidUsage;
    public String messageNotEnoughMoney;
    public String messageBetPlaced;
    public String messageNoGameRunning;
    public String messageGameAlreadyRunning;
    public String messageGameLocked;
    public String messagePreferenceUpdated;
    public String messageGameStarted;
    public String messageGameSettingsUpdated;
    public String messageBetLimitReachedSelf;
    public String messageBetLimitReachedPermission;
    public String messagePlayerNotFound;
    public String messageNotifyBalanceChange;
    public String messagePendingClaimed;
    public String messageGameNumberNotFound;
    public String messageBettingAccountSuspended;
    public String messageBetLimitMaximumChancePerSelection;
    public String messageWithdrawSuccess;
    public String messageDepositSuccess;
    public String messageWithdrawFailed;
    public String messageInvalidNumber;
    public String messageInvalidBetNumbers;
    public String messagePlayerBalance;
    public String messageLotterySixNotOnCurrentBackend;
    public String explanationMessage;
    public String explanationURL;
    public String[] explanationGUIItem;
    public Locale locale;
    public SimpleDateFormat dateFormat;
    public String trueFormat;
    public String falseFormat;
    public Map<PrizeTier, String> tierNames;
    public String ticketDescription;
    public String ticketDescriptionMultipleDraw;
    public String winningsDescription;
    public String multipleWinningsDescription;
    public String bulkWinningsDescription;
    public String combinationWinningsDescription;
    public String randomEntryName;
    public Map<BetNumbersType, String> betNumbersTypeNames;
    public boolean updaterEnabled;
    public boolean backendBungeecordMode;
    public Cron runInterval;
    public TimeZone timezone;
    public long betsAcceptDuration;
    public long pricePerBet;
    public int numberOfChoices;
    public long lowestTopPlacesPrize;
    public long estimationRoundToNearest;
    public double taxPercentage;
    public PrizeCalculationMode prizeCalculationMode;
    public CarryOverMode carryOverMode;
    public long maxTopPlacesPrize;
    public boolean retainLowestPrizeForTier;
    public String guiMainMenuTitle;
    public String[] guiMainMenuCheckPastResults;
    public String[] guiMainMenuNoLotteryGamesScheduled;
    public String[] guiMainMenuCheckOwnBets;
    public String[] guiMainMenuPlaceNewBets;
    public String[] guiMainMenuStatistics;
    public String[] guiMainMenuBettingAccount;
    public String[] guiMainMenuAccountFundTransfer;
    public String guiLastResultsTitle;
    public String[] guiLastResultsLotteryInfo;
    public String[] guiLastResultsYourBets;
    public String guiLastResultsNoWinnings;
    public String[] guiLastResultsNothing;
    public String[] guiLastResultsListHistoricGames;
    public String guiLastResultsHistoricGameListTitle;
    public String[] guiLastResultsHistoricGameListInfo;
    public String[] guiLastResultsHistoricGameListSpecialName;
    public String[] guiLastResultsHistoricNewerGames;
    public String[] guiLastResultsHistoricOlderGames;
    public String[] guiLastResultsLookupHistoricGames;
    public String guiGameNumberInputTitle;
    public String guiYourBetsTitle;
    public String[] guiYourBetsNothing;
    public String guiSelectNewBetTypeTitle;
    public String[] guiSelectNewBetTypeSingle;
    public String[] guiSelectNewBetTypeMultiple;
    public String[] guiSelectNewBetTypeBanker;
    public String[] guiSelectNewBetTypeRandom;
    public String guiNewBetSingleTitle;
    public String guiNewBetMultipleTitle;
    public String guiNewBetBankerTitle;
    public String guiNewBetSelectAll;
    public String[] guiNewBetAddRandom;
    public String[] guiNewBetNotYetFinish;
    public String[] guiNewBetFinishSimple;
    public String[] guiNewBetFinishComplex;
    public String[] guiNewBetFinishBankers;
    public String guiRandomEntrySingleTitle;
    public String guiRandomEntryMultipleTitle;
    public String guiRandomEntryBankerTitle;
    public String[] guiRandomEntryBetCountValueSimple;
    public String[] guiRandomEntryBetCountValueComplex;
    public String[] guiRandomEntryIncrementButton;
    public String[] guiRandomEntryDecrementButton;
    public String[] guiRandomEntrySingleTab;
    public String[] guiRandomEntryMultipleTab;
    public String[] guiRandomEntryMultipleSizeValue;
    public String[] guiRandomEntryBankerTab;
    public String[] guiRandomEntryBankerBankersValue;
    public String[] guiRandomEntryBankerSelectionsValue;
    public String guiConfirmNewBetSingleTitle;
    public String guiConfirmNewBetComplexTitle;
    public String guiConfirmNewBetBulkSingleTitle;
    public String guiConfirmNewBetBulkComplexTitle;
    public String[] guiConfirmNewBetLotteryInfo;
    public String[] guiConfirmNewBetBulkRandom;
    public String[] guiConfirmNewBetMultipleDrawValue;
    public String[] guiConfirmNewBetIncrementButton;
    public String[] guiConfirmNewBetDecrementButton;
    public String[] guiConfirmNewBetUnitInvestmentConfirm;
    public String[] guiConfirmNewBetPartialInvestmentConfirm;
    public String[] guiConfirmNewBetCancel;
    public String guiNumberStatisticsTitle;
    public String guiNumberStatisticsLastDrawn;
    public String guiNumberStatisticsTimesDrawn;
    public String guiNumberStatisticsNever;
    public String[] guiNumberStatisticsNote;
    public String guiBettingAccountTitle;
    public String[] guiBettingAccountProfile;
    public String[] guiBettingAccountFlipLeftRightClick;
    public String[] guiBettingAccountToggleHideTitles;
    public String[] guiBettingAccountToggleHidePeriodicAnnouncements;
    public String[] guiBettingAccountToggleReopenMenu;
    public String[] guiBettingAccountSetBetLimitPerRound;
    public String guiBettingAccountSetBetLimitPerRoundTitle;
    public String[] guiBettingAccountSuspendAccountForAWeek;
    public String guiAccountFundTransferTitleNoMoney;
    public String guiAccountFundTransferTitle;
    public String[] guiAccountFundTransferCurrentBalance;
    public String[] guiAccountFundTransferDeposit;
    public String[] guiAccountFundTransferDepositRestricted;
    public String[] guiAccountFundTransferWithdraw;
    public String[] guiAccountFundTransferWithdrawAll;
    public String guiAccountFundTransferWithdrawInputTitle;
    public String guiAccountFundTransferDepositInputTitle;
    public String guiAccountFundTransferPlacingBetTitle;
    public String[] guiAccountFundTransferPlacingBetConfirm;
    public String[] guiAccountFundTransferPlacingBetCancel;
    public String announcerPeriodicMessageMessage;
    public String announcerPeriodicMessageHover;
    public int announcerPeriodicMessageFrequency;
    public boolean announcerPeriodicMessageOneMinuteBefore;
    public String announcerDrawCancelledMessage;
    public boolean announcerBetPlacedAnnouncementEnabled;
    public String announcerBetPlacedAnnouncementMessage;
    public boolean announcerPreDrawBossBarEnabled;
    public long announcerPreDrawBossBarTimeBeforeDraw;
    public String announcerPreDrawBossBarMessage;
    public String announcerPreDrawBossBarColor;
    public String announcerPreDrawBossBarStyle;
    public boolean announcerDrawBossBarEnabled;
    public List<String> announcerDrawBossBarMessages;
    public String announcerDrawBossBarColor;
    public String announcerDrawBossBarStyle;
    public boolean liveDrawAnnouncerEnabled;
    public boolean liveDrawAnnouncerSendMessagesTitle;
    public int liveDrawAnnouncerTimeBetween;
    public List<String> liveDrawAnnouncerPreMessage;
    public List<String> liveDrawAnnouncerPreMessageHover;
    public List<String> liveDrawAnnouncerMessages;
    public List<String> liveDrawAnnouncerPostMessages;
    public List<String> liveDrawAnnouncerPostMessagesHover;
    public String discordSRVDrawResultAnnouncementChannel;
    public String discordSRVDrawResultAnnouncementTitle;
    public String discordSRVDrawResultAnnouncementDescription;
    public String discordSRVDrawResultAnnouncementThumbnailURL;
    public boolean discordSRVSlashCommandsEnableLotteryCommand;
    public String discordSRVSlashCommandsGlobalTitle;
    public String discordSRVSlashCommandsGlobalSubTitleActiveGame;
    public String discordSRVSlashCommandsGlobalSubTitleNoGame;
    public String discordSRVSlashCommandsGlobalDescription;
    public String discordSRVSlashCommandsGlobalThumbnailURL;
    public String discordSRVSlashCommandsGlobalMessagesNotLinked;
    public String discordSRVSlashCommandsGlobalMessagesNoOneOnline;
    public String discordSRVSlashCommandsGlobalMessagesTimeOut;
    public String discordSRVSlashCommandsGlobalMessagesUnknownError;
    public String discordSRVSlashCommandsGlobalComponentsBack;
    public String discordSRVSlashCommandsBetAccountTitle;
    public String[] discordSRVSlashCommandsBetAccountSubTitle;
    public String discordSRVSlashCommandsBetAccountThumbnailURL;
    public String discordSRVSlashCommandsPlaceBetNoGame;
    public String discordSRVSlashCommandsPlaceBetTitle;
    public String[] discordSRVSlashCommandsPlaceBetSubTitle;
    public String discordSRVSlashCommandsComponentsSingleTitle;
    public String discordSRVSlashCommandsComponentsMultipleTitle;
    public String discordSRVSlashCommandsComponentsBankerTitle;
    public String discordSRVSlashCommandsComponentsRandomTitle;
    public String discordSRVSlashCommandsComponentsNotYetFinish;
    public String discordSRVSlashCommandsComponentsAddRandom;
    public String discordSRVSlashCommandsComponentsFinish;
    public String discordSRVSlashCommandsComponentsFinishBankers;
    public String discordSRVSlashCommandsComponentsMultipleRandomSize;
    public String discordSRVSlashCommandsComponentsBankerRandomBankerSize;
    public String discordSRVSlashCommandsComponentsBankerRandomSelectionSize;
    public String discordSRVSlashCommandsComponentsMultipleDrawSelection;
    public String discordSRVSlashCommandsPlaceBetThumbnailURL;
    public String discordSRVSlashCommandsViewPastDrawTitle;
    public String discordSRVSlashCommandsViewPastDrawNoResults;
    public String discordSRVSlashCommandsViewPastDrawYourBets;
    public String discordSRVSlashCommandsViewPastDrawNoWinnings;
    public String discordSRVSlashCommandsViewPastDrawThumbnailURL;
    public String discordSRVSlashCommandsViewCurrentBetsTitle;
    public List<String> discordSRVSlashCommandsViewCurrentBetsSubTitle;
    public String discordSRVSlashCommandsViewCurrentBetsNoBets;
    public String discordSRVSlashCommandsViewCurrentBetsNoGame;
    public String discordSRVSlashCommandsViewCurrentBetsThumbnailURL;
    public String discordSRVSlashCommandsViewNumberStatisticsTitle;
    public String discordSRVSlashCommandsViewNumberStatisticsThumbnailURL;
    public boolean placeholderAPIHideResultsWhileGameIsLocked;
    public boolean allowLoans;
    public Map<String, Long> playerBetLimit;
    public UUID lotteriesFundAccount;
    public long maximumChancePerSelection;
    public boolean hideManuelAccountFundTransferDeposit;
    public String numberItemsType;
    public boolean numberItemsSetStackSize;
    public int numberItemsCustomModelData;
    public boolean borderPaneItemsHideAll;
    public int guiCustomModelData;
    public Map<GUIType, GUIInfo> guiInfo;
    private final ExecutorService saveDataService;
    private final AtomicLong lastSaveBegin;
    private final Queue<Future<?>> saveTasks;
    private final LotteryPlayerManager lotteryPlayerManager;
    private volatile PlayableLotterySixGame currentGame;
    private volatile boolean gameLocked;
    private volatile WinningNumbers nextWinningNumbers;
    private final LazyCompletedLotterySixGameList completedGames;
    private final AtomicInteger requestSave;
    private final BiPredicate<UUID, Long> takeMoneyConsumer;
    private final BiPredicate<UUID, Long> giveMoneyConsumer;
    private final Consumer<UUID> notifyBalanceChangeConsumer;
    private final BiPredicate<UUID, String> hasPermissionPredicate;
    private final Consumer<Boolean> lockRunnable;
    private final Supplier<Collection<UUID>> onlinePlayersSupplier;
    private final MessageConsumer messageSendingConsumer;
    private final MessageConsumer titleSendingConsumer;
    private final BetResultConsumer playerBetListener;
    private final Consumer<Collection<PlayerBets>> playerBetsInvalidateListener;
    private final Consumer<LotterySixAction> actionListener;
    private final Consumer<LotteryPlayer> lotteryPlayerUpdateListener;
    private final Consumer<String> consoleMessageConsumer;
    private final BiConsumer<BossBarInfo, ILotterySixGame> bossBarUpdater;

    public static CompletedLotterySixGame loadFromDirectory(File folder, CompletedLotterySixGameIndex index) {
        File file = new File(folder, index.getDataFileName("json"));
        if (file.exists()) {
            CompletedLotterySixGame completedLotterySixGame;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            try {
                completedLotterySixGame = GSON.fromJson((Reader)reader, CompletedLotterySixGame.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Do not remove LotterySix game data from the file system while the server is running, please restart the server now", e);
                }
            }
            reader.close();
            return completedLotterySixGame;
        }
        File compressedFile = new File(folder, index.getDataFileName("json.gz"));
        if (compressedFile.exists()) {
            CompletedLotterySixGame completedLotterySixGame;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(compressedFile.toPath(), new OpenOption[0])), StandardCharsets.UTF_8));
            try {
                completedLotterySixGame = GSON.fromJson((Reader)reader, CompletedLotterySixGame.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Do not remove LotterySix game data from the file system while the server is running, please restart the server now", e);
                }
            }
            reader.close();
            return completedLotterySixGame;
        }
        throw new IllegalStateException("Do not remove LotterySix game data from the file system while the server is running, please restart the server now");
    }

    public LotterySix(boolean isBackend, File dataFolder, String configId, BiPredicate<UUID, Long> takeMoneyConsumer, BiPredicate<UUID, Long> giveMoneyConsumer, Consumer<UUID> notifyBalanceChangeConsumer, BiPredicate<UUID, String> hasPermissionPredicate, Consumer<Boolean> lockRunnable, final Supplier<Collection<UUID>> onlinePlayersSupplier, final MessageConsumer messageSendingConsumer, MessageConsumer titleSendingConsumer, BetResultConsumer playerBetListener, Consumer<Collection<PlayerBets>> playerBetsInvalidateListener, Consumer<LotterySixAction> actionListener, Consumer<LotteryPlayer> lotteryPlayerUpdateListener, final Consumer<String> consoleMessageConsumer, final BiConsumer<BossBarInfo, ILotterySixGame> bossBarUpdater) {
        this.dataFolder = dataFolder;
        this.configId = configId;
        this.takeMoneyConsumer = takeMoneyConsumer;
        this.giveMoneyConsumer = giveMoneyConsumer;
        this.notifyBalanceChangeConsumer = notifyBalanceChangeConsumer;
        this.hasPermissionPredicate = hasPermissionPredicate;
        this.lockRunnable = lockRunnable;
        this.onlinePlayersSupplier = onlinePlayersSupplier;
        this.messageSendingConsumer = messageSendingConsumer;
        this.titleSendingConsumer = titleSendingConsumer;
        this.playerBetListener = playerBetListener;
        this.playerBetsInvalidateListener = playerBetsInvalidateListener;
        this.actionListener = actionListener;
        this.lotteryPlayerUpdateListener = lotteryPlayerUpdateListener;
        this.consoleMessageConsumer = consoleMessageConsumer;
        this.bossBarUpdater = bossBarUpdater;
        this.requestSave = new AtomicInteger(0);
        this.saveDataService = Executors.newSingleThreadExecutor();
        this.lastSaveBegin = new AtomicLong(Long.MIN_VALUE);
        this.saveTasks = new ConcurrentLinkedQueue();
        File lotteryDataFolder = new File(this.getDataFolder(), "data");
        lotteryDataFolder.mkdirs();
        this.completedGames = new LazyCompletedLotterySixGameList(gameIndex -> LotterySix.loadFromDirectory(lotteryDataFolder, gameIndex));
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.reloadConfig();
        this.loadData();
        this.backendBungeecordMode = isBackend && Config.getConfig(configId).getConfiguration().getBoolean("Bungeecord");
        this.lotteryPlayerManager = new LotteryPlayerManager(this);
        this.lotteryTask = new TimerTask(){
            private int counter = 0;
            private int saveInterval = 0;
            private boolean oneMinuteAnnounced = false;

            @Override
            public void run() {
                try {
                    long elapsed;
                    int requestState;
                    long now;
                    block20: {
                        block21: {
                            if (!LotterySix.this.announcerPreDrawBossBarEnabled && !LotterySix.this.announcerDrawBossBarEnabled) {
                                bossBarUpdater.accept(BossBarInfo.CLEAR, null);
                            }
                            now = System.currentTimeMillis();
                            if (LotterySix.this.backendBungeecordMode) break block20;
                            if (LotterySix.this.currentGame != null) break block21;
                            if (LotterySix.this.gameLocked) break block20;
                            if (LotterySix.this.announcerPreDrawBossBarEnabled || LotterySix.this.announcerDrawBossBarEnabled) {
                                bossBarUpdater.accept(BossBarInfo.CLEAR, null);
                            }
                            if (LotterySix.this.runInterval == null || !CronUtils.satisfyByCurrentMinute(LotterySix.this.runInterval, LotterySix.this.timezone)) break block20;
                            LotterySix.this.startNewGame();
                            this.counter = 0;
                            break block20;
                        }
                        long timeLeft = LotterySix.this.currentGame.getDatetime() - now;
                        if (LotterySix.this.announcerPreDrawBossBarEnabled && !LotterySix.this.gameLocked) {
                            if (timeLeft > 0L && timeLeft < LotterySix.this.announcerPreDrawBossBarTimeBeforeDraw) {
                                double progress = Math.max(0.0, Math.min(1.0, (double)timeLeft / (double)LotterySix.this.announcerPreDrawBossBarTimeBeforeDraw));
                                BossBarInfo info = new BossBarInfo(LotterySix.this.announcerPreDrawBossBarMessage, LotterySix.this.announcerPreDrawBossBarColor, LotterySix.this.announcerPreDrawBossBarStyle, progress);
                                bossBarUpdater.accept(info, LotterySix.this.currentGame);
                            } else {
                                bossBarUpdater.accept(BossBarInfo.CLEAR, null);
                            }
                        }
                        boolean announce = false;
                        if (timeLeft <= 0L) {
                            LotterySix.this.runCurrentGame();
                        } else if (this.counter % LotterySix.this.announcerPeriodicMessageFrequency == 0) {
                            announce = true;
                        } else if (LotterySix.this.currentGame.getDatetime() / 1000L - now / 1000L <= 60L) {
                            if (!this.oneMinuteAnnounced) {
                                this.oneMinuteAnnounced = true;
                                announce = true;
                            }
                        } else if (this.oneMinuteAnnounced) {
                            this.oneMinuteAnnounced = false;
                        }
                        if (announce) {
                            for (UUID uuid : (Collection)onlinePlayersSupplier.get()) {
                                if (LotterySix.this.lotteryPlayerManager.getLotteryPlayer(uuid).getPreference(PlayerPreferenceKey.HIDE_PERIODIC_ANNOUNCEMENTS, Boolean.TYPE).booleanValue()) continue;
                                messageSendingConsumer.accept(uuid, LotterySix.this.announcerPeriodicMessageMessage, LotterySix.this.announcerPeriodicMessageHover, LotterySix.this.currentGame);
                            }
                        }
                    }
                    if ((requestState = LotterySix.this.requestSave.getAndSet(0)) > 0 || this.saveInterval % 30 == 0) {
                        LotterySix.this.saveData(requestState < 2);
                    }
                    LotterySix.this.saveTasks.removeIf(t -> t.isDone());
                    long lastSaveBeginTime = LotterySix.this.lastSaveBegin.get();
                    if (lastSaveBeginTime > Long.MIN_VALUE && (elapsed = now - lastSaveBeginTime) > 5000L) {
                        Future task;
                        consoleMessageConsumer.accept("Save task is taking more that " + elapsed + " ms!");
                        if (elapsed > 10000L && (task = (Future)LotterySix.this.saveTasks.poll()) != null && !task.isDone()) {
                            task.cancel(true);
                        }
                    }
                    ++this.saveInterval;
                    ++this.counter;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        new Timer().scheduleAtFixedRate(this.lotteryTask, 5000L, 1000L);
    }

    @Override
    public void close() {
        this.lotteryTask.cancel();
        if (this.announcementTask != null) {
            this.announcementTask.cancel();
        }
        this.saveDataService.shutdown();
        try {
            if (!this.saveDataService.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                this.saveDataService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.saveDataNow(false);
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public String getConfigId() {
        return this.configId;
    }

    public LotteryPlayerManager getLotteryPlayerManager() {
        return this.lotteryPlayerManager;
    }

    public ILotterySixGame getGame(UUID uuid) {
        if (this.currentGame != null && this.currentGame.getGameId().equals(uuid)) {
            return this.currentGame;
        }
        for (CompletedLotterySixGame completedLotterySixGame : this.completedGames) {
            if (!completedLotterySixGame.getGameId().equals(uuid)) continue;
            return completedLotterySixGame;
        }
        return null;
    }

    public PlayableLotterySixGame getCurrentGame() {
        return this.currentGame;
    }

    public GameNumber dateToGameNumber(long time) {
        Year year = Year.from(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), this.timezone.toZoneId()));
        if (this.completedGames.isEmpty()) {
            return new GameNumber(year, 1);
        }
        CompletedLotterySixGameIndex gameIndex = this.completedGames.getIndex(0);
        if (gameIndex.getGameNumber() == null || !gameIndex.getGameNumber().getYear().equals(year)) {
            return new GameNumber(year, 1);
        }
        return new GameNumber(year, gameIndex.getGameNumber().getNumber() + 1);
    }

    public PlayableLotterySixGame startNewGame() {
        ZonedDateTime dateTime;
        ZonedDateTime now = CronUtils.getNow(this.timezone);
        long endTime = now.withNano(0).toInstant().toEpochMilli() + this.betsAcceptDuration;
        if (this.runInterval != null && this.betsAcceptDuration < 0L && (dateTime = CronUtils.getNextExecution(this.runInterval, now)) != null) {
            endTime = dateTime.toInstant().toEpochMilli() + this.betsAcceptDuration;
        }
        return this.startNewGame(endTime);
    }

    public synchronized PlayableLotterySixGame startNewGame(long dateTime) {
        if (this.backendBungeecordMode) {
            throw new IllegalStateException("method cannot be ran on backend server while on bungeecord mode");
        }
        this.nextWinningNumbers = null;
        CompletedLotterySixGame lastGame = this.completedGames.getLatest();
        ArrayList<PlayerBets> placedBets = new ArrayList<PlayerBets>();
        for (UUID uuid : this.lotteryPlayerManager.getAllLotteryPlayerUUIDs()) {
            placedBets.addAll(this.lotteryPlayerManager.getLotteryPlayer(uuid).getMultipleDrawPlayerBets());
        }
        this.currentGame = PlayableLotterySixGame.createNewGame(this, Math.max(dateTime, System.currentTimeMillis()), null, lastGame == null ? Collections.emptyMap() : lastGame.getNumberStatistics(), lastGame == null ? 0L : lastGame.getRemainingFunds(), this.lowestTopPlacesPrize, placedBets);
        this.saveData(true);
        this.actionListener.accept(LotterySixAction.START);
        return this.currentGame;
    }

    protected synchronized CompletedLotterySixGame runCurrentGame() {
        CompletedLotterySixGame completed;
        if (this.backendBungeecordMode) {
            throw new IllegalStateException("method cannot be ran on backend server while on bungeecord mode");
        }
        if (!this.currentGame.hasBets()) {
            this.cancelCurrentGame();
            return null;
        }
        this.setGameLocked(true);
        this.actionListener.accept(LotterySixAction.RUN_LOTTERY_BEGIN);
        if (this.liveDrawAnnouncerEnabled) {
            for (UUID uuid : this.onlinePlayersSupplier.get()) {
                for (int i = 0; i < this.liveDrawAnnouncerPreMessage.size(); ++i) {
                    String hover = i < this.liveDrawAnnouncerPreMessageHover.size() ? this.liveDrawAnnouncerPreMessageHover.get(i) : "";
                    this.messageSendingConsumer.accept(uuid, this.liveDrawAnnouncerPreMessage.get(i), hover, this.currentGame);
                }
            }
        }
        this.consoleMessageConsumer.accept("Calculating Lottery Wins, this might take a while...");
        long start = System.currentTimeMillis();
        if (this.nextWinningNumbers == null) {
            completed = this.currentGame.runLottery(this.numberOfChoices, this.pricePerBet, this.maxTopPlacesPrize, this.taxPercentage);
        } else {
            completed = this.currentGame.runLottery(this.numberOfChoices, this.pricePerBet, this.maxTopPlacesPrize, this.taxPercentage, this.nextWinningNumbers);
            this.nextWinningNumbers = null;
        }
        long end = System.currentTimeMillis();
        this.consoleMessageConsumer.accept("Lottery Wins Calculation Completed! (" + (end - start) + "ms)");
        this.completedGames.add(0, completed);
        this.currentGame = null;
        this.saveData(false);
        this.actionListener.accept(LotterySixAction.RUN_LOTTERY_INTERNAL_DRAWN);
        if (this.liveDrawAnnouncerEnabled) {
            this.announcementTask = new TimerTask(){
                private int counter;
                private int index;
                {
                    this.counter = -LotterySix.this.liveDrawAnnouncerTimeBetween;
                    this.index = 0;
                }

                @Override
                public void run() {
                    try {
                        if (this.index >= LotterySix.this.liveDrawAnnouncerMessages.size()) {
                            for (UUID uuid : (Collection)LotterySix.this.onlinePlayersSupplier.get()) {
                                for (int i = 0; i < LotterySix.this.liveDrawAnnouncerPostMessages.size(); ++i) {
                                    String hover = i < LotterySix.this.liveDrawAnnouncerPostMessagesHover.size() ? LotterySix.this.liveDrawAnnouncerPostMessagesHover.get(i) : "";
                                    LotterySix.this.messageSendingConsumer.accept(uuid, LotterySix.this.liveDrawAnnouncerPostMessages.get(i), hover, completed);
                                }
                            }
                            if (LotterySix.this.announcerDrawBossBarEnabled) {
                                LotterySix.this.bossBarUpdater.accept(BossBarInfo.CLEAR, completed);
                            }
                            LotterySix.this.consoleMessageConsumer.accept("Distributing Lottery Win Prizes...");
                            long start1 = System.currentTimeMillis();
                            completed.givePrizesAndUpdateStats(LotterySix.this, () -> {
                                long end1 = System.currentTimeMillis();
                                LotterySix.this.consoleMessageConsumer.accept("Lottery Win Prizes Distribution Completed! (" + (end1 - start1) + "ms)");
                                LotterySix.this.setGameLocked(false);
                                LotterySix.this.actionListener.accept(LotterySixAction.RUN_LOTTERY_FINISH);
                            });
                            LotterySix.this.announcementTask = null;
                            this.cancel();
                            return;
                        }
                        if (this.counter >= 0 && this.counter % LotterySix.this.liveDrawAnnouncerTimeBetween == 0) {
                            String message = LotterySix.this.liveDrawAnnouncerMessages.get(this.index);
                            for (UUID uuid : (Collection)LotterySix.this.onlinePlayersSupplier.get()) {
                                LotterySix.this.messageSendingConsumer.accept(uuid, message, completed);
                                if (!LotterySix.this.liveDrawAnnouncerSendMessagesTitle || LotterySix.this.lotteryPlayerManager.getLotteryPlayer(uuid).getPreference(PlayerPreferenceKey.HIDE_TITLES, Boolean.TYPE).booleanValue()) continue;
                                LotterySix.this.titleSendingConsumer.accept(uuid, message, completed);
                            }
                            if (LotterySix.this.announcerDrawBossBarEnabled) {
                                String title = LotterySix.this.announcerDrawBossBarMessages.isEmpty() ? "" : (this.index >= LotterySix.this.announcerDrawBossBarMessages.size() ? LotterySix.this.announcerDrawBossBarMessages.get(LotterySix.this.announcerDrawBossBarMessages.size() - 1) : LotterySix.this.announcerDrawBossBarMessages.get(this.index));
                                LotterySix.this.bossBarUpdater.accept(new BossBarInfo(title, LotterySix.this.announcerDrawBossBarColor, LotterySix.this.announcerDrawBossBarStyle, 1.0), completed);
                            }
                            ++this.index;
                        }
                        ++this.counter;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            };
            new Timer().scheduleAtFixedRate(this.announcementTask, 0L, 1000L);
        } else {
            this.consoleMessageConsumer.accept("Distributing Lottery Win Prizes...");
            long start1 = System.currentTimeMillis();
            completed.givePrizesAndUpdateStats(this, () -> {
                long end1 = System.currentTimeMillis();
                this.consoleMessageConsumer.accept("Lottery Win Prizes Distribution Completed! (" + (end1 - start1) + "ms)");
                this.setGameLocked(false);
                this.actionListener.accept(LotterySixAction.RUN_LOTTERY_FINISH);
            });
        }
        return completed;
    }

    public synchronized PlayableLotterySixGame cancelCurrentGame() {
        if (this.backendBungeecordMode) {
            throw new IllegalStateException("method cannot be ran on backend server while on bungeecord mode");
        }
        for (UUID uuid : this.onlinePlayersSupplier.get()) {
            this.messageSendingConsumer.accept(uuid, this.announcerDrawCancelledMessage, this.currentGame);
        }
        this.currentGame.cancelGame();
        PlayableLotterySixGame game = this.currentGame;
        this.currentGame = null;
        this.saveData(true);
        this.actionListener.accept(LotterySixAction.CANCEL);
        return game;
    }

    @Deprecated
    public void setCurrentGame(PlayableLotterySixGame currentGame) {
        this.currentGame = currentGame;
    }

    @Deprecated
    public void setLastGame(CompletedLotterySixGame game) {
        for (CompletedLotterySixGameIndex gameIndex : this.completedGames.indexIterable()) {
            if (gameIndex.getDatetime() <= game.getDatetime()) break;
            this.completedGames.remove(gameIndex);
        }
        this.completedGames.add(0, game);
    }

    public void setNextWinningNumbers(WinningNumbers nextWinningNumbers) {
        this.nextWinningNumbers = nextWinningNumbers;
    }

    public LazyCompletedLotterySixGameList getCompletedGames() {
        return this.completedGames;
    }

    public boolean takeMoney(UUID player, long amount) {
        return this.takeMoneyConsumer.test(player, amount);
    }

    public boolean giveMoney(UUID player, long amount) {
        return this.giveMoneyConsumer.test(player, amount);
    }

    public void notifyBalanceChangeConsumer(UUID player) {
        this.notifyBalanceChangeConsumer.accept(player);
    }

    public boolean isGameLocked() {
        return this.gameLocked;
    }

    public void setGameLocked(boolean gameLocked) {
        this.gameLocked = gameLocked;
        this.lockRunnable.accept(gameLocked);
    }

    public Supplier<Collection<UUID>> getOnlinePlayersSupplier() {
        return this.onlinePlayersSupplier;
    }

    public MessageConsumer getMessageSendingConsumer() {
        return this.messageSendingConsumer;
    }

    public MessageConsumer getTitleSendingConsumer() {
        return this.titleSendingConsumer;
    }

    public Consumer<String> getConsoleMessageConsumer() {
        return this.consoleMessageConsumer;
    }

    public BetResultConsumer getPlayerBetListener() {
        return this.playerBetListener;
    }

    public Consumer<Collection<PlayerBets>> getPlayerBetsInvalidateListener() {
        return this.playerBetsInvalidateListener;
    }

    public Consumer<LotterySixAction> getActionListener() {
        return this.actionListener;
    }

    public Consumer<LotteryPlayer> getLotteryPlayerUpdateListener() {
        return this.lotteryPlayerUpdateListener;
    }

    public BiConsumer<BossBarInfo, ILotterySixGame> getBossBarUpdater() {
        return this.bossBarUpdater;
    }

    public long getPlayerBetLimit(UUID uuid) {
        if (this.hasPermissionPredicate.test(uuid, "lotterysix.betlimit.unlimited")) {
            return -1L;
        }
        long limit = Long.MIN_VALUE;
        for (Map.Entry<String, Long> entry : this.playerBetLimit.entrySet()) {
            if (!this.hasPermissionPredicate.test(uuid, "lotterysix.betlimit." + entry.getKey())) continue;
            long value = entry.getValue();
            if (value < 0L) {
                return -1L;
            }
            if (value <= limit) continue;
            limit = value;
        }
        if (limit == Long.MIN_VALUE) {
            return this.playerBetLimit.getOrDefault("default", -1L);
        }
        return limit;
    }

    /*
     * WARNING - void declaration
     */
    public void reloadConfig() {
        void var7_15;
        Config config = Config.getConfig(this.configId);
        config.reload();
        this.messageReloaded = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.Reloaded"));
        this.messageNoPermission = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.NoPermission"));
        this.messageNoConsole = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.NoConsole"));
        this.messageInvalidUsage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.InvalidUsage"));
        this.messageNotEnoughMoney = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.NotEnoughMoney"));
        this.messageBetPlaced = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.BetPlaced"));
        this.messageNoGameRunning = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.NoGameRunning"));
        this.messageGameAlreadyRunning = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.GameAlreadyRunning"));
        this.messageGameLocked = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.GameLocked"));
        this.messagePreferenceUpdated = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.PreferenceUpdated"));
        this.messageGameStarted = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.GameStarted"));
        this.messageGameSettingsUpdated = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.GameSettingsUpdated"));
        this.messageBetLimitReachedSelf = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.BetLimitReachedSelf"));
        this.messageBetLimitReachedPermission = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.BetLimitReachedPermission"));
        this.messagePlayerNotFound = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.PlayerNotFound"));
        this.messageNotifyBalanceChange = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.NotifyBalanceChange"));
        this.messagePendingClaimed = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.PendingClaimed"));
        this.messageGameNumberNotFound = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.GameNumberNotFound"));
        this.messageBettingAccountSuspended = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.BettingAccountSuspended"));
        this.messageBetLimitMaximumChancePerSelection = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.BetLimitMaximumChancePerSelection"));
        this.messageWithdrawSuccess = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.WithdrawSuccess"));
        this.messageDepositSuccess = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.DepositSuccess"));
        this.messageWithdrawFailed = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.WithdrawFailed"));
        this.messageInvalidNumber = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.InvalidNumber"));
        this.messageInvalidBetNumbers = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.InvalidBetNumbers"));
        this.messagePlayerBalance = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.PlayerBalance"));
        this.messageLotterySixNotOnCurrentBackend = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.LotterySixNotOnCurrentBackend"));
        this.explanationMessage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Explanation.Message"));
        this.explanationURL = config.getConfiguration().getString("Explanation.URL");
        this.explanationGUIItem = (String[])config.getConfiguration().getStringList("Explanation.GUIItem").stream().map(each -> ChatColorUtils.translateAlternateColorCodes('&', each)).toArray(String[]::new);
        String runInternalStr = config.getConfiguration().getString("LotterySix.RunInterval");
        this.runInterval = runInternalStr.equalsIgnoreCase("Never") ? null : CronUtils.PARSER.parse(runInternalStr);
        this.timezone = TimeZone.getTimeZone(config.getConfiguration().getString("LotterySix.TimeZone"));
        String[] localeStr = config.getConfiguration().getString("Formatting.Locale").split("_");
        this.locale = new Locale(localeStr[0], localeStr[1]);
        this.dateFormat = new SimpleDateFormat(ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.Date")), this.locale);
        this.dateFormat.setTimeZone(this.timezone);
        this.trueFormat = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.Booleans.T"));
        this.falseFormat = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.Booleans.F"));
        this.tierNames = new EnumMap<PrizeTier, String>(PrizeTier.class);
        for (PrizeTier prizeTier : PrizeTier.values()) {
            this.tierNames.put(prizeTier, ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.PrizeTiers." + prizeTier.name())));
        }
        this.ticketDescription = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.TicketDescription"));
        this.ticketDescriptionMultipleDraw = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.TicketDescriptionMultipleDraw"));
        this.winningsDescription = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.WinningsDescription"));
        this.multipleWinningsDescription = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.MultipleWinningsDescription"));
        this.bulkWinningsDescription = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.BulkWinningsDescription"));
        this.combinationWinningsDescription = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.CombinationWinningsDescription"));
        this.randomEntryName = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.RandomEntryGeneric"));
        this.betNumbersTypeNames = new EnumMap<BetNumbersType, String>(BetNumbersType.class);
        for (Enum enum_ : BetNumbersType.values()) {
            this.betNumbersTypeNames.put((BetNumbersType)enum_, ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Formatting.BetNumbersTypes." + enum_.name())));
        }
        this.updaterEnabled = config.getConfiguration().getBoolean("Options.Updater");
        this.betsAcceptDuration = config.getConfiguration().getLong("LotterySix.BetsAcceptDuration") * 1000L;
        if (this.runInterval == null) {
            this.betsAcceptDuration = Math.abs(this.betsAcceptDuration);
        }
        this.pricePerBet = config.getConfiguration().getLong("LotterySix.PricePerBet");
        if (this.pricePerBet % 2L != 0L) {
            ++this.pricePerBet;
        }
        this.numberOfChoices = Math.max(7, Math.min(49, config.getConfiguration().getInt("LotterySix.NumberOfChoices")));
        this.lowestTopPlacesPrize = config.getConfiguration().getLong("LotterySix.LowestTopPlacesPrize");
        this.estimationRoundToNearest = config.getConfiguration().getLong("LotterySix.EstimationRoundToNearest");
        this.taxPercentage = config.getConfiguration().getDouble("LotterySix.TaxPercentage");
        this.prizeCalculationMode = PrizeCalculationMode.fromName(config.getConfiguration().getString("LotterySix.PrizeCalculationMode").toUpperCase());
        this.carryOverMode = CarryOverMode.fromName(config.getConfiguration().getString("LotterySix.CarryOverMode").toUpperCase());
        this.maxTopPlacesPrize = config.getConfiguration().getLong("LotterySix.MaxTopPlacesPrize");
        this.retainLowestPrizeForTier = config.getConfiguration().getBoolean("LotterySix.RetainLowestPrizeForTier");
        this.guiMainMenuTitle = config.getConfiguration().getString("GUI.MainMenu.Title");
        this.guiMainMenuCheckPastResults = config.getConfiguration().getStringList("GUI.MainMenu.CheckPastResults").toArray(new String[0]);
        this.guiMainMenuNoLotteryGamesScheduled = config.getConfiguration().getStringList("GUI.MainMenu.NoLotteryGamesScheduled").toArray(new String[0]);
        this.guiMainMenuCheckOwnBets = config.getConfiguration().getStringList("GUI.MainMenu.CheckOwnBets").toArray(new String[0]);
        this.guiMainMenuPlaceNewBets = config.getConfiguration().getStringList("GUI.MainMenu.PlaceNewBets").toArray(new String[0]);
        this.guiMainMenuStatistics = config.getConfiguration().getStringList("GUI.MainMenu.Statistics").toArray(new String[0]);
        this.guiMainMenuBettingAccount = config.getConfiguration().getStringList("GUI.MainMenu.BettingAccount").toArray(new String[0]);
        this.guiMainMenuAccountFundTransfer = config.getConfiguration().getStringList("GUI.MainMenu.AccountFundTransfer").toArray(new String[0]);
        this.guiLastResultsTitle = config.getConfiguration().getString("GUI.LastResults.Title");
        this.guiLastResultsLotteryInfo = config.getConfiguration().getStringList("GUI.LastResults.LotteryInfo").toArray(new String[0]);
        this.guiLastResultsYourBets = config.getConfiguration().getStringList("GUI.LastResults.YourBets").toArray(new String[0]);
        this.guiLastResultsNoWinnings = config.getConfiguration().getString("GUI.LastResults.NoWinnings");
        this.guiLastResultsNothing = config.getConfiguration().getStringList("GUI.LastResults.Nothing").toArray(new String[0]);
        this.guiLastResultsListHistoricGames = config.getConfiguration().getStringList("GUI.LastResults.ListHistoricGames").toArray(new String[0]);
        this.guiLastResultsHistoricGameListTitle = config.getConfiguration().getString("GUI.LastResults.HistoricGameListTitle");
        this.guiLastResultsHistoricGameListInfo = config.getConfiguration().getStringList("GUI.LastResults.HistoricGameListInfo").toArray(new String[0]);
        this.guiLastResultsHistoricGameListSpecialName = config.getConfiguration().getStringList("GUI.LastResults.HistoricGameListSpecialName").toArray(new String[0]);
        this.guiLastResultsHistoricNewerGames = config.getConfiguration().getStringList("GUI.LastResults.HistoricNewerGames").toArray(new String[0]);
        this.guiLastResultsHistoricOlderGames = config.getConfiguration().getStringList("GUI.LastResults.HistoricOlderGames").toArray(new String[0]);
        this.guiLastResultsLookupHistoricGames = config.getConfiguration().getStringList("GUI.LastResults.LookupHistoricGames").toArray(new String[0]);
        this.guiGameNumberInputTitle = config.getConfiguration().getString("GUI.GameNumberInput.Title");
        this.guiYourBetsTitle = config.getConfiguration().getString("GUI.YourBets.Title");
        this.guiYourBetsNothing = config.getConfiguration().getStringList("GUI.YourBets.Nothing").toArray(new String[0]);
        this.guiSelectNewBetTypeTitle = config.getConfiguration().getString("GUI.SelectNewBetType.Title");
        this.guiSelectNewBetTypeSingle = config.getConfiguration().getStringList("GUI.SelectNewBetType.Single").toArray(new String[0]);
        this.guiSelectNewBetTypeMultiple = config.getConfiguration().getStringList("GUI.SelectNewBetType.Multiple").toArray(new String[0]);
        this.guiSelectNewBetTypeBanker = config.getConfiguration().getStringList("GUI.SelectNewBetType.Banker").toArray(new String[0]);
        this.guiSelectNewBetTypeRandom = config.getConfiguration().getStringList("GUI.SelectNewBetType.Random").toArray(new String[0]);
        this.guiNewBetSingleTitle = config.getConfiguration().getString("GUI.NewBet.SingleTitle");
        this.guiNewBetMultipleTitle = config.getConfiguration().getString("GUI.NewBet.MultipleTitle");
        this.guiNewBetBankerTitle = config.getConfiguration().getString("GUI.NewBet.BankerTitle");
        this.guiNewBetSelectAll = config.getConfiguration().getString("GUI.NewBet.SelectAll");
        this.guiNewBetAddRandom = config.getConfiguration().getStringList("GUI.NewBet.AddRandom").toArray(new String[0]);
        this.guiNewBetNotYetFinish = config.getConfiguration().getStringList("GUI.NewBet.NotYetFinish").toArray(new String[0]);
        this.guiNewBetFinishSimple = config.getConfiguration().getStringList("GUI.NewBet.FinishSimple").toArray(new String[0]);
        this.guiNewBetFinishComplex = config.getConfiguration().getStringList("GUI.NewBet.FinishComplex").toArray(new String[0]);
        this.guiNewBetFinishBankers = config.getConfiguration().getStringList("GUI.NewBet.FinishBankers").toArray(new String[0]);
        this.guiRandomEntrySingleTitle = config.getConfiguration().getString("GUI.RandomEntry.SingleTitle");
        this.guiRandomEntryMultipleTitle = config.getConfiguration().getString("GUI.RandomEntry.MultipleTitle");
        this.guiRandomEntryBankerTitle = config.getConfiguration().getString("GUI.RandomEntry.BankerTitle");
        this.guiRandomEntryBetCountValueSimple = config.getConfiguration().getStringList("GUI.RandomEntry.BetCountValueSimple").toArray(new String[0]);
        this.guiRandomEntryBetCountValueComplex = config.getConfiguration().getStringList("GUI.RandomEntry.BetCountValueComplex").toArray(new String[0]);
        this.guiRandomEntryIncrementButton = config.getConfiguration().getStringList("GUI.RandomEntry.IncrementButton").toArray(new String[0]);
        this.guiRandomEntryDecrementButton = config.getConfiguration().getStringList("GUI.RandomEntry.DecrementButton").toArray(new String[0]);
        this.guiRandomEntrySingleTab = config.getConfiguration().getStringList("GUI.RandomEntry.Single.Tab").toArray(new String[0]);
        this.guiRandomEntryMultipleTab = config.getConfiguration().getStringList("GUI.RandomEntry.Multiple.Tab").toArray(new String[0]);
        this.guiRandomEntryMultipleSizeValue = config.getConfiguration().getStringList("GUI.RandomEntry.Multiple.SizeValue").toArray(new String[0]);
        this.guiRandomEntryBankerTab = config.getConfiguration().getStringList("GUI.RandomEntry.Banker.Tab").toArray(new String[0]);
        this.guiRandomEntryBankerBankersValue = config.getConfiguration().getStringList("GUI.RandomEntry.Banker.BankersValue").toArray(new String[0]);
        this.guiRandomEntryBankerSelectionsValue = config.getConfiguration().getStringList("GUI.RandomEntry.Banker.SelectionsValue").toArray(new String[0]);
        this.guiConfirmNewBetSingleTitle = config.getConfiguration().getString("GUI.ConfirmNewBet.SingleTitle");
        this.guiConfirmNewBetComplexTitle = config.getConfiguration().getString("GUI.ConfirmNewBet.ComplexTitle");
        this.guiConfirmNewBetBulkSingleTitle = config.getConfiguration().getString("GUI.ConfirmNewBet.BulkSingleTitle");
        this.guiConfirmNewBetBulkComplexTitle = config.getConfiguration().getString("GUI.ConfirmNewBet.BulkComplexTitle");
        this.guiConfirmNewBetLotteryInfo = config.getConfiguration().getStringList("GUI.ConfirmNewBet.LotteryInfo").toArray(new String[0]);
        this.guiConfirmNewBetBulkRandom = config.getConfiguration().getStringList("GUI.ConfirmNewBet.BulkRandom").toArray(new String[0]);
        this.guiConfirmNewBetMultipleDrawValue = config.getConfiguration().getStringList("GUI.ConfirmNewBet.MultipleDrawValue").toArray(new String[0]);
        this.guiConfirmNewBetIncrementButton = config.getConfiguration().getStringList("GUI.ConfirmNewBet.IncrementButton").toArray(new String[0]);
        this.guiConfirmNewBetDecrementButton = config.getConfiguration().getStringList("GUI.ConfirmNewBet.DecrementButton").toArray(new String[0]);
        this.guiConfirmNewBetUnitInvestmentConfirm = config.getConfiguration().getStringList("GUI.ConfirmNewBet.UnitInvestmentConfirm").toArray(new String[0]);
        this.guiConfirmNewBetPartialInvestmentConfirm = config.getConfiguration().getStringList("GUI.ConfirmNewBet.PartialInvestmentConfirm").toArray(new String[0]);
        this.guiConfirmNewBetCancel = config.getConfiguration().getStringList("GUI.ConfirmNewBet.Cancel").toArray(new String[0]);
        this.guiNumberStatisticsTitle = config.getConfiguration().getString("GUI.NumberStatistics.Title");
        this.guiNumberStatisticsLastDrawn = config.getConfiguration().getString("GUI.NumberStatistics.LastDrawn");
        this.guiNumberStatisticsTimesDrawn = config.getConfiguration().getString("GUI.NumberStatistics.TimesDrawn");
        this.guiNumberStatisticsNever = config.getConfiguration().getString("GUI.NumberStatistics.Never");
        this.guiNumberStatisticsNote = config.getConfiguration().getStringList("GUI.NumberStatistics.Note").toArray(new String[0]);
        this.guiBettingAccountTitle = config.getConfiguration().getString("GUI.BettingAccount.Title");
        this.guiBettingAccountProfile = config.getConfiguration().getStringList("GUI.BettingAccount.Profile").toArray(new String[0]);
        this.guiBettingAccountFlipLeftRightClick = config.getConfiguration().getStringList("GUI.BettingAccount.FlipLeftRightClick").toArray(new String[0]);
        this.guiBettingAccountToggleHideTitles = config.getConfiguration().getStringList("GUI.BettingAccount.ToggleHideTitles").toArray(new String[0]);
        this.guiBettingAccountToggleHidePeriodicAnnouncements = config.getConfiguration().getStringList("GUI.BettingAccount.ToggleHidePeriodicAnnouncements").toArray(new String[0]);
        this.guiBettingAccountToggleReopenMenu = config.getConfiguration().getStringList("GUI.BettingAccount.ToggleReopenMenu").toArray(new String[0]);
        this.guiBettingAccountSetBetLimitPerRound = config.getConfiguration().getStringList("GUI.BettingAccount.SetBetLimitPerRound").toArray(new String[0]);
        this.guiBettingAccountSetBetLimitPerRoundTitle = config.getConfiguration().getString("GUI.BettingAccount.SetBetLimitPerRoundTitle");
        this.guiBettingAccountSuspendAccountForAWeek = config.getConfiguration().getStringList("GUI.BettingAccount.SuspendAccountForAWeek").toArray(new String[0]);
        this.guiAccountFundTransferTitleNoMoney = config.getConfiguration().getString("GUI.AccountFundTransfer.NoMoneyTitle");
        this.guiAccountFundTransferTitle = config.getConfiguration().getString("GUI.AccountFundTransfer.Title");
        this.guiAccountFundTransferCurrentBalance = config.getConfiguration().getStringList("GUI.AccountFundTransfer.CurrentBalance").toArray(new String[0]);
        this.guiAccountFundTransferDeposit = config.getConfiguration().getStringList("GUI.AccountFundTransfer.Deposit").toArray(new String[0]);
        this.guiAccountFundTransferDepositRestricted = config.getConfiguration().getStringList("GUI.AccountFundTransfer.DepositRestricted").toArray(new String[0]);
        this.guiAccountFundTransferWithdraw = config.getConfiguration().getStringList("GUI.AccountFundTransfer.Withdraw").toArray(new String[0]);
        this.guiAccountFundTransferWithdrawAll = config.getConfiguration().getStringList("GUI.AccountFundTransfer.WithdrawAll").toArray(new String[0]);
        this.guiAccountFundTransferWithdrawInputTitle = config.getConfiguration().getString("GUI.AccountFundTransfer.WithdrawInputTitle");
        this.guiAccountFundTransferDepositInputTitle = config.getConfiguration().getString("GUI.AccountFundTransfer.DepositInputTitle");
        this.guiAccountFundTransferPlacingBetTitle = config.getConfiguration().getString("GUI.AccountFundTransferPlacingBet.Title");
        this.guiAccountFundTransferPlacingBetConfirm = config.getConfiguration().getStringList("GUI.AccountFundTransferPlacingBet.Confirm").toArray(new String[0]);
        this.guiAccountFundTransferPlacingBetCancel = config.getConfiguration().getStringList("GUI.AccountFundTransferPlacingBet.Cancel").toArray(new String[0]);
        this.announcerPeriodicMessageMessage = config.getConfiguration().getString("Announcer.PeriodicMessage.Message");
        this.announcerPeriodicMessageHover = config.getConfiguration().getString("Announcer.PeriodicMessage.Hover");
        this.announcerPeriodicMessageFrequency = config.getConfiguration().getInt("Announcer.PeriodicMessage.Frequency");
        this.announcerPeriodicMessageOneMinuteBefore = config.getConfiguration().getBoolean("Announcer.PeriodicMessage.OneMinuteBefore");
        this.announcerDrawCancelledMessage = config.getConfiguration().getString("Announcer.DrawCancelledMessage");
        this.announcerBetPlacedAnnouncementEnabled = config.getConfiguration().getBoolean("Announcer.BetPlacedAnnouncement.Enabled");
        this.announcerBetPlacedAnnouncementMessage = config.getConfiguration().getString("Announcer.BetPlacedAnnouncement.Message");
        this.announcerPreDrawBossBarEnabled = config.getConfiguration().getBoolean("Announcer.PreDrawBossBar.Enabled");
        this.announcerPreDrawBossBarTimeBeforeDraw = config.getConfiguration().getLong("Announcer.PreDrawBossBar.TimeBeforeDraw") * 1000L;
        this.announcerPreDrawBossBarMessage = config.getConfiguration().getString("Announcer.PreDrawBossBar.Message");
        this.announcerPreDrawBossBarColor = config.getConfiguration().getString("Announcer.PreDrawBossBar.Color");
        this.announcerPreDrawBossBarStyle = config.getConfiguration().getString("Announcer.PreDrawBossBar.Style");
        this.announcerDrawBossBarEnabled = config.getConfiguration().getBoolean("Announcer.DrawBossBar.Enabled");
        this.announcerDrawBossBarMessages = config.getConfiguration().getStringList("Announcer.DrawBossBar.Messages");
        this.announcerDrawBossBarColor = config.getConfiguration().getString("Announcer.DrawBossBar.Color");
        this.announcerDrawBossBarStyle = config.getConfiguration().getString("Announcer.DrawBossBar.Style");
        this.liveDrawAnnouncerEnabled = config.getConfiguration().getBoolean("Announcer.LiveDrawAnnouncer.Enabled");
        this.liveDrawAnnouncerSendMessagesTitle = config.getConfiguration().getBoolean("Announcer.LiveDrawAnnouncer.SendMessagesTitle");
        this.liveDrawAnnouncerTimeBetween = config.getConfiguration().getInt("Announcer.LiveDrawAnnouncer.TimeBetween");
        this.liveDrawAnnouncerPreMessage = config.getConfiguration().getStringList("Announcer.LiveDrawAnnouncer.PreMessage");
        this.liveDrawAnnouncerPreMessageHover = config.getConfiguration().getStringList("Announcer.LiveDrawAnnouncer.PreMessageHover");
        this.liveDrawAnnouncerMessages = config.getConfiguration().getStringList("Announcer.LiveDrawAnnouncer.Messages");
        this.liveDrawAnnouncerPostMessages = config.getConfiguration().getStringList("Announcer.LiveDrawAnnouncer.PostMessages");
        this.liveDrawAnnouncerPostMessagesHover = config.getConfiguration().getStringList("Announcer.LiveDrawAnnouncer.PostMessagesHover");
        this.discordSRVDrawResultAnnouncementChannel = config.getConfiguration().getString("DiscordSRV.DrawResultAnnouncement.Channel");
        this.discordSRVDrawResultAnnouncementTitle = config.getConfiguration().getString("DiscordSRV.DrawResultAnnouncement.Title");
        this.discordSRVDrawResultAnnouncementDescription = String.join((CharSequence)"\n", config.getConfiguration().getStringList("DiscordSRV.DrawResultAnnouncement.Description"));
        this.discordSRVDrawResultAnnouncementThumbnailURL = config.getConfiguration().getString("DiscordSRV.DrawResultAnnouncement.ThumbnailURL");
        this.discordSRVSlashCommandsEnableLotteryCommand = config.getConfiguration().getBoolean("DiscordSRV.SlashCommands.EnableLotteryCommand");
        this.discordSRVSlashCommandsGlobalTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.Title");
        this.discordSRVSlashCommandsGlobalSubTitleActiveGame = String.join((CharSequence)"\n", config.getConfiguration().getStringList("DiscordSRV.SlashCommands.Global.SubTitle.ActiveGame"));
        this.discordSRVSlashCommandsGlobalSubTitleNoGame = String.join((CharSequence)"\n", config.getConfiguration().getStringList("DiscordSRV.SlashCommands.Global.SubTitle.NoGame"));
        this.discordSRVSlashCommandsGlobalDescription = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.Description");
        this.discordSRVSlashCommandsGlobalThumbnailURL = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.ThumbnailURL");
        this.discordSRVSlashCommandsGlobalMessagesNotLinked = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.Messages.NotLinked");
        this.discordSRVSlashCommandsGlobalMessagesNoOneOnline = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.Messages.NoOneOnline");
        this.discordSRVSlashCommandsGlobalMessagesTimeOut = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.Messages.TimeOut");
        this.discordSRVSlashCommandsGlobalMessagesUnknownError = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.Messages.UnknownError");
        this.discordSRVSlashCommandsGlobalComponentsBack = config.getConfiguration().getString("DiscordSRV.SlashCommands.Global.Components.Back");
        this.discordSRVSlashCommandsBetAccountTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.BetAccount.Title");
        this.discordSRVSlashCommandsBetAccountSubTitle = config.getConfiguration().getStringList("DiscordSRV.SlashCommands.BetAccount.SubTitle").toArray(new String[0]);
        this.discordSRVSlashCommandsBetAccountThumbnailURL = config.getConfiguration().getString("DiscordSRV.SlashCommands.BetAccount.ThumbnailURL");
        this.discordSRVSlashCommandsPlaceBetNoGame = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.NoGame");
        this.discordSRVSlashCommandsPlaceBetTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Title");
        this.discordSRVSlashCommandsPlaceBetSubTitle = config.getConfiguration().getStringList("DiscordSRV.SlashCommands.PlaceBet.SubTitle").toArray(new String[0]);
        this.discordSRVSlashCommandsComponentsSingleTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.SingleTitle");
        this.discordSRVSlashCommandsComponentsMultipleTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.MultipleTitle");
        this.discordSRVSlashCommandsComponentsBankerTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.BankerTitle");
        this.discordSRVSlashCommandsComponentsRandomTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.RandomTitle");
        this.discordSRVSlashCommandsComponentsNotYetFinish = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.NotYetFinish");
        this.discordSRVSlashCommandsComponentsAddRandom = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.AddRandom");
        this.discordSRVSlashCommandsComponentsFinish = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.Finish");
        this.discordSRVSlashCommandsComponentsFinishBankers = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.FinishBankers");
        this.discordSRVSlashCommandsComponentsMultipleRandomSize = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.MultipleRandomSize");
        this.discordSRVSlashCommandsComponentsBankerRandomBankerSize = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.BankerRandomBankerSize");
        this.discordSRVSlashCommandsComponentsBankerRandomSelectionSize = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.BankerRandomSelectionSize");
        this.discordSRVSlashCommandsComponentsMultipleDrawSelection = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.Components.MultipleDrawSelection");
        this.discordSRVSlashCommandsPlaceBetThumbnailURL = config.getConfiguration().getString("DiscordSRV.SlashCommands.PlaceBet.ThumbnailURL");
        this.discordSRVSlashCommandsViewPastDrawTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewPastDraw.Title");
        this.discordSRVSlashCommandsViewPastDrawNoResults = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewPastDraw.NoResults");
        this.discordSRVSlashCommandsViewPastDrawYourBets = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewPastDraw.YourBets");
        this.discordSRVSlashCommandsViewPastDrawNoWinnings = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewPastDraw.NoWinnings");
        this.discordSRVSlashCommandsViewPastDrawThumbnailURL = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewPastDraw.ThumbnailURL");
        this.discordSRVSlashCommandsViewCurrentBetsTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewCurrentBets.Title");
        this.discordSRVSlashCommandsViewCurrentBetsSubTitle = config.getConfiguration().getStringList("DiscordSRV.SlashCommands.ViewCurrentBets.SubTitle");
        this.discordSRVSlashCommandsViewCurrentBetsNoBets = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewCurrentBets.NoBets");
        this.discordSRVSlashCommandsViewCurrentBetsNoGame = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewCurrentBets.NoGame");
        this.discordSRVSlashCommandsViewCurrentBetsThumbnailURL = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewPastDraw.ThumbnailURL");
        this.discordSRVSlashCommandsViewNumberStatisticsTitle = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewNumberStatistics.Title");
        this.discordSRVSlashCommandsViewNumberStatisticsThumbnailURL = config.getConfiguration().getString("DiscordSRV.SlashCommands.ViewNumberStatistics.ThumbnailURL");
        this.placeholderAPIHideResultsWhileGameIsLocked = config.getConfiguration().getBoolean("PlaceholderAPI.HideResultsWhileGameIsLocked");
        this.allowLoans = config.getConfiguration().getBoolean("Restrictions.AllowLoans");
        this.playerBetLimit = new HashMap<String, Long>();
        for (String group : config.getConfiguration().getConfigurationSection("Restrictions.BetLimitPerRound").getKeys(false)) {
            this.playerBetLimit.put(group, config.getConfiguration().getLong("Restrictions.BetLimitPerRound." + group));
        }
        String lotteriesFundAccountStr = config.getConfiguration().getString("LotterySix.LotteriesFundAccount");
        try {
            this.lotteriesFundAccount = UUID.fromString(lotteriesFundAccountStr);
        }
        catch (IllegalArgumentException e) {
            this.lotteriesFundAccount = null;
        }
        this.maximumChancePerSelection = config.getConfiguration().getLong("Restrictions.MaximumChancePerSelection");
        this.hideManuelAccountFundTransferDeposit = config.getConfiguration().getBoolean("Restrictions.HideManuelAccountFundTransferDeposit");
        this.numberItemsType = config.getConfiguration().getString("NumberItems.ItemType");
        this.numberItemsSetStackSize = config.getConfiguration().getBoolean("NumberItems.SetStackSize");
        this.numberItemsCustomModelData = config.getConfiguration().getInt("NumberItems.StartingCustomModelData");
        this.borderPaneItemsHideAll = config.getConfiguration().getBoolean("BorderPaneItems.HideAll");
        this.guiCustomModelData = config.getConfiguration().getInt("AdvancedGUICustomization.StartingCustomModelData");
        this.guiInfo = new HashMap<GUIType, GUIInfo>();
        GUIType[] e = GUIType.values();
        int n = e.length;
        boolean bl = false;
        while (var7_15 < n) {
            GUIType type = e[var7_15];
            String key = type.getKey();
            String itemType = config.getConfiguration().getString("AdvancedGUICustomization.GUIs." + key + ".ItemType");
            List<String> layout = config.getConfiguration().getStringList("AdvancedGUICustomization.GUIs." + key + ".Layout");
            int customModelDataOffset = this.guiCustomModelData + type.ordinal() * 1000;
            this.guiInfo.put(type, new GUIInfo(type, itemType, layout, customModelDataOffset));
            ++var7_15;
        }
        int seventhTierMultiplier = config.getConfiguration().getInt("LotterySix.PrizeTierSettings.SEVENTH.FixedPrizeMultiplier");
        int sixthTierMultiplier = config.getConfiguration().getInt("LotterySix.PrizeTierSettings.SIXTH.MultiplierFromLast");
        int n2 = config.getConfiguration().getInt("LotterySix.PrizeTierSettings.FIFTH.MultiplierFromLast");
        int fourthTierMultiplier = config.getConfiguration().getInt("LotterySix.PrizeTierSettings.FOURTH.MultiplierFromLast");
        PrizeTier.SEVENTH.setFixedPrizeMultiplier(seventhTierMultiplier);
        PrizeTier.SIXTH.setFixedPrizeMultiplier(seventhTierMultiplier * sixthTierMultiplier);
        PrizeTier.SIXTH.setMinimumMultiplierFromLast(sixthTierMultiplier);
        PrizeTier.FIFTH.setFixedPrizeMultiplier(seventhTierMultiplier * sixthTierMultiplier * n2);
        PrizeTier.FIFTH.setMinimumMultiplierFromLast(n2);
        PrizeTier.FOURTH.setFixedPrizeMultiplier(seventhTierMultiplier * sixthTierMultiplier * n2 * fourthTierMultiplier);
        PrizeTier.FOURTH.setMinimumMultiplierFromLast(fourthTierMultiplier);
    }

    public synchronized void loadData() {
        File completedGameFile;
        this.completedGames.clear();
        File lotteryDataFolder = new File(this.getDataFolder(), "data");
        lotteryDataFolder.mkdirs();
        File currentGameFile = new File(lotteryDataFolder, "current.json");
        if (currentGameFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(currentGameFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                this.currentGame = GSON.fromJson((Reader)reader, PlayableLotterySixGame.class);
                if (this.currentGame == null) {
                    throw new IOException("Unable to read data of current LotterySix game in " + currentGameFile.getAbsolutePath());
                }
                this.currentGame.setInstance(this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((completedGameFile = new File(lotteryDataFolder, "completed.json")).exists()) {
            boolean needSaving = false;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(completedGameFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                JsonArray array = GSON.fromJson((Reader)reader, JsonArray.class);
                Iterator<JsonElement> iterator = array.iterator();
                while (iterator.hasNext()) {
                    File oldLocation;
                    JsonElement element = iterator.next();
                    CompletedLotterySixGameIndex gameIndex = GSON.fromJson((JsonElement)element.getAsJsonObject(), CompletedLotterySixGameIndex.class);
                    File detailFile = new File(lotteryDataFolder, gameIndex.getDataFileName("json"));
                    File detailCompressedFile = new File(lotteryDataFolder, gameIndex.getDataFileName("json.gz"));
                    if (!detailFile.exists() && !detailCompressedFile.exists() && (oldLocation = new File(lotteryDataFolder, gameIndex.getDatetime() + ".json")).exists()) {
                        Files.move(oldLocation.toPath(), detailFile.toPath(), new CopyOption[0]);
                    }
                    if (detailFile.exists()) {
                        try (BufferedReader uncompressedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(detailFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                             PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(Files.newOutputStream(detailCompressedFile.toPath(), new OpenOption[0])), StandardCharsets.UTF_8));){
                            uncompressedReader.lines().forEach(l -> pw.println((String)l));
                            pw.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!detailCompressedFile.exists()) continue;
                    if (detailFile.exists()) {
                        detailFile.delete();
                    }
                    if (gameIndex.isDetailsComplete()) {
                        this.completedGames.addUnloaded(gameIndex);
                        continue;
                    }
                    needSaving = true;
                    this.completedGames.add(LotterySix.loadFromDirectory(lotteryDataFolder, gameIndex));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!this.completedGames.isEmpty()) {
                this.completedGames.get(0);
            }
            if (needSaving) {
                JsonArray array = new JsonArray();
                for (CompletedLotterySixGameIndex gameIndex : this.completedGames.indexIterable()) {
                    array.add(GSON.toJsonTree(gameIndex));
                }
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(completedGameFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    pw.println(GSON.toJson(array));
                    pw.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void requestSave(boolean onlyCurrent) {
        this.requestSave.updateAndGet(i -> Math.max(i, onlyCurrent ? 1 : 2));
    }

    private void saveData(boolean onlyCurrent) {
        this.saveTasks.add(this.saveDataService.submit(() -> {
            this.lastSaveBegin.set(System.currentTimeMillis());
            try {
                this.saveDataNow(onlyCurrent);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.lastSaveBegin.set(Long.MIN_VALUE);
        }));
    }

    private void saveDataNow(boolean onlyCurrent) {
        File lotteryDataFolder = new File(this.getDataFolder(), "data");
        lotteryDataFolder.mkdirs();
        File currentGameFile = new File(lotteryDataFolder, "current.json");
        if (this.currentGame != null) {
            if (this.currentGame.getDirtyFlag().get()) {
                File backupCurrentGameFile = new File(lotteryDataFolder, "current.json.bak");
                if (currentGameFile.exists()) {
                    boolean shouldBackup = false;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(currentGameFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                        GSON.fromJson((Reader)reader, PlayableLotterySixGame.class);
                        shouldBackup = true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (shouldBackup) {
                        try {
                            Files.copy(currentGameFile.toPath(), backupCurrentGameFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(currentGameFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    this.currentGame.getDirtyFlag().set(false);
                    pw.println(this.currentGame.toJson(GSON, true));
                    pw.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (currentGameFile.exists()) {
            currentGameFile.delete();
        }
        if (!onlyCurrent) {
            File completedGameFile = new File(lotteryDataFolder, "completed.json");
            JsonArray array = new JsonArray();
            for (CompletedLotterySixGameIndex gameIndex : this.completedGames.indexIterable()) {
                array.add(GSON.toJsonTree(gameIndex));
            }
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(completedGameFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                pw.println(GSON.toJson(array));
                pw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Iterator<CompletedLotterySixGame> itr = this.completedGames.dirtyGamesIterator();
            while (itr.hasNext()) {
                CompletedLotterySixGame game = itr.next();
                File file = new File(lotteryDataFolder, game.getDataFileName("json.gz"));
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])), StandardCharsets.UTF_8));){
                    pw.println(GSON.toJson(game));
                    itr.remove();
                    pw.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

