/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.lottery;

import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.GameNumber;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.objects.AddBetResult;
import com.loohp.lotterysix.game.objects.BetUnitType;
import com.loohp.lotterysix.game.objects.CarryOverMode;
import com.loohp.lotterysix.game.objects.NumberStatistics;
import com.loohp.lotterysix.game.objects.Pair;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.PlayerWinnings;
import com.loohp.lotterysix.game.objects.PrizeCalculationMode;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.game.objects.WinningCombination;
import com.loohp.lotterysix.game.objects.WinningNumbers;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.game.player.LotteryPlayerManager;
import com.loohp.lotterysix.libs.com.google.gson.Gson;
import com.loohp.lotterysix.utils.MathUtils;
import com.loohp.lotterysix.utils.StringUtils;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PlayableLotterySixGame
implements ILotterySixGame {
    private static final Map<Object, Map<String, Object>> LOCKS_AND_FLAGS = Collections.synchronizedMap(new WeakHashMap());
    private static final String DIRTY_FLAG = "dirty";
    private transient LotterySix instance;
    private final UUID gameId;
    private volatile long scheduledDateTime;
    private volatile GameNumber gameNumber;
    private volatile String specialName;
    private final ConcurrentHashMap<Integer, NumberStatistics> numberStatistics;
    private final ConcurrentHashMap<UUID, PlayerBets> bets;
    private volatile long carryOverFund;
    private volatile long lowestTopPlacesPrize;
    private volatile boolean valid;
    private volatile long lastSaved;

    private static <T, V> V getSharedLockOrFlag(T owner, String key, Supplier<V> constructor) {
        return (V)LOCKS_AND_FLAGS.computeIfAbsent(owner, k -> new ConcurrentHashMap()).computeIfAbsent(key, k -> constructor.get());
    }

    public static PlayableLotterySixGame createNewGame(LotterySix instance, long scheduledDateTime, String specialName, Map<Integer, NumberStatistics> numberStatistics, long carryOverFund, long lowestTopPlacesPrize, List<PlayerBets> placedBets) {
        GameNumber gameNumber = instance == null ? new GameNumber(Year.now(), 1) : instance.dateToGameNumber(scheduledDateTime);
        return new PlayableLotterySixGame(instance, UUID.randomUUID(), scheduledDateTime, gameNumber, specialName, numberStatistics, placedBets, lowestTopPlacesPrize, carryOverFund, true);
    }

    public static PlayableLotterySixGame createPresetGame(LotterySix instance, UUID gameId, GameNumber gameNumber, long scheduledDateTime, String specialName, Map<Integer, NumberStatistics> numberStatistics, long carryOverFund, long lowestTopPlacesPrize, List<PlayerBets> placedBets) {
        return new PlayableLotterySixGame(instance, gameId, scheduledDateTime, gameNumber, specialName, numberStatistics, placedBets, lowestTopPlacesPrize, carryOverFund, true);
    }

    private PlayableLotterySixGame(LotterySix instance, UUID gameId, long scheduledDateTime, GameNumber gameNumber, String specialName, Map<Integer, NumberStatistics> numberStatistics, List<PlayerBets> placedBets, long lowestTopPlacesPrize, long carryOverFund, boolean valid) {
        this.instance = instance;
        this.gameId = gameId;
        this.scheduledDateTime = scheduledDateTime;
        this.specialName = specialName;
        this.numberStatistics = new ConcurrentHashMap<Integer, NumberStatistics>(numberStatistics);
        this.gameNumber = gameNumber;
        this.bets = new ConcurrentHashMap();
        for (PlayerBets bet : placedBets) {
            this.bets.put(bet.getBetId(), bet);
        }
        this.carryOverFund = carryOverFund;
        this.lowestTopPlacesPrize = lowestTopPlacesPrize;
        this.valid = valid;
        this.lastSaved = -1L;
    }

    public AtomicBoolean getDirtyFlag() {
        return PlayableLotterySixGame.getSharedLockOrFlag(this, DIRTY_FLAG, () -> new AtomicBoolean(true));
    }

    public String toJson(Gson gson, boolean updateSaveTime) {
        if (updateSaveTime) {
            this.lastSaved = System.currentTimeMillis();
        }
        return gson.toJson(this);
    }

    public LotterySix getInstance() {
        return this.instance;
    }

    public void setInstance(LotterySix instance) {
        this.instance = instance;
    }

    @Override
    public UUID getGameId() {
        return this.gameId;
    }

    @Override
    public GameNumber getGameNumber() {
        return this.gameNumber;
    }

    @Override
    public boolean hasSpecialName() {
        return this.specialName != null && !this.specialName.isEmpty();
    }

    @Override
    public String getSpecialName() {
        return this.specialName;
    }

    public void setSpecialName(String specialName) {
        if (!Objects.equals(this.specialName, specialName)) {
            this.specialName = specialName;
            this.getDirtyFlag().set(true);
        }
    }

    @Override
    public String getDataFileName(String extension) {
        return "current." + extension;
    }

    public void setDatetime(long scheduledDateTime, GameNumber gameNumber) {
        if (this.scheduledDateTime != scheduledDateTime || !this.gameNumber.equals(gameNumber)) {
            this.scheduledDateTime = scheduledDateTime;
            this.gameNumber = gameNumber;
            this.getDirtyFlag().set(true);
        }
    }

    @Override
    public long getDatetime() {
        return this.scheduledDateTime;
    }

    public NumberStatistics getNumberStatistics(int number) {
        if (this.numberStatistics == null) {
            return NumberStatistics.NOT_EVER_DRAWN;
        }
        return this.numberStatistics.getOrDefault(number, NumberStatistics.NOT_EVER_DRAWN);
    }

    public Map<Integer, NumberStatistics> getNumberStatistics() {
        return this.numberStatistics == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.numberStatistics);
    }

    public void setNumberStatistics(Map<Integer, NumberStatistics> numberStatistics) {
        if (!this.numberStatistics.equals(numberStatistics)) {
            this.numberStatistics.clear();
            this.numberStatistics.putAll(numberStatistics);
            this.getDirtyFlag().set(true);
        }
    }

    public long getCarryOverFund(long rounding) {
        return MathUtils.followRound(rounding, this.carryOverFund);
    }

    public long getCarryOverFund() {
        return this.carryOverFund;
    }

    public void setCarryOverFund(long carryOverFund) {
        if (this.carryOverFund != carryOverFund) {
            this.carryOverFund = carryOverFund;
            this.getDirtyFlag().set(true);
        }
    }

    public long getLowestTopPlacesPrize() {
        return this.lowestTopPlacesPrize;
    }

    public void setLowestTopPlacesPrize(long lowestTopPlacesPrize) {
        if (this.lowestTopPlacesPrize != lowestTopPlacesPrize) {
            this.lowestTopPlacesPrize = lowestTopPlacesPrize;
            this.getDirtyFlag().set(true);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Deprecated
    public void markInvalid() {
        if (this.valid) {
            this.valid = false;
            this.getDirtyFlag().set(true);
        }
    }

    public void cancelGame() {
        this.valid = false;
        if (this.instance != null && !this.instance.backendBungeecordMode) {
            LotteryPlayer lotteryPlayer;
            HashMap<UUID, List> multipleDrawBets = new HashMap<UUID, List>();
            HashMap<LotteryPlayer, Boolean> affected = new HashMap<LotteryPlayer, Boolean>();
            LotteryPlayerManager lotteryPlayerManager = this.instance.getLotteryPlayerManager();
            for (PlayerBets playerBets : this.bets.values()) {
                List playerBets2 = multipleDrawBets.computeIfAbsent(playerBets.getPlayer(), k -> new ArrayList());
                if (playerBets.isMultipleDraw()) {
                    playerBets2.add(playerBets);
                    continue;
                }
                LotteryPlayer lotteryPlayer2 = lotteryPlayerManager.getLotteryPlayer(playerBets.getPlayer());
                lotteryPlayer2.updateStats(PlayerStatsKey.TOTAL_BETS_PLACED, Long.TYPE, i -> i - bet.getBet(), false);
                lotteryPlayer2.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + bet.getBet(), false);
                lotteryPlayer2.updateStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, Long.TYPE, i -> i + bet.getBet(), false);
                affected.put(lotteryPlayer2, true);
            }
            for (Map.Entry entry : multipleDrawBets.entrySet()) {
                lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer((UUID)entry.getKey());
                lotteryPlayer.setMultipleDrawPlayerBets((List)entry.getValue(), false);
                affected.putIfAbsent(lotteryPlayer, false);
            }
            for (Map.Entry entry : affected.entrySet()) {
                lotteryPlayer = (LotteryPlayer)entry.getKey();
                lotteryPlayer.save();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                this.instance.notifyBalanceChangeConsumer(lotteryPlayer.getPlayer());
            }
        }
    }

    public synchronized void invalidateBetsIf(Predicate<PlayerBets> predicate, boolean clearMultipleDraw) {
        ArrayList<PlayerBets> removedBets = new ArrayList<PlayerBets>();
        Iterator<PlayerBets> itr = this.bets.values().iterator();
        while (itr.hasNext()) {
            PlayerBets playerBet = itr.next();
            if (!predicate.test(playerBet)) continue;
            itr.remove();
            removedBets.add(playerBet);
        }
        this.getDirtyFlag().set(true);
        if (this.instance != null && !this.instance.backendBungeecordMode) {
            this.instance.requestSave(true);
            LotteryPlayerManager lotteryPlayerManager = this.instance.getLotteryPlayerManager();
            HashSet<LotteryPlayer> affected = new HashSet<LotteryPlayer>();
            for (PlayerBets bet : removedBets) {
                long total = clearMultipleDraw ? bet.getBet() * (long)bet.getDrawsRemaining() : bet.getBet();
                LotteryPlayer lotteryPlayer = lotteryPlayerManager.getLotteryPlayer(bet.getPlayer());
                lotteryPlayer.updateStats(PlayerStatsKey.TOTAL_BETS_PLACED, Long.TYPE, i -> i - total, false);
                lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + total, false);
                lotteryPlayer.updateStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, Long.TYPE, i -> i + total, false);
                affected.add(lotteryPlayer);
            }
            for (LotteryPlayer lotteryPlayer : affected) {
                if (clearMultipleDraw) {
                    lotteryPlayer.setMultipleDrawPlayerBets(Collections.emptyList(), false);
                }
                lotteryPlayer.save();
                this.instance.notifyBalanceChangeConsumer(lotteryPlayer.getPlayer());
            }
            this.instance.getPlayerBetsInvalidateListener().accept(removedBets);
        }
    }

    public boolean hasBets() {
        return !this.bets.isEmpty();
    }

    public List<PlayerBets> getBets() {
        return this.bets.values().stream().sorted().collect(Collectors.toList());
    }

    public Set<UUID> getBetIds() {
        return Collections.unmodifiableSet(this.bets.keySet());
    }

    public PlayerBets getBet(UUID betId) {
        return this.bets.get(betId);
    }

    public List<PlayerBets> getPlayerBets(UUID player) {
        return this.bets.values().stream().filter(each -> each.getPlayer().equals(player)).sorted().collect(Collectors.toList());
    }

    public long getTotalBets() {
        return this.bets.values().stream().mapToLong(each -> each.getBet()).sum();
    }

    public AddBetResult addBet(String name, UUID player, long bet, BetUnitType unitType, BetNumbers chosenNumbers, int multipleDraw) {
        return this.addBet(new PlayerBets(name, player, System.currentTimeMillis(), System.nanoTime(), bet, unitType, chosenNumbers, multipleDraw));
    }

    public AddBetResult addBet(String name, UUID player, long betPerUnit, BetUnitType unitType, Collection<BetNumbers> chosenNumbers, int multipleDraw) {
        if (chosenNumbers.isEmpty()) {
            throw new IllegalArgumentException("chosenNumbers cannot be empty");
        }
        long now = System.currentTimeMillis();
        long nano = System.nanoTime();
        return this.addBet(name, player, chosenNumbers.stream().map(each -> new PlayerBets(name, player, now, nano, betPerUnit, unitType, (BetNumbers)each, multipleDraw)).collect(Collectors.toList()));
    }

    public AddBetResult addBet(PlayerBets bet) {
        return this.addBet(bet.getName(), bet.getPlayer(), Collections.singleton(bet));
    }

    private synchronized AddBetResult addBet(String name, UUID player, Collection<PlayerBets> bets) {
        long price = bets.stream().mapToLong(each -> each.getBet() * (long)each.getMultipleDraw()).sum();
        if (this.instance != null && this.instance.isGameLocked()) {
            return this.betResult0(player, price, bets, AddBetResult.GAME_LOCKED);
        }
        if (this.instance != null && !this.instance.backendBungeecordMode) {
            LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player);
            long totalBets = this.getPlayerBets(player).stream().mapToLong(each -> each.getBet()).sum() + price;
            long playerLimit = lotteryPlayer.getPreference(PlayerPreferenceKey.BET_LIMIT_PER_ROUND, Long.TYPE);
            if (playerLimit >= 0L && playerLimit < totalBets) {
                return this.betResult0(player, price, bets, AddBetResult.LIMIT_SELF);
            }
            long permissionLimit = this.instance.getPlayerBetLimit(player);
            if (permissionLimit >= 0L && permissionLimit < totalBets) {
                return this.betResult0(player, price, bets, AddBetResult.LIMIT_PERMISSION);
            }
            for (PlayerBets bet : bets) {
                BetNumbers numbers = bet.getChosenNumbers();
                if (!numbers.isCombination() || MathUtils.combinationsCount(numbers.getNumbers().size(), numbers.getBankersNumbers().size()) <= this.instance.maximumChancePerSelection) continue;
                return this.betResult0(player, price, bets, AddBetResult.LIMIT_CHANCE_PER_SELECTION);
            }
            if (price > lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE)) {
                return this.betResult0(player, price, bets, AddBetResult.NOT_ENOUGH_MONEY);
            }
            if (System.currentTimeMillis() < lotteryPlayer.getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE)) {
                return this.betResult0(player, price, bets, AddBetResult.ACCOUNT_SUSPENDED);
            }
            lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i - price, false);
            lotteryPlayer.updateStats(PlayerStatsKey.TOTAL_BETS_PLACED, Long.TYPE, i -> i + price, false);
            lotteryPlayer.save();
        }
        for (PlayerBets bet : bets) {
            this.bets.put(bet.getBetId(), bet);
        }
        this.getDirtyFlag().set(true);
        if (this.instance != null) {
            this.instance.requestSave(true);
            if (!this.instance.backendBungeecordMode && this.instance.announcerBetPlacedAnnouncementEnabled) {
                for (UUID uuid : this.instance.getOnlinePlayersSupplier().get()) {
                    this.instance.getMessageSendingConsumer().accept(uuid, this.instance.announcerBetPlacedAnnouncementMessage.replace("{Player}", name).replace("{Price}", StringUtils.formatComma(price)), this);
                }
            }
        }
        return this.betResult0(player, price, bets, AddBetResult.SUCCESS);
    }

    private AddBetResult betResult0(UUID player, long price, Collection<PlayerBets> bets, AddBetResult result) {
        if (this.instance != null && !this.instance.backendBungeecordMode) {
            this.instance.getPlayerBetListener().accept(player, result, price, bets);
            if (result.isSuccess()) {
                for (PlayerBets playerBet : bets) {
                    this.instance.getConsoleMessageConsumer().accept(playerBet.getName() + " (" + playerBet.getPlayer() + ") placed a bet worth $" + playerBet.getBet() * (long)playerBet.getMultipleDraw() + " (" + (Object)((Object)playerBet.getType()) + ") with type " + (Object)((Object)playerBet.getChosenNumbers().getType()) + " [" + playerBet.getChosenNumbers().toString() + "] to game " + this.gameNumber + " (" + this.gameId + ") for " + playerBet.getMultipleDraw() + " games");
                }
            }
        }
        return result;
    }

    public long estimatedPrizePool(long maxTopPlacesPrize, double taxPercentage, long rounding) {
        PrizeCalculationMode prizeCalculationMode;
        PrizeCalculationMode prizeCalculationMode2 = prizeCalculationMode = this.instance == null ? PrizeCalculationMode.CONFIG_DEFAULT : this.instance.prizeCalculationMode;
        if (prizeCalculationMode.equals((Object)PrizeCalculationMode.HKJC)) {
            return MathUtils.followRound(rounding, Math.min(maxTopPlacesPrize, this.carryOverFund + this.lowestTopPlacesPrize));
        }
        CarryOverMode carryOverMode = this.instance == null ? CarryOverMode.CONFIG_DEFAULT : this.instance.carryOverMode;
        switch (carryOverMode) {
            case ONLY_TICKET_SALES: {
                return MathUtils.followRound(rounding, Math.min(maxTopPlacesPrize, Math.max(this.lowestTopPlacesPrize, this.lowestTopPlacesPrize + this.carryOverFund + (long)Math.floor((double)this.getTotalBets() * (1.0 - taxPercentage)))));
            }
            case PRIZE_AND_SALES: {
                return MathUtils.followRound(rounding, Math.min(maxTopPlacesPrize, Math.max(this.lowestTopPlacesPrize, this.lowestTopPlacesPrize / 2L + this.carryOverFund + (long)Math.floor((double)this.getTotalBets() * (1.0 - taxPercentage)))));
            }
        }
        throw new RuntimeException("Unknown carry over mode: " + (Object)((Object)carryOverMode));
    }

    public synchronized CompletedLotterySixGame runLottery(int maxNumber, long pricePerBet, long maxTopPlacesPrize, double taxPercentage) {
        PrizeCalculationMode prizeCalculationMode = this.instance == null ? PrizeCalculationMode.CONFIG_DEFAULT : this.instance.prizeCalculationMode;
        CarryOverMode carryOverMode = this.instance == null ? CarryOverMode.CONFIG_DEFAULT : this.instance.carryOverMode;
        return this.runLottery(maxNumber, pricePerBet, maxTopPlacesPrize, taxPercentage, prizeCalculationMode, carryOverMode);
    }

    public synchronized CompletedLotterySixGame runLottery(int maxNumber, long pricePerBet, long maxTopPlacesPrize, double taxPercentage, PrizeCalculationMode prizeCalculationMode, CarryOverMode carryOverMode) {
        SecureRandom random = new SecureRandom();
        List num = random.ints(1, maxNumber + 1).distinct().limit(7L).boxed().collect(Collectors.toList());
        WinningNumbers winningNumbers = new WinningNumbers(num.subList(0, 6), (Integer)num.get(num.size() - 1));
        return this.runLottery(maxNumber, pricePerBet, maxTopPlacesPrize, taxPercentage, winningNumbers, prizeCalculationMode, carryOverMode);
    }

    public synchronized CompletedLotterySixGame runLottery(int maxNumber, long pricePerBet, long maxTopPlacesPrize, double taxPercentage, WinningNumbers winningNumbers) {
        PrizeCalculationMode prizeCalculationMode = this.instance == null ? PrizeCalculationMode.CONFIG_DEFAULT : this.instance.prizeCalculationMode;
        CarryOverMode carryOverMode = this.instance == null ? CarryOverMode.CONFIG_DEFAULT : this.instance.carryOverMode;
        return this.runLottery(maxNumber, pricePerBet, maxTopPlacesPrize, taxPercentage, winningNumbers, prizeCalculationMode, carryOverMode);
    }

    public synchronized CompletedLotterySixGame runLottery(int maxNumber, long pricePerBet, long maxTopPlacesPrize, double taxPercentage, WinningNumbers winningNumbers, PrizeCalculationMode prizeCalculationMode, CarryOverMode carryOverMode) {
        CompletedLotterySixGame completed;
        if (this.instance != null && this.instance.backendBungeecordMode) {
            throw new IllegalStateException("lottery cannot be run on backend server while on bungeecord mode");
        }
        HashMap<Integer, NumberStatistics> newNumberStats = new HashMap<Integer, NumberStatistics>();
        for (int i = 1; i <= maxNumber; ++i) {
            newNumberStats.put(i, this.getNumberStatistics(i).increment(winningNumbers.containsAnywhere(i)));
        }
        EnumMap<PrizeTier, List<Pair<PlayerBets, WinningCombination>>> tiers = new EnumMap<PrizeTier, List<Pair<PlayerBets, WinningCombination>>>(PrizeTier.class);
        for (PrizeTier prizeTier : PrizeTier.values()) {
            tiers.put(prizeTier, new ArrayList());
        }
        HashSet<UUID> participants = new HashSet<UUID>();
        for (PlayerBets playerBets : this.bets.values()) {
            participants.add(playerBets.getPlayer());
            Iterator itr = winningNumbers.checkWinning(playerBets.getChosenNumbers()).iterator();
            while (itr.hasNext()) {
                Pair prizeTiersPair = (Pair)itr.next();
                ((List)tiers.get(prizeTiersPair.getFirst())).add(Pair.of(playerBets, (WinningCombination)prizeTiersPair.getSecond()));
            }
        }
        if (this.instance != null) {
            new Thread(() -> {
                for (UUID player : participants) {
                    this.instance.getLotteryPlayerManager().getLotteryPlayer(player).updateStats(PlayerStatsKey.TOTAL_ROUNDS_PARTICIPATED, Long.TYPE, i -> i + 1L);
                }
            }).start();
        }
        switch (prizeCalculationMode) {
            case UNREALISTIC_FOR_FUN: {
                completed = this.completeWithUnrealisticPrizeCalculation(pricePerBet, maxTopPlacesPrize, taxPercentage, carryOverMode, tiers, winningNumbers, newNumberStats);
                break;
            }
            case HKJC: {
                completed = this.completeWithHkjcPrizeCalculation(pricePerBet, maxTopPlacesPrize, taxPercentage, carryOverMode, tiers, winningNumbers, newNumberStats);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Prize Calculation Mode " + (Object)((Object)prizeCalculationMode));
            }
        }
        this.valid = false;
        return completed;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized CompletedLotterySixGame completeWithUnrealisticPrizeCalculation(long pricePerBet, long maxTopPlacesPrize, double taxPercentage, CarryOverMode carryOverMode, Map<PrizeTier, List<Pair<PlayerBets, WinningCombination>>> tiers, WinningNumbers winningNumbers, Map<Integer, NumberStatistics> newNumberStats) {
        void var51_47;
        void var51_45;
        double secondPortion;
        PlayerWinnings playerWinnings2;
        PlayerBets playerBets;
        long totalPrize;
        long totalBetsFund = this.getTotalBets();
        switch (carryOverMode) {
            case ONLY_TICKET_SALES: {
                totalPrize = this.lowestTopPlacesPrize + this.carryOverFund + (long)Math.floor((double)totalBetsFund * (1.0 - taxPercentage));
                break;
            }
            case PRIZE_AND_SALES: {
                totalPrize = this.lowestTopPlacesPrize / 2L + this.carryOverFund + (long)Math.floor((double)totalBetsFund * (1.0 - taxPercentage));
                break;
            }
            default: {
                throw new RuntimeException("Unknown carry over mode: " + (Object)((Object)carryOverMode));
            }
        }
        long lotteriesFunds = totalBetsFund - (long)Math.floor((double)totalBetsFund * (1.0 - taxPercentage));
        EnumMap<PrizeTier, Long> prizeForTier = new EnumMap<PrizeTier, Long>(PrizeTier.class);
        ArrayList<PlayerWinnings> winnings = new ArrayList<PlayerWinnings>();
        long totalPrizes = 0L;
        long totalFourthToSeventh = 0L;
        if (!tiers.get((Object)PrizeTier.SEVENTH).isEmpty()) {
            prizeForTier.put(PrizeTier.SEVENTH, pricePerBet * (long)PrizeTier.SEVENTH.getFixedPrizeMultiplier());
        }
        for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)PrizeTier.SEVENTH)) {
            playerBets = pair.getFirst();
            PlayerWinnings playerWinnings3 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), PrizeTier.SEVENTH, playerBets, pair.getSecond(), pricePerBet * (long)PrizeTier.SEVENTH.getFixedPrizeMultiplier() / (long)playerBets.getType().getDivisor());
            totalPrizes += playerWinnings3.getWinnings();
            totalFourthToSeventh += playerWinnings3.getWinnings();
            winnings.add(playerWinnings3);
        }
        if (!tiers.get((Object)PrizeTier.SIXTH).isEmpty()) {
            prizeForTier.put(PrizeTier.SIXTH, pricePerBet * (long)PrizeTier.SIXTH.getFixedPrizeMultiplier());
        }
        for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)PrizeTier.SIXTH)) {
            playerBets = pair.getFirst();
            playerWinnings2 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), PrizeTier.SIXTH, playerBets, pair.getSecond(), pricePerBet * (long)PrizeTier.SIXTH.getFixedPrizeMultiplier() / (long)playerBets.getType().getDivisor());
            totalPrizes += playerWinnings2.getWinnings();
            totalFourthToSeventh += playerWinnings2.getWinnings();
            winnings.add(playerWinnings2);
        }
        if (!tiers.get((Object)PrizeTier.FIFTH).isEmpty()) {
            prizeForTier.put(PrizeTier.FIFTH, pricePerBet * (long)PrizeTier.FIFTH.getFixedPrizeMultiplier());
        }
        for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)PrizeTier.FIFTH)) {
            playerBets = pair.getFirst();
            playerWinnings2 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), PrizeTier.FIFTH, playerBets, pair.getSecond(), pricePerBet * (long)PrizeTier.FIFTH.getFixedPrizeMultiplier() / (long)playerBets.getType().getDivisor());
            totalPrizes += playerWinnings2.getWinnings();
            totalFourthToSeventh += playerWinnings2.getWinnings();
            winnings.add(playerWinnings2);
        }
        if (!tiers.get((Object)PrizeTier.FOURTH).isEmpty()) {
            prizeForTier.put(PrizeTier.FOURTH, pricePerBet * (long)PrizeTier.FOURTH.getFixedPrizeMultiplier());
        }
        for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)PrizeTier.FOURTH)) {
            playerBets = pair.getFirst();
            playerWinnings2 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), PrizeTier.FOURTH, playerBets, pair.getSecond(), pricePerBet * (long)PrizeTier.FOURTH.getFixedPrizeMultiplier() / (long)playerBets.getType().getDivisor());
            totalPrizes += playerWinnings2.getWinnings();
            totalFourthToSeventh += playerWinnings2.getWinnings();
            winnings.add(playerWinnings2);
        }
        long totalRemaining = Math.min(maxTopPlacesPrize, Math.max(this.lowestTopPlacesPrize, totalPrize - totalFourthToSeventh));
        boolean thirdPlaceEmpty = tiers.get((Object)PrizeTier.THIRD).isEmpty();
        boolean secondPlaceEmpty = tiers.get((Object)PrizeTier.SECOND).isEmpty();
        boolean firstPlaceEmpty = tiers.get((Object)PrizeTier.FIRST).isEmpty();
        double thirdTierWeightedWinners = Math.max(1.0, tiers.get((Object)PrizeTier.THIRD).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum());
        double secondTierWeightedWinners = Math.max(1.0, tiers.get((Object)PrizeTier.SECOND).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()) * 2.6;
        double totalWeightedWinners = thirdTierWeightedWinners + secondTierWeightedWinners;
        double carryOverPortion = 0.0;
        double thirdPortion = thirdTierWeightedWinners / totalWeightedWinners * 0.55;
        if (thirdPortion > 0.4) {
            carryOverPortion += thirdPortion - 0.4;
            thirdPortion = 0.4;
        }
        if ((secondPortion = secondTierWeightedWinners / totalWeightedWinners * 0.55) > 0.4) {
            carryOverPortion += secondPortion - 0.4;
            secondPortion = 0.4;
        } else if (secondPortion < 0.15) {
            carryOverPortion -= 0.15 - secondPortion;
            secondPortion = 0.15;
        }
        long carryOverNext = (long)Math.floor((double)totalRemaining * carryOverPortion);
        long thirdTierPrizeTotal = (long)Math.floor((double)totalRemaining * thirdPortion);
        if (!thirdPlaceEmpty) {
            long thirdTierPrize = (long)Math.floor((double)thirdTierPrizeTotal / Math.max(1.0, tiers.get((Object)PrizeTier.THIRD).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()));
            prizeForTier.put(PrizeTier.THIRD, thirdTierPrize);
            long thirdTierTotal = 0L;
            for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)PrizeTier.THIRD)) {
                PlayerBets playerBets2 = pair.getFirst();
                PlayerWinnings playerWinnings3 = new PlayerWinnings(playerBets2.getName(), playerBets2.getPlayer(), PrizeTier.THIRD, playerBets2, pair.getSecond(), thirdTierPrize / (long)playerBets2.getType().getDivisor());
                totalPrizes += playerWinnings3.getWinnings();
                thirdTierTotal += playerWinnings3.getWinnings();
                winnings.add(playerWinnings3);
            }
            if (thirdTierPrize > thirdTierTotal) {
                carryOverNext += thirdTierPrize - thirdTierTotal;
            }
        } else if (firstPlaceEmpty && secondPlaceEmpty) {
            carryOverNext += thirdTierPrizeTotal;
        }
        long secondTierPrizeTotal = (long)Math.floor((double)totalRemaining * secondPortion);
        if (!secondPlaceEmpty) {
            if (thirdPlaceEmpty) {
                secondTierPrizeTotal = firstPlaceEmpty ? (secondTierPrizeTotal += thirdTierPrizeTotal) : (secondTierPrizeTotal += (long)((double)thirdTierPrizeTotal * 0.25));
            }
            long secondTierPrize = (long)Math.floor((double)secondTierPrizeTotal / Math.max(1.0, tiers.get((Object)PrizeTier.SECOND).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()));
            prizeForTier.put(PrizeTier.SECOND, secondTierPrize);
            long secondTierTotal = 0L;
            for (Pair pair : tiers.get((Object)PrizeTier.SECOND)) {
                PlayerBets playerBets3 = (PlayerBets)pair.getFirst();
                PlayerWinnings playerWinnings4 = new PlayerWinnings(playerBets3.getName(), playerBets3.getPlayer(), PrizeTier.SECOND, playerBets3, (WinningCombination)pair.getSecond(), secondTierPrize / (long)playerBets3.getType().getDivisor());
                totalPrizes += playerWinnings4.getWinnings();
                secondTierTotal += playerWinnings4.getWinnings();
                winnings.add(playerWinnings4);
            }
            if (secondTierPrize > secondTierTotal) {
                carryOverNext += secondTierPrize - secondTierTotal;
            }
        } else {
            carryOverNext += secondTierPrizeTotal;
        }
        long firstTierPrizeTotal = (long)Math.floor((double)totalRemaining * 0.45);
        if (!firstPlaceEmpty) {
            if (thirdPlaceEmpty) {
                firstTierPrizeTotal = secondPlaceEmpty ? (firstTierPrizeTotal += thirdTierPrizeTotal) : (firstTierPrizeTotal += (long)((double)thirdTierPrizeTotal * 0.75));
            }
            long firstTierPrize = (long)Math.floor((double)firstTierPrizeTotal / Math.max(1.0, tiers.get((Object)PrizeTier.FIRST).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()));
            prizeForTier.put(PrizeTier.FIRST, firstTierPrize);
            long firstTierTotal = 0L;
            for (Pair pair : tiers.get((Object)PrizeTier.FIRST)) {
                PlayerBets playerBets4 = (PlayerBets)pair.getFirst();
                PlayerWinnings playerWinnings6 = new PlayerWinnings(playerBets4.getName(), playerBets4.getPlayer(), PrizeTier.FIRST, playerBets4, (WinningCombination)pair.getSecond(), firstTierPrize / (long)playerBets4.getType().getDivisor());
                totalPrizes += playerWinnings6.getWinnings();
                firstTierTotal += playerWinnings6.getWinnings();
                winnings.add(playerWinnings6);
            }
            if (firstTierPrize > firstTierTotal) {
                carryOverNext += firstTierPrize - firstTierTotal;
            }
        } else {
            carryOverNext += firstTierPrizeTotal;
        }
        PrizeTier[] prizeTiers = PrizeTier.values();
        long prize = firstTierPrizeTotal;
        boolean bl = false;
        while (var51_45 < prizeTiers.length - 1) {
            long lowerPrize;
            PrizeTier prizeTier = prizeTiers[var51_45];
            PrizeTier prizeTier2 = prizeTiers[var51_45 + true];
            Long tierPrize = (Long)prizeForTier.get((Object)prizeTier);
            if (tierPrize != null) {
                prize = tierPrize;
            }
            if ((lowerPrize = prizeForTier.getOrDefault((Object)prizeTier2, 0L).longValue()) * (long)prizeTier.getMinimumMultiplierFromLast() > prize) {
                long newLowerPrize = prize / (long)prizeTier.getMinimumMultiplierFromLast();
                prizeForTier.put(prizeTier2, newLowerPrize);
                long prizeMoneyRemoved = 0L;
                for (int u2 = 0; u2 < winnings.size(); ++u2) {
                    PlayerWinnings playerWinnings7 = (PlayerWinnings)winnings.get(u2);
                    if (!playerWinnings7.getTier().equals((Object)prizeTier2)) continue;
                    long currentPrize = playerWinnings7.getWinnings();
                    long newPrize = newLowerPrize / (long)playerWinnings7.getWinningBet(this.bets).getType().getDivisor();
                    prizeMoneyRemoved += currentPrize - newPrize;
                    winnings.set(u2, playerWinnings7.winnings(newPrize));
                }
                if (prizeTier2.isVariableTier()) {
                    carryOverNext += prizeMoneyRemoved;
                }
                totalPrizes -= prizeMoneyRemoved;
            }
            ++var51_45;
        }
        prizeForTier.replaceAll((k, v) -> MathUtils.followRoundDown(pricePerBet, v));
        boolean bl2 = false;
        while (var51_47 < winnings.size()) {
            long rounded;
            PlayerWinnings playerWinnings22 = (PlayerWinnings)winnings.get((int)var51_47);
            long l = playerWinnings22.getWinnings();
            if (l > (rounded = (Long)prizeForTier.get((Object)playerWinnings22.getTier()) / (long)playerWinnings22.getWinningBet(this.bets).getType().getDivisor())) {
                winnings.set((int)var51_47, playerWinnings22.winnings(rounded));
                carryOverNext += l - rounded;
            }
            ++var51_47;
        }
        if (this.instance == null || this.instance.retainLowestPrizeForTier) {
            void var51_49;
            prizeForTier.replaceAll((k, v) -> {
                if (v <= 0L) {
                    return v;
                }
                return Math.max(v, this.instance.pricePerBet * (long)k.getFixedPrizeMultiplier());
            });
            boolean bl3 = false;
            while (var51_49 < winnings.size()) {
                long rounded;
                PlayerWinnings playerWinnings5 = (PlayerWinnings)winnings.get((int)var51_49);
                long l = playerWinnings5.getWinnings();
                if (l < (rounded = (Long)prizeForTier.get((Object)playerWinnings5.getTier()) / (long)playerWinnings5.getWinningBet(this.bets).getType().getDivisor())) {
                    winnings.set((int)var51_49, playerWinnings5.winnings(rounded));
                    carryOverNext -= rounded - l;
                }
                ++var51_49;
            }
            carryOverNext = Math.max(0L, carryOverNext);
        }
        winnings.sort(Comparator.comparing(playerWinnings -> playerWinnings.getTier()).thenComparing(playerWinnings -> playerWinnings.getWinningBet(this.bets)));
        switch (carryOverMode) {
            case ONLY_TICKET_SALES: {
                long l = this.carryOverFund + (long)Math.floor((double)this.getTotalBets() * (1.0 - taxPercentage));
                l = Math.round((double)l * ((double)carryOverNext / (double)totalRemaining));
                carryOverNext = Math.max(0L, Math.min(maxTopPlacesPrize - this.lowestTopPlacesPrize, l));
                break;
            }
        }
        return new CompletedLotterySixGame(this.gameId, this.scheduledDateTime, this.gameNumber, this.specialName, winningNumbers, newNumberStats, pricePerBet, prizeForTier, winnings, this.bets, totalPrizes, carryOverNext, lotteriesFunds);
    }

    private synchronized CompletedLotterySixGame completeWithHkjcPrizeCalculation(long pricePerBet, long maxTopPlacesPrize, double taxPercentage, CarryOverMode carryOverMode, Map<PrizeTier, List<Pair<PlayerBets, WinningCombination>>> tiers, WinningNumbers winningNumbers, Map<Integer, NumberStatistics> newNumberStats) {
        int u;
        double secondPortion;
        PrizeTier[] prizeTiers = PrizeTier.values();
        long totalBetsFund = this.getTotalBets();
        long totalFund = (long)Math.floor((double)totalBetsFund * (1.0 - taxPercentage));
        long totalFundForFourthToSeventh = (long)Math.floor((double)totalFund * 0.6);
        long totalFourthToSeventhFundRequired = 0L;
        long lotteriesFunds = totalBetsFund - totalFund;
        EnumMap<PrizeTier, Long> portionsFourthToSeventh = new EnumMap<PrizeTier, Long>(PrizeTier.class);
        EnumMap<PrizeTier, Double> unitsFourthToSeventh = new EnumMap<PrizeTier, Double>(PrizeTier.class);
        for (Map.Entry<PrizeTier, List<Pair<PlayerBets, WinningCombination>>> entry : tiers.entrySet()) {
            PrizeTier prizeTier = entry.getKey();
            if (prizeTier.isVariableTier() || entry.getValue().isEmpty()) continue;
            double unit = entry.getValue().stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum();
            unitsFourthToSeventh.put(prizeTier, unit);
            long portion = Math.round(BigDecimal.valueOf(unit).multiply(BigDecimal.valueOf(pricePerBet)).multiply(BigDecimal.valueOf(prizeTier.getFixedPrizeMultiplier())).doubleValue());
            totalFourthToSeventhFundRequired += portion;
            portionsFourthToSeventh.put(prizeTier, portion);
        }
        boolean carryOverRequiredForFourthToSeventh = totalFourthToSeventhFundRequired > totalFundForFourthToSeventh;
        long total = totalFourthToSeventhFundRequired;
        long bigTotalFund = carryOverRequiredForFourthToSeventh ? totalFundForFourthToSeventh + this.carryOverFund : totalFundForFourthToSeventh;
        EnumMap<PrizeTier, Long> maxPrizeInTier = new EnumMap<PrizeTier, Long>(PrizeTier.class);
        for (Map.Entry entry : portionsFourthToSeventh.entrySet()) {
            PrizeTier prizeTier = (PrizeTier)((Object)entry.getKey());
            if (prizeTier.isVariableTier()) continue;
            Double unit = (Double)unitsFourthToSeventh.get((Object)prizeTier);
            if (unit == null) {
                maxPrizeInTier.put(prizeTier, 0L);
                continue;
            }
            maxPrizeInTier.put(prizeTier, (long)Math.floor((double)bigTotalFund * ((double)((Long)entry.getValue()).longValue() / (double)total) / unit));
        }
        EnumMap<PrizeTier, Long> prizeForTier = new EnumMap<PrizeTier, Long>(PrizeTier.class);
        ArrayList<PlayerWinnings> winnings = new ArrayList<PlayerWinnings>();
        long totalPrizes = 0L;
        long totalFourthToSeventh = 0L;
        for (int i = prizeTiers.length - 1; i >= 3; --i) {
            PrizeTier prizeTier = prizeTiers[i];
            if (tiers.get((Object)prizeTier).isEmpty()) continue;
            long prizePerBetForTier = Math.max(0L, Math.min(pricePerBet * (long)prizeTier.getFixedPrizeMultiplier(), (Long)maxPrizeInTier.get((Object)prizeTier)));
            prizeForTier.put(prizeTier, prizePerBetForTier);
            for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)prizeTier)) {
                PlayerBets playerBets = pair.getFirst();
                PlayerWinnings playerWinnings3 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), prizeTier, playerBets, pair.getSecond(), prizePerBetForTier / (long)playerBets.getType().getDivisor());
                totalPrizes += playerWinnings3.getWinnings();
                totalFourthToSeventh += playerWinnings3.getWinnings();
                winnings.add(playerWinnings3);
            }
        }
        long carryOverRemaining = carryOverRequiredForFourthToSeventh ? this.carryOverFund - (long)Math.floor(totalFourthToSeventh - totalFundForFourthToSeventh) : this.carryOverFund;
        long totalRemaining = Math.max(0L, totalFund - Math.min(totalFourthToSeventh, totalFundForFourthToSeventh));
        long lowestThirdTierPrize = 0L;
        for (int i = 3; i < prizeTiers.length; ++i) {
            PrizeTier prizeTier = prizeTiers[i];
            Long prize = (Long)prizeForTier.get((Object)prizeTier);
            if (prize == null) continue;
            lowestThirdTierPrize = prize;
            for (int u2 = i - 1; u2 >= 2; --u2) {
                lowestThirdTierPrize *= (long)prizeTiers[u2].getMinimumMultiplierFromLast();
            }
            break;
        }
        long lowestSecondTierPrize = lowestThirdTierPrize * (long)PrizeTier.SECOND.getMinimumMultiplierFromLast();
        boolean thirdPlaceEmpty = tiers.get((Object)PrizeTier.THIRD).isEmpty();
        boolean secondPlaceEmpty = tiers.get((Object)PrizeTier.SECOND).isEmpty();
        boolean firstPlaceEmpty = tiers.get((Object)PrizeTier.FIRST).isEmpty();
        double thirdTierWeightedWinners = Math.max(1.0, tiers.get((Object)PrizeTier.THIRD).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum());
        double secondTierWeightedWinners = Math.max(1.0, tiers.get((Object)PrizeTier.SECOND).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()) * 2.6;
        double totalWeightedWinners = thirdTierWeightedWinners + secondTierWeightedWinners;
        double carryOverPortion = 0.0;
        double thirdPortion = thirdTierWeightedWinners / totalWeightedWinners * 0.55;
        if (thirdPortion > 0.4) {
            carryOverPortion += thirdPortion - 0.4;
            thirdPortion = 0.4;
        }
        if ((secondPortion = secondTierWeightedWinners / totalWeightedWinners * 0.55) > 0.4) {
            carryOverPortion += secondPortion - 0.4;
            secondPortion = 0.4;
        } else if (secondPortion < 0.15) {
            carryOverPortion -= 0.15 - secondPortion;
            secondPortion = 0.15;
        }
        long carryOverNext = (long)Math.floor((double)totalRemaining * carryOverPortion);
        long thirdTierPrizeTotal = (long)Math.floor((double)totalRemaining * thirdPortion);
        if (!thirdPlaceEmpty) {
            long thirdTierPrize = (long)Math.floor((double)thirdTierPrizeTotal / Math.max(1.0, tiers.get((Object)PrizeTier.THIRD).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()));
            if (thirdTierPrize < lowestThirdTierPrize) {
                carryOverRemaining -= lowestThirdTierPrize - thirdTierPrize;
                thirdTierPrize = lowestThirdTierPrize;
                if (carryOverRemaining < 0L) {
                    thirdTierPrize += carryOverRemaining;
                    carryOverRemaining = 0L;
                }
            }
            prizeForTier.put(PrizeTier.THIRD, thirdTierPrize);
            long thirdTierTotal = 0L;
            for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)PrizeTier.THIRD)) {
                PlayerBets playerBets = pair.getFirst();
                PlayerWinnings playerWinnings2 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), PrizeTier.THIRD, playerBets, pair.getSecond(), thirdTierPrize / (long)playerBets.getType().getDivisor());
                totalPrizes += playerWinnings2.getWinnings();
                thirdTierTotal += playerWinnings2.getWinnings();
                winnings.add(playerWinnings2);
            }
            if (thirdTierPrize > thirdTierTotal) {
                carryOverNext += thirdTierPrize - thirdTierTotal;
            }
        } else if (firstPlaceEmpty && secondPlaceEmpty) {
            carryOverNext += thirdTierPrizeTotal;
        }
        long secondTierPrizeTotal = (long)Math.floor((double)totalRemaining * secondPortion);
        if (!secondPlaceEmpty) {
            long secondTierPrize;
            if (thirdPlaceEmpty) {
                secondTierPrizeTotal = firstPlaceEmpty ? (secondTierPrizeTotal += thirdTierPrizeTotal) : (secondTierPrizeTotal += (long)((double)thirdTierPrizeTotal * 0.25));
            }
            if ((secondTierPrize = (long)Math.floor((double)secondTierPrizeTotal / Math.max(1.0, tiers.get((Object)PrizeTier.SECOND).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()))) < lowestSecondTierPrize) {
                carryOverRemaining -= lowestSecondTierPrize - secondTierPrize;
                secondTierPrize = lowestSecondTierPrize;
            }
            if (carryOverRemaining < 0L) {
                secondTierPrize += carryOverRemaining;
                carryOverRemaining = 0L;
            }
            prizeForTier.put(PrizeTier.SECOND, secondTierPrize);
            long secondTierTotal = 0L;
            for (Pair pair : tiers.get((Object)PrizeTier.SECOND)) {
                PlayerBets playerBets = (PlayerBets)pair.getFirst();
                PlayerWinnings playerWinnings5 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), PrizeTier.SECOND, playerBets, (WinningCombination)pair.getSecond(), secondTierPrize / (long)playerBets.getType().getDivisor());
                totalPrizes += playerWinnings5.getWinnings();
                secondTierTotal += playerWinnings5.getWinnings();
                winnings.add(playerWinnings5);
            }
            if (secondTierPrize > secondTierTotal) {
                carryOverNext += secondTierPrize - secondTierTotal;
            }
        } else {
            carryOverNext += secondTierPrizeTotal;
        }
        long firstTierPrizeTotal = Math.min(maxTopPlacesPrize, carryOverRemaining + Math.max(this.lowestTopPlacesPrize, (long)Math.floor((double)totalRemaining * 0.45)));
        long difference = Math.max(0L, this.lowestTopPlacesPrize - (long)Math.floor((double)totalRemaining * 0.45));
        long firstTierCarryOver = 0L;
        if (!firstPlaceEmpty) {
            if (thirdPlaceEmpty) {
                firstTierPrizeTotal = secondPlaceEmpty ? (firstTierPrizeTotal += thirdTierPrizeTotal) : (firstTierPrizeTotal += (long)((double)thirdTierPrizeTotal * 0.75));
            }
            long firstTierPrize = (long)Math.floor((double)firstTierPrizeTotal / Math.max(1.0, tiers.get((Object)PrizeTier.FIRST).stream().mapToDouble(each -> ((PlayerBets)each.getFirst()).getType().getUnit()).sum()));
            prizeForTier.put(PrizeTier.FIRST, firstTierPrize);
            long firstTierTotal = 0L;
            for (Pair<PlayerBets, WinningCombination> pair : tiers.get((Object)PrizeTier.FIRST)) {
                PlayerBets playerBets = pair.getFirst();
                PlayerWinnings playerWinnings6 = new PlayerWinnings(playerBets.getName(), playerBets.getPlayer(), PrizeTier.FIRST, playerBets, pair.getSecond(), firstTierPrize / (long)playerBets.getType().getDivisor());
                totalPrizes += playerWinnings6.getWinnings();
                firstTierTotal += playerWinnings6.getWinnings();
                winnings.add(playerWinnings6);
            }
            if (firstTierPrize > firstTierTotal) {
                firstTierCarryOver += firstTierPrize - firstTierTotal;
            }
        } else {
            firstTierCarryOver += firstTierPrizeTotal;
        }
        switch (carryOverMode) {
            case ONLY_TICKET_SALES: {
                carryOverNext += Math.max(0L, firstTierCarryOver - difference);
                break;
            }
            case PRIZE_AND_SALES: {
                carryOverNext += firstTierCarryOver;
                break;
            }
            default: {
                throw new RuntimeException("Unknown carry over mode: " + (Object)((Object)carryOverMode));
            }
        }
        long prize = firstTierPrizeTotal;
        for (int i = 0; i < prizeTiers.length - 1; ++i) {
            long lowerPrize;
            PrizeTier prizeTier = prizeTiers[i];
            PrizeTier lowerTier = prizeTiers[i + 1];
            Long tierPrize = (Long)prizeForTier.get((Object)prizeTier);
            if (tierPrize != null) {
                prize = tierPrize;
            }
            if ((lowerPrize = prizeForTier.getOrDefault((Object)lowerTier, 0L).longValue()) * (long)prizeTier.getMinimumMultiplierFromLast() <= prize) continue;
            long newLowerPrize = prize / (long)prizeTier.getMinimumMultiplierFromLast();
            prizeForTier.put(lowerTier, newLowerPrize);
            long prizeMoneyRemoved = 0L;
            for (int u3 = 0; u3 < winnings.size(); ++u3) {
                PlayerWinnings playerWinnings7 = (PlayerWinnings)winnings.get(u3);
                if (!playerWinnings7.getTier().equals((Object)lowerTier)) continue;
                long currentPrize = playerWinnings7.getWinnings();
                long newPrize = newLowerPrize / (long)playerWinnings7.getWinningBet(this.bets).getType().getDivisor();
                prizeMoneyRemoved += currentPrize - newPrize;
                winnings.set(u3, playerWinnings7.winnings(newPrize));
            }
            carryOverNext += prizeMoneyRemoved;
            totalPrizes -= prizeMoneyRemoved;
        }
        prizeForTier.replaceAll((k, v) -> MathUtils.followRoundDown(pricePerBet, v));
        for (u = 0; u < winnings.size(); ++u) {
            long rounded;
            PlayerWinnings playerWinnings2 = (PlayerWinnings)winnings.get(u);
            long currentPrize = playerWinnings2.getWinnings();
            if (currentPrize <= (rounded = (Long)prizeForTier.get((Object)playerWinnings2.getTier()) / (long)playerWinnings2.getWinningBet(this.bets).getType().getDivisor())) continue;
            winnings.set(u, playerWinnings2.winnings(rounded));
            carryOverNext += currentPrize - rounded;
        }
        if (this.instance == null || this.instance.retainLowestPrizeForTier) {
            prizeForTier.replaceAll((k, v) -> {
                if (v <= 0L) {
                    return v;
                }
                if (k.equals((Object)PrizeTier.FIRST)) {
                    return Math.max(v, this.instance.lowestTopPlacesPrize);
                }
                return Math.max(v, this.instance.pricePerBet * (long)k.getFixedPrizeMultiplier());
            });
            for (u = 0; u < winnings.size(); ++u) {
                long rounded;
                PlayerWinnings playerWinnings3 = (PlayerWinnings)winnings.get(u);
                long currentPrize = playerWinnings3.getWinnings();
                if (currentPrize >= (rounded = (Long)prizeForTier.get((Object)playerWinnings3.getTier()) / (long)playerWinnings3.getWinningBet(this.bets).getType().getDivisor())) continue;
                winnings.set(u, playerWinnings3.winnings(rounded));
                carryOverNext -= rounded - currentPrize;
            }
            carryOverNext = Math.max(0L, carryOverNext);
        }
        winnings.sort(Comparator.comparing(playerWinnings -> playerWinnings.getTier()).thenComparing(playerWinnings -> playerWinnings.getWinningBet(this.bets)));
        return new CompletedLotterySixGame(this.gameId, this.scheduledDateTime, this.gameNumber, this.specialName, winningNumbers, newNumberStats, pricePerBet, prizeForTier, winnings, this.bets, totalPrizes, carryOverNext, lotteriesFunds);
    }
}

