/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import com.loohp.lotterysix.game.objects.BetUnitType;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;

public class PlayerBets
implements Comparable<PlayerBets> {
    public static final Comparator<PlayerBets> COMPARATOR = Comparator.comparing(PlayerBets::getTimePlaced).thenComparing(PlayerBets::getNanoTime).thenComparing(PlayerBets::getBetId);
    private final UUID betId;
    private final String name;
    private final UUID player;
    private final long timePlaced;
    private final long nanoTime;
    private final long bet;
    private final BetUnitType type;
    private final BetNumbers chosenNumbers;
    private final int multipleDraw;
    private final int drawsRemaining;

    private PlayerBets(String name, UUID player, long timePlaced, long nanoTime, long bet, BetUnitType type, BetNumbers chosenNumbers, int multipleDraw, int drawsRemaining) {
        this.name = name;
        this.timePlaced = timePlaced;
        this.nanoTime = nanoTime;
        this.multipleDraw = multipleDraw;
        this.drawsRemaining = drawsRemaining;
        this.betId = UUID.randomUUID();
        this.player = player;
        this.bet = bet;
        this.type = type;
        this.chosenNumbers = chosenNumbers;
    }

    public PlayerBets(String name, UUID player, long timePlaced, long nanoTime, long bet, BetUnitType type, BetNumbers chosenNumbers, int multipleDraw) {
        this(name, player, timePlaced, nanoTime, bet, type, chosenNumbers, multipleDraw, multipleDraw);
    }

    public UUID getBetId() {
        return this.betId;
    }

    public String getName() {
        return this.name;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public long getTimePlaced() {
        return this.timePlaced;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public long getBet() {
        return this.bet;
    }

    public BetUnitType getType() {
        return this.type;
    }

    public BetNumbers getChosenNumbers() {
        return this.chosenNumbers;
    }

    public boolean isMultipleDraw() {
        return this.multipleDraw > 1;
    }

    public int getMultipleDraw() {
        return this.isMultipleDraw() ? this.multipleDraw : 1;
    }

    public int getDrawsRemaining() {
        return this.isMultipleDraw() ? this.drawsRemaining : 1;
    }

    public PlayerBets decrementDrawsRemaining() {
        int decremented;
        if (this.isMultipleDraw() && (decremented = Math.max(0, this.drawsRemaining - 1)) < this.drawsRemaining) {
            return new PlayerBets(this.name, this.player, this.timePlaced, this.nanoTime, this.bet, this.type, this.chosenNumbers, this.multipleDraw, decremented);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerBets that = (PlayerBets)o;
        return this.timePlaced == that.timePlaced && this.nanoTime == that.nanoTime && this.bet == that.bet && this.multipleDraw == that.multipleDraw && this.drawsRemaining == that.drawsRemaining && Objects.equals(this.betId, that.betId) && Objects.equals(this.name, that.name) && Objects.equals(this.player, that.player) && this.type == that.type && Objects.equals(this.chosenNumbers, that.chosenNumbers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.betId, this.name, this.player, this.timePlaced, this.nanoTime, this.bet, this.type, this.chosenNumbers, this.multipleDraw, this.drawsRemaining});
    }

    @Override
    public int compareTo(PlayerBets o) {
        return COMPARATOR.compare(this, o);
    }
}

