/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.org.paukov.combinatorics3;

import com.loohp.lotterysix.libs.org.paukov.combinatorics3.CartesianProductGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CartesianProductIterator<T>
implements Iterator<List<T>> {
    private final CartesianProductGenerator<T> generator;
    private final int[] indices;
    private List<T> current;
    private int nextIndex;
    private int index = 0;
    private boolean hasEmptyList = false;

    CartesianProductIterator(CartesianProductGenerator<T> generator) {
        this.generator = generator;
        int vectorSize = this.generator.originalVector.size();
        this.nextIndex = vectorSize - 1;
        this.indices = new int[vectorSize];
        for (int i = 0; i < vectorSize; ++i) {
            this.hasEmptyList = this.hasEmptyList || this.generator.originalVector.get(i).size() == 0;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.hasEmptyList && this.nextIndex >= 0;
    }

    @Override
    public List<T> next() {
        if (this.index == 0) {
            return this.generateCartesianProduct();
        }
        if (this.nextIndex < 0) {
            throw new RuntimeException("No more cartesian product.");
        }
        int n = this.nextIndex;
        this.indices[n] = this.indices[n] + 1;
        for (int i = this.nextIndex + 1; i < this.generator.originalVector.size(); ++i) {
            this.indices[i] = 0;
        }
        return this.generateCartesianProduct();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CartesianProductIterator=[#" + this.index + ", " + this.current + "]";
    }

    private List<T> generateCartesianProduct() {
        this.current = new ArrayList<T>();
        for (int i = 0; i < this.generator.originalVector.size(); ++i) {
            this.current.add(this.generator.originalVector.get(i).get(this.indices[i]));
        }
        this.checkIfHasNextCartesianProduct();
        ++this.index;
        return this.current;
    }

    private void checkIfHasNextCartesianProduct() {
        this.nextIndex = this.generator.originalVector.size() - 1;
        while (this.nextIndex >= 0 && this.indices[this.nextIndex] + 1 >= this.generator.originalVector.get(this.nextIndex).size()) {
            --this.nextIndex;
        }
    }
}

