/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.reflect.accessor;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Accessor {

    public static class QueryBuilder {
        private final Class<?> clazz;
        private Type type = null;
        private String name = "";
        private Class<?>[] paramTypes = new Class[0];

        QueryBuilder(@NotNull Class<?> clazz) {
            this.clazz = clazz;
        }

        @Contract(value="_ -> new", pure=true)
        @NotNull
        public static QueryBuilder builder(@NotNull Class<?> clazz) {
            return new QueryBuilder(clazz);
        }

        @NotNull
        public static QueryBuilder builder(@NotNull Query query) {
            return QueryBuilder.builder(query.clazz).type(query.type).name(query.name).paramTypes(query.paramTypes);
        }

        public QueryBuilder name(@NotNull String name) {
            this.name = name;
            return this;
        }

        public QueryBuilder type(@NotNull Type type) {
            this.type = type;
            return this;
        }

        public QueryBuilder paramTypes(Class<?> ... paramTypes) {
            this.paramTypes = paramTypes;
            return this;
        }

        public Query build() {
            if (this.type == null) {
                if (!this.name.isEmpty()) {
                    throw new NullPointerException("Type cannot be null");
                }
                this.type = Type.METHOD;
            }
            return new Query(this.clazz, this.type, this.name, this.paramTypes);
        }
    }

    public static class Query {
        private final Class<?> clazz;
        private final Type type;
        private final String name;
        private final Class<?>[] paramTypes;

        private Query(Class<?> clazz, @NotNull Type type, String name, Class<?>[] paramTypes) {
            this.clazz = clazz;
            this.type = type;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        @NotNull
        public Class<?> clazz() {
            return this.clazz;
        }

        @NotNull
        public Type type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public Class<?>[] paramTypes() {
            return this.paramTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query query = (Query)o;
            return Objects.equals(this.clazz, query.clazz) && this.type == query.type && Objects.equals(this.name, query.name) && Arrays.equals(this.paramTypes, query.paramTypes);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.clazz, this.type, this.name});
            result = 31 * result + Arrays.hashCode(this.paramTypes);
            return result;
        }

        public String toString() {
            return "Query{clazz=" + this.clazz + ", type=" + (Object)((Object)this.type) + (this.name.isEmpty() ? "" : ", name='" + this.name + '\'') + (this.paramTypes.length == 0 ? "" : ", paramTypes=" + Arrays.toString(this.paramTypes)) + '}';
        }
    }

    public static enum Type {
        FIELD,
        METHOD;

    }
}

