/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.placeholderapi;

import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.libs.com.cronutils.model.Cron;
import com.loohp.lotterysix.utils.CronUtils;
import com.loohp.lotterysix.utils.LotteryUtils;
import com.loohp.lotterysix.utils.StringUtils;
import java.time.ZonedDateTime;
import java.util.Date;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class LotteryPlaceholders
extends PlaceholderExpansion {
    private static String asString(Object input, boolean isMonetaryValue) {
        if (input == null) {
            return "N/A";
        }
        if (isMonetaryValue) {
            return StringUtils.formatComma((Long)input);
        }
        if (input instanceof PrizeTier) {
            return LotterySixPlugin.getInstance().tierNames.get(input);
        }
        return input.toString();
    }

    public String getAuthor() {
        return String.join((CharSequence)", ", LotterySixPlugin.plugin.getDescription().getAuthors());
    }

    public String getIdentifier() {
        return "lotterysix";
    }

    public String getVersion() {
        return LotterySixPlugin.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String getRequiredPlugin() {
        return LotterySixPlugin.plugin.getName();
    }

    public String onRequest(OfflinePlayer offlineplayer, String identifier) {
        if (identifier.startsWith("currentgame_")) {
            if (LotterySixPlugin.getInstance().getCurrentGame() == null || LotterySixPlugin.getInstance().isGameLocked() && LotterySixPlugin.getInstance().placeholderAPIHideResultsWhileGameIsLocked) {
                String str = "{" + identifier.substring("currentgame_".length()) + "}";
                return LotteryUtils.formatPlaceholders(offlineplayer, str, LotterySixPlugin.getInstance(), (PlayableLotterySixGame)null);
            }
            String str = "{" + identifier.substring("currentgame_".length()) + "}";
            return LotteryUtils.formatPlaceholders(offlineplayer, str, LotterySixPlugin.getInstance(), LotterySixPlugin.getInstance().getCurrentGame());
        }
        if (identifier.startsWith("lastgame_")) {
            if (LotterySixPlugin.getInstance().getCompletedGames().isEmpty() || LotterySixPlugin.getInstance().isGameLocked() && LotterySixPlugin.getInstance().placeholderAPIHideResultsWhileGameIsLocked) {
                String str = "{" + identifier.substring("lastgame_".length()) + "}";
                return LotteryUtils.formatPlaceholders(offlineplayer, str, LotterySixPlugin.getInstance(), (CompletedLotterySixGame)null);
            }
            String str = "{" + identifier.substring("lastgame_".length()) + "}";
            return LotteryUtils.formatPlaceholders(offlineplayer, str, LotterySixPlugin.getInstance(), LotterySixPlugin.getInstance().getCompletedGames().get(0));
        }
        if (identifier.startsWith("preference_")) {
            PlayerPreferenceKey key = PlayerPreferenceKey.fromKey(identifier.substring("preference_".length()));
            if (key == null) {
                return "";
            }
            return LotteryPlaceholders.asString(LotterySixPlugin.getInstance().getLotteryPlayerManager().getLotteryPlayer(offlineplayer.getUniqueId()).getPreference(key), key.isMonetaryValue());
        }
        if (identifier.startsWith("stats_")) {
            PlayerStatsKey key = PlayerStatsKey.fromKey(identifier.substring("stats_".length()));
            if (key == null) {
                return "";
            }
            return LotteryPlaceholders.asString(LotterySixPlugin.getInstance().getLotteryPlayerManager().getLotteryPlayer(offlineplayer.getUniqueId()).getStats(key), key.isMonetaryValue());
        }
        if (identifier.startsWith("scheduler_")) {
            Cron cron = LotterySixPlugin.getInstance().runInterval;
            if (cron == null) {
                return LotteryPlaceholders.asString(null, false);
            }
            String type = identifier.substring("scheduler_".length());
            if (type.equalsIgnoreCase("interval")) {
                return CronUtils.getDescriptor(LotterySixPlugin.getInstance().locale).describe(cron);
            }
            if (type.equalsIgnoreCase("next")) {
                ZonedDateTime dateTime = CronUtils.getNextExecution(cron, CronUtils.getNow(LotterySixPlugin.getInstance().timezone));
                if (dateTime == null) {
                    return LotteryPlaceholders.asString(null, false);
                }
                return LotterySixPlugin.getInstance().dateFormat.format(new Date(dateTime.toInstant().toEpochMilli()));
            }
        }
        return null;
    }
}

