/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.proxy.velocity;

import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.LazyCompletedLotterySixGameList;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.PlayerWinnings;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.proxy.velocity.LotterySixVelocity;
import com.loohp.lotterysix.utils.StringUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class DebugVelocity {
    @Subscribe
    public void onSwitch(ServerPostConnectEvent event) {
        LotterySixVelocity.proxyServer.getScheduler().buildTask((Object)LotterySixVelocity.plugin, () -> {
            if (event.getPlayer().getUsername().equals("LOOHP") || event.getPlayer().getUsername().equals("AppLEshakE")) {
                event.getPlayer().sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.RED, "LotterySix (Velocity) " + LotterySixVelocity.plugin.getDescription().getVersion() + " is running!"));
            }
        });
    }

    public static void debugLotteryPlayer(CommandSource sender, String name, UUID uuid, int maxPastGames) {
        int i;
        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.AQUA, "LotterySix Player Info ----"));
        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Name: " + name));
        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "UUID: " + uuid));
        sender.sendMessage((Component)DebugVelocity.m(""));
        long limit = LotterySixVelocity.getInstance().getPlayerBetLimit(uuid);
        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GREEN, "Bet Limit By Permission: " + (limit <= 0L ? "Unlimited" : Long.valueOf(limit))));
        sender.sendMessage((Component)DebugVelocity.m(""));
        LotteryPlayer lotteryPlayer = LotterySixVelocity.getInstance().getLotteryPlayerManager().getLotteryPlayer(uuid);
        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.AQUA, "Preferences ----"));
        for (PlayerPreferenceKey playerPreferenceKey : PlayerPreferenceKey.values()) {
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GREEN, playerPreferenceKey.name() + ": " + lotteryPlayer.getPreference(playerPreferenceKey, playerPreferenceKey.getValueTypeClass())));
        }
        sender.sendMessage((Component)DebugVelocity.m(""));
        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.AQUA, "Stats ----"));
        for (Enum enum_ : PlayerStatsKey.values()) {
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GREEN, enum_.name() + ": " + lotteryPlayer.getStats((PlayerStatsKey)enum_, ((PlayerStatsKey)enum_).getValueTypeClass())));
        }
        sender.sendMessage((Component)DebugVelocity.m(""));
        PlayableLotterySixGame currentGame = LotterySixVelocity.getInstance().getCurrentGame();
        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.AQUA, "Current Round ----"));
        if (currentGame == null) {
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.RED, "There are no active current round"));
        } else {
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Game ID: " + currentGame.getGameId()));
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Game Number: " + currentGame.getGameNumber()));
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Date: " + LotterySixVelocity.getInstance().dateFormat.format(new Date(currentGame.getDatetime()))));
            List<PlayerBets> bets = currentGame.getPlayerBets(uuid);
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GREEN, "Total Bet Placed By Player: $" + StringUtils.formatComma(bets.stream().mapToLong(each -> each.getBet()).sum())));
            sender.sendMessage((Component)DebugVelocity.m(""));
            for (i = 0; i < bets.size(); ++i) {
                PlayerBets playerBets = bets.get(i);
                sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, i + 1 + ". " + playerBets.getChosenNumbers().toFormattedString()));
                sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Bet ID: " + playerBets.getBetId()));
                sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Type: " + playerBets.getChosenNumbers().getType().name()));
                sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Price: $" + StringUtils.formatComma(playerBets.getBet())));
                if (playerBets.isMultipleDraw()) {
                    sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.BLUE, "    Multiple Draws: " + playerBets.getDrawsRemaining() + "/" + playerBets.getMultipleDraw()));
                }
                sender.sendMessage((Component)DebugVelocity.m(""));
            }
        }
        if (maxPastGames > 0) {
            sender.sendMessage((Component)DebugVelocity.m(""));
            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.AQUA, "Past Rounds ----"));
            LazyCompletedLotterySixGameList pastGames = LotterySixVelocity.getInstance().getCompletedGames();
            if (pastGames.isEmpty()) {
                sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.RED, "There are no past games"));
            } else {
                for (i = 0; i < Math.min(pastGames.size(), maxPastGames); ++i) {
                    CompletedLotterySixGame completedLotterySixGame = (CompletedLotterySixGame)pastGames.get(i);
                    sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Game ID: " + completedLotterySixGame.getGameId()));
                    sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Game Number: " + completedLotterySixGame.getGameNumber()));
                    sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Date: " + LotterySixVelocity.getInstance().dateFormat.format(new Date(completedLotterySixGame.getDatetime()))));
                    sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.YELLOW, "Result: " + completedLotterySixGame.getDrawResult().toFormattedString()));
                    sender.sendMessage((Component)DebugVelocity.m(""));
                    List<PlayerWinnings> winningsList = completedLotterySixGame.getSortedPlayerWinnings(uuid);
                    int u = 1;
                    for (PlayerWinnings winnings : winningsList.subList(0, Math.min(50, winningsList.size()))) {
                        sender.sendMessage((Component)DebugVelocity.m(u++ + ". " + winnings.getWinningBet(completedLotterySixGame).getChosenNumbers().toFormattedString()));
                        if (winnings.isCombination(completedLotterySixGame)) {
                            sender.sendMessage((Component)DebugVelocity.m("    (" + winnings.getWinningCombination().toFormattedString() + ")"));
                        }
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    " + winnings.getTier().getShortHand() + " $" + StringUtils.formatComma(winnings.getWinnings())));
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Bet ID: " + winnings.getWinningBetId()));
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Type: " + winnings.getWinningBet(completedLotterySixGame).getChosenNumbers().getType().name()));
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Price: $" + StringUtils.formatComma(winnings.getWinningBet(completedLotterySixGame).getBet())));
                        if (winnings.getWinningBet(completedLotterySixGame).isMultipleDraw()) {
                            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.BLUE, "    Multiple Draws: " + winnings.getWinningBet(completedLotterySixGame).getDrawsRemaining() + "/" + winnings.getWinningBet(completedLotterySixGame).getMultipleDraw()));
                        }
                        sender.sendMessage((Component)DebugVelocity.m(""));
                    }
                    for (PlayerBets bet : completedLotterySixGame.getPlayerBets(uuid)) {
                        if (!winningsList.stream().noneMatch(each -> each.getWinningBet(game).getBetId().equals(bet.getBetId()))) continue;
                        sender.sendMessage((Component)DebugVelocity.m(u++ + ". " + bet.getChosenNumbers().toFormattedString()));
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    No Winnings $0"));
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Bet ID: " + bet.getBetId()));
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Type: " + bet.getChosenNumbers().getType().name()));
                        sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.GOLD, "    Price: $" + StringUtils.formatComma(bet.getBet())));
                        if (bet.isMultipleDraw()) {
                            sender.sendMessage((Component)DebugVelocity.m((TextColor)NamedTextColor.BLUE, "    Multiple Draws: " + bet.getDrawsRemaining() + "/" + bet.getMultipleDraw()));
                        }
                        sender.sendMessage((Component)DebugVelocity.m(""));
                    }
                }
            }
        }
    }

    private static TextComponent m(String m) {
        return LegacyComponentSerializer.legacySection().deserialize(m);
    }

    private static TextComponent m(TextColor c, String m) {
        return (TextComponent)LegacyComponentSerializer.legacySection().deserialize(m).color(c);
    }
}

