/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.utils;

import java.util.Arrays;
import java.util.Optional;

public class ArrayUtils {
    public static <T> T getOrNull(T[] array, int index) {
        if (index < 0 || index >= array.length) {
            return null;
        }
        return array[index];
    }

    public static <T> Optional<T> getOptional(T[] array, int index) {
        if (index < 0 || index >= array.length) {
            return Optional.empty();
        }
        return Optional.of(array[index]);
    }

    public static byte[][] divideArray(byte[] source, int chunksize) {
        int length = (int)Math.ceil((double)source.length / (double)chunksize);
        if (length <= 1) {
            return new byte[][]{source};
        }
        byte[][] ret = new byte[length][];
        int start = 0;
        for (int i = 0; i < ret.length; ++i) {
            int end = start + chunksize;
            ret[i] = Arrays.copyOfRange(source, start, Math.min(end, source.length));
            start += chunksize;
        }
        return ret;
    }
}

