/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.discordsrv.menus;

import com.loohp.lotterysix.discordsrv.DiscordInteraction;
import com.loohp.lotterysix.utils.LotteryUtils;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Emoji;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ActionRow;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Button;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Component;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class BettingAccountInteraction
extends DiscordInteraction {
    public static final String INTERACTION_LABEL = "ls_betting_account";

    public BettingAccountInteraction() {
        super(INTERACTION_LABEL, true);
    }

    @Override
    public boolean doOccupyEntireRow(UUID uuid) {
        return false;
    }

    @Override
    public List<ActionRow> getActionRows(UUID uuid) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        String title = LotteryUtils.formatPlaceholders(player, BettingAccountInteraction.instance.discordSRVSlashCommandsBetAccountTitle, instance);
        return Collections.singletonList(ActionRow.of((Component[])new Component[]{Button.secondary((String)INTERACTION_LABEL, (String)title).withEmoji(Emoji.fromUnicode((String)"\u2139\ufe0f"))}));
    }

    @Override
    public void handle(GenericComponentInteractionCreateEvent event) {
        String discordUserId = event.getUser().getId();
        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(discordUserId);
        if (uuid == null) {
            event.getHook().editOriginalEmbeds(new MessageEmbed[]{BettingAccountInteraction.getGenericEmbed(BettingAccountInteraction.instance.discordSRVSlashCommandsGlobalMessagesNotLinked, Color.RED)}).setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{BettingAccountInteraction.getMainMenuButton()})}).retainFiles(Collections.emptyList()).queue();
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        StringBuilder sb = new StringBuilder();
        for (String line : BettingAccountInteraction.instance.discordSRVSlashCommandsBetAccountSubTitle) {
            sb.append(ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(player, line, instance))).append("\n");
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        String description = sb.charAt(sb.length() - 1) == '\n' ? sb.substring(0, sb.length() - 1) : sb.toString();
        EmbedBuilder builder = new EmbedBuilder().setColor(Color.BLUE).setTitle(ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(player, BettingAccountInteraction.instance.discordSRVSlashCommandsBetAccountTitle, instance))).setDescription((CharSequence)description).setThumbnail(BettingAccountInteraction.instance.discordSRVSlashCommandsBetAccountThumbnailURL);
        event.getHook().editOriginalEmbeds(new MessageEmbed[]{builder.build()}).setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{BettingAccountInteraction.getMainMenuButton()})}).retainFiles(Collections.emptyList()).queue();
    }
}

