/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.game.objects.WinningCombination;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class PlayerWinnings {
    private final String name;
    private final UUID player;
    private final PrizeTier tier;
    private final UUID winningBetId;
    private final WinningCombination winningCombination;
    private final long winnings;

    public PlayerWinnings(String name, UUID player, PrizeTier tier, PlayerBets winningBet, WinningCombination winningCombination, long winnings) {
        this.name = name;
        this.player = player;
        this.tier = tier;
        this.winningBetId = winningBet.getBetId();
        this.winningCombination = winningCombination;
        this.winnings = winnings;
    }

    private PlayerWinnings(String name, UUID player, PrizeTier tier, UUID winningBetId, WinningCombination winningCombination, long winnings) {
        this.name = name;
        this.player = player;
        this.tier = tier;
        this.winningBetId = winningBetId;
        this.winningCombination = winningCombination;
        this.winnings = winnings;
    }

    public String getName() {
        return this.name;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public PrizeTier getTier() {
        return this.tier;
    }

    public UUID getWinningBetId() {
        return this.winningBetId;
    }

    public PlayerBets getWinningBet(CompletedLotterySixGame game) {
        return game.getBet(this.winningBetId);
    }

    public PlayerBets getWinningBet(Map<UUID, PlayerBets> bets) {
        return bets.get(this.winningBetId);
    }

    public WinningCombination getWinningCombination() {
        return this.winningCombination;
    }

    public boolean isCombination(CompletedLotterySixGame game) {
        return this.getWinningBet(game).getChosenNumbers().isCombination();
    }

    public boolean isBulk(CompletedLotterySixGame game) {
        return this.getWinningBet(game).getChosenNumbers().isBulk();
    }

    public long getWinnings() {
        return this.winnings;
    }

    public PlayerWinnings winnings(long winnings) {
        return new PlayerWinnings(this.name, this.player, this.tier, this.winningBetId, this.winningCombination, winnings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerWinnings that = (PlayerWinnings)o;
        return this.winnings == that.winnings && this.name.equals(that.name) && this.player.equals(that.player) && this.tier == that.tier && this.winningBetId.equals(that.winningBetId) && this.winningCombination.equals(that.winningCombination);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.player, this.tier, this.winningBetId, this.winningCombination, this.winnings});
    }
}

