/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.player;

import com.google.common.reflect.TypeToken;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.libs.com.google.gson.Gson;
import com.loohp.lotterysix.libs.com.google.gson.JsonElement;
import com.loohp.lotterysix.libs.com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class LotteryPlayerManager {
    public static final Gson GSON = LotterySix.GSON;
    private final LotterySix instance;
    private final Map<UUID, WeakReference<LotteryPlayer>> loadedPlayers;
    private final Set<LotteryPlayer> persistentReferences;

    public LotteryPlayerManager(LotterySix instance) {
        this.instance = instance;
        this.loadedPlayers = new ConcurrentHashMap<UUID, WeakReference<LotteryPlayer>>();
        this.persistentReferences = ConcurrentHashMap.newKeySet();
    }

    public LotterySix getInstance() {
        return this.instance;
    }

    public LotteryPlayer getLotteryPlayer(UUID player) {
        return this.getLotteryPlayer(player, true);
    }

    public LotteryPlayer getLotteryPlayer(UUID player, boolean loadIfNeeded) {
        WeakReference<LotteryPlayer> preference = this.loadedPlayers.get(player);
        if (preference == null || preference.get() == null) {
            if (loadIfNeeded) {
                return this.loadLotteryPlayer(player, false);
            }
            this.loadedPlayers.remove(player);
            return null;
        }
        return (LotteryPlayer)preference.get();
    }

    public Collection<UUID> getAllLotteryPlayerUUIDs() {
        File playerFolder = new File(this.instance.getDataFolder(), "player");
        playerFolder.mkdirs();
        File[] files = playerFolder.listFiles();
        HashSet<UUID> lotteryPlayers = new HashSet<UUID>(files.length + this.loadedPlayers.size());
        lotteryPlayers.addAll(this.loadedPlayers.keySet());
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".json")) continue;
            try {
                lotteryPlayers.add(UUID.fromString(fileName.substring(0, fileName.lastIndexOf("."))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return lotteryPlayers;
    }

    public boolean isLotteryPlayerLoaded(UUID player) {
        LotteryPlayer lotteryPlayer = this.getLotteryPlayer(player, false);
        if (lotteryPlayer == null) {
            return false;
        }
        return this.persistentReferences.contains(lotteryPlayer);
    }

    public synchronized LotteryPlayer loadLotteryPlayer(UUID player, boolean persist) {
        LotteryPlayer loaded = this.getLotteryPlayer(player, false);
        if (loaded != null) {
            if (persist) {
                this.persistentReferences.add(loaded);
            }
            return loaded;
        }
        File playerFolder = new File(this.instance.getDataFolder(), "player");
        playerFolder.mkdirs();
        File file = new File(playerFolder, player + ".json");
        if (file.exists()) {
            LotteryPlayer lotteryPlayer;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            try {
                JsonObject json = GSON.fromJson((Reader)reader, JsonObject.class);
                EnumMap<PlayerPreferenceKey, Object> preferences = new EnumMap<PlayerPreferenceKey, Object>(PlayerPreferenceKey.class);
                JsonObject preferencesJson = json.getAsJsonObject("preferences");
                for (PlayerPreferenceKey key : PlayerPreferenceKey.values()) {
                    JsonElement element = preferencesJson.get(key.name());
                    if (element == null) continue;
                    preferences.put(key, GSON.fromJson(element, key.getValueTypeClass()));
                }
                JsonObject statsJson = json.getAsJsonObject("stats");
                EnumMap<PlayerStatsKey, Object> stats = new EnumMap<PlayerStatsKey, Object>(PlayerStatsKey.class);
                for (PlayerStatsKey key : PlayerStatsKey.values()) {
                    JsonElement element = statsJson.get(key.name());
                    if (element == null) continue;
                    stats.put(key, GSON.fromJson(element, key.getValueTypeClass()));
                }
                List multipleDrawPlayerBets = (List)GSON.fromJson((JsonElement)json.getAsJsonArray("multipleDrawPlayerBets"), new TypeToken<ArrayList<PlayerBets>>(){}.getType());
                LotteryPlayer lotteryPlayer2 = new LotteryPlayer(this, UUID.fromString(json.get("player").getAsString()), preferences, stats, multipleDrawPlayerBets == null ? Collections.emptyList() : multipleDrawPlayerBets);
                lotteryPlayer2.setManager(this);
                this.loadedPlayers.put(player, new WeakReference<LotteryPlayer>(lotteryPlayer2));
                if (persist) {
                    this.persistentReferences.add(lotteryPlayer2);
                }
                lotteryPlayer = lotteryPlayer2;
            }
            catch (Throwable json) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        json.addSuppressed(throwable);
                    }
                    throw json;
                }
                catch (Exception e) {
                    new RuntimeException("Error while reading data for lottery player " + player, e).printStackTrace();
                    try {
                        Files.copy(file.toPath(), new File(playerFolder, player + ".json.bak." + System.currentTimeMillis()).toPath(), new CopyOption[0]);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            reader.close();
            return lotteryPlayer;
        }
        LotteryPlayer lotteryPlayer = new LotteryPlayer(this, player);
        this.loadedPlayers.put(player, new WeakReference<LotteryPlayer>(lotteryPlayer));
        if (persist) {
            this.persistentReferences.add(lotteryPlayer);
        }
        this.saveLotteryPlayer(player);
        return lotteryPlayer;
    }

    public synchronized void saveLotteryPlayer(UUID player) {
        LotteryPlayer lotteryPlayer = this.getLotteryPlayer(player, false);
        if (lotteryPlayer != null) {
            File playerFolder = new File(this.instance.getDataFolder(), "player");
            playerFolder.mkdirs();
            File file = new File(playerFolder, player + ".json");
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                pw.println(GSON.toJson(lotteryPlayer));
                pw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void unloadLotteryPlayer(UUID player, boolean save) {
        LotteryPlayer lotteryPlayer;
        if (save) {
            this.saveLotteryPlayer(player);
        }
        if ((lotteryPlayer = this.getLotteryPlayer(player, false)) != null) {
            this.persistentReferences.remove(lotteryPlayer);
        }
        this.loadedPlayers.remove(player);
    }
}

