/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.gui;

import com.loohp.interactivechat.libs.com.loohp.platformscheduler.ScheduledRunnable;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGameIndex;
import com.loohp.lotterysix.game.lottery.GameNumber;
import com.loohp.lotterysix.game.lottery.LazyCompletedLotterySixGameList;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.AddBetResult;
import com.loohp.lotterysix.game.objects.BetUnitType;
import com.loohp.lotterysix.game.objects.IntObjectConsumer;
import com.loohp.lotterysix.game.objects.NumberStatistics;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.PlayerWinnings;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.game.objects.WinningNumbers;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersBuilder;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersType;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.gui.GUIInfo;
import com.loohp.lotterysix.gui.GUIType;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XEnchantment;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.lotterysix.libs.de.themoep.inventorygui.DynamicGuiElement;
import com.loohp.lotterysix.libs.de.themoep.inventorygui.GuiElement;
import com.loohp.lotterysix.libs.de.themoep.inventorygui.GuiStateElement;
import com.loohp.lotterysix.libs.de.themoep.inventorygui.InventoryGui;
import com.loohp.lotterysix.libs.de.themoep.inventorygui.StaticGuiElement;
import com.loohp.lotterysix.libs.net.wesjd.anvilgui.AnvilGUI;
import com.loohp.lotterysix.utils.BookUtils;
import com.loohp.lotterysix.utils.ChatColorUtils;
import com.loohp.lotterysix.utils.LotteryUtils;
import com.loohp.lotterysix.utils.MCVersion;
import com.loohp.lotterysix.utils.SkinUtils;
import com.loohp.lotterysix.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class LotteryPluginGUI
implements Listener {
    private final LotterySixPlugin plugin;
    private final LotterySix instance;
    private final Map<Player, Long> lastGuiClick;
    private final Map<Player, AtomicInteger> tickCounter;

    private static String multipleDrawStr(int multipleDraw) {
        return multipleDraw <= 1 ? "-" : StringUtils.formatComma(multipleDraw);
    }

    private static String[] fillChars(int arrays) {
        return LotteryPluginGUI.fillChars(arrays, 0);
    }

    private static String[] fillChars(int arrays, int trail) {
        String[] strings = new String[arrays + trail];
        char c = 'a';
        for (int i = 0; i < strings.length; ++i) {
            StringBuilder sb = new StringBuilder(9);
            for (int u = 0; u < 9; ++u) {
                char c2 = c;
                c = (char)(c + 1);
                sb.append(c2);
            }
            strings[i] = sb.toString();
        }
        return strings;
    }

    private static ItemStack getNumberItem(int number, NumberSelectedState selectedState) {
        return LotteryPluginGUI.getNumberItem(number, false, selectedState);
    }

    private static ItemStack getNumberItem(int number, boolean enchanted, NumberSelectedState selectedState) {
        XMaterial material;
        XMaterial parsedNumberItemsType = LotteryPluginGUI.parse(LotterySixPlugin.getInstance().numberItemsType);
        if (parsedNumberItemsType == null) {
            if (number == 0) {
                material = selectedState.equals((Object)NumberSelectedState.NOT_SELECTED) ? XMaterial.ORANGE_WOOL : XMaterial.GRAY_WOOL;
            } else {
                switch (selectedState.ordinal()) {
                    case 0: {
                        String color = ChatColorUtils.getNumberColor(number);
                        if (color.equals(ChatColor.RED.toString())) {
                            material = XMaterial.RED_STAINED_GLASS;
                            break;
                        }
                        if (color.equals(ChatColor.AQUA.toString())) {
                            material = XMaterial.LIGHT_BLUE_STAINED_GLASS;
                            break;
                        }
                        if (color.equals(ChatColor.GREEN.toString())) {
                            material = XMaterial.LIME_STAINED_GLASS;
                            break;
                        }
                        material = XMaterial.RED_STAINED_GLASS;
                        break;
                    }
                    case 1: {
                        String color = ChatColorUtils.getNumberColor(number);
                        if (color.equals(ChatColor.RED.toString())) {
                            material = XMaterial.RED_WOOL;
                            break;
                        }
                        if (color.equals(ChatColor.AQUA.toString())) {
                            material = XMaterial.LIGHT_BLUE_WOOL;
                            break;
                        }
                        if (color.equals(ChatColor.GREEN.toString())) {
                            material = XMaterial.LIME_WOOL;
                            break;
                        }
                        material = XMaterial.RED_WOOL;
                        break;
                    }
                    case 2: {
                        material = XMaterial.YELLOW_WOOL;
                        break;
                    }
                    default: {
                        material = XMaterial.GRAY_WOOL;
                        break;
                    }
                }
            }
        } else {
            material = parsedNumberItemsType;
        }
        ItemStack itemStack = material.parseItem();
        if (LotterySixPlugin.getInstance().numberItemsSetStackSize) {
            itemStack.setAmount(Math.max(1, number));
        }
        if (enchanted) {
            itemStack = LotteryPluginGUI.setEnchanted(itemStack);
        }
        int itemModelData = LotterySixPlugin.getInstance().numberItemsCustomModelData + selectedState.getCustomModelDataOffset() + number;
        ItemMeta meta = itemStack.getItemMeta();
        if (LotterySixPlugin.version.isNewerOrEqualTo(MCVersion.V1_13_1)) {
            meta.setCustomModelData(Integer.valueOf(itemModelData));
        }
        itemStack.setItemMeta(meta);
        itemStack = LotterySixPlugin.version.isNewerOrEqualTo(MCVersion.V1_20_5) ? Bukkit.getUnsafe().modifyItemStack(itemStack, itemStack.getType().getKey() + "[custom_data={LotterySixNumber:" + number + "}]") : Bukkit.getUnsafe().modifyItemStack(itemStack, "{LotterySixNumber: " + number + "}");
        return itemStack;
    }

    private static ItemStack setItemSize(ItemStack item, int amount) {
        if (item == null) {
            return null;
        }
        item.setAmount(amount);
        return item;
    }

    private static ItemStack setEnchanted(ItemStack item) {
        if (item == null) {
            return null;
        }
        item.addUnsafeEnchantment(XEnchantment.FORTUNE.getEnchant(), 8);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(itemMeta);
        return item;
    }

    private static String getNumberColor(int number) {
        return ChatColorUtils.getNumberColor(number);
    }

    private static ItemStack getFillerItem(ItemStack itemStack) {
        return LotterySixPlugin.getInstance().borderPaneItemsHideAll ? new ItemStack(Material.AIR) : itemStack;
    }

    private static ItemStack setInfo(ItemStack itemStack, GUIInfo info, int index) {
        XMaterial parsedItemType = LotteryPluginGUI.parse(info.getItemType());
        if (parsedItemType != null) {
            itemStack = parsedItemType.parseItem();
        }
        return LotteryPluginGUI.setCustomModelData(itemStack, info.getCustomModelDataOffset(), index);
    }

    private static ItemStack setCustomModelData(ItemStack itemStack, int offset, int number) {
        int model = offset + number;
        ItemMeta meta = itemStack.getItemMeta();
        if (LotterySixPlugin.version.isNewerOrEqualTo(MCVersion.V1_13_1)) {
            meta.setCustomModelData(Integer.valueOf(model));
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    private static XMaterial parse(String material) {
        try {
            if (material == null || material.equalsIgnoreCase("DEFAULT")) {
                return null;
            }
            return XMaterial.valueOf(material.toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LotteryPluginGUI(LotterySixPlugin plugin) {
        this.plugin = plugin;
        this.instance = LotterySixPlugin.getInstance();
        this.lastGuiClick = new HashMap<Player, Long>();
        this.tickCounter = new ConcurrentHashMap<Player, AtomicInteger>();
    }

    public void forceClose(Player player) {
        InventoryGui gui = InventoryGui.getOpen((HumanEntity)player);
        if (gui != null) {
            gui.close((HumanEntity)player, true);
        }
    }

    private void handleClick(InventoryInteractEvent event) {
        Player player = (Player)event.getWhoClicked();
        long gameTick = this.tickCounter.get(player).get();
        Long lastClick = this.lastGuiClick.get(player);
        if (lastClick == null || gameTick != lastClick) {
            this.lastGuiClick.put(player, gameTick);
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        AtomicInteger counter = new AtomicInteger();
        this.tickCounter.put(player, counter);
        Scheduler.runTaskTimer((Plugin)this.plugin, () -> counter.incrementAndGet(), 0L, 1L, (Entity)player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.lastGuiClick.remove(player);
        Deque<InventoryGui> guis = InventoryGui.clearHistory((HumanEntity)player);
        Scheduler.runTaskLater((Plugin)this.plugin, () -> {
            InventoryGui gui;
            while ((gui = (InventoryGui)guis.poll()) != null) {
                gui.destroy();
            }
        }, 1L, (Entity)player);
        this.tickCounter.remove(player);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryClickLow(InventoryClickEvent event) {
        Inventory inventory = event.getView().getTopInventory();
        if (inventory.getHolder() instanceof InventoryGui.Holder) {
            this.handleClick((InventoryInteractEvent)event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getView().getTopInventory();
        if (inventory.getHolder() instanceof InventoryGui.Holder && InventoryGui.getOpen(event.getWhoClicked()) == null) {
            event.setCancelled(true);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                InventoryGui.clearHistory(event.getWhoClicked());
                event.getWhoClicked().closeInventory();
            }, 1L, (Entity)event.getWhoClicked());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory inventory = event.getView().getTopInventory();
        if (inventory.getHolder() instanceof InventoryGui.Holder) {
            this.handleClick((InventoryInteractEvent)event);
            if (InventoryGui.getOpen(event.getWhoClicked()) == null) {
                event.setCancelled(true);
                Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                    InventoryGui.clearHistory(event.getWhoClicked());
                    event.getWhoClicked().closeInventory();
                }, 1L, (Entity)event.getWhoClicked());
            }
        }
    }

    public void close(HumanEntity player, InventoryGui inventoryGui, boolean back) {
        inventoryGui.close(player, !back);
        Scheduler.runTaskLater((Plugin)this.plugin, () -> inventoryGui.destroy(), 1L, (Entity)player);
    }

    public void removeSecondLast(HumanEntity player) {
        Deque<InventoryGui> history = InventoryGui.getHistory(player);
        if (history.size() <= 1) {
            return;
        }
        Iterator<InventoryGui> itr = history.descendingIterator();
        itr.next();
        InventoryGui inventoryGui = itr.next();
        itr.remove();
        Scheduler.runTaskLater((Plugin)this.plugin, () -> inventoryGui.destroy(), 1L, (Entity)player);
    }

    public void checkReopen(HumanEntity player) {
        if (this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.REOPEN_MENU_ON_PURCHASE, Boolean.TYPE).booleanValue() && InventoryGui.getHistory(player).isEmpty()) {
            this.getMainMenu((Player)player).show(player);
        }
    }

    public InventoryGui getMainMenu(final Player player) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.MAIN_MENU);
        String[] guiSetup = guiInfo.getLayout();
        final InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuTitle, this.instance), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.YELLOW_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('a', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        gui.addElement(new StaticGuiElement('y', LotteryPluginGUI.getFillerItem(XMaterial.ORANGE_STAINED_GLASS_PANE.parseItem()), ChatColor.LIGHT_PURPLE.toString()));
        CompletedLotterySixGame completedGame = this.instance.getCompletedGames().getLatest();
        gui.addElement(new StaticGuiElement('b', completedGame != null && completedGame.hasPlayerWinnings(player.getUniqueId()) ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.CLOCK.parseItem()), guiInfo, 0) : LotteryPluginGUI.setInfo(XMaterial.CLOCK.parseItem(), guiInfo, 1), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), gui, false), 1L, (Entity)player);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getPastResults((Player)click.getWhoClicked(), completedGame).show(click.getWhoClicked()), 2L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuCheckPastResults, this.instance)));
        gui.addElement(new DynamicGuiElement('c', viewer -> {
            PlayableLotterySixGame currentGame = this.instance.getCurrentGame();
            if (currentGame == null) {
                return new StaticGuiElement('c', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 2), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuNoLotteryGamesScheduled, this.instance));
            }
            return new StaticGuiElement('c', LotteryPluginGUI.setInfo(XMaterial.PAPER.parseItem(), guiInfo, 3), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                    this.close(click.getWhoClicked(), click.getGui(), true);
                    Scheduler.runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                        ItemStack itemStack = this.getPlacedBets((Player)click.getWhoClicked());
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> BookUtils.openBook((Player)click.getWhoClicked(), itemStack), 1L, (Entity)player);
                    }, 1L);
                }, 1L, (Entity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuCheckOwnBets, this.instance, currentGame));
        }));
        gui.addElement(new DynamicGuiElement('d', viewer -> {
            PlayableLotterySixGame currentGame = this.instance.getCurrentGame();
            if (currentGame == null) {
                return new StaticGuiElement('d', LotteryPluginGUI.setInfo(XMaterial.RED_WOOL.parseItem(), guiInfo, 4), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuNoLotteryGamesScheduled, this.instance));
            }
            return new StaticGuiElement('d', LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 5), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getBetTypeChooser((Player)click.getWhoClicked(), this.instance.getCurrentGame()).show(click.getWhoClicked()), 1L, (Entity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuPlaceNewBets, this.instance, currentGame));
        }));
        gui.addElement(new StaticGuiElement('e', LotteryPluginGUI.setInfo(XMaterial.OAK_SIGN.parseItem(), guiInfo, 6), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getNumberStatistics((Player)click.getWhoClicked(), this.instance.getCompletedGames().getLatest()).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuStatistics, this.instance)));
        gui.addElement(new StaticGuiElement('z', LotteryPluginGUI.setInfo(XMaterial.COMPASS.parseItem(), guiInfo, 7), click -> {
            TextComponent message = new TextComponent(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.explanationMessage, this.instance));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.instance.explanationURL));
            click.getWhoClicked().spigot().sendMessage((BaseComponent)message);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), true), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.explanationGUIItem, this.instance)));
        gui.addElement(new StaticGuiElement('f', LotteryPluginGUI.setInfo(SkinUtils.getSkull(player.getUniqueId()), guiInfo, 8), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getBettingAccount((Player)click.getWhoClicked()).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuBettingAccount, this.instance)));
        gui.addElement(new StaticGuiElement('$', LotteryPluginGUI.setInfo(XMaterial.EMERALD.parseItem(), guiInfo, 9), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getTransactionMenu((Player)click.getWhoClicked()).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuAccountFundTransfer, this.instance)));
        gui.setCloseAction(close -> false);
        final Set<GuiElement> elements = Collections.singleton(gui.getElement('c'));
        new ScheduledRunnable(){

            @Override
            public void run() {
                Deque<InventoryGui> history = InventoryGui.getHistory((HumanEntity)player);
                if (!history.contains(gui)) {
                    this.cancel();
                    return;
                }
                if (Objects.equals(history.peekLast(), gui)) {
                    InventoryGui.updateElements((HumanEntity)player, elements);
                    gui.draw((HumanEntity)player, false);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 10L, 10L, (Entity)player);
        return gui;
    }

    public InventoryGui getBettingAccount(final Player player) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.BETTING_ACCOUNT);
        String[] guiSetup = guiInfo.getLayout();
        final InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountTitle, this.instance), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('a', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        gui.addElement(new StaticGuiElement('z', LotteryPluginGUI.getFillerItem(XMaterial.LIGHT_BLUE_STAINED_GLASS_PANE.parseItem()), ChatColor.LIGHT_PURPLE.toString()));
        gui.addElement(new StaticGuiElement('b', LotteryPluginGUI.setInfo(SkinUtils.getSkull(player.getUniqueId()), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountProfile, this.instance)));
        AtomicBoolean flipLeftRightClick = new AtomicBoolean(false);
        Predicate<ClickType> isLeftClick = clickType -> flipLeftRightClick.get() ? clickType.isRightClick() : clickType.isLeftClick();
        Predicate<ClickType> isRightClick = clickType -> flipLeftRightClick.get() ? clickType.isLeftClick() : clickType.isRightClick();
        gui.addElement(new DynamicGuiElement('y', () -> {
            boolean value = flipLeftRightClick.get();
            String display = value ? this.instance.trueFormat : this.instance.falseFormat;
            return new StaticGuiElement('c', value ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.ARROW.parseItem()), guiInfo, 1) : LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 2), click -> {
                flipLeftRightClick.set(!value);
                gui.draw();
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountFlipLeftRightClick, this.instance)).map(e -> e.replace("{Status}", display)).toArray(String[]::new));
        }));
        LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId());
        gui.addElement(new DynamicGuiElement('c', () -> {
            String display;
            boolean value = lotteryPlayer.getPreference(PlayerPreferenceKey.HIDE_TITLES, Boolean.TYPE);
            String string = display = value ? this.instance.trueFormat : this.instance.falseFormat;
            if (value) {
                return new StaticGuiElement('c', LotteryPluginGUI.setInfo(XMaterial.LIME_DYE.parseItem(), guiInfo, 3), click -> {
                    if (this.instance.backendBungeecordMode) {
                        LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.HIDE_TITLES, false);
                    } else {
                        lotteryPlayer.setPreference(PlayerPreferenceKey.HIDE_TITLES, false);
                    }
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountToggleHideTitles, this.instance)).map(e -> e.replace("{Status}", display)).toArray(String[]::new));
            }
            return new StaticGuiElement('c', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 4), click -> {
                if (this.instance.backendBungeecordMode) {
                    LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.HIDE_TITLES, true);
                } else {
                    lotteryPlayer.setPreference(PlayerPreferenceKey.HIDE_TITLES, true);
                }
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountToggleHideTitles, this.instance)).map(e -> e.replace("{Status}", display)).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('d', () -> {
            String display;
            boolean value = lotteryPlayer.getPreference(PlayerPreferenceKey.HIDE_PERIODIC_ANNOUNCEMENTS, Boolean.TYPE);
            String string = display = value ? this.instance.trueFormat : this.instance.falseFormat;
            if (value) {
                return new StaticGuiElement('d', LotteryPluginGUI.setInfo(XMaterial.LIME_DYE.parseItem(), guiInfo, 5), click -> {
                    if (this.instance.backendBungeecordMode) {
                        LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.HIDE_PERIODIC_ANNOUNCEMENTS, false);
                    } else {
                        lotteryPlayer.setPreference(PlayerPreferenceKey.HIDE_PERIODIC_ANNOUNCEMENTS, false);
                    }
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountToggleHidePeriodicAnnouncements, this.instance)).map(e -> e.replace("{Status}", display)).toArray(String[]::new));
            }
            return new StaticGuiElement('d', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 6), click -> {
                if (this.instance.backendBungeecordMode) {
                    LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.HIDE_PERIODIC_ANNOUNCEMENTS, true);
                } else {
                    lotteryPlayer.setPreference(PlayerPreferenceKey.HIDE_PERIODIC_ANNOUNCEMENTS, true);
                }
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountToggleHidePeriodicAnnouncements, this.instance)).map(e -> e.replace("{Status}", display)).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('e', () -> {
            String display;
            boolean value = lotteryPlayer.getPreference(PlayerPreferenceKey.REOPEN_MENU_ON_PURCHASE, Boolean.TYPE);
            String string = display = value ? this.instance.trueFormat : this.instance.falseFormat;
            if (value) {
                return new StaticGuiElement('e', LotteryPluginGUI.setInfo(XMaterial.LIME_DYE.parseItem(), guiInfo, 7), click -> {
                    if (this.instance.backendBungeecordMode) {
                        LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.REOPEN_MENU_ON_PURCHASE, false);
                    } else {
                        lotteryPlayer.setPreference(PlayerPreferenceKey.REOPEN_MENU_ON_PURCHASE, false);
                    }
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountToggleReopenMenu, this.instance)).map(e -> e.replace("{Status}", display)).toArray(String[]::new));
            }
            return new StaticGuiElement('e', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 8), click -> {
                if (this.instance.backendBungeecordMode) {
                    LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.REOPEN_MENU_ON_PURCHASE, true);
                } else {
                    lotteryPlayer.setPreference(PlayerPreferenceKey.REOPEN_MENU_ON_PURCHASE, true);
                }
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountToggleReopenMenu, this.instance)).map(e -> e.replace("{Status}", display)).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('f', () -> {
            long realValue = lotteryPlayer.getPreference(PlayerPreferenceKey.BET_LIMIT_PER_ROUND, Long.TYPE);
            boolean active = lotteryPlayer.isPreferenceSet(PlayerPreferenceKey.BET_LIMIT_PER_ROUND);
            String value = active ? StringUtils.formatComma(realValue) : "-";
            ItemStack left = XMaterial.PAPER.parseItem();
            ItemMeta leftMeta = left.getItemMeta();
            leftMeta.setDisplayName(Math.max(0L, realValue) + "");
            left.setItemMeta(leftMeta);
            return new StaticGuiElement('g', active ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.OAK_FENCE_GATE.parseItem()), guiInfo, 9) : LotteryPluginGUI.setInfo(XMaterial.OAK_FENCE_GATE.parseItem(), guiInfo, 10), click -> {
                if (isLeftClick.test(click.getType())) {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> new AnvilGUI.Builder().plugin((Plugin)this.plugin).title(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountSetBetLimitPerRoundTitle, this.instance)).itemLeft(left).onClick((slot, completion) -> {
                        if (slot != 2) {
                            return Collections.emptyList();
                        }
                        Scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                            String input = completion.getText().trim();
                            try {
                                long newValue = Math.max(0L, Long.parseLong(input));
                                if (this.instance.backendBungeecordMode) {
                                    LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.BET_LIMIT_PER_ROUND, newValue);
                                } else {
                                    lotteryPlayer.setPreference(PlayerPreferenceKey.BET_LIMIT_PER_ROUND, newValue);
                                }
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getMainMenu(player).show((HumanEntity)player), 2L, (Entity)player);
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getBettingAccount(player).show((HumanEntity)player), 3L, (Entity)player);
                            }
                            catch (Exception e) {
                                player.sendMessage(this.instance.messageInvalidUsage);
                            }
                        });
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }).open(player), 2L, (Entity)player);
                } else if (isRightClick.test(click.getType())) {
                    if (this.instance.backendBungeecordMode) {
                        LotterySixPlugin.getPluginMessageHandler().resetPlayerPreference(lotteryPlayer, PlayerPreferenceKey.BET_LIMIT_PER_ROUND);
                    } else {
                        lotteryPlayer.resetPreference(PlayerPreferenceKey.BET_LIMIT_PER_ROUND);
                    }
                }
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountSetBetLimitPerRound, this.instance)).map(s -> s.replace("{Value}", value)).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('g', () -> {
            long realValue = lotteryPlayer.getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
            boolean active = System.currentTimeMillis() < realValue;
            String value = active ? this.instance.dateFormat.format(realValue) : "-";
            return new StaticGuiElement('f', active ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.ANVIL.parseItem()), guiInfo, 11) : LotteryPluginGUI.setInfo(XMaterial.ANVIL.parseItem(), guiInfo, 12), click -> {
                if (isLeftClick.test(click.getType())) {
                    long newValue = Math.max(System.currentTimeMillis(), realValue) + 604800000L;
                    if (this.instance.backendBungeecordMode) {
                        LotterySixPlugin.getPluginMessageHandler().updatePlayerPreference(lotteryPlayer, PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, newValue);
                    } else {
                        lotteryPlayer.setPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, newValue);
                    }
                } else if (isRightClick.test(click.getType())) {
                    if (this.instance.backendBungeecordMode) {
                        LotterySixPlugin.getPluginMessageHandler().resetPlayerPreference(lotteryPlayer, PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL);
                    } else {
                        lotteryPlayer.resetPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL);
                    }
                }
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountSuspendAccountForAWeek, this.instance)).map(s -> s.replace("{Value}", value)).toArray(String[]::new));
        }));
        gui.addElement(new StaticGuiElement('$', LotteryPluginGUI.setInfo(XMaterial.EMERALD.parseItem(), guiInfo, 13), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getTransactionMenu((Player)click.getWhoClicked()).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiMainMenuAccountFundTransfer, this.instance)));
        gui.setSilent(true);
        new ScheduledRunnable(){

            @Override
            public void run() {
                Deque<InventoryGui> history = InventoryGui.getHistory((HumanEntity)player);
                if (!history.contains(gui)) {
                    this.cancel();
                    return;
                }
                if (Objects.equals(history.peekLast(), gui)) {
                    gui.draw((HumanEntity)player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 10L, 10L, (Entity)player);
        return gui;
    }

    public InventoryGui getTransactionMenu(Player player) {
        LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId());
        long money = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.TRANSACTION_MENU);
        String[] guiSetup = guiInfo.getLayout();
        String title = money > 0L ? this.instance.guiAccountFundTransferTitle : this.instance.guiAccountFundTransferTitleNoMoney;
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, title, this.instance), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('a', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        gui.addElement(new StaticGuiElement('z', LotteryPluginGUI.getFillerItem(XMaterial.ORANGE_STAINED_GLASS_PANE.parseItem()), ChatColor.LIGHT_PURPLE.toString()));
        gui.addElement(new StaticGuiElement('b', LotteryPluginGUI.setInfo(SkinUtils.getSkull(player.getUniqueId()), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiBettingAccountProfile, this.instance)));
        gui.addElement(new StaticGuiElement('c', LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 1), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferCurrentBalance, this.instance)).map(s -> s.replace("{Amount}", StringUtils.formatComma(money))).toArray(String[]::new)));
        long time = lotteryPlayer.getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
        if (System.currentTimeMillis() < time) {
            gui.addElement(new StaticGuiElement('d', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('e', LotteryPluginGUI.setInfo(new ItemStack(Material.BARRIER), guiInfo, 2), click -> {
                player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", "0"));
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
                return true;
            }, ChatColor.RED + "-"));
            gui.addElement(new StaticGuiElement('f', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        } else {
            if (this.instance.hideManuelAccountFundTransferDeposit) {
                gui.addElement(new StaticGuiElement(money > 0L ? (char)'d' : 'e', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 3), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferDepositRestricted, this.instance)).map(s -> s.replace("{Amount}", StringUtils.formatComma(money))).toArray(String[]::new)));
            } else {
                gui.addElement(new StaticGuiElement(money > 0L ? (char)'d' : 'e', LotteryPluginGUI.setInfo(XMaterial.EMERALD.parseItem(), guiInfo, 4), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getTransactionInput(player, AccountTransactionMode.DEPOSIT).open(player), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferDeposit, this.instance)).map(s -> s.replace("{Amount}", StringUtils.formatComma(money))).toArray(String[]::new)));
            }
            if (money > 0L) {
                gui.addElement(new StaticGuiElement('e', LotteryPluginGUI.setInfo(XMaterial.RED_DYE.parseItem(), guiInfo, 5), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getTransactionInput(player, AccountTransactionMode.WITHDRAW).open(player), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferWithdraw, this.instance)).map(s -> s.replace("{Amount}", StringUtils.formatComma(money))).toArray(String[]::new)));
                gui.addElement(new StaticGuiElement('f', LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.RED_DYE.parseItem()), guiInfo, 6), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
                    Scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                        long total = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
                        if (this.instance.giveMoney(player.getUniqueId(), total)) {
                            if (this.instance.backendBungeecordMode) {
                                long current = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
                                LotterySixPlugin.getPluginMessageHandler().updatePlayerStats(lotteryPlayer, PlayerStatsKey.ACCOUNT_BALANCE, current - total);
                            } else {
                                lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i - total);
                            }
                            player.sendMessage(this.instance.messageWithdrawSuccess.replace("{Amount}", StringUtils.formatComma(total)));
                            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen((HumanEntity)player), 5L, (Entity)player);
                        } else {
                            player.sendMessage(this.instance.messageWithdrawFailed);
                        }
                    });
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferWithdrawAll, this.instance)).map(s -> s.replace("{Amount}", StringUtils.formatComma(money))).toArray(String[]::new)));
            } else {
                gui.addElement(new StaticGuiElement('d', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
                gui.addElement(new StaticGuiElement('f', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            }
        }
        gui.setSilent(true);
        return gui;
    }

    public AnvilGUI.Builder getTransactionInput(Player player, AccountTransactionMode transactionMode) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.TRANSACTION_INPUT);
        ItemStack left = XMaterial.GOLD_INGOT.parseItem();
        ItemMeta leftMeta = left.getItemMeta();
        leftMeta.setDisplayName("0");
        left.setItemMeta(leftMeta);
        left = LotteryPluginGUI.setInfo(left, guiInfo, 0);
        return new AnvilGUI.Builder().plugin((Plugin)this.plugin).title(LotteryUtils.formatPlaceholders((OfflinePlayer)player, transactionMode.equals((Object)AccountTransactionMode.WITHDRAW) ? this.instance.guiAccountFundTransferWithdrawInputTitle : this.instance.guiAccountFundTransferDepositInputTitle, this.instance)).itemLeft(left).onClick((slot, completion) -> {
            if (slot != 2) {
                return Collections.emptyList();
            }
            Scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                String input = completion.getText().trim();
                try {
                    long amount = Long.parseLong(input);
                    Scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                        if (amount <= 0L) {
                            player.sendMessage(this.instance.messageInvalidNumber);
                        } else {
                            LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId());
                            long money = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
                            if (transactionMode.equals((Object)AccountTransactionMode.WITHDRAW)) {
                                if (money < amount) {
                                    player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(amount)));
                                } else if (this.instance.giveMoney(player.getUniqueId(), amount)) {
                                    if (this.instance.backendBungeecordMode) {
                                        long current = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
                                        LotterySixPlugin.getPluginMessageHandler().updatePlayerStats(lotteryPlayer, PlayerStatsKey.ACCOUNT_BALANCE, current - amount);
                                    } else {
                                        lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i - amount);
                                    }
                                    player.sendMessage(this.instance.messageWithdrawSuccess.replace("{Amount}", StringUtils.formatComma(amount)));
                                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen((HumanEntity)player), 5L, (Entity)player);
                                } else {
                                    player.sendMessage(this.instance.messageWithdrawFailed);
                                }
                            } else if (this.instance.takeMoney(player.getUniqueId(), amount)) {
                                if (this.instance.backendBungeecordMode) {
                                    long current = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
                                    LotterySixPlugin.getPluginMessageHandler().updatePlayerStats(lotteryPlayer, PlayerStatsKey.ACCOUNT_BALANCE, current + amount);
                                } else {
                                    lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + amount);
                                }
                                player.sendMessage(this.instance.messageDepositSuccess.replace("{Amount}", StringUtils.formatComma(amount)));
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen((HumanEntity)player), 5L, (Entity)player);
                            } else {
                                player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(amount)));
                            }
                        }
                    });
                }
                catch (NumberFormatException e) {
                    player.sendMessage(this.instance.messageInvalidNumber);
                }
            });
            return Collections.singletonList(AnvilGUI.ResponseAction.close());
        });
    }

    public void checkFixedTransactionDeposit(Player player, final long amount, final Runnable onSuccess) {
        final LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId());
        long time = lotteryPlayer.getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
        if (System.currentTimeMillis() < time) {
            player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(amount)));
            InventoryGui gui = InventoryGui.getOpen((HumanEntity)player);
            if (gui != null) {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
            }
            return;
        }
        long money = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
        if (amount > money) {
            long amountNeeded = amount - money;
            GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.FIXED_TRANSACTION_DEPOSIT);
            String[] guiSetup = guiInfo.getLayout();
            InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferPlacingBetTitle, this.instance), guiSetup, new GuiElement[0]);
            gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.RED_STAINED_GLASS_PANE.parseItem()));
            gui.addElement(new StaticGuiElement('a', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('b', LotteryPluginGUI.setInfo(XMaterial.EMERALD.parseItem(), guiInfo, 0), click -> {
                Scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                    if (this.instance.takeMoney(player.getUniqueId(), amountNeeded)) {
                        if (this.instance.backendBungeecordMode) {
                            long current = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
                            LotterySixPlugin.getPluginMessageHandler().updatePlayerStats(lotteryPlayer, PlayerStatsKey.ACCOUNT_BALANCE, current + amountNeeded);
                        } else {
                            lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + amountNeeded);
                        }
                        player.sendMessage(this.instance.messageDepositSuccess.replace("{Amount}", StringUtils.formatComma(amountNeeded)));
                        new ScheduledRunnable(){
                            private int counter = 0;

                            @Override
                            public void run() {
                                long current = lotteryPlayer.getStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE);
                                if (amount <= current) {
                                    this.cancel();
                                    onSuccess.run();
                                }
                                if (this.counter++ > 40) {
                                    this.cancel();
                                }
                            }
                        }.runTaskTimer((Plugin)this.plugin, 2L, 1L, (Entity)player);
                    } else {
                        player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(amountNeeded)));
                    }
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
                });
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferPlacingBetConfirm, this.instance)).map(s -> s.replace("{Amount}", StringUtils.formatComma(amountNeeded))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('c', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 1), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen((HumanEntity)player), 5L, (Entity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiAccountFundTransferPlacingBetCancel, this.instance)));
            gui.show((HumanEntity)player);
        } else {
            onSuccess.run();
        }
    }

    public ItemStack getPlacedBets(Player player) {
        PlayableLotterySixGame game = this.instance.getCurrentGame();
        List<PlayerBets> bets = game.getPlayerBets(player.getUniqueId());
        ItemStack itemStack = XMaterial.WRITTEN_BOOK.parseItem();
        BookMeta meta = (BookMeta)itemStack.getItemMeta();
        meta.setAuthor("LotterySix");
        meta.setTitle("LotterySix");
        ArrayList<String> pages = new ArrayList<String>();
        String title = LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiYourBetsTitle, this.instance, game);
        if (bets.isEmpty()) {
            pages.add(title + "\n\n" + String.join((CharSequence)"\n", LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiYourBetsNothing, this.instance, game)));
        } else {
            for (PlayerBets bet : bets) {
                if (pages.size() > 100) break;
                String str = title + "\n\n" + bet.getChosenNumbers().toFormattedString().replace("/ ", "/\n") + "\n";
                str = bet.isMultipleDraw() ? str + this.instance.ticketDescriptionMultipleDraw.replace("{Price}", StringUtils.formatComma(bet.getBet())).replace("{UnitPrice}", StringUtils.formatComma(this.instance.pricePerBet / (long)bet.getType().getDivisor())).replace("{DrawsRemaining}", StringUtils.formatComma(bet.getDrawsRemaining())).replace("{MultipleDraw}", StringUtils.formatComma(bet.getMultipleDraw())) : str + this.instance.ticketDescription.replace("{Price}", StringUtils.formatComma(bet.getBet())).replace("{UnitPrice}", StringUtils.formatComma(this.instance.pricePerBet / (long)bet.getType().getDivisor()));
                pages.add(str);
            }
        }
        meta.setPages(pages);
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public InventoryGui getBetTypeChooser(Player player, PlayableLotterySixGame game) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.BET_TYPE_CHOOSER);
        String[] guiSetup = guiInfo.getLayout();
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiSelectNewBetTypeTitle, this.instance), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.ORANGE_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('a', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        gui.addElement(new StaticGuiElement('b', LotteryPluginGUI.setInfo(XMaterial.BRICK.parseItem(), guiInfo, 0), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getNumberChooser((Player)click.getWhoClicked(), game, BetNumbersBuilder.single(1, this.instance.numberOfChoices)).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiSelectNewBetTypeSingle, this.instance)));
        gui.addElement(new StaticGuiElement('c', LotteryPluginGUI.setInfo(XMaterial.IRON_INGOT.parseItem(), guiInfo, 1), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getNumberChooser((Player)click.getWhoClicked(), game, BetNumbersBuilder.multiple(1, this.instance.numberOfChoices)).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiSelectNewBetTypeMultiple, this.instance)));
        gui.addElement(new StaticGuiElement('d', LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 2), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getNumberChooser((Player)click.getWhoClicked(), game, BetNumbersBuilder.banker(1, this.instance.numberOfChoices)).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiSelectNewBetTypeBanker, this.instance)));
        gui.addElement(new StaticGuiElement('e', LotteryPluginGUI.setInfo(XMaterial.REDSTONE.parseItem(), guiInfo, 3), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getRandomEntryChooser((Player)click.getWhoClicked(), game, BetNumbersType.RANDOM).show(click.getWhoClicked()), 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiSelectNewBetTypeRandom, this.instance)));
        gui.setSilent(true);
        return gui;
    }

    public InventoryGui getRandomEntryChooser(Player player, PlayableLotterySixGame game, BetNumbersType selectedType) {
        BetNumbersType type = selectedType.isRandom() ? selectedType : BetNumbersType.RANDOM;
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.RANDOM_ENTRY_CHOOSER);
        String[] guiSetup = guiInfo.getLayout();
        String title = type.equals((Object)BetNumbersType.RANDOM) ? this.instance.guiRandomEntrySingleTitle : (type.equals((Object)BetNumbersType.MULTIPLE_RANDOM) ? this.instance.guiRandomEntryMultipleTitle : (type.equals((Object)BetNumbersType.BANKER_RANDOM) ? this.instance.guiRandomEntryBankerTitle : ""));
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, title, this.instance), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.RED_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('a', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        gui.addElement(new StaticGuiElement('b', type.equals((Object)BetNumbersType.RANDOM) ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.BRICK.parseItem()), guiInfo, 0) : LotteryPluginGUI.setInfo(XMaterial.BRICK.parseItem(), guiInfo, 1), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                this.getRandomEntryChooser((Player)click.getWhoClicked(), game, BetNumbersType.RANDOM).show(click.getWhoClicked());
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.removeSecondLast((HumanEntity)player), 2L, (Entity)player);
            }, 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntrySingleTab, this.instance)));
        gui.addElement(new StaticGuiElement('c', type.equals((Object)BetNumbersType.MULTIPLE_RANDOM) ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.IRON_INGOT.parseItem()), guiInfo, 2) : LotteryPluginGUI.setInfo(XMaterial.IRON_INGOT.parseItem(), guiInfo, 3), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                this.getRandomEntryChooser((Player)click.getWhoClicked(), game, BetNumbersType.MULTIPLE_RANDOM).show(click.getWhoClicked());
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.removeSecondLast((HumanEntity)player), 2L, (Entity)player);
            }, 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryMultipleTab, this.instance)));
        gui.addElement(new StaticGuiElement('d', type.equals((Object)BetNumbersType.BANKER_RANDOM) ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.GOLD_INGOT.parseItem()), guiInfo, 4) : LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 5), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                this.getRandomEntryChooser((Player)click.getWhoClicked(), game, BetNumbersType.BANKER_RANDOM).show(click.getWhoClicked());
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.removeSecondLast((HumanEntity)player), 2L, (Entity)player);
            }, 1L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBankerTab, this.instance)));
        if (type.equals((Object)BetNumbersType.RANDOM)) {
            gui.addElement(new StaticGuiElement('f', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('h', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('j', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('e', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 1), guiInfo, 6), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 1).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "1").replace("{BetUnits}", "1").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('g', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 2), guiInfo, 7), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 2).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "2").replace("{BetUnits}", "2").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet * 2L))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('i', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 5), guiInfo, 8), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 5).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "5").replace("{BetUnits}", "5").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet * 5L))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('k', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 10), guiInfo, 9), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 10).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "10").replace("{BetUnits}", "10").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet * 10L))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('l', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 20), guiInfo, 10), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 20).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "20").replace("{BetUnits}", "20").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet * 20L))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('m', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 40), guiInfo, 11), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 40).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "40").replace("{BetUnits}", "40").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet * 40L))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('n', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 50), guiInfo, 12), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 50).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "50").replace("{BetUnits}", "50").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet * 50L))).toArray(String[]::new)));
            gui.addElement(new StaticGuiElement('o', LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.PAPER.parseItem()), guiInfo, 13), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getSingleBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.random(1, this.instance.numberOfChoices, 100).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueSimple, this.instance)).map(each -> each.replace("{Count}", "100").replace("{BetUnits}", "100").replace("{Price}", StringUtils.formatComma(this.instance.pricePerBet * 100L))).toArray(String[]::new)));
        } else if (type.equals((Object)BetNumbersType.MULTIPLE_RANDOM)) {
            gui.addElement(new StaticGuiElement('e', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('f', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('j', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            gui.addElement(new StaticGuiElement('k', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            AtomicInteger size = new AtomicInteger(7);
            gui.addElement(new StaticGuiElement('g', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 14), click -> {
                int decrement = click.getType().isRightClick() ? 10 : 1;
                size.updateAndGet(i -> Math.max(7, i - decrement));
                gui.draw((HumanEntity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryDecrementButton, this.instance)));
            gui.addElement(new StaticGuiElement('i', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 15), click -> {
                int increment = click.getType().isRightClick() ? 10 : 1;
                size.updateAndGet(i -> Math.min(this.instance.numberOfChoices, i + increment));
                gui.draw((HumanEntity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryIncrementButton, this.instance)));
            gui.addElement(new DynamicGuiElement('h', () -> new StaticGuiElement('g', LotteryPluginGUI.getNumberItem(size.get(), NumberSelectedState.SELECTED), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryMultipleSizeValue, this.instance)).map(each -> each.replace("{Count}", size.get() + "")).toArray(String[]::new))));
            gui.addElement(new DynamicGuiElement('l', () -> {
                long price = LotteryUtils.calculatePrice(size.get(), 0, this.instance.pricePerBet);
                return new StaticGuiElement('l', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 1), guiInfo, 16), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.multipleRandom(1, this.instance.numberOfChoices, size.get(), 1).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "1").replace("{BetUnits}", StringUtils.formatComma(price / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(price / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
            gui.addElement(new DynamicGuiElement('m', () -> {
                long price = LotteryUtils.calculatePrice(size.get(), 0, this.instance.pricePerBet);
                return new StaticGuiElement('m', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 2), guiInfo, 17), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.multipleRandom(1, this.instance.numberOfChoices, size.get(), 2).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "2").replace("{BetUnits}", StringUtils.formatComma(price * 2L / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price * 2L)).replace("{PricePartial}", StringUtils.formatComma(price * 2L / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
            gui.addElement(new DynamicGuiElement('n', () -> {
                long price = LotteryUtils.calculatePrice(size.get(), 0, this.instance.pricePerBet);
                return new StaticGuiElement('n', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 5), guiInfo, 18), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.multipleRandom(1, this.instance.numberOfChoices, size.get(), 5).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "5").replace("{BetUnits}", StringUtils.formatComma(price * 5L / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price * 5L)).replace("{PricePartial}", StringUtils.formatComma(price * 5L / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
            gui.addElement(new DynamicGuiElement('o', () -> {
                long price = LotteryUtils.calculatePrice(size.get(), 0, this.instance.pricePerBet);
                return new StaticGuiElement('o', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 10), guiInfo, 19), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.multipleRandom(1, this.instance.numberOfChoices, size.get(), 10).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "10").replace("{BetUnits}", StringUtils.formatComma(price * 10L / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price * 10L)).replace("{PricePartial}", StringUtils.formatComma(price * 10L / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
        } else if (type.equals((Object)BetNumbersType.BANKER_RANDOM)) {
            gui.addElement(new StaticGuiElement('h', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            AtomicInteger bankerSize = new AtomicInteger(1);
            AtomicInteger selectionSize = new AtomicInteger(6);
            gui.addElement(new StaticGuiElement('e', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 20), click -> {
                int decrement = click.getType().isRightClick() ? 10 : 1;
                bankerSize.updateAndGet(i -> Math.max(1, i - decrement));
                selectionSize.updateAndGet(i -> Math.max(7 - bankerSize.get(), i));
                gui.draw((HumanEntity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryDecrementButton, this.instance)));
            gui.addElement(new StaticGuiElement('g', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 21), click -> {
                int increment = click.getType().isRightClick() ? 10 : 1;
                bankerSize.updateAndGet(i -> Math.min(5, i + increment));
                selectionSize.updateAndGet(i -> Math.min(this.instance.numberOfChoices - bankerSize.get(), i));
                gui.draw((HumanEntity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryIncrementButton, this.instance)));
            gui.addElement(new StaticGuiElement('i', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 22), click -> {
                int decrement = click.getType().isRightClick() ? 10 : 1;
                selectionSize.updateAndGet(i -> Math.max(7 - bankerSize.get(), i - decrement));
                gui.draw((HumanEntity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryDecrementButton, this.instance)));
            gui.addElement(new StaticGuiElement('k', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 23), click -> {
                int increment = click.getType().isRightClick() ? 10 : 1;
                selectionSize.updateAndGet(i -> Math.min(this.instance.numberOfChoices - bankerSize.get(), i + increment));
                gui.draw((HumanEntity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryIncrementButton, this.instance)));
            gui.addElement(new DynamicGuiElement('f', () -> new StaticGuiElement('f', LotteryPluginGUI.getNumberItem(bankerSize.get(), NumberSelectedState.SELECTED), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBankerBankersValue, this.instance)).map(each -> each.replace("{Count}", bankerSize.get() + "")).toArray(String[]::new))));
            gui.addElement(new DynamicGuiElement('j', () -> new StaticGuiElement('j', LotteryPluginGUI.getNumberItem(selectionSize.get(), NumberSelectedState.SELECTED), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBankerSelectionsValue, this.instance)).map(each -> each.replace("{Count}", selectionSize.get() + "")).toArray(String[]::new))));
            gui.addElement(new DynamicGuiElement('l', () -> {
                long price = LotteryUtils.calculatePrice(selectionSize.get(), bankerSize.get(), this.instance.pricePerBet);
                return new StaticGuiElement('l', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 1), guiInfo, 24), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.bankerRandom(1, this.instance.numberOfChoices, bankerSize.get(), selectionSize.get(), 1).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "1").replace("{BetUnits}", StringUtils.formatComma(price / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(price / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
            gui.addElement(new DynamicGuiElement('m', () -> {
                long price = LotteryUtils.calculatePrice(selectionSize.get(), bankerSize.get(), this.instance.pricePerBet);
                return new StaticGuiElement('m', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 2), guiInfo, 25), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.bankerRandom(1, this.instance.numberOfChoices, bankerSize.get(), selectionSize.get(), 2).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "2").replace("{BetUnits}", StringUtils.formatComma(price * 2L / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price * 2L)).replace("{PricePartial}", StringUtils.formatComma(price * 2L / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
            gui.addElement(new DynamicGuiElement('n', () -> {
                long price = LotteryUtils.calculatePrice(selectionSize.get(), bankerSize.get(), this.instance.pricePerBet);
                return new StaticGuiElement('n', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 5), guiInfo, 26), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.bankerRandom(1, this.instance.numberOfChoices, bankerSize.get(), selectionSize.get(), 5).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "5").replace("{BetUnits}", StringUtils.formatComma(price * 5L / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price * 5L)).replace("{PricePartial}", StringUtils.formatComma(price * 5L / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
            gui.addElement(new DynamicGuiElement('o', () -> {
                long price = LotteryUtils.calculatePrice(selectionSize.get(), bankerSize.get(), this.instance.pricePerBet);
                return new StaticGuiElement('o', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), 10), guiInfo, 27), click -> {
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getComplexBulkNumberConfirm((Player)click.getWhoClicked(), game, BetNumbersBuilder.bankerRandom(1, this.instance.numberOfChoices, bankerSize.get(), selectionSize.get(), 10).map(each -> each.build()).collect(Collectors.toList())).show(click.getWhoClicked()), 2L, (Entity)player);
                    return true;
                }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiRandomEntryBetCountValueComplex, this.instance)).map(each -> each.replace("{Count}", "10").replace("{BetUnits}", StringUtils.formatComma(price * 10L / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price * 10L)).replace("{PricePartial}", StringUtils.formatComma(price * 10L / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new));
            }));
        }
        gui.setSilent(true);
        return gui;
    }

    public InventoryGui getNumberChooser(Player player, PlayableLotterySixGame game, BetNumbersBuilder builder) {
        String title;
        int num = this.instance.numberOfChoices;
        String[] guiSetup = LotteryPluginGUI.fillChars((num + (builder.getType().isMultipleCombination() ? 2 : 1)) / 9 + 1);
        String last = guiSetup[guiSetup.length - 1];
        guiSetup[guiSetup.length - 1] = last.substring(0, last.length() - 2) + "\u0001\u0000";
        boolean isBanker = builder.getType().isBanker();
        switch (builder.getType()) {
            case SINGLE: {
                title = this.instance.guiNewBetSingleTitle;
                break;
            }
            case MULTIPLE: {
                title = this.instance.guiNewBetMultipleTitle;
                break;
            }
            case BANKER: {
                title = this.instance.guiNewBetBankerTitle;
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)builder.getType()) + " type does not need choosing");
            }
        }
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.NUMBER_CHOOSER);
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, title.replace("{Price}", StringUtils.formatComma(LotteryUtils.calculatePrice(builder, this.instance))).replace("{MinSelection}", (isBanker ? ((BetNumbersBuilder.BankerBuilder)builder).getMinSelectionsNeeded() : 6) - builder.size() + ""), this.instance, game), guiSetup, new GuiElement[0]);
        char c = 'a';
        IntObjectConsumer<Player> handleClick = (number, clicker) -> {
            if (builder.completed() || isBanker && !((BetNumbersBuilder.BankerBuilder)builder).getBankers().isEmpty()) {
                if (isBanker && !((BetNumbersBuilder.BankerBuilder)builder).inSelectionPhase() && ((BetNumbersBuilder.BankerBuilder)builder).bankerCompleted()) {
                    ((BetNumbersBuilder.BankerBuilder)builder).finishBankers();
                    gui.removeElement('\u0000');
                    gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetNotYetFinish, this.instance, game)));
                    for (int banker : ((BetNumbersBuilder.BankerBuilder)builder).getBankers()) {
                        char bankerC = (char)(97 + banker - 1);
                        gui.removeElement(bankerC);
                        gui.addElement(new StaticGuiElement(bankerC, LotteryPluginGUI.getNumberItem(banker, NumberSelectedState.SELECTED_BANKER), ChatColor.YELLOW + "" + banker));
                    }
                } else if (builder.completed() || isBanker && !((BetNumbersBuilder.BankerBuilder)builder).inSelectionPhase() && !((BetNumbersBuilder.BankerBuilder)builder).getBankers().isEmpty()) {
                    long price = LotteryUtils.calculatePrice(builder, this.instance);
                    gui.removeElement('\u0000');
                    gui.addElement(new StaticGuiElement('\u0000', isBanker && !((BetNumbersBuilder.BankerBuilder)builder).inSelectionPhase() ? LotteryPluginGUI.setInfo(XMaterial.EMERALD.parseItem(), guiInfo, 1) : LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 2), click -> {
                        if (builder.completed()) {
                            Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                                BetNumbers betNumbers = builder.build();
                                if (betNumbers.getType().equals((Object)BetNumbersType.SINGLE)) {
                                    this.getSingleNumberConfirm((Player)click.getWhoClicked(), game, betNumbers).show(click.getWhoClicked());
                                } else {
                                    this.getComplexNumberConfirm((Player)click.getWhoClicked(), game, betNumbers).show(click.getWhoClicked());
                                }
                            }, 2L, (Entity)player);
                        } else if (isBanker && !((BetNumbersBuilder.BankerBuilder)builder).inSelectionPhase() && !((BetNumbersBuilder.BankerBuilder)builder).getBankers().isEmpty()) {
                            ((BetNumbersBuilder.BankerBuilder)builder).finishBankers();
                            gui.removeElement('\u0000');
                            gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetNotYetFinish, this.instance, game)));
                            for (int banker : ((BetNumbersBuilder.BankerBuilder)builder).getBankers()) {
                                char bankerC = (char)(97 + banker - 1);
                                gui.removeElement(bankerC);
                                gui.addElement(new StaticGuiElement(bankerC, LotteryPluginGUI.getNumberItem(banker, NumberSelectedState.SELECTED_BANKER), ChatColor.YELLOW + "" + banker));
                            }
                            gui.draw((HumanEntity)clicker);
                        }
                        return true;
                    }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, (String[])Arrays.stream(isBanker && !((BetNumbersBuilder.BankerBuilder)builder).inSelectionPhase() ? this.instance.guiNewBetFinishBankers : (builder.getType().isMultipleCombination() ? this.instance.guiNewBetFinishComplex : this.instance.guiNewBetFinishSimple)).map(each -> each.replace("{BetUnits}", StringUtils.formatComma(price / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(price / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new), this.instance, game)));
                }
            } else {
                gui.removeElement('\u0000');
                gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetNotYetFinish, this.instance, game)));
            }
        };
        for (int i = 0; i < num; ++i) {
            int number2 = i + 1;
            char c2 = c;
            c = (char)(c + 1);
            GuiStateElement element = new GuiStateElement(c2, new GuiStateElement.State(change -> {
                if (builder.canAdd()) {
                    builder.addNumber(number2);
                    handleClick.accept(number2, (Player)change.getWhoClicked());
                } else {
                    ((GuiStateElement)change.getElement()).nextState();
                }
                gui.draw(change.getWhoClicked());
            }, "true", LotteryPluginGUI.getNumberItem(number2, NumberSelectedState.SELECTED), LotteryPluginGUI.getNumberColor(number2) + ChatColor.BOLD + number2), new GuiStateElement.State(change -> {
                builder.removeNumber(number2);
                gui.draw((HumanEntity)player);
                GuiElement guiElement = gui.getElement('\u0000');
                if (guiElement != null) {
                    if (isBanker) {
                        BetNumbersBuilder.BankerBuilder bankerBuilder = (BetNumbersBuilder.BankerBuilder)builder;
                        if (bankerBuilder.inSelectionPhase()) {
                            if (!bankerBuilder.completed()) {
                                gui.removeElement('\u0000');
                                gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetNotYetFinish, this.instance, game)));
                                return;
                            }
                        } else if (bankerBuilder.getBankers().isEmpty()) {
                            gui.removeElement('\u0000');
                            gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetNotYetFinish, this.instance, game)));
                            return;
                        }
                    } else if (!builder.completed()) {
                        gui.removeElement('\u0000');
                        gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetNotYetFinish, this.instance, game)));
                        return;
                    }
                    long price = LotteryUtils.calculatePrice(builder, this.instance);
                    ((StaticGuiElement)gui.getElement('\u0000')).setText(LotteryUtils.formatPlaceholders((OfflinePlayer)player, (String[])Arrays.stream(isBanker && !((BetNumbersBuilder.BankerBuilder)builder).inSelectionPhase() ? this.instance.guiNewBetFinishBankers : (builder.getType().isMultipleCombination() ? this.instance.guiNewBetFinishComplex : this.instance.guiNewBetFinishSimple)).map(each -> each.replace("{BetUnits}", StringUtils.formatComma(price / this.instance.pricePerBet)).replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(price / (long)BetUnitType.PARTIAL.getDivisor()))).toArray(String[]::new), this.instance, game));
                }
            }, "false", LotteryPluginGUI.getNumberItem(number2, NumberSelectedState.NOT_SELECTED), LotteryPluginGUI.getNumberColor(number2) + number2));
            element.setState("false");
            element.setSilent(true);
            gui.addElement(element);
        }
        if (builder.getType().isMultipleCombination()) {
            char allChar = c;
            gui.addElement(new DynamicGuiElement(allChar, viewer -> {
                if (builder.canAdd()) {
                    if (!isBanker || ((BetNumbersBuilder.BankerBuilder)builder).inSelectionPhase()) {
                        return new StaticGuiElement(allChar, LotteryPluginGUI.getNumberItem(0, NumberSelectedState.NOT_SELECTED), click -> {
                            for (int number = 1; number <= num; ++number) {
                                if (builder.contains(number)) continue;
                                builder.addNumber(number);
                                GuiStateElement element = (GuiStateElement)gui.getElement((char)(97 + number - 1));
                                element.nextState();
                                handleClick.accept(number, (Player)click.getWhoClicked());
                            }
                            gui.draw(click.getWhoClicked());
                            return true;
                        }, ChatColor.GOLD + this.instance.guiNewBetSelectAll);
                    }
                    return new StaticGuiElement(allChar, new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString());
                }
                return new StaticGuiElement(allChar, LotteryPluginGUI.getNumberItem(0, NumberSelectedState.SELECTED), ChatColor.DARK_GRAY + this.instance.guiNewBetSelectAll);
            }));
        }
        gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.GRAY_DYE.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetNotYetFinish, this.instance, game)));
        gui.addElement(new DynamicGuiElement('\u0001', viewer -> {
            if (builder.canAdd()) {
                return new StaticGuiElement('\u0001', LotteryPluginGUI.setInfo(XMaterial.REDSTONE.parseItem(), guiInfo, 4), click -> {
                    int number = builder.addRandomNumber().getFirstInt();
                    GuiStateElement element = (GuiStateElement)gui.getElement((char)(97 + number - 1));
                    element.nextState();
                    handleClick.accept(number, (Player)click.getWhoClicked());
                    gui.draw(click.getWhoClicked());
                    return true;
                }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNewBetAddRandom, this.instance, game));
            }
            return new StaticGuiElement('\u0001', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString());
        }));
        return gui;
    }

    public InventoryGui getNumberConfirm(Player player, PlayableLotterySixGame game, Collection<BetNumbers> betNumbers, BetNumbersType type) {
        if (betNumbers.isEmpty()) {
            throw new IllegalArgumentException("betNumbers cannot be empty");
        }
        switch (type) {
            case SINGLE: {
                return this.getSingleNumberConfirm(player, game, betNumbers.iterator().next());
            }
            case MULTIPLE: 
            case BANKER: {
                return this.getComplexNumberConfirm(player, game, betNumbers.iterator().next());
            }
            case RANDOM: {
                return this.getSingleBulkNumberConfirm(player, game, betNumbers);
            }
            case MULTIPLE_RANDOM: 
            case BANKER_RANDOM: {
                return this.getComplexBulkNumberConfirm(player, game, betNumbers);
            }
        }
        throw new IllegalArgumentException("Unknown BetNumbersType \"" + (Object)((Object)type) + "\"");
    }

    public InventoryGui getSingleNumberConfirm(Player player, PlayableLotterySixGame game, BetNumbers betNumbers) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.SINGLE_NUMBER_CONFIRM);
        String[] guiSetup = guiInfo.getLayout();
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetSingleTitle, this.instance, game), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.LIME_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('z', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        char c = 'a';
        for (int i : betNumbers.getNumbers()) {
            char c2 = c;
            c = (char)(c + 1);
            gui.addElement(new StaticGuiElement(c2, LotteryPluginGUI.getNumberItem(i, NumberSelectedState.SELECTED), LotteryPluginGUI.getNumberColor(i) + i));
        }
        AtomicInteger multipleDraw = new AtomicInteger(1);
        gui.addElement(new StaticGuiElement('k', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 0), click -> {
            int decrement = click.getType().isRightClick() ? 5 : 1;
            multipleDraw.updateAndGet(i -> Math.max(1, i - decrement));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetDecrementButton, this.instance)));
        gui.addElement(new StaticGuiElement('m', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 1), click -> {
            int increment = click.getType().isRightClick() ? (multipleDraw.get() == 1 ? 4 : 5) : 1;
            multipleDraw.updateAndGet(i -> Math.min(20, i + increment));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetIncrementButton, this.instance)));
        gui.addElement(new DynamicGuiElement('l', () -> new StaticGuiElement('l', LotteryPluginGUI.getNumberItem(multipleDraw.get(), NumberSelectedState.SELECTED), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetMultipleDrawValue, this.instance)).map(each -> each.replace("{Count}", LotteryPluginGUI.multipleDrawStr(multipleDraw.get()))).toArray(String[]::new))));
        LongSupplier priceProvider = () -> LotteryUtils.calculatePrice(betNumbers, this.instance) * (long)multipleDraw.get();
        gui.addElement(new DynamicGuiElement('g', () -> new StaticGuiElement('g', LotteryPluginGUI.setInfo(XMaterial.DIAMOND.parseItem(), guiInfo, 2), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetLotteryInfo, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(priceProvider.getAsLong()))).toArray(String[]::new))));
        gui.addElement(new DynamicGuiElement('h', () -> {
            long price = priceProvider.getAsLong();
            return new StaticGuiElement('h', LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 3), click -> {
                this.checkFixedTransactionDeposit(player, price, () -> {
                    if (game != null && game.isValid()) {
                        if (this.instance.backendBungeecordMode) {
                            LotterySixPlugin.getPluginMessageHandler().requestAddBet(player.getName(), player.getUniqueId(), this.instance.pricePerBet, BetUnitType.FULL, betNumbers, multipleDraw.get());
                        } else {
                            AddBetResult result = game.addBet(player.getName(), player.getUniqueId(), this.instance.pricePerBet, BetUnitType.FULL, betNumbers, multipleDraw.get());
                            switch (result) {
                                case SUCCESS: {
                                    player.sendMessage(this.instance.messageBetPlaced.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case GAME_LOCKED: {
                                    player.sendMessage(this.instance.messageGameLocked.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case NOT_ENOUGH_MONEY: {
                                    player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_SELF: {
                                    player.sendMessage(this.instance.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_PERMISSION: {
                                    player.sendMessage(this.instance.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_CHANCE_PER_SELECTION: {
                                    player.sendMessage(this.instance.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case ACCOUNT_SUSPENDED: {
                                    long time = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                                    player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                            }
                            if (result.isSuccess()) {
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
                            }
                        }
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                    }
                });
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetUnitInvestmentConfirm, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price))).toArray(String[]::new));
        }));
        gui.addElement(new StaticGuiElement('i', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 4), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetCancel, this.instance, game)));
        return gui;
    }

    public InventoryGui getComplexNumberConfirm(Player player, PlayableLotterySixGame game, BetNumbers betNumbers) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.COMPLEX_NUMBER_CONFIRM);
        String[] guiSetup = guiInfo.getLayout();
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetComplexTitle, this.instance, game), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.LIME_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('z', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        AtomicInteger multipleDraw = new AtomicInteger(1);
        gui.addElement(new StaticGuiElement('k', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 0), click -> {
            int decrement = click.getType().isRightClick() ? 5 : 1;
            multipleDraw.updateAndGet(i -> Math.max(1, i - decrement));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetDecrementButton, this.instance)));
        gui.addElement(new StaticGuiElement('m', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 1), click -> {
            int increment = click.getType().isRightClick() ? (multipleDraw.get() == 1 ? 4 : 5) : 1;
            multipleDraw.updateAndGet(i -> Math.min(20, i + increment));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetIncrementButton, this.instance)));
        gui.addElement(new DynamicGuiElement('l', () -> new StaticGuiElement('l', LotteryPluginGUI.getNumberItem(multipleDraw.get(), NumberSelectedState.SELECTED), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetMultipleDrawValue, this.instance)).map(each -> each.replace("{Count}", LotteryPluginGUI.multipleDrawStr(multipleDraw.get()))).toArray(String[]::new))));
        LongSupplier priceProvider = () -> LotteryUtils.calculatePrice(betNumbers, this.instance) * (long)multipleDraw.get();
        gui.addElement(new DynamicGuiElement('a', () -> {
            long price = priceProvider.getAsLong();
            long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
            return new StaticGuiElement('a', LotteryPluginGUI.setInfo(XMaterial.PAPER.parseItem(), guiInfo, 2), StringUtils.wrapAtSpace(betNumbers.toFormattedString(), 6).replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial)));
        }));
        gui.addElement(new DynamicGuiElement('g', () -> {
            long price = priceProvider.getAsLong();
            long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
            return new StaticGuiElement('g', LotteryPluginGUI.setInfo(XMaterial.DIAMOND.parseItem(), guiInfo, 3), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetLotteryInfo, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial))).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('h', () -> {
            long price = priceProvider.getAsLong();
            long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
            return new StaticGuiElement('h', LotteryPluginGUI.setInfo(XMaterial.GOLD_NUGGET.parseItem(), guiInfo, 4), click -> {
                this.checkFixedTransactionDeposit(player, partial, () -> {
                    if (game != null && game.isValid()) {
                        if (this.instance.backendBungeecordMode) {
                            LotterySixPlugin.getPluginMessageHandler().requestAddBet(player.getName(), player.getUniqueId(), partial / (long)multipleDraw.get(), BetUnitType.PARTIAL, betNumbers, multipleDraw.get());
                        } else {
                            AddBetResult result = game.addBet(player.getName(), player.getUniqueId(), partial / (long)multipleDraw.get(), BetUnitType.PARTIAL, betNumbers, multipleDraw.get());
                            switch (result) {
                                case SUCCESS: {
                                    player.sendMessage(this.instance.messageBetPlaced.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case GAME_LOCKED: {
                                    player.sendMessage(this.instance.messageGameLocked.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case NOT_ENOUGH_MONEY: {
                                    player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case LIMIT_SELF: {
                                    player.sendMessage(this.instance.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case LIMIT_PERMISSION: {
                                    player.sendMessage(this.instance.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case LIMIT_CHANCE_PER_SELECTION: {
                                    player.sendMessage(this.instance.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case ACCOUNT_SUSPENDED: {
                                    long time = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                                    player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                            }
                            if (result.isSuccess()) {
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
                            }
                        }
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                    }
                });
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetPartialInvestmentConfirm, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial))).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('i', () -> {
            long price = priceProvider.getAsLong();
            long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
            return new StaticGuiElement('i', LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 5), click -> {
                this.checkFixedTransactionDeposit(player, price, () -> {
                    if (game != null && game.isValid()) {
                        if (this.instance.backendBungeecordMode) {
                            LotterySixPlugin.getPluginMessageHandler().requestAddBet(player.getName(), player.getUniqueId(), price / (long)multipleDraw.get(), BetUnitType.FULL, betNumbers, multipleDraw.get());
                        } else {
                            AddBetResult result = game.addBet(player.getName(), player.getUniqueId(), price / (long)multipleDraw.get(), BetUnitType.FULL, betNumbers, multipleDraw.get());
                            switch (result) {
                                case SUCCESS: {
                                    player.sendMessage(this.instance.messageBetPlaced.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case GAME_LOCKED: {
                                    player.sendMessage(this.instance.messageGameLocked.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case NOT_ENOUGH_MONEY: {
                                    player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_SELF: {
                                    player.sendMessage(this.instance.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_PERMISSION: {
                                    player.sendMessage(this.instance.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_CHANCE_PER_SELECTION: {
                                    player.sendMessage(this.instance.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case ACCOUNT_SUSPENDED: {
                                    long time = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                                    player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                            }
                            if (result.isSuccess()) {
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
                            }
                        }
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                    }
                });
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetUnitInvestmentConfirm, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial))).toArray(String[]::new));
        }));
        gui.addElement(new StaticGuiElement('j', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 6), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetCancel, this.instance, game)));
        return gui;
    }

    public InventoryGui getSingleBulkNumberConfirm(Player player, PlayableLotterySixGame game, Collection<BetNumbers> betNumbers) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.SINGLE_BULK_NUMBER_CONFIRM);
        String[] guiSetup = guiInfo.getLayout();
        int entriesTotal = betNumbers.stream().mapToInt(each -> each.getSetsSize()).sum();
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetBulkSingleTitle, this.instance, game), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.LIME_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('z', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        AtomicInteger multipleDraw = new AtomicInteger(1);
        gui.addElement(new StaticGuiElement('k', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 0), click -> {
            int decrement = click.getType().isRightClick() ? 5 : 1;
            multipleDraw.updateAndGet(i -> Math.max(1, i - decrement));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetDecrementButton, this.instance)));
        gui.addElement(new StaticGuiElement('m', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 1), click -> {
            int increment = click.getType().isRightClick() ? (multipleDraw.get() == 1 ? 4 : 5) : 1;
            multipleDraw.updateAndGet(i -> Math.min(20, i + increment));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetIncrementButton, this.instance)));
        gui.addElement(new DynamicGuiElement('l', () -> new StaticGuiElement('l', LotteryPluginGUI.getNumberItem(multipleDraw.get(), NumberSelectedState.SELECTED), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetMultipleDrawValue, this.instance)).map(each -> each.replace("{Count}", LotteryPluginGUI.multipleDrawStr(multipleDraw.get()))).toArray(String[]::new))));
        LongSupplier priceProvider = () -> betNumbers.stream().mapToLong(each -> LotteryUtils.calculatePrice(each, this.instance)).sum() * (long)multipleDraw.get();
        gui.addElement(new StaticGuiElement('a', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), betNumbers.size()), guiInfo, 2), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetBulkRandom, this.instance, game)).map(each -> each.replace("{EntriesTotal}", entriesTotal + "")).toArray(String[]::new)));
        gui.addElement(new DynamicGuiElement('g', () -> new StaticGuiElement('g', LotteryPluginGUI.setInfo(XMaterial.DIAMOND.parseItem(), guiInfo, 3), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetLotteryInfo, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(priceProvider.getAsLong()))).toArray(String[]::new))));
        gui.addElement(new DynamicGuiElement('h', () -> {
            long price = priceProvider.getAsLong();
            return new StaticGuiElement('h', LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 4), click -> {
                this.checkFixedTransactionDeposit(player, price, () -> {
                    if (game != null && game.isValid()) {
                        if (this.instance.backendBungeecordMode) {
                            LotterySixPlugin.getPluginMessageHandler().requestAddBet(player.getName(), player.getUniqueId(), price / (long)multipleDraw.get() / (long)betNumbers.size(), BetUnitType.FULL, betNumbers, multipleDraw.get());
                        } else {
                            AddBetResult result = game.addBet(player.getName(), player.getUniqueId(), price / (long)multipleDraw.get() / (long)betNumbers.size(), BetUnitType.FULL, betNumbers, multipleDraw.get());
                            switch (result) {
                                case SUCCESS: {
                                    player.sendMessage(this.instance.messageBetPlaced.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case GAME_LOCKED: {
                                    player.sendMessage(this.instance.messageGameLocked.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case NOT_ENOUGH_MONEY: {
                                    player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_SELF: {
                                    player.sendMessage(this.instance.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_PERMISSION: {
                                    player.sendMessage(this.instance.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_CHANCE_PER_SELECTION: {
                                    player.sendMessage(this.instance.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case ACCOUNT_SUSPENDED: {
                                    long time = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                                    player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                            }
                            if (result.isSuccess()) {
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
                            }
                        }
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                    }
                });
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetUnitInvestmentConfirm, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price))).toArray(String[]::new));
        }));
        gui.addElement(new StaticGuiElement('i', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 5), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetCancel, this.instance, game)));
        return gui;
    }

    public InventoryGui getComplexBulkNumberConfirm(Player player, PlayableLotterySixGame game, Collection<BetNumbers> betNumbers) {
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.COMPLEX_BULK_NUMBER_CONFIRM);
        String[] guiSetup = guiInfo.getLayout();
        int entriesTotal = betNumbers.stream().mapToInt(each -> each.getSetsSize()).sum();
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetBulkComplexTitle, this.instance, game), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.LIME_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('z', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        AtomicInteger multipleDraw = new AtomicInteger(1);
        gui.addElement(new StaticGuiElement('k', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 0), click -> {
            int decrement = click.getType().isRightClick() ? 5 : 1;
            multipleDraw.updateAndGet(i -> Math.max(1, i - decrement));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetDecrementButton, this.instance)));
        gui.addElement(new StaticGuiElement('m', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 1), click -> {
            int increment = click.getType().isRightClick() ? (multipleDraw.get() == 1 ? 4 : 5) : 1;
            multipleDraw.updateAndGet(i -> Math.min(20, i + increment));
            gui.draw((HumanEntity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetIncrementButton, this.instance)));
        gui.addElement(new DynamicGuiElement('l', () -> new StaticGuiElement('l', LotteryPluginGUI.getNumberItem(multipleDraw.get(), NumberSelectedState.SELECTED), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetMultipleDrawValue, this.instance)).map(each -> each.replace("{Count}", LotteryPluginGUI.multipleDrawStr(multipleDraw.get()))).toArray(String[]::new))));
        LongSupplier priceProvider = () -> betNumbers.stream().mapToLong(each -> LotteryUtils.calculatePrice(each, this.instance)).sum() * (long)multipleDraw.get();
        gui.addElement(new StaticGuiElement('a', LotteryPluginGUI.setInfo(LotteryPluginGUI.setItemSize(XMaterial.PAPER.parseItem(), betNumbers.size()), guiInfo, 2), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetBulkRandom, this.instance, game)).map(each -> each.replace("{EntriesTotal}", entriesTotal + "")).toArray(String[]::new)));
        gui.addElement(new DynamicGuiElement('g', () -> {
            long price = priceProvider.getAsLong();
            long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
            return new StaticGuiElement('g', LotteryPluginGUI.setInfo(XMaterial.DIAMOND.parseItem(), guiInfo, 3), (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetLotteryInfo, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial))).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('h', () -> {
            long price = priceProvider.getAsLong();
            long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
            return new StaticGuiElement('h', LotteryPluginGUI.setInfo(XMaterial.GOLD_NUGGET.parseItem(), guiInfo, 4), click -> {
                this.checkFixedTransactionDeposit(player, partial, () -> {
                    if (game != null && game.isValid()) {
                        if (this.instance.backendBungeecordMode) {
                            LotterySixPlugin.getPluginMessageHandler().requestAddBet(player.getName(), player.getUniqueId(), partial / (long)multipleDraw.get() / (long)betNumbers.size(), BetUnitType.PARTIAL, betNumbers, multipleDraw.get());
                        } else {
                            AddBetResult result = game.addBet(player.getName(), player.getUniqueId(), partial / (long)multipleDraw.get() / (long)betNumbers.size(), BetUnitType.PARTIAL, betNumbers, multipleDraw.get());
                            switch (result) {
                                case SUCCESS: {
                                    player.sendMessage(this.instance.messageBetPlaced.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case GAME_LOCKED: {
                                    player.sendMessage(this.instance.messageGameLocked.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case NOT_ENOUGH_MONEY: {
                                    player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case LIMIT_SELF: {
                                    player.sendMessage(this.instance.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case LIMIT_PERMISSION: {
                                    player.sendMessage(this.instance.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case LIMIT_CHANCE_PER_SELECTION: {
                                    player.sendMessage(this.instance.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                                case ACCOUNT_SUSPENDED: {
                                    long time = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                                    player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(partial)));
                                    break;
                                }
                            }
                            if (result.isSuccess()) {
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
                            }
                        }
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                    }
                });
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetPartialInvestmentConfirm, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial))).toArray(String[]::new));
        }));
        gui.addElement(new DynamicGuiElement('i', () -> {
            long price = priceProvider.getAsLong();
            long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
            return new StaticGuiElement('i', LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 5), click -> {
                this.checkFixedTransactionDeposit(player, price, () -> {
                    if (game != null && game.isValid()) {
                        if (this.instance.backendBungeecordMode) {
                            LotterySixPlugin.getPluginMessageHandler().requestAddBet(player.getName(), player.getUniqueId(), price / (long)multipleDraw.get() / (long)betNumbers.size(), BetUnitType.FULL, betNumbers, multipleDraw.get());
                        } else {
                            AddBetResult result = game.addBet(player.getName(), player.getUniqueId(), price / (long)multipleDraw.get() / (long)betNumbers.size(), BetUnitType.FULL, betNumbers, multipleDraw.get());
                            switch (result) {
                                case SUCCESS: {
                                    player.sendMessage(this.instance.messageBetPlaced.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case GAME_LOCKED: {
                                    player.sendMessage(this.instance.messageGameLocked.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case NOT_ENOUGH_MONEY: {
                                    player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_SELF: {
                                    player.sendMessage(this.instance.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_PERMISSION: {
                                    player.sendMessage(this.instance.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case LIMIT_CHANCE_PER_SELECTION: {
                                    player.sendMessage(this.instance.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                                case ACCOUNT_SUSPENDED: {
                                    long time = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                                    player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(price)));
                                    break;
                                }
                            }
                            if (result.isSuccess()) {
                                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
                            }
                        }
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                    }
                });
                return true;
            }, (String[])Arrays.stream(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetUnitInvestmentConfirm, this.instance, game)).map(each -> each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial))).toArray(String[]::new));
        }));
        gui.addElement(new StaticGuiElement('j', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 6), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(click.getWhoClicked()), 5L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiConfirmNewBetCancel, this.instance, game)));
        return gui;
    }

    public InventoryGui getPastResults(Player player, CompletedLotterySixGame game) {
        InventoryGui gui;
        if (game == null) {
            GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.PAST_RESULTS_NO_GAMES);
            String[] guiSetup = guiInfo.getLayout();
            gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsTitle, this.instance), guiSetup, new GuiElement[0]);
            gui.addElement(new StaticGuiElement('a', LotteryPluginGUI.setInfo(XMaterial.BARRIER.parseItem(), guiInfo, 0), ChatColor.RED + "No games have been played yet."));
        } else {
            GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.PAST_RESULTS);
            String[] guiSetup = guiInfo.getLayout();
            gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsTitle, this.instance, game), guiSetup, new GuiElement[0]);
            char c = 'a';
            for (int i : game.getDrawResult().getNumbersOrdered()) {
                char c2 = c;
                c = (char)(c + 1);
                gui.addElement(new StaticGuiElement(c2, LotteryPluginGUI.getNumberItem(i, NumberSelectedState.SELECTED), LotteryPluginGUI.getNumberColor(i) + i));
            }
            int specialNumber = game.getDrawResult().getSpecialNumber();
            gui.addElement(new StaticGuiElement(c, LotteryPluginGUI.getNumberItem(specialNumber, true, NumberSelectedState.SELECTED), LotteryPluginGUI.getNumberColor(specialNumber) + specialNumber));
            gui.addElement(new StaticGuiElement('h', LotteryPluginGUI.setInfo(XMaterial.CLOCK.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsLotteryInfo, this.instance, game)));
            gui.addElement(new StaticGuiElement('i', game.hasPlayerWinnings(player.getUniqueId()) ? LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.GOLD_INGOT.parseItem()), guiInfo, 1) : LotteryPluginGUI.setInfo(XMaterial.GOLD_INGOT.parseItem(), guiInfo, 2), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                    this.close(click.getWhoClicked(), click.getGui(), false);
                    Scheduler.runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                        String winningNumberStr = game.getDrawResult().toFormattedString();
                        ArrayList<BaseComponent> pages = new ArrayList<BaseComponent>();
                        List<PlayerWinnings> winningsList = game.getSortedPlayerWinnings(player.getUniqueId());
                        HashSet<UUID> displayedBets = new HashSet<UUID>();
                        for (PlayerWinnings winnings : winningsList) {
                            TextComponent text;
                            Object winningsForBet;
                            if (pages.size() > 100) break;
                            UUID betId = winnings.getWinningBetId();
                            if (displayedBets.contains(betId)) continue;
                            displayedBets.add(betId);
                            if (winnings.isBulk(game)) {
                                winningsForBet = game.getPlayerWinningsByBet(betId).values().stream().flatMap(each -> each.stream()).collect(Collectors.toList());
                                text = new TextComponent(winningNumberStr + "\n\n");
                                PlayerBets bets = winnings.getWinningBet(game);
                                BetNumbers betNumbers = bets.getChosenNumbers();
                                String[] stringArray = betNumbers.toFormattedString().replace("/ ", "/\n\u0000").split("\u0000");
                                int i = 0;
                                for (String numbers : stringArray) {
                                    TextComponent numbersText = new TextComponent(numbers);
                                    int finalI = i;
                                    Optional<PlayerWinnings> optWinnings = winningsForBet.stream().filter(each -> each.getWinningCombination().getNumbers().equals(betNumbers.getSet(finalI))).findFirst();
                                    if (optWinnings.isPresent()) {
                                        PlayerWinnings localWinnings = optWinnings.get();
                                        numbersText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.instance.winningsDescription.replace("{Tier}", this.instance.tierNames.get((Object)localWinnings.getTier())).replace("{Winnings}", StringUtils.formatComma(localWinnings.getWinnings())).replace("{UnitPrice}", StringUtils.formatComma(game.getPricePerBet(localWinnings.getWinningBet(game).getType()))))}));
                                    } else {
                                        numbersText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.instance.winningsDescription.replace("{Tier}", LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsNoWinnings, this.instance, game)).replace("{Winnings}", StringUtils.formatComma(0L)).replace("{UnitPrice}", StringUtils.formatComma(game.getPricePerBet(bets.getType()))))}));
                                    }
                                    text.addExtra((BaseComponent)numbersText);
                                    ++i;
                                }
                                text.addExtra("\n");
                                text.addExtra(this.instance.bulkWinningsDescription.replace("{HighestTier}", this.instance.tierNames.get((Object)winnings.getTier())).replace("{Winnings}", StringUtils.formatComma(winningsForBet.stream().mapToLong(each -> each.getWinnings()).sum())).replace("{UnitPrice}", StringUtils.formatComma(game.getPricePerBet(winnings.getWinningBet(game).getType()))));
                                pages.add((BaseComponent)text);
                                continue;
                            }
                            if (winnings.isCombination(game)) {
                                void var15_18;
                                void var17_22;
                                winningsForBet = game.getPlayerWinningsByBet(betId);
                                text = new TextComponent(winningNumberStr + "\n\n");
                                TextComponent numbersText = new TextComponent(winnings.getWinningBet(game).getChosenNumbers().toFormattedString().replace("/ ", "/\n"));
                                ArrayList<TextComponent> hoverComponents = new ArrayList<TextComponent>(7);
                                PrizeTier[] prizeTierArray = PrizeTier.values();
                                int n = prizeTierArray.length;
                                boolean bl = false;
                                while (var17_22 < n) {
                                    PrizeTier prizeTier = prizeTierArray[var17_22];
                                    List playerWinnings = (List)winningsForBet.get((Object)prizeTier);
                                    if (playerWinnings != null && !playerWinnings.isEmpty()) {
                                        hoverComponents.add(new TextComponent(this.instance.multipleWinningsDescription.replace("{Tier}", this.instance.tierNames.get((Object)prizeTier)).replace("{Times}", String.valueOf(playerWinnings.size())).replace("{Winnings}", StringUtils.formatComma(((PlayerWinnings)playerWinnings.get(0)).getWinnings())).replace("{UnitPrice}", StringUtils.formatComma(game.getPricePerBet(winnings.getWinningBet(game).getType())))));
                                    }
                                    ++var17_22;
                                }
                                boolean bl2 = false;
                                while (var15_18 < hoverComponents.size() - 1) {
                                    ((BaseComponent)hoverComponents.get((int)var15_18)).addExtra("\n");
                                    ++var15_18;
                                }
                                numbersText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponents.toArray(new BaseComponent[0])));
                                text.addExtra((BaseComponent)numbersText);
                                text.addExtra("\n");
                                text.addExtra(this.instance.combinationWinningsDescription.replace("{HighestTier}", this.instance.tierNames.get((Object)winnings.getTier())).replace("{Winnings}", StringUtils.formatComma(winningsForBet.values().stream().flatMap(each -> each.stream()).mapToLong(each -> each.getWinnings()).sum())).replace("{UnitPrice}", StringUtils.formatComma(game.getPricePerBet(winnings.getWinningBet(game).getType()))));
                                pages.add((BaseComponent)text);
                                continue;
                            }
                            String str = winningNumberStr + "\n\n" + winnings.getWinningBet(game).getChosenNumbers().toFormattedString().replace("/ ", "/\n") + "\n";
                            str = str + this.instance.winningsDescription.replace("{Tier}", this.instance.tierNames.get((Object)winnings.getTier())).replace("{Winnings}", StringUtils.formatComma(winnings.getWinnings())).replace("{UnitPrice}", StringUtils.formatComma(game.getPricePerBet(winnings.getWinningBet(game).getType())));
                            pages.add((BaseComponent)new TextComponent(str));
                        }
                        for (PlayerBets bets : game.getPlayerBets(player.getUniqueId())) {
                            if (pages.size() > 100) break;
                            if (displayedBets.contains(bets.getBetId())) continue;
                            String str = winningNumberStr + "\n\n" + bets.getChosenNumbers().toFormattedString().replace("/ ", "/\n") + "\n";
                            str = str + this.instance.winningsDescription.replace("{Tier}", LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsNoWinnings, this.instance, game)).replace("{Winnings}", StringUtils.formatComma(0L)).replace("{UnitPrice}", StringUtils.formatComma(game.getPricePerBet(bets.getType())));
                            pages.add((BaseComponent)new TextComponent(str));
                        }
                        if (pages.isEmpty()) {
                            pages.add((BaseComponent)new TextComponent(winningNumberStr + "\n\n" + String.join((CharSequence)"\n", LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsNothing, this.instance, game)) + "\n"));
                        }
                        ItemStack itemStack = XMaterial.WRITTEN_BOOK.parseItem();
                        BookUtils.setPagesComponent(itemStack, pages);
                        BookMeta meta = (BookMeta)itemStack.getItemMeta();
                        meta.setAuthor("LotterySix");
                        meta.setTitle("LotterySix");
                        itemStack.setItemMeta((ItemMeta)meta);
                        Scheduler.runTaskLater((Plugin)this.plugin, () -> BookUtils.openBook((Player)click.getWhoClicked(), itemStack), 1L, (Entity)player);
                    }, 1L);
                }, 1L, (Entity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsYourBets, this.instance, game)));
            gui.addElement(new StaticGuiElement('j', LotteryPluginGUI.setInfo(XMaterial.MAP.parseItem(), guiInfo, 3), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getPastResultsList(player, game).show((HumanEntity)player), 2L, (Entity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsListHistoricGames, this.instance, game)));
        }
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.YELLOW_STAINED_GLASS_PANE.parseItem()));
        gui.addElement(new StaticGuiElement('z', new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        gui.setCloseAction(action -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(action.getPlayer()), 5L, (Entity)player);
            return false;
        });
        return gui;
    }

    public InventoryGui getPastResultsList(Player player, CompletedLotterySixGame lastSelectedGame) {
        return this.getPastResultsList(player, this.instance.getCompletedGames().indexOf(lastSelectedGame), lastSelectedGame);
    }

    public InventoryGui getPastResultsList(Player player, int currentPosition, CompletedLotterySixGame lastSelectedGame) {
        int startPosition;
        LazyCompletedLotterySixGameList completedGames = this.instance.getCompletedGames();
        LinkedList<CompletedLotterySixGameIndex> list = new LinkedList<CompletedLotterySixGameIndex>();
        HashMap<CompletedLotterySixGameIndex, Integer> position = new HashMap<CompletedLotterySixGameIndex, Integer>();
        for (int i = startPosition = Math.max(0, currentPosition - currentPosition % 5); i < startPosition + 5 && i < completedGames.size(); ++i) {
            CompletedLotterySixGameIndex gameIndex = completedGames.getIndex(i);
            list.add(gameIndex);
            position.put(gameIndex, i);
        }
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.PAST_RESULTS_LIST);
        String[] guiSetup = LotteryPluginGUI.fillChars(5, 1);
        char lastChar = guiSetup[guiSetup.length - 1].charAt(8);
        guiSetup[5] = " \u0000  \u0001  \u0002 ";
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsHistoricGameListTitle.replace("{FromGameNumber}", ((CompletedLotterySixGameIndex)list.getFirst()).getGameNumber() + "").replace("{ToGameNumber}", ((CompletedLotterySixGameIndex)list.getLast()).getGameNumber() + ""), this.instance, lastSelectedGame), guiSetup, new GuiElement[0]);
        gui.setFiller(LotteryPluginGUI.getFillerItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem()));
        if (startPosition >= 5) {
            gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 0), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                    this.getPastResultsList(player, currentPosition - 5, lastSelectedGame).show((HumanEntity)player);
                    this.removeSecondLast((HumanEntity)player);
                }, 1L, (Entity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsHistoricNewerGames, this.instance, lastSelectedGame)));
        } else {
            gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.getFillerItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem()), ChatColor.LIGHT_PURPLE.toString()));
        }
        if (startPosition + 5 < completedGames.size()) {
            gui.addElement(new StaticGuiElement('\u0002', LotteryPluginGUI.setInfo(XMaterial.ARROW.parseItem(), guiInfo, 1), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                    this.getPastResultsList(player, currentPosition + 5, lastSelectedGame).show((HumanEntity)player);
                    this.removeSecondLast((HumanEntity)player);
                }, 1L, (Entity)player);
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsHistoricOlderGames, this.instance, lastSelectedGame)));
        } else {
            gui.addElement(new StaticGuiElement('\u0002', LotteryPluginGUI.getFillerItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem()), ChatColor.LIGHT_PURPLE.toString()));
        }
        char c = 'a';
        for (CompletedLotterySixGameIndex gameIndex : list) {
            char c2 = c;
            c = (char)(c + '\u0001');
            gui.addElement(new StaticGuiElement(c2, LotteryPluginGUI.setInfo(XMaterial.PAPER.parseItem(), guiInfo, 2), click -> {
                Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close((HumanEntity)player, gui, false), 1L, (Entity)player);
                Scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                    CompletedLotterySixGame game = completedGames.get((Integer)position.get(gameIndex));
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getPastResults(player, game).show((HumanEntity)player), 2L, (Entity)player);
                });
                return true;
            }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsHistoricGameListInfo, this.instance, gameIndex)));
            if (gameIndex.hasSpecialName()) {
                char c3 = c;
                c = (char)(c + '\u0001');
                gui.addElement(new StaticGuiElement(c3, LotteryPluginGUI.setInfo(LotteryPluginGUI.setEnchanted(XMaterial.GOLD_INGOT.parseItem()), guiInfo, 3), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsHistoricGameListSpecialName, this.instance, gameIndex)));
            } else {
                char c4 = c;
                c = (char)(c + '\u0001');
                gui.addElement(new StaticGuiElement(c4, new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
            }
            WinningNumbers winningNumbers = gameIndex.getDrawResult();
            for (int i : winningNumbers.getNumbersOrdered()) {
                char c5 = c;
                c = (char)(c + '\u0001');
                gui.addElement(new StaticGuiElement(c5, LotteryPluginGUI.getNumberItem(i, NumberSelectedState.SELECTED), LotteryPluginGUI.getNumberColor(i) + i));
            }
            int specialNumber = winningNumbers.getSpecialNumber();
            char c6 = c;
            c = (char)(c + '\u0001');
            gui.addElement(new StaticGuiElement(c6, LotteryPluginGUI.getNumberItem(specialNumber, true, NumberSelectedState.SELECTED), LotteryPluginGUI.getNumberColor(specialNumber) + specialNumber));
        }
        while (c <= lastChar) {
            char c7 = c;
            c = (char)(c + '\u0001');
            gui.addElement(new StaticGuiElement(c7, new ItemStack(Material.AIR), ChatColor.LIGHT_PURPLE.toString()));
        }
        ItemStack leftPre = XMaterial.PAPER.parseItem();
        ItemMeta leftMeta = leftPre.getItemMeta();
        leftMeta.setDisplayName(lastSelectedGame.getGameNumber() == null ? " " : lastSelectedGame.getGameNumber().toString());
        leftPre.setItemMeta(leftMeta);
        ItemStack left = LotteryPluginGUI.setInfo(leftPre, guiInfo, 5);
        gui.addElement(new StaticGuiElement('\u0001', LotteryPluginGUI.setInfo(XMaterial.MAP.parseItem(), guiInfo, 4), click -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.close(click.getWhoClicked(), click.getGui(), false), 1L, (Entity)player);
            Scheduler.runTaskLater((Plugin)this.plugin, () -> new AnvilGUI.Builder().plugin((Plugin)this.plugin).title(LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiGameNumberInputTitle, this.instance, lastSelectedGame)).itemLeft(left).onClick((slot, completion) -> {
                if (slot != 2) {
                    return Collections.emptyList();
                }
                Scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                    String input = completion.getText().trim();
                    try {
                        GameNumber gameNumber = GameNumber.fromString(input);
                        CompletedLotterySixGame targetGame = this.instance.getCompletedGames().get(gameNumber);
                        if (targetGame == null) {
                            player.sendMessage(this.instance.messageGameNumberNotFound);
                        } else {
                            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.getPastResults(player, targetGame).show((HumanEntity)player), 2L, (Entity)player);
                        }
                    }
                    catch (Exception e) {
                        player.sendMessage(this.instance.messageGameNumberNotFound);
                    }
                });
                return Collections.singletonList(AnvilGUI.ResponseAction.close());
            }).open(player), 2L, (Entity)player);
            return true;
        }, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiLastResultsLookupHistoricGames, this.instance, lastSelectedGame)));
        gui.setCloseAction(action -> {
            Scheduler.runTaskLater((Plugin)this.plugin, () -> this.checkReopen(action.getPlayer()), 5L, (Entity)player);
            return false;
        });
        return gui;
    }

    public InventoryGui getNumberStatistics(Player player, CompletedLotterySixGame game) {
        int num = this.instance.numberOfChoices;
        GUIInfo guiInfo = LotterySixPlugin.getInstance().guiInfo.get((Object)GUIType.NUMBER_STATISTICS);
        String[] guiSetup = LotteryPluginGUI.fillChars((num + 1) / 9 + 1);
        String last = guiSetup[guiSetup.length - 1];
        guiSetup[guiSetup.length - 1] = last.substring(0, last.length() - 1) + "\u0000";
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNumberStatisticsTitle, this.instance, game), guiSetup, new GuiElement[0]);
        char c = 'a';
        for (int i = 0; i < num; ++i) {
            int number = i + 1;
            NumberStatistics stats = game == null ? NumberStatistics.NOT_EVER_DRAWN : game.getNumberStatistics(number);
            char c2 = c;
            c = (char)(c + 1);
            gui.addElement(new StaticGuiElement(c2, LotteryPluginGUI.getNumberItem(number, stats.getLastDrawn() == 0, NumberSelectedState.SELECTED), LotteryPluginGUI.getNumberColor(number) + number, LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNumberStatisticsLastDrawn.replace("{Number}", number + ""), this.instance, game), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNumberStatisticsTimesDrawn.replace("{Number}", number + ""), this.instance, game)));
        }
        gui.addElement(new StaticGuiElement('\u0000', LotteryPluginGUI.setInfo(XMaterial.OAK_SIGN.parseItem(), guiInfo, 0), LotteryUtils.formatPlaceholders((OfflinePlayer)player, this.instance.guiNumberStatisticsNote, this.instance, game)));
        return gui;
    }

    public static enum NumberSelectedState {
        NOT_SELECTED(0),
        SELECTED(100),
        SELECTED_BANKER(200);

        private final int customModelDataOffset;

        private NumberSelectedState(int customModelDataOffset) {
            this.customModelDataOffset = customModelDataOffset;
        }

        public int getCustomModelDataOffset() {
            return this.customModelDataOffset;
        }
    }

    public static enum AccountTransactionMode {
        WITHDRAW,
        DEPOSIT;

    }
}

