/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.proxy.bungee.utils;

import com.loohp.lotterysix.utils.HTTPRequestUtils;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.json.simple.JSONObject;

public class PlayerUtilsBungee {
    private static final String PLAYER_PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static final String PLAYER_UUID_URL = "https://api.mojang.com/users/profiles/minecraft/%s";

    public static String getPlayerName(UUID uuid) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null) {
            return player.getName();
        }
        JSONObject jsonResponse = HTTPRequestUtils.getJSONResponse(PLAYER_PROFILE_URL.replaceFirst("%s", uuid.toString()));
        if (jsonResponse == null) {
            return null;
        }
        return (String)jsonResponse.get((Object)"name");
    }

    public static UUID getPlayerUUID(String name) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(name);
        if (player != null) {
            return player.getUniqueId();
        }
        JSONObject jsonResponse = HTTPRequestUtils.getJSONResponse(PLAYER_UUID_URL.replaceFirst("%s", name));
        if (jsonResponse == null) {
            return null;
        }
        Object id = jsonResponse.get((Object)"id");
        if (!(id instanceof String)) {
            return null;
        }
        String idStr = (String)id;
        if (!idStr.contains("-")) {
            idStr = idStr.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
        }
        try {
            return UUID.fromString(idStr);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }
}

