/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.proxy.velocity.utils;

import com.loohp.lotterysix.proxy.velocity.LotterySixVelocity;
import com.loohp.lotterysix.utils.HTTPRequestUtils;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import java.util.UUID;
import org.json.simple.JSONObject;

public class PlayerUtilsVelocity {
    private static final String PLAYER_PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static final String PLAYER_UUID_URL = "https://api.mojang.com/users/profiles/minecraft/%s";

    public static String getPlayerName(UUID uuid) {
        Optional player = LotterySixVelocity.proxyServer.getPlayer(uuid);
        if (player.isPresent()) {
            return ((Player)player.get()).getUsername();
        }
        JSONObject jsonResponse = HTTPRequestUtils.getJSONResponse(PLAYER_PROFILE_URL.replaceFirst("%s", uuid.toString()));
        if (jsonResponse == null) {
            return null;
        }
        return (String)jsonResponse.get((Object)"name");
    }

    public static UUID getPlayerUUID(String name) {
        Optional player = LotterySixVelocity.proxyServer.getPlayer(name);
        if (player.isPresent()) {
            return ((Player)player.get()).getUniqueId();
        }
        JSONObject jsonResponse = HTTPRequestUtils.getJSONResponse(PLAYER_UUID_URL.replaceFirst("%s", name));
        if (jsonResponse == null) {
            return null;
        }
        Object id = jsonResponse.get((Object)"id");
        if (!(id instanceof String)) {
            return null;
        }
        String idStr = (String)id;
        if (!idStr.contains("-")) {
            idStr = idStr.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
        }
        try {
            return UUID.fromString(idStr);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }
}

