/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.utils;

import com.loohp.lotterysix.game.lottery.GameNumber;
import com.loohp.lotterysix.game.objects.NumberStatistics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Year;
import java.util.UUID;

public class DataTypeIO {
    public static UUID readUUID(DataInputStream in) throws IOException {
        return new UUID(in.readLong(), in.readLong());
    }

    public static void writeUUID(DataOutputStream out, UUID uuid) throws IOException {
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
    }

    public static String readString(DataInputStream in, Charset charset) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            throw new IOException("Premature end of stream.");
        }
        byte[] b = new byte[length];
        in.readFully(b);
        return new String(b, charset);
    }

    public static void writeString(DataOutputStream out, String string, Charset charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static GameNumber readGameNumber(DataInputStream in) throws IOException {
        return new GameNumber(Year.of(in.readInt()), in.readInt());
    }

    public static void writeGameNumber(DataOutputStream out, GameNumber gameNumber) throws IOException {
        out.writeInt(gameNumber.getYear().getValue());
        out.writeInt(gameNumber.getNumber());
    }

    public static NumberStatistics readNumberStatistics(DataInputStream in) throws IOException {
        return new NumberStatistics(in.readInt(), in.readInt());
    }

    public static void writeNumberStatistics(DataOutputStream out, NumberStatistics statistics) throws IOException {
        out.writeInt(statistics.getLastDrawn());
        out.writeInt(statistics.getTimesDrawn());
    }
}

