/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.discordsrv.menus;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.loohp.lotterysix.discordsrv.DiscordInteraction;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.BetUnitType;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersBuilder;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersType;
import com.loohp.lotterysix.utils.LotteryUtils;
import com.loohp.lotterysix.utils.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Emoji;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ActionRow;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Button;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Component;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.selections.SelectOption;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.selections.SelectionMenu;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.WebhookMessageUpdateAction;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.OfflinePlayer;

public class PlaceBetInteraction
extends DiscordInteraction {
    public static final String INTERACTION_LABEL = "ls_place_bet";
    public static final String CONFIRM_SCREEN_BACK = "ls_place_bet_confirm_screen_back_";
    public static final String SINGLE_ENTRY_LABEL = "ls_place_bet_single";
    public static final String MULTIPLE_ENTRY_LABEL = "ls_place_bet_multiple";
    public static final String BANKER_ENTRY_LABEL = "ls_place_bet_banker";
    public static final String RANDOM_ENTRY_LABEL = "ls_place_bet_random";
    public static final String SINGLE_RANDOM_ENTRY_LABEL = "ls_place_bet_single_random";
    public static final String MULTIPLE_RANDOM_ENTRY_LABEL = "ls_place_bet_multiple_random";
    public static final String BANKER_RANDOM_ENTRY_LABEL = "ls_place_bet_banker_random";
    public static final String SINGLE_ENTRY_SELECTION_LABEL = "ls_place_bet_single_selection_";
    public static final String SINGLE_ENTRY_SELECTION_OPTION_LABEL = "ls_place_bet_single_number_";
    public static final String SINGLE_ENTRY_SELECTION_RANDOM_LABEL = "ls_place_bet_single_cpu_random_";
    public static final String SINGLE_ENTRY_CONFIRM_LABEL = "ls_place_bet_single_confirm_";
    public static final String MULTIPLE_ENTRY_SELECTION_LABEL = "ls_place_bet_multiple_selection_";
    public static final String MULTIPLE_ENTRY_SELECTION_OPTION_LABEL = "ls_place_bet_multiple_number_";
    public static final String MULTIPLE_ENTRY_SELECTION_SELECT_ALL_LABEL = "ls_place_bet_multiple_select_all_";
    public static final String MULTIPLE_ENTRY_SELECTION_RANDOM_LABEL = "ls_place_bet_multiple_cpu_random_";
    public static final String MULTIPLE_ENTRY_CONFIRM_LABEL = "ls_place_bet_multiple_confirm_";
    public static final String BANKER_ENTRY_SELECTION_LABEL = "ls_place_bet_banker_selection_";
    public static final String BANKER_ENTRY_SELECTION_OPTION_LABEL = "ls_place_bet_banker_number_";
    public static final String BANKER_ENTRY_SELECTION_SELECT_ALL_LABEL = "ls_place_bet_banker_select_all_";
    public static final String BANKER_ENTRY_SELECTION_RANDOM_LABEL = "ls_place_bet_banker_cpu_random_";
    public static final String BANKER_ENTRY_CONFIRM_LABEL = "ls_place_bet_banker_confirm_";
    public static final String SINGLE_RANDOM_ENTRY_CONFIRM_LABEL = "ls_place_bet_single_random_";
    public static final String MULTIPLE_RANDOM_ENTRY_SIZE_LABEL = "ls_place_bet_multiple_random_selection_";
    public static final String MULTIPLE_RANDOM_ENTRY_SIZE_OPTION_LABEL = "ls_place_bet_multiple_random_size_";
    public static final String MULTIPLE_RANDOM_ENTRY_CONFIRM_LABEL = "ls_place_bet_multiple_random_";
    public static final String BANKER_RANDOM_ENTRY_BANKER_LABEL = "ls_place_bet_banker_random_bankersel_";
    public static final String BANKER_RANDOM_ENTRY_BANKER_OPTION_LABEL = "ls_place_bet_banker_random_banker_";
    public static final String BANKER_RANDOM_ENTRY_SIZE_LABEL = "ls_place_bet_banker_random_selection_";
    public static final String BANKER_RANDOM_ENTRY_SIZE_OPTION_LABEL = "ls_place_bet_banker_random_size_";
    public static final String BANKER_RANDOM_ENTRY_CONFIRM_LABEL = "ls_place_bet_banker_random_";
    public static final String PLACE_BET_CONFIRM_MULTIPLE_DRAW_LABEL = "ls_place_bet_multiple_draw_selection_";
    public static final String PLACE_BET_CONFIRM_MULTIPLE_DRAW_OPTION_LABEL = "ls_place_bet_multiple_draw_option_";
    public static final String PLACE_BET_CONFIRM_LABEL = "ls_place_bet_{Number}_{Unit}";
    public static final Pattern PLACE_BET_CONFIRM_LABEL_PATTERN = Pattern.compile("^ls_place_bet_([^_]+)_(.+)$");
    public static final Color OFFSET_WHITE = new Color(0xFFFFFE);
    private final Map<UUID, BetNumbersBuilder> chosenNumbers;
    private final Map<UUID, List<BetNumbers>> confirmNumbers;
    private final Map<UUID, int[]> randomSizeSelection;
    private final Map<UUID, long[]> multipleDrawSelection;
    private final Map<UUID, ConfirmBackData> confirmBack;

    public PlaceBetInteraction() {
        super(INTERACTION_LABEL, true);
        Cache chosenNumbers = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.chosenNumbers = chosenNumbers.asMap();
        Cache confirmNumbers = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.confirmNumbers = confirmNumbers.asMap();
        Cache randomSizeSelection = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.randomSizeSelection = randomSizeSelection.asMap();
        Cache multipleDrawSelection = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.multipleDrawSelection = multipleDrawSelection.asMap();
        Cache confirmBack = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.confirmBack = confirmBack.asMap();
    }

    public List<SelectionMenu.Builder> createNumberSelectionMenu(String menuId, String optionsId) {
        return this.createNumberSelectionMenu(menuId, optionsId, Collections.emptySet());
    }

    public List<SelectionMenu.Builder> createNumberSelectionMenu(String menuId, String optionsId, Collection<Integer> hidden) {
        ArrayList<SelectionMenu.Builder> list = new ArrayList<SelectionMenu.Builder>(2);
        int u = 1;
        SelectionMenu.Builder current = SelectionMenu.create((String)(menuId + u++));
        for (int i = 1; i <= PlaceBetInteraction.instance.numberOfChoices; ++i) {
            if (hidden.contains(i)) continue;
            if (current.getOptions().size() >= 25) {
                list.add(current);
                current = SelectionMenu.create((String)(menuId + u++));
            }
            current.addOption(String.valueOf(i), optionsId + i);
        }
        list.add(current);
        return list;
    }

    public List<SelectionMenu.Builder> createSizeSelectionMenu(String menuId, String optionsId, int min, int max, String optionFormat) {
        ArrayList<SelectionMenu.Builder> list = new ArrayList<SelectionMenu.Builder>(2);
        int u = 1;
        SelectionMenu.Builder current = SelectionMenu.create((String)(menuId + u++));
        for (int i = min; i <= max; ++i) {
            if (current.getOptions().size() >= 25) {
                list.add(current);
                current = SelectionMenu.create((String)(menuId + u++));
            }
            current.addOption(optionFormat.replace("{Count}", String.valueOf(i)), optionsId + i);
        }
        list.add(current);
        return list;
    }

    @Override
    public boolean doOccupyEntireRow(UUID uuid) {
        return false;
    }

    @Override
    public List<ActionRow> getActionRows(UUID uuid) {
        Button button = Button.success((String)INTERACTION_LABEL, (String)PlaceBetInteraction.instance.discordSRVSlashCommandsPlaceBetTitle).withEmoji(Emoji.fromUnicode((String)"\ud83d\udcb0"));
        if (instance.getCurrentGame() == null) {
            button = button.asDisabled();
        }
        return Collections.singletonList(ActionRow.of((Component[])new Component[]{button}));
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handle(GenericComponentInteractionCreateEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleConfirm(GenericComponentInteractionCreateEvent event, OfflinePlayer player, BetNumbersType type, List<BetNumbers> betNumbers, Runnable repopulateData) {
        PlayableLotterySixGame game = instance.getCurrentGame();
        long price = betNumbers.stream().mapToLong(each -> LotteryUtils.calculatePrice(each, instance)).sum();
        long partial = price / (long)BetUnitType.PARTIAL.getDivisor();
        StringBuilder sb = new StringBuilder();
        for (String line : PlaceBetInteraction.instance.discordSRVSlashCommandsPlaceBetSubTitle) {
            sb.append(ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(player, line.replace("{BetNumbersType}", PlaceBetInteraction.instance.betNumbersTypeNames.get((Object)type)), instance, game))).append("\n");
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        if (type.isRandom()) {
            int entriesTotal = betNumbers.stream().mapToInt(each -> each.getSetsSize()).sum();
            sb.append("**").append(ChatColor.stripColor((String)Arrays.stream(LotteryUtils.formatPlaceholders(player, PlaceBetInteraction.instance.guiConfirmNewBetBulkRandom, instance, game)).map(each -> each.replace("{EntriesTotal}", entriesTotal + "")).collect(Collectors.joining("**\n**")))).append("**");
        } else {
            sb.append("**").append(betNumbers.iterator().next().toString()).append("**");
        }
        String description = sb.charAt(sb.length() - 1) == '\n' ? sb.substring(0, sb.length() - 1) : sb.toString();
        EmbedBuilder builder = new EmbedBuilder().setColor(Color.GREEN).setTitle(ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(player, PlaceBetInteraction.instance.discordSRVSlashCommandsPlaceBetTitle, instance, game))).setDescription((CharSequence)description).setThumbnail(PlaceBetInteraction.instance.discordSRVSlashCommandsPlaceBetThumbnailURL);
        UUID betNumbersId = UUID.randomUUID();
        String id = PLACE_BET_CONFIRM_LABEL.replace("{Number}", betNumbersId.toString());
        this.confirmNumbers.put(betNumbersId, betNumbers);
        WebhookMessageUpdateAction action = event.getHook().editOriginalEmbeds(new MessageEmbed[]{builder.build()});
        ArrayList<ActionRow> actionRows = new ArrayList<ActionRow>();
        String menuId = PLACE_BET_CONFIRM_MULTIPLE_DRAW_LABEL + betNumbersId + "_";
        List<SelectionMenu.Builder> multipleDrawMenu = this.createSizeSelectionMenu(menuId, PLACE_BET_CONFIRM_MULTIPLE_DRAW_OPTION_LABEL, 1, 20, PlaceBetInteraction.instance.discordSRVSlashCommandsComponentsMultipleDrawSelection);
        multipleDrawMenu.get(0).setDefaultValues(Collections.singleton(((SelectOption)multipleDrawMenu.get(0).getOptions().get(0)).getValue()));
        for (SelectionMenu.Builder menu : multipleDrawMenu) {
            actionRows.add(ActionRow.of((Component[])new Component[]{menu.setMaxValues(1).setMinValues(1).build()}));
        }
        this.multipleDrawSelection.put(betNumbersId, new long[]{1L, price});
        if (type.isMultipleCombination()) {
            actionRows.add(ActionRow.of((Component[])new Component[]{Button.secondary((String)id.replace("{Unit}", BetUnitType.PARTIAL.name()), (String)Arrays.stream(LotteryUtils.formatPlaceholders(player, PlaceBetInteraction.instance.guiConfirmNewBetPartialInvestmentConfirm, instance, game)).map(each -> ChatColor.stripColor((String)each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial)))).collect(Collectors.joining("\n"))), Button.primary((String)id.replace("{Unit}", BetUnitType.FULL.name()), (String)Arrays.stream(LotteryUtils.formatPlaceholders(player, PlaceBetInteraction.instance.guiConfirmNewBetUnitInvestmentConfirm, instance, game)).map(each -> ChatColor.stripColor((String)each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial)))).collect(Collectors.joining("\n")))}));
        } else {
            actionRows.add(ActionRow.of((Component[])new Component[]{Button.primary((String)id.replace("{Unit}", BetUnitType.FULL.name()), (String)Arrays.stream(LotteryUtils.formatPlaceholders(player, PlaceBetInteraction.instance.guiConfirmNewBetUnitInvestmentConfirm, instance, game)).map(each -> ChatColor.stripColor((String)each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial)))).collect(Collectors.joining("\n")))}));
        }
        UUID backId = UUID.randomUUID();
        Message message = event.getMessage();
        this.confirmBack.put(backId, new ConfirmBackData(message.getActionRows(), message.getEmbeds(), repopulateData));
        actionRows.add(ActionRow.of((Component[])new Component[]{PlaceBetInteraction.getMainMenuButton().withId(CONFIRM_SCREEN_BACK + backId)}));
        action.setActionRows(actionRows).retainFiles(Collections.emptyList()).queue();
    }

    private static /* synthetic */ long lambda$handle$58(BetNumbers each) {
        return LotteryUtils.calculatePrice(each, instance);
    }

    private static /* synthetic */ Button lambda$handle$57(Button b) {
        return b.asDisabled();
    }

    private static /* synthetic */ String lambda$handle$56(long price, long partial, String each) {
        return ChatColor.stripColor((String)each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial)));
    }

    private static /* synthetic */ String lambda$handle$55(long price, long partial, String each) {
        return ChatColor.stripColor((String)each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial)));
    }

    private static /* synthetic */ String lambda$handle$54(long price, long partial, String each) {
        return ChatColor.stripColor((String)each.replace("{Price}", StringUtils.formatComma(price)).replace("{PricePartial}", StringUtils.formatComma(partial)));
    }

    private /* synthetic */ void lambda$handle$53(UUID selectionId, int[] data) {
        this.randomSizeSelection.put(selectionId, data);
    }

    private static /* synthetic */ BetNumbers lambda$handle$52(BetNumbersBuilder.BankerRandomBuilder b) {
        return b.build();
    }

    private static /* synthetic */ ActionRow lambda$handle$51(SelectionMenu.Builder m) {
        return ActionRow.of((Component[])new Component[]{m.setMinValues(1).setMaxValues(1).build()});
    }

    private static /* synthetic */ int[] lambda$handle$50(UUID k) {
        return new int[]{1, 6};
    }

    private static /* synthetic */ ActionRow lambda$handle$49(SelectionMenu.Builder m) {
        return ActionRow.of((Component[])new Component[]{m.setMinValues(1).setMaxValues(1).build()});
    }

    private static /* synthetic */ int[] lambda$handle$43(UUID k) {
        return new int[]{7};
    }

    public static class ConfirmBackData {
        private final List<ActionRow> actionRows;
        private final List<MessageEmbed> messageEmbeds;
        private final Runnable repopulateData;

        public ConfirmBackData(List<ActionRow> actionRows, List<MessageEmbed> messageEmbeds, Runnable repopulateData) {
            this.actionRows = actionRows;
            this.messageEmbeds = messageEmbeds;
            this.repopulateData = repopulateData;
        }

        public List<ActionRow> getActionRows() {
            return this.actionRows;
        }

        public List<MessageEmbed> getMessageEmbeds() {
            return this.messageEmbeds;
        }

        public void repopulateData() {
            if (this.repopulateData != null) {
                this.repopulateData.run();
            }
        }
    }
}

