/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LazyReplaceString
implements CharSequence {
    private final String value;

    public LazyReplaceString(String value) {
        this.value = value;
    }

    public LazyReplaceString replace(String target, Supplier<String> replacement) {
        if (this.value.contains(target)) {
            return new LazyReplaceString(this.value.replace(target, replacement.get()));
        }
        return this;
    }

    public LazyReplaceString replaceAll(String regex, Function<MatchResult, String> replacement) {
        Pattern pattern = Pattern.compile(regex);
        if (pattern.matcher(this.value).find()) {
            Matcher matcher = pattern.matcher(this.value);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, replacement.apply(matcher));
            }
            matcher.appendTail(sb);
            return new LazyReplaceString(sb.toString());
        }
        return this;
    }

    public LazyReplaceString replace(String target, String replacement) {
        if (this.value.contains(target)) {
            return new LazyReplaceString(this.value.replace(target, replacement));
        }
        return this;
    }

    public LazyReplaceString replaceAll(String regex, String replacement) {
        Pattern pattern = Pattern.compile(regex);
        if (pattern.matcher(this.value).find()) {
            return new LazyReplaceString(pattern.matcher(this.value).replaceAll(replacement));
        }
        return this;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyReplaceString that = (LazyReplaceString)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

