/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.org.simpleyaml.configuration.implementation.snakeyaml;

import com.loohp.lotterysix.libs.org.simpleyaml.configuration.ConfigurationSection;
import com.loohp.lotterysix.libs.org.simpleyaml.configuration.implementation.api.QuoteValue;
import com.loohp.lotterysix.libs.org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlQuoteValue;
import com.loohp.lotterysix.libs.org.simpleyaml.configuration.serialization.ConfigurationSerializable;
import com.loohp.lotterysix.libs.org.simpleyaml.configuration.serialization.ConfigurationSerialization;
import com.loohp.lotterysix.libs.org.yaml.snakeyaml.DumperOptions;
import com.loohp.lotterysix.libs.org.yaml.snakeyaml.nodes.Node;
import com.loohp.lotterysix.libs.org.yaml.snakeyaml.nodes.Tag;
import com.loohp.lotterysix.libs.org.yaml.snakeyaml.representer.Represent;
import com.loohp.lotterysix.libs.org.yaml.snakeyaml.representer.Representer;
import com.loohp.lotterysix.libs.org.yaml.snakeyaml.representer.SafeRepresenter;
import java.util.LinkedHashMap;

public class SnakeYamlRepresenter
extends Representer {
    public SnakeYamlRepresenter() {
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        this.multiRepresenters.put(QuoteValue.class, new RepresentQuoteValue());
    }

    private final class RepresentQuoteValue
    implements Represent {
        private RepresentQuoteValue() {
        }

        @Override
        public Node representData(Object data) {
            QuoteValue quoteValue = (QuoteValue)data;
            DumperOptions.ScalarStyle quoteScalarStyle = SnakeYamlQuoteValue.getQuoteScalarStyle(quoteValue.getQuoteStyle());
            Object value = quoteValue.getValue();
            if (value == null) {
                return SnakeYamlRepresenter.this.representScalar(Tag.NULL, "", quoteScalarStyle);
            }
            DumperOptions.ScalarStyle defaultScalarStyle = SnakeYamlRepresenter.this.getDefaultScalarStyle();
            SnakeYamlRepresenter.this.setDefaultScalarStyle(quoteScalarStyle);
            Node node = SnakeYamlRepresenter.this.representData(value);
            SnakeYamlRepresenter.this.setDefaultScalarStyle(defaultScalarStyle);
            return node;
        }
    }

    private final class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super(SnakeYamlRepresenter.this);
        }

        @Override
        public Node representData(Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }

    private final class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super(SnakeYamlRepresenter.this);
        }

        @Override
        public Node representData(Object data) {
            return super.representData(((ConfigurationSection)data).getValues(false));
        }
    }
}

