/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.reflect.accessor;

import com.loohp.lotterysix.libs.xyz.tozymc.reflect.accessor.Accessor;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.accessor.ConstructorAccessor;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.accessor.FieldAccessor;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.accessor.MethodAccessor;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.util.Constructors;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.util.Fields;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.util.Methods;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.util.NotFoundMessages;
import com.loohp.lotterysix.libs.xyz.tozymc.util.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Accessors {
    private static final Map<Accessor.Query, Accessor> accessedObjects = new HashMap<Accessor.Query, Accessor>();

    @Contract(value="_ -> new")
    @NotNull
    public static FieldAccessor accessField(@NotNull Field field) {
        return new FieldAccessor(field);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T> ConstructorAccessor<T> accessConstructor(@NotNull Constructor<T> constructor) {
        return new ConstructorAccessor<T>(constructor);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MethodAccessor accessMethod(@NotNull Method method) {
        return new MethodAccessor(method);
    }

    public static FieldAccessor accessField(@NotNull Class<?> clazz, @NotNull String name) {
        return Accessors.accessField(Accessor.QueryBuilder.builder(clazz).type(Accessor.Type.FIELD).name(name).build());
    }

    public static <T> ConstructorAccessor<T> accessConstructor(@NotNull Class<?> clazz, Class<?> ... paramTypes) {
        return Accessors.accessConstructor(Accessor.QueryBuilder.builder(clazz).type(Accessor.Type.METHOD).paramTypes(paramTypes).build());
    }

    public static MethodAccessor accessMethod(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... paramTypes) {
        return Accessors.accessMethod(Accessor.QueryBuilder.builder(clazz).type(Accessor.Type.METHOD).name(name).paramTypes(paramTypes).build());
    }

    @NotNull
    public static FieldAccessor accessField(Accessor.Query @NotNull [] queries) {
        for (Accessor.Query query : queries) {
            FieldAccessor accessed = null;
            try {
                accessed = Accessors.accessField(query);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (accessed == null) continue;
            return accessed;
        }
        throw new RuntimeException("Queries: " + Arrays.toString(queries), new NoSuchFieldException());
    }

    @NotNull
    public static ConstructorAccessor<?> accessConstructor(Accessor.Query @NotNull [] queries) {
        for (Accessor.Query query : queries) {
            ConstructorAccessor accessed = null;
            try {
                accessed = Accessors.accessConstructor(query);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (accessed == null) continue;
            return accessed;
        }
        throw new RuntimeException("Queries: " + Arrays.toString(queries), new NoSuchMethodException());
    }

    @NotNull
    public static MethodAccessor accessMethod(Accessor.Query @NotNull [] queries) {
        for (Accessor.Query query : queries) {
            MethodAccessor accessed = null;
            try {
                accessed = Accessors.accessMethod(query);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (accessed == null) continue;
            return accessed;
        }
        throw new RuntimeException("Queries: " + Arrays.toString(queries), new NoSuchMethodException());
    }

    public static FieldAccessor accessField(@NotNull Accessor.Query query) {
        Preconditions.checkArgument(query.type().equals((Object)Accessor.Type.FIELD), "Type must be FIELD");
        Preconditions.checkArgument(!query.name().isEmpty(), "Name cannot be empty");
        if (accessedObjects.containsKey(query)) {
            return (FieldAccessor)accessedObjects.get(query);
        }
        Field field = Fields.getField(query.clazz(), query.name());
        if (field == null) {
            throw new NullPointerException(NotFoundMessages.fieldNotFound(query.name()));
        }
        FieldAccessor accessed = new FieldAccessor(field);
        accessedObjects.put(query, accessed);
        return accessed;
    }

    public static <T> ConstructorAccessor<T> accessConstructor(@NotNull Accessor.Query query) {
        Preconditions.checkArgument(query.type().equals((Object)Accessor.Type.METHOD), "Type must be METHOD");
        if (accessedObjects.containsKey(query)) {
            return (ConstructorAccessor)accessedObjects.get(query);
        }
        Constructor<?> constructor = Constructors.getConstructor(query.clazz(), query.paramTypes());
        if (constructor == null) {
            throw new NullPointerException(NotFoundMessages.constructorNotFound(query.clazz(), query.paramTypes()));
        }
        ConstructorAccessor accessed = new ConstructorAccessor(constructor);
        accessedObjects.put(query, accessed);
        return accessed;
    }

    public static MethodAccessor accessMethod(@NotNull Accessor.Query query) {
        Preconditions.checkArgument(query.type().equals((Object)Accessor.Type.METHOD), "Type must be METHOD");
        Preconditions.checkArgument(!query.name().isEmpty(), "Name cannot be empty");
        if (accessedObjects.containsKey(query)) {
            return (MethodAccessor)accessedObjects.get(query);
        }
        Method method = Methods.getMethod(query.clazz(), query.name(), query.paramTypes());
        if (method == null) {
            throw new NullPointerException(NotFoundMessages.methodNotFound(query.name(), query.paramTypes()));
        }
        MethodAccessor accessed = new MethodAccessor(method);
        accessedObjects.put(query, accessed);
        return accessed;
    }
}

