/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.reflect.resolver.minecraft;

import com.loohp.lotterysix.libs.xyz.tozymc.minecraft.MinecraftVersion;
import com.loohp.lotterysix.libs.xyz.tozymc.reflect.resolver.ClassResolver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class NmsClassResolver
extends ClassResolver {
    private NmsClassResolver() {
    }

    @Contract(pure=true)
    @NotNull
    public static NmsClassResolver resolver() {
        return NmsClassResolverHelper.INSTANCE;
    }

    @Override
    public <T> Class<T> resolve(@NotNull String name) {
        if (name.contains("net.minecraft")) {
            return super.resolve(name);
        }
        if (name.contains(".") && MinecraftVersion.getVersion().isNmsPackage()) {
            String[] path = name.split("\\.");
            name = path[path.length - 1];
        }
        name = MinecraftVersion.getVersion().getNmsPackage() + '.' + name;
        return super.resolve(name);
    }

    private static class NmsClassResolverHelper {
        private static final NmsClassResolver INSTANCE = new NmsClassResolver();

        private NmsClassResolverHelper() {
        }
    }
}

