/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.upperlevel.spigot.book;

import com.loohp.lotterysix.libs.xyz.upperlevel.spigot.book.CustomBookOpenEvent;
import com.loohp.lotterysix.libs.xyz.upperlevel.spigot.book.internals.BookHelper;
import com.loohp.lotterysix.libs.xyz.upperlevel.spigot.book.internals.NmsBookHelper;
import com.loohp.lotterysix.libs.xyz.upperlevel.spigot.book.internals.SpigotBookHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public final class BookUtil {
    private static final boolean canTranslateDirectly;
    private static final BookHelper helper;

    public static void openPlayer(Player p, ItemStack book) {
        CustomBookOpenEvent event = new CustomBookOpenEvent(p, book, false);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        p.closeInventory();
        ItemStack hand = p.getItemInHand();
        p.setItemInHand(event.getBook());
        p.updateInventory();
        helper.openBook(p, event.getBook());
        p.setItemInHand(hand);
        p.updateInventory();
    }

    public static BookBuilder writtenBook() {
        return new BookBuilder(new ItemStack(Material.WRITTEN_BOOK));
    }

    static {
        boolean success = true;
        try {
            ChatColor.BLACK.asBungee();
        }
        catch (NoSuchMethodError e) {
            success = false;
        }
        canTranslateDirectly = success;
        helper = SpigotBookHelper.isSupported() ? new SpigotBookHelper() : new NmsBookHelper();
    }

    public static interface HoverAction {
        public HoverEvent.Action action();

        public BaseComponent[] value();

        public static HoverAction showText(BaseComponent ... text) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_TEXT, text);
        }

        public static HoverAction showText(String text) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(text)});
        }

        public static HoverAction showItem(BaseComponent ... item) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_ITEM, item);
        }

        public static HoverAction showItem(ItemStack item) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_ITEM, helper.itemToComponents(item));
        }

        public static HoverAction showEntity(BaseComponent ... entity) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_ENTITY, entity);
        }

        public static HoverAction showEntity(UUID uuid, String type, String name) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_ENTITY, new BaseComponent[]{new TextComponent("{id:\"" + uuid + "\",type:\"" + type + "\"name:\"" + name + "\"}")});
        }

        public static HoverAction showEntity(Entity entity) {
            return HoverAction.showEntity(entity.getUniqueId(), entity.getType().getName(), entity.getName());
        }

        public static HoverAction showAchievement(String achievementId) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_ACHIEVEMENT, new BaseComponent[]{new TextComponent("achievement." + achievementId)});
        }

        public static HoverAction showStatistic(String statisticId) {
            return new SimpleHoverAction(HoverEvent.Action.SHOW_ACHIEVEMENT, new BaseComponent[]{new TextComponent("statistic." + statisticId)});
        }

        public static class SimpleHoverAction
        implements HoverAction {
            private final HoverEvent.Action action;
            private final BaseComponent[] value;

            public SimpleHoverAction(HoverEvent.Action action, BaseComponent ... value) {
                this.action = action;
                this.value = value;
            }

            @Override
            public HoverEvent.Action action() {
                return this.action;
            }

            @Override
            public BaseComponent[] value() {
                return this.value;
            }
        }
    }

    public static interface ClickAction {
        public ClickEvent.Action action();

        public String value();

        public static ClickAction runCommand(String command) {
            return new SimpleClickAction(ClickEvent.Action.RUN_COMMAND, command);
        }

        @Deprecated
        public static ClickAction suggestCommand(String command) {
            return new SimpleClickAction(ClickEvent.Action.SUGGEST_COMMAND, command);
        }

        public static ClickAction openUrl(String url) {
            if (url.startsWith("http://") || url.startsWith("https://")) {
                return new SimpleClickAction(ClickEvent.Action.OPEN_URL, url);
            }
            throw new IllegalArgumentException("Invalid url: \"" + url + "\", it should start with http:// or https://");
        }

        public static ClickAction changePage(int page) {
            return new SimpleClickAction(ClickEvent.Action.CHANGE_PAGE, Integer.toString(page));
        }

        public static class SimpleClickAction
        implements ClickAction {
            private final ClickEvent.Action action;
            private final String value;

            @Override
            public ClickEvent.Action action() {
                return this.action;
            }

            @Override
            public String value() {
                return this.value;
            }

            public SimpleClickAction(ClickEvent.Action action, String value) {
                this.action = action;
                this.value = value;
            }
        }
    }

    public static class TextBuilder {
        private String text = "";
        private ClickAction onClick = null;
        private HoverAction onHover = null;
        private ChatColor color = ChatColor.BLACK;
        private ChatColor[] style;

        public TextBuilder color(ChatColor color) {
            if (color != null && !color.isColor()) {
                throw new IllegalArgumentException("Argument isn't a color!");
            }
            this.color = color;
            return this;
        }

        public TextBuilder style(ChatColor ... style) {
            for (ChatColor c : style) {
                if (c.isFormat()) continue;
                throw new IllegalArgumentException("Argument isn't a style!");
            }
            this.style = style;
            return this;
        }

        public BaseComponent build() {
            TextComponent res = new TextComponent(this.text);
            if (this.onClick != null) {
                res.setClickEvent(new ClickEvent(this.onClick.action(), this.onClick.value()));
            }
            if (this.onHover != null) {
                res.setHoverEvent(new HoverEvent(this.onHover.action(), this.onHover.value()));
            }
            if (this.color != null) {
                if (canTranslateDirectly) {
                    res.setColor(this.color.asBungee());
                } else {
                    res.setColor(net.md_5.bungee.api.ChatColor.getByChar((char)this.color.getChar()));
                }
            }
            if (this.style != null) {
                block7: for (ChatColor c : this.style) {
                    switch (c) {
                        case MAGIC: {
                            res.setObfuscated(Boolean.valueOf(true));
                            continue block7;
                        }
                        case BOLD: {
                            res.setBold(Boolean.valueOf(true));
                            continue block7;
                        }
                        case STRIKETHROUGH: {
                            res.setStrikethrough(Boolean.valueOf(true));
                            continue block7;
                        }
                        case UNDERLINE: {
                            res.setUnderlined(Boolean.valueOf(true));
                            continue block7;
                        }
                        case ITALIC: {
                            res.setItalic(Boolean.valueOf(true));
                        }
                    }
                }
            }
            return res;
        }

        public static TextBuilder of(String text) {
            return new TextBuilder().text(text);
        }

        public TextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TextBuilder onClick(ClickAction onClick) {
            this.onClick = onClick;
            return this;
        }

        public TextBuilder onHover(HoverAction onHover) {
            this.onHover = onHover;
            return this;
        }

        public String text() {
            return this.text;
        }

        public ClickAction onClick() {
            return this.onClick;
        }

        public HoverAction onHover() {
            return this.onHover;
        }

        public ChatColor color() {
            return this.color;
        }
    }

    public static class PageBuilder {
        private List<BaseComponent> text = new ArrayList<BaseComponent>();

        public PageBuilder add(String text) {
            this.text.add(TextBuilder.of(text).build());
            return this;
        }

        public PageBuilder add(BaseComponent component) {
            this.text.add(component);
            return this;
        }

        public PageBuilder add(BaseComponent ... components) {
            this.text.addAll(Arrays.asList(components));
            return this;
        }

        public PageBuilder add(Collection<BaseComponent> components) {
            this.text.addAll(components);
            return this;
        }

        public PageBuilder newLine() {
            this.text.add((BaseComponent)new TextComponent("\n"));
            return this;
        }

        public BaseComponent[] build() {
            return this.text.toArray(new BaseComponent[0]);
        }

        public static PageBuilder of(String text) {
            return new PageBuilder().add(text);
        }

        public static PageBuilder of(BaseComponent text) {
            return new PageBuilder().add(text);
        }

        public static PageBuilder of(BaseComponent ... text) {
            PageBuilder res = new PageBuilder();
            for (BaseComponent b : text) {
                res.add(b);
            }
            return res;
        }
    }

    public static class BookBuilder {
        private final BookMeta meta;
        private final ItemStack book;

        public BookBuilder(ItemStack book) {
            this.book = book;
            this.meta = (BookMeta)book.getItemMeta();
        }

        public BookBuilder title(String title) {
            if (title.length() > 32) {
                throw new IllegalArgumentException("The book title must be at most 32 characters");
            }
            this.meta.setTitle(title);
            return this;
        }

        public BookBuilder author(String author) {
            this.meta.setAuthor(author);
            return this;
        }

        public BookBuilder pagesRaw(String ... pages) {
            this.meta.setPages(pages);
            return this;
        }

        public BookBuilder pagesRaw(List<String> pages) {
            this.meta.setPages(pages);
            return this;
        }

        public BookBuilder pages(BaseComponent[] ... pages) {
            helper.setPages(this.meta, pages);
            return this;
        }

        public BookBuilder pages(List<BaseComponent[]> pages) {
            helper.setPages(this.meta, (BaseComponent[][])pages.toArray((T[])new BaseComponent[0][]));
            return this;
        }

        public BookBuilder generation(BookMeta.Generation generation) {
            this.meta.setGeneration(generation);
            return this;
        }

        public ItemStack build() {
            if (!this.meta.hasAuthor()) {
                this.meta.setAuthor("");
            }
            if (!this.meta.hasTitle()) {
                this.meta.setTitle("");
            }
            if (!this.meta.hasPages()) {
                this.pages(new BaseComponent[][]{new BaseComponent[0]});
            }
            this.book.setItemMeta((ItemMeta)this.meta);
            return this.book;
        }
    }
}

